/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.generic.base;

import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.ValueCollectionSetting;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.base.AbstractHasValueSetting;
import com.sap.sse.common.settings.value.Value;
import com.sap.sse.common.settings.value.ValueCollectionValue;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractValueCollectionSetting<T, C extends Collection<Value>, D extends Collection<T>>
extends AbstractHasValueSetting<T>
implements ValueCollectionSetting<T> {
    private D defaultValues;
    private final boolean emptyIsDefault;

    public AbstractValueCollectionSetting(String name, AbstractGenericSerializableSettings settings, ValueConverter<T> valueConverter, boolean emptyIsDefault) {
        super(name, settings, valueConverter);
        this.emptyIsDefault = emptyIsDefault;
    }

    private D getDefaultValuesCollectionInternal() {
        if (this.defaultValues == null) {
            this.defaultValues = this.createDefaultValuesCollection();
        }
        return this.defaultValues;
    }

    protected ValueCollectionValue<C> getValue() {
        return (ValueCollectionValue)this.settings.getValue(this.settingName);
    }

    protected abstract ValueCollectionValue<C> createValue();

    private ValueCollectionValue<C> ensureValue() {
        ValueCollectionValue<C> result = this.getValue();
        if (result == null) {
            result = this.createValue();
            this.settings.setValue(this.settingName, result);
        }
        return result;
    }

    protected abstract D createDefaultValuesCollection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> getValues() {
        ValueCollectionValue<C> value = this.getValue();
        if (this.emptyIsDefault && (value == null || value.isEmpty())) {
            D defaultVal;
            D d = defaultVal = this.getDefaultValuesCollectionInternal();
            synchronized (d) {
                D result = this.createDefaultValuesCollection();
                result.addAll(defaultVal);
                return result;
            }
        }
        if (value == null) {
            return Collections.emptyList();
        }
        return value.getValues(this.getValueConverter());
    }

    @Override
    public boolean isValuesEmpty() {
        ValueCollectionValue<C> value = this.getValue();
        return value == null || value.isEmpty();
    }

    @Override
    public final void setValues(Iterable<T> values) {
        this.ensureValue().setValues(values, this.getValueConverter());
    }

    @Override
    public void addValue(T value) {
        this.ensureValue().addValue(value, this.getValueConverter());
    }

    public void clear() {
        this.ensureValue().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetToDefault() {
        D defaultVal;
        D d = defaultVal = this.getDefaultValuesCollectionInternal();
        synchronized (d) {
            this.setValues((Iterable<T>)defaultVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDefaultValue() {
        D defaultVal;
        ValueCollectionValue<C> value = this.getValue();
        D d = defaultVal = this.getDefaultValuesCollectionInternal();
        synchronized (d) {
            return (this.emptyIsDefault || defaultVal.isEmpty()) && (value == null || value.isEmpty()) || value != null && value.size() == defaultVal.size() && defaultVal.containsAll((Collection<?>)value.getValues(this.getValueConverter()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDefaultValues(Iterable<T> defaultValues) {
        D defaultVal;
        boolean wasDefault = this.isDefaultValue();
        D d = defaultVal = this.getDefaultValuesCollectionInternal();
        synchronized (d) {
            defaultVal.clear();
            if (defaultValues != null) {
                Util.addAll(defaultValues, defaultVal);
            }
            if (wasDefault) {
                this.resetToDefault();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> getDefaultValues() {
        D localDefaultValues;
        D result = this.createDefaultValuesCollection();
        D d = localDefaultValues = this.getDefaultValuesCollectionInternal();
        synchronized (d) {
            result.addAll(localDefaultValues);
            return result;
        }
    }

    @Override
    public Iterable<T> getAddedValues() {
        D added = this.createDefaultValuesCollection();
        Util.addAll(this.getValues(), added);
        Util.removeAll(this.getDefaultValues(), added);
        return added;
    }

    @Override
    public Iterable<T> getRemovedValues() {
        D removed = this.createDefaultValuesCollection();
        Util.addAll(this.getDefaultValues(), removed);
        Util.removeAll(this.getValues(), removed);
        return removed;
    }

    @Override
    public void setDiff(Iterable<T> removedValues, Iterable<T> addedValues) {
        D values = this.createDefaultValuesCollection();
        Util.addAll(this.getValues(), values);
        Util.removeAll(removedValues, values);
        Util.addAll(addedValues, values);
        this.setValues((Iterable<T>)values);
    }

    public String toString() {
        ValueCollectionValue<C> value = this.getValue();
        if (value == null) {
            return "[]";
        }
        return value.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        ValueCollectionValue<C> value = this.getValue();
        result = 31 * result + (value == null ? 0 : this.getValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValueCollectionSetting other = (AbstractValueCollectionSetting)obj;
        ValueCollectionValue<C> value = this.getValue();
        ValueCollectionValue<C> otherValue = other.getValue();
        return !(value == null ? otherValue != null : !value.equals(otherValue));
    }
}

