/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimedLock;
import com.sap.sse.common.Util;

public class TimedLockImpl
implements TimedLock {
    private static final long serialVersionUID = 3547356744366236677L;
    public static final Duration DEFAULT_INITIAL_LOCKING_DELAY = Duration.ONE_SECOND;
    private TimePoint lockedUntil;
    private Duration nextLockingDelay;

    public TimedLockImpl() {
        this(TimePoint.BeginningOfTime, DEFAULT_INITIAL_LOCKING_DELAY);
    }

    public TimedLockImpl(TimePoint lockedUntil, Duration nextLockingDelay) {
        this.lockedUntil = lockedUntil;
        this.nextLockingDelay = nextLockingDelay;
    }

    @Override
    public void extendLockDuration() {
        this.lockedUntil = TimePoint.now().plus(this.nextLockingDelay);
        this.nextLockingDelay = this.nextLockingDelay.times(2L);
    }

    @Override
    public boolean resetLock() {
        Duration oldLockingDelay = this.nextLockingDelay;
        this.nextLockingDelay = DEFAULT_INITIAL_LOCKING_DELAY;
        TimePoint oldLockedUntil = this.lockedUntil;
        this.lockedUntil = TimePoint.BeginningOfTime;
        return !Util.equalsWithNull(oldLockingDelay, this.nextLockingDelay) || !Util.equalsWithNull(oldLockedUntil, this.lockedUntil);
    }

    @Override
    public boolean isLocked() {
        return TimePoint.now().before(this.lockedUntil);
    }

    @Override
    public TimePoint getLockedUntil() {
        return this.lockedUntil;
    }

    public Duration getNextLockingDelay() {
        return this.nextLockingDelay;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isLocked()) {
            result.append("locked until ");
            result.append(this.getLockedUntil());
        } else {
            result.append("unlocked");
        }
        result.append(", next locking duration: ");
        result.append(this.getNextLockingDelay());
        return result.toString();
    }
}

