/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpeditionMessageImpl
implements ExpeditionMessage {
    private static final Logger logger = Logger.getLogger(ExpeditionMessageImpl.class.getName());
    private final String originalMessage;
    private final int boatID;
    private final Map<Integer, Double> values;
    private final boolean valid;
    private final long createdAtMillis;
    private final TimePoint timePoint;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC") == null ? TimeZone.getTimeZone("GMT") : TimeZone.getTimeZone("UTC");
    private static final GregorianCalendar cal = new GregorianCalendar(UTC);

    static {
        cal.set(1899, 11, 30, 0, 0, 0);
    }

    public ExpeditionMessageImpl(int boatID, Map<Integer, Double> values, boolean valid, String originalMessage) {
        this(boatID, values, valid, null, originalMessage, true);
    }

    public ExpeditionMessageImpl(int boatID, Map<Integer, Double> values, boolean valid, TimePoint defaultTimePoint, String originalMessage) {
        this(boatID, values, valid, defaultTimePoint, originalMessage, true);
        if (defaultTimePoint == null) {
            throw new IllegalArgumentException("defaultTimePoint for this ExpeditionMessageImpl constructor must not be null");
        }
    }

    private ExpeditionMessageImpl(int boatID, Map<Integer, Double> values, boolean valid, TimePoint defaultTimePoint, String originalMessage, boolean unused) {
        this.boatID = boatID;
        this.values = new HashMap<Integer, Double>(values);
        this.valid = valid;
        this.originalMessage = originalMessage;
        this.createdAtMillis = System.currentTimeMillis();
        if (this.hasValue(146)) {
            long referenceTime;
            double gpsTimeValue = this.getValue(146);
            if (gpsTimeValue <= 1.0) {
                GregorianCalendar todayMidnightUTC = new GregorianCalendar();
                ((Calendar)todayMidnightUTC).setTimeZone(TimeZone.getTimeZone("UTC"));
                todayMidnightUTC.set(11, 0);
                todayMidnightUTC.set(12, 0);
                todayMidnightUTC.set(13, 0);
                todayMidnightUTC.set(14, 0);
                referenceTime = todayMidnightUTC.getTimeInMillis();
            } else {
                referenceTime = cal.getTimeInMillis();
            }
            this.timePoint = new MillisecondsTimePoint((long)(gpsTimeValue * 24.0 * 3600.0 * 1000.0) + referenceTime);
        } else {
            this.timePoint = defaultTimePoint == null ? new MillisecondsTimePoint(this.createdAtMillis) : defaultTimePoint;
        }
    }

    @Override
    public String getOriginalMessage() {
        return this.originalMessage;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getBoatID() {
        return this.boatID;
    }

    @Override
    public Set<Integer> getVariableIDs() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public boolean hasValue(int variableID) {
        return this.values.containsKey(variableID);
    }

    @Override
    public double getValue(int variableID) {
        if (!this.hasValue(variableID)) {
            throw new IllegalArgumentException("Variable ID " + variableID + " not present in message");
        }
        return this.values.get(variableID);
    }

    @Override
    public GPSFix getGPSFix() {
        if (this.hasValue(48) && this.hasValue(49)) {
            return new GPSFixImpl((Position)new DegreePosition(this.getValue(48), this.getValue(49)), this.getTimePoint());
        }
        return null;
    }

    @Override
    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public TimePoint getCreatedAt() {
        return new MillisecondsTimePoint(this.createdAtMillis);
    }

    @Override
    public GPSFixMoving getGPSFixMoving() {
        GPSFixMovingImpl result;
        if (this.hasValue(48) && this.hasValue(49)) {
            SpeedWithBearing cogSog = this.getSpeedOverGround();
            if (cogSog != null) {
                Bearing optionalTrueHeading;
                DegreePosition position = new DegreePosition(this.getValue(48), this.getValue(49));
                if (this.hasValue(13)) {
                    try {
                        optionalTrueHeading = new DegreeBearingImpl(this.getValue(13)).add(DeclinationService.INSTANCE.getDeclination(this.getTimePoint(), (Position)position, 1000L).getBearingCorrectedTo(this.getTimePoint()));
                    }
                    catch (IOException | ParseException e) {
                        logger.log(Level.WARNING, "Problem obtaining the magnetic declination for Expedition fix", e);
                        optionalTrueHeading = null;
                    }
                } else {
                    optionalTrueHeading = null;
                }
                result = new GPSFixMovingImpl((Position)position, this.getTimePoint(), this.getSpeedOverGround(), optionalTrueHeading);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public SpeedWithBearing getTrueWind() {
        KnotSpeedWithBearingImpl result = this.hasValue(94) && this.hasValue(95) ? new KnotSpeedWithBearingImpl(this.getValue(95), this.getTrueWindBearing()) : (this.hasValue(6) && this.hasValue(5) ? new KnotSpeedWithBearingImpl(this.getValue(5), this.getTrueWindBearing()) : null);
        return result;
    }

    @Override
    public Bearing getTrueWindBearing() {
        Bearing result = this.hasValue(6) ? new DegreeBearingImpl(this.getValue(6)).reverse() : (this.hasValue(94) ? new DegreeBearingImpl(this.getValue(94)).reverse() : null);
        return result;
    }

    @Override
    public SpeedWithBearing getSpeedOverGround() {
        KnotSpeedWithBearingImpl result;
        if (this.hasValue(50)) {
            double sogInKnots = this.hasValue(51) ? this.getValue(51) : 0.0;
            result = new KnotSpeedWithBearingImpl(sogInKnots, this.getCourseOverGround());
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Bearing getCourseOverGround() {
        DegreeBearingImpl result = this.hasValue(50) ? new DegreeBearingImpl(this.getValue(50)) : null;
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Boat #");
        result.append(this.getBoatID());
        result.append(": ");
        TreeSet<Integer> ids = new TreeSet<Integer>(this.values.keySet());
        boolean first = true;
        for (Integer id : ids) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(id);
            result.append(":");
            result.append(this.getValue(id));
        }
        return result.toString();
    }
}

