/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.freg.resultimport.impl;

import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.freg.resultimport.impl.ScoreCorrectionProviderImpl;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.resultimport.impl.ResultUrlRegistryServiceTrackerCustomizer;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String SCAN_DIR_PATH_PROPERTY_NAME = "freg.results";
    private static final String DEFAULT_SCAN_DIR = "fregresults";
    private ServiceTracker<ResultUrlRegistry, ResultUrlRegistry> resultUrlRegistryServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        String scanDirPath = bundleContext.getProperty(SCAN_DIR_PATH_PROPERTY_NAME);
        if (scanDirPath == null) {
            scanDirPath = System.getProperty(SCAN_DIR_PATH_PROPERTY_NAME, DEFAULT_SCAN_DIR);
        }
        logger.info("Scanning " + scanDirPath + " for official result lists of " + "FREG HTML Score Importer");
        this.resultUrlRegistryServiceTracker = new ServiceTracker(bundleContext, ResultUrlRegistry.class, (ServiceTrackerCustomizer)new ResultUrlRegistryServiceTrackerCustomizer(bundleContext){

            protected ScoreCorrectionProvider configureScoreCorrectionProvider(ResultUrlRegistry resultUrlRegistry) {
                ScoreCorrectionProviderImpl service = new ScoreCorrectionProviderImpl(resultUrlRegistry);
                return service;
            }
        });
        this.resultUrlRegistryServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.resultUrlRegistryServiceTracker.close();
    }
}

