/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.yellowbrickadapter.impl.PositionsDocument;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPosition;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPositions;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GetPositionsParser {
    private static final String RACE_URL = "raceUrl";
    private static final String TEAMS = "teams";
    private static final String SERIAL = "serial";
    private static final String MARKER = "marker";
    private static final String NAME = "name";
    private static final String POSITIONS = "positions";
    private static final String GPS_AT_MILLIS = "gpsAtMillis";
    private static final String LATITUDE = "latitude";
    private static final String SOG_KNOTS = "sogKnots";
    private static final String COG = "cog";
    private static final String ID = "id";
    private static final String LONGITUDE = "longitude";

    public PositionsDocument parse(Reader reader, boolean inferSpeedAndBearing) throws IOException, ParseException {
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(reader);
        return this.parse(jsonObject, inferSpeedAndBearing);
    }

    private PositionsDocument parse(JSONObject jsonObject, boolean inferSpeedAndBearing) {
        String raceUrl = jsonObject.get((Object)RACE_URL).toString();
        JSONArray teamsJsonArray = (JSONArray)jsonObject.get((Object)TEAMS);
        Iterable<TeamPositions> teamPositions = this.parseTeamsPositions(teamsJsonArray, inferSpeedAndBearing);
        return new PositionsDocument(raceUrl, teamPositions);
    }

    private Iterable<TeamPositions> parseTeamsPositions(JSONArray teamsJsonArray, boolean inferSpeedAndBearing) {
        ArrayList<TeamPositions> result = new ArrayList<TeamPositions>(teamsJsonArray.size());
        for (Object teamObject : teamsJsonArray) {
            JSONObject teamJson = (JSONObject)teamObject;
            int serial = ((Number)teamJson.get((Object)SERIAL)).intValue();
            int marker = ((Number)teamJson.get((Object)MARKER)).intValue();
            String name = teamJson.get((Object)NAME).toString();
            JSONArray positionsJson = (JSONArray)teamJson.get((Object)POSITIONS);
            result.add(new TeamPositions(serial, marker, name, this.parseTeamPositions(positionsJson, inferSpeedAndBearing)));
        }
        return result;
    }

    private Iterable<TeamPosition> parseTeamPositions(JSONArray positionsJson, boolean inferSpeedAndBearing) {
        ArrayList<TeamPosition> result = new ArrayList<TeamPosition>(positionsJson.size());
        GPSFixMoving lastFix = null;
        for (Object positionObject : positionsJson) {
            JSONObject positionJson = (JSONObject)positionObject;
            long timeAsMillis = ((Number)positionJson.get((Object)GPS_AT_MILLIS)).longValue();
            MillisecondsTimePoint timePoint = new MillisecondsTimePoint(timeAsMillis);
            double latDeg = ((Number)positionJson.get((Object)LATITUDE)).doubleValue();
            double lngDeg = ((Number)positionJson.get((Object)LONGITUDE)).doubleValue();
            DegreePosition position = new DegreePosition(latDeg, lngDeg);
            Number sogAsNumber = (Number)positionJson.get((Object)SOG_KNOTS);
            Number cogAsNumber = (Number)positionJson.get((Object)COG);
            Object cog = cogAsNumber != null ? new DegreeBearingImpl(cogAsNumber.doubleValue()) : (inferSpeedAndBearing && lastFix != null && lastFix.getPosition() != null ? (lastFix.getTimePoint().before((TimePoint)timePoint) ? lastFix.getPosition().getBearingGreatCircle((Position)position) : position.getBearingGreatCircle(lastFix.getPosition())) : new DegreeBearingImpl(0.0));
            double sogInKnots = sogAsNumber != null ? sogAsNumber.doubleValue() : (inferSpeedAndBearing && lastFix != null && lastFix.getPosition() != null ? (lastFix.getTimePoint().before((TimePoint)timePoint) ? lastFix.getSpeedAndBearingRequiredToReach((GPSFix)new GPSFixImpl((Position)position, (TimePoint)timePoint)).getKnots() : new GPSFixImpl((Position)position, (TimePoint)timePoint).getSpeedAndBearingRequiredToReach(lastFix).getKnots()) : 0.0);
            long id = ((Number)positionJson.get((Object)ID)).longValue();
            TeamPosition teamPosition = new TeamPosition((SpeedWithBearing)new KnotSpeedWithBearingImpl(sogInKnots, (Bearing)cog), (TimePoint)timePoint, id, (Position)position);
            result.add(teamPosition);
            lastFix = teamPosition.getGPSFixMoving();
        }
        return result;
    }
}

