/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.interfaces.impl.ReplicaDescriptorImpl;
import com.sap.sse.replication.persistence.DomainObjectFactory;
import com.sap.sse.replication.persistence.impl.CollectionNames;
import com.sap.sse.replication.persistence.impl.FieldNames;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase db;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    private MongoCollection<Document> getReplicaDescriptorCollection() {
        MongoCollection result = this.db.getCollection(CollectionNames.REPLICA_DESCRIPTORS.name());
        return result;
    }

    @Override
    public Iterable<ReplicaDescriptor> loadReplicaDescriptors() {
        HashMap<UUID, ReplicaDescriptor> result = new HashMap<UUID, ReplicaDescriptor>();
        for (Document o : this.getReplicaDescriptorCollection().find()) {
            ReplicaDescriptor replicaDescriptor = this.loadReplicaDescriptor(o);
            if (replicaDescriptor == null) continue;
            result.put(replicaDescriptor.getUuid(), replicaDescriptor);
        }
        return result.values();
    }

    private ReplicaDescriptor loadReplicaDescriptor(Document o) {
        InetAddress ipAddress;
        UUID uuid = UUID.fromString(o.getString((Object)FieldNames.REPLICA_ID_AS_STRING.name()));
        String ipAddressString = o.getString((Object)FieldNames.REPLICA_IP_ADDRESS.name());
        try {
            ipAddress = InetAddress.getByName(ipAddressString);
        }
        catch (UnknownHostException e) {
            String message = "Internal error: the IP address " + ipAddressString + " cannot be converted into an InetAddress";
            logger.log(Level.WARNING, message, e);
            throw new RuntimeException(message, e);
        }
        MillisecondsTimePoint registrationTime = new MillisecondsTimePoint(o.getLong((Object)FieldNames.REPLICA_REGISTRATION_TIME_MILLIS.name()).longValue());
        String additionalInformation = o.getString((Object)FieldNames.REPLICA_ADDITIONAL_INFORMATION.name());
        String[] replicableIdsAsStrings = ((ArrayList)o.get((Object)FieldNames.REPLICA_REPLICABLE_IDS_AS_STRINGS.name(), new ArrayList())).toArray(new String[0]);
        Integer port = o.getInteger((Object)FieldNames.REPLICA_PORT.name());
        return new ReplicaDescriptorImpl(ipAddress, port, uuid, (TimePoint)registrationTime, additionalInformation, replicableIdsAsStrings);
    }
}

