/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.rabbitmq.client.Channel;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationReceiver;
import com.sap.sse.replication.ReplicationStatus;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.UUID;

public interface ReplicationService {
    public static final String SAILING_SERVER_REPLICATION_TOPIC = "SailingServerReplicationTopic";

    public Iterable<ReplicaDescriptor> getReplicaInfo();

    public ReplicationMasterDescriptor getReplicatingFromMaster();

    public void startToReplicateFrom(ReplicationMasterDescriptor var1) throws Exception;

    public void registerReplica(ReplicaDescriptor var1) throws IOException, Exception;

    public void unregisterReplica(ReplicaDescriptor var1) throws IOException;

    public ReplicaDescriptor unregisterReplica(UUID var1) throws IOException;

    public Map<Class<? extends OperationWithResult<?, ?>>, Integer> getStatistics(ReplicaDescriptor var1);

    public double getAverageNumberOfOperationsPerMessage(ReplicaDescriptor var1);

    public void stopToReplicateFromMaster() throws IOException;

    public void stopAllReplicas() throws IOException;

    public UUID getServerIdentifier();

    public Channel createMasterChannel() throws IOException, ConnectException, Exception;

    public long getNumberOfMessagesSent(ReplicaDescriptor var1);

    public long getNumberOfBytesSent(ReplicaDescriptor var1);

    public double getAverageNumberOfBytesPerMessage(ReplicaDescriptor var1);

    public Iterable<Replicable<?, ?>> getAllReplicables();

    public ReplicationMasterDescriptor createReplicationMasterDescriptor(String var1, String var2, String var3, int var4, int var5, String var6, String var7, Iterable<Replicable<?, ?>> var8);

    public ReplicationReceiver getReplicator();

    public void setReplicationStarting(boolean var1);

    public void addReplicationStartingListener(ReplicationStartingListener var1);

    public void removeReplicationStartingListener(ReplicationStartingListener var1);

    public boolean isReplicationStarting();

    public ReplicationStatus getStatus();

    @FunctionalInterface
    public static interface ReplicationStartingListener {
        public void onReplicationStartingChanged(boolean var1);
    }
}

