/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.velum.resultimport.impl;

import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.CompetitorRowImpl;
import com.sap.sailing.resultimport.impl.DefaultCompetitorEntryImpl;
import com.sap.sailing.velum.resultimport.CsvParser;
import com.sap.sse.common.TimePoint;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvParserImpl
implements CsvParser {
    private final InputStream inputStream;
    private final String filename;
    private final TimePoint lastModified;
    private final String SEPARATOR = ";";
    private static final String STAR_BOAT_CLASS_NAME = "Star";

    public CsvParserImpl(InputStream inputStream, String filename, TimePoint lastModified) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.lastModified = lastModified;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getBoatClass() {
        String result = STAR_BOAT_CLASS_NAME;
        int underScoreIndex = this.filename.lastIndexOf("_");
        if (underScoreIndex > 0) {
            result = this.filename.substring(0, underScoreIndex);
        }
        return result;
    }

    @Override
    public RegattaResults parseResults() throws Exception {
        final ArrayList<CompetitorRowImpl> competitorRows = new ArrayList<CompetitorRowImpl>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, "Cp1252"));
        String line = br.readLine();
        int startIndexForRacePoints = -1;
        int endIndexForRacePoints = -1;
        while (line != null) {
            int firstSeparator = line.indexOf(";");
            if (!line.startsWith("Wettfahrten") && firstSeparator > 0) {
                String firstEntry = line.substring(0, firstSeparator);
                if (firstEntry.startsWith("G-PL") || firstEntry.startsWith("G-Pl")) {
                    String[] splittedHeadline = line.split(";");
                    int i = 0;
                    while (i < splittedHeadline.length) {
                        if (splittedHeadline != null && splittedHeadline[i].endsWith(".Wf")) {
                            if (startIndexForRacePoints < 0) {
                                startIndexForRacePoints = i;
                            }
                            if (i > endIndexForRacePoints) {
                                endIndexForRacePoints = i;
                            }
                        }
                        ++i;
                    }
                } else {
                    try {
                        Integer.parseInt(firstEntry);
                        String[] splittedRow = line.split(";");
                        String sailID = splittedRow[1];
                        sailID = sailID.replace(" ", "");
                        Integer totalRank = Integer.parseInt(splittedRow[endIndexForRacePoints + 2]);
                        List<String> names = Arrays.asList(splittedRow[2].split("/"));
                        ArrayList<DefaultCompetitorEntryImpl> rankAndMaxPointsReasonAndPointsAndDiscarded = new ArrayList<DefaultCompetitorEntryImpl>();
                        int index = startIndexForRacePoints;
                        while (index <= endIndexForRacePoints) {
                            Double points;
                            String maxPointsReason;
                            Integer rank;
                            boolean discarded = false;
                            String rankOrMaxPointsReason = splittedRow[index++];
                            String pointsAsText = splittedRow[index++];
                            if (rankOrMaxPointsReason.startsWith("[") && rankOrMaxPointsReason.endsWith("]")) {
                                rankOrMaxPointsReason = rankOrMaxPointsReason.substring(1, rankOrMaxPointsReason.length() - 1);
                                discarded = true;
                            }
                            try {
                                rank = Integer.parseInt(rankOrMaxPointsReason);
                                maxPointsReason = null;
                            }
                            catch (NumberFormatException e) {
                                rank = null;
                                maxPointsReason = rankOrMaxPointsReason;
                            }
                            if (pointsAsText.startsWith("[") && pointsAsText.endsWith("]")) {
                                pointsAsText = pointsAsText.substring(1, pointsAsText.length() - 1);
                            }
                            if ((points = Double.valueOf(pointsAsText = pointsAsText.replaceAll(",", "."))) != 0.0) {
                                DefaultCompetitorEntryImpl entry = new DefaultCompetitorEntryImpl(rank, maxPointsReason, points, discarded);
                                rankAndMaxPointsReasonAndPointsAndDiscarded.add(entry);
                                continue;
                            }
                            rankAndMaxPointsReasonAndPointsAndDiscarded.add(null);
                        }
                        CompetitorRowImpl competitorRow = new CompetitorRowImpl(totalRank, sailID, names, null, null, rankAndMaxPointsReasonAndPointsAndDiscarded);
                        competitorRows.add(competitorRow);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            line = br.readLine();
        }
        return new RegattaResults(){

            public Map<String, String> getMetadata() {
                HashMap<String, String> result = new HashMap<String, String>();
                return result;
            }

            public List<CompetitorRow> getCompetitorResults() {
                return competitorRows;
            }
        };
    }

    @Override
    public TimePoint getLastModified() {
        return this.lastModified;
    }
}

