/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.server.gateway.serialization.impl.MarkRoleJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MarkTemplateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RepeatablePartJsonSerializer;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseTemplateJsonSerializer
implements JsonSerializer<CourseTemplate> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SHORT_NAME = "shortName";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_OPTIONAL_IMAGE_URL = "optionalImageURL";
    public static final String FIELD_ALL_MARK_TEMPLATES = "allMarkTemplates";
    public static final String FIELD_ALL_MARK_ROLES = "allMarkRoles";
    public static final String FIELD_WAYPOINTS = "waypoints";
    public static final String FIELD_PASSING_INSTRUCTION = "passingInstruction";
    public static final String FIELD_CONTROL_POINT_NAME = "controlPointName";
    public static final String FIELD_CONTROL_POINT_SHORT_NAME = "controlPointShortName";
    public static final String FIELD_MARK_TEMPLATE_IDS = "markTemplateIds";
    public static final String FIELD_MARK_TEMPLATE_ID = "markTemplateId";
    public static final String FIELD_ASSOCIATED_MARK_ROLE_ID = "associatedRoleId";
    public static final String FIELD_MARK_ROLE_IDS = "markRoleIds";
    public static final String FIELD_ASSOCIATED_MARK_TEMPLATE_ID = "associatedMarkTemplateId";
    public static final String FIELD_OPTIONAL_REPEATABLE_PART = "optionalRepeatablePart";
    public static final String FIELD_DEFAULT_NUMBER_OF_LAPS = "defaultNumberOfLaps";
    private final JsonSerializer<RepeatablePart> repeatablePartJsonSerializer = new RepeatablePartJsonSerializer();
    private final MarkRoleJsonSerializer markRoleJsonSerializer = new MarkRoleJsonSerializer();
    private final MarkTemplateJsonSerializer markTemplateJsonSerializer = new MarkTemplateJsonSerializer();

    public JSONObject serialize(CourseTemplate courseTemplate) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_ID, (Object)courseTemplate.getId().toString());
        result.put((Object)FIELD_NAME, (Object)courseTemplate.getName());
        result.put((Object)FIELD_SHORT_NAME, (Object)courseTemplate.getShortName());
        result.put((Object)FIELD_OPTIONAL_IMAGE_URL, (Object)courseTemplate.getOptionalImageURL());
        result.put((Object)FIELD_DEFAULT_NUMBER_OF_LAPS, (Object)courseTemplate.getDefaultNumberOfLaps());
        JSONArray tags = new JSONArray();
        if (courseTemplate.getTags() != null) {
            courseTemplate.getTags().forEach(arg_0 -> tags.add(arg_0));
        }
        result.put((Object)FIELD_TAGS, (Object)tags);
        JSONArray allMarkRoles = new JSONArray();
        courseTemplate.getMarkRoles().forEach(markRole -> {
            JSONObject markRoleEntry = this.markRoleJsonSerializer.serialize((MarkRole)markRole);
            markRoleEntry.put((Object)FIELD_ASSOCIATED_MARK_TEMPLATE_ID, (Object)courseTemplate.getDefaultMarkTemplateForMarkRole(markRole).getId().toString());
            allMarkRoles.add((Object)markRoleEntry);
        });
        result.put((Object)FIELD_ALL_MARK_ROLES, (Object)allMarkRoles);
        JSONArray allMarkTemplates = new JSONArray();
        courseTemplate.getMarkTemplates().forEach(mt -> {
            JSONObject markTemplateEntry = this.markTemplateJsonSerializer.serialize((MarkTemplate)mt);
            MarkRole associatedRoleOrNull = courseTemplate.getOptionalAssociatedRole(mt);
            if (associatedRoleOrNull != null) {
                markTemplateEntry.put((Object)FIELD_ASSOCIATED_MARK_ROLE_ID, (Object)associatedRoleOrNull.getId().toString());
            }
            allMarkTemplates.add((Object)markTemplateEntry);
        });
        result.put((Object)FIELD_ALL_MARK_TEMPLATES, (Object)allMarkTemplates);
        JSONArray waypoints = new JSONArray();
        courseTemplate.getWaypointTemplates().forEach(wp -> {
            JSONObject waypointEntry = new JSONObject();
            waypointEntry.put((Object)FIELD_PASSING_INSTRUCTION, (Object)wp.getPassingInstruction().name());
            JSONArray markRoleIDs = new JSONArray();
            wp.getControlPointTemplate().getMarkRoles().forEach(mr -> {
                boolean bl = markRoleIDs.add((Object)mr.getId().toString());
            });
            waypointEntry.put((Object)FIELD_MARK_ROLE_IDS, (Object)markRoleIDs);
            waypointEntry.put((Object)FIELD_CONTROL_POINT_NAME, (Object)wp.getControlPointTemplate().getName());
            waypointEntry.put((Object)FIELD_CONTROL_POINT_SHORT_NAME, (Object)wp.getControlPointTemplate().getShortName());
            waypoints.add((Object)waypointEntry);
        });
        result.put((Object)FIELD_WAYPOINTS, (Object)waypoints);
        if (courseTemplate.hasRepeatablePart()) {
            result.put((Object)FIELD_OPTIONAL_REPEATABLE_PART, (Object)this.repeatablePartJsonSerializer.serialize((Object)courseTemplate.getRepeatablePart()));
        }
        return result;
    }
}

