/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationRequestAnnotation;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.impl.MarkConfigurationRequestAnnotationImpl;
import com.sap.sailing.server.gateway.deserialization.impl.CourseConfigurationBuilder;
import com.sap.sailing.server.gateway.deserialization.impl.DeviceIdentifierJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.FreestyleMarkPropertiesJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PositioningJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.RepeatablePartJsonDeserializer;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseConfigurationJsonDeserializer
implements JsonDeserializer<CourseConfiguration<MarkConfigurationRequestAnnotation>> {
    private final SharedSailingData sharedSailingData;
    private final FreestyleMarkPropertiesJsonDeserializer commonMarkPropertiesJsonDeserializer;
    private final JsonDeserializer<RepeatablePart> repeatablePartJsonDeserializer;
    private final Regatta regatta;
    private final PositioningJsonDeserializer positioningJsonDeserializer;

    public CourseConfigurationJsonDeserializer(SharedSailingData sharedSailingData, DeviceIdentifierJsonDeserializer deviceIdentifierDeserializer, Regatta regatta) {
        this.sharedSailingData = sharedSailingData;
        this.commonMarkPropertiesJsonDeserializer = new FreestyleMarkPropertiesJsonDeserializer();
        this.repeatablePartJsonDeserializer = new RepeatablePartJsonDeserializer();
        this.positioningJsonDeserializer = new PositioningJsonDeserializer(deviceIdentifierDeserializer);
        this.regatta = regatta;
    }

    public CourseConfiguration<MarkConfigurationRequestAnnotation> deserialize(JSONObject json) throws JsonDeserializationException {
        Number numberOfLapsNumber;
        Integer numberOfLaps;
        JSONObject repeatablePartJSON;
        JSONArray wayPointsJSON;
        URL optionalImageURL;
        String name = (String)json.get((Object)"name");
        String shortName = (String)json.get((Object)"shortName");
        String optionalImageURLAsString = (String)json.get((Object)"optionalImageUrl");
        try {
            optionalImageURL = optionalImageURLAsString == null ? null : new URL(optionalImageURLAsString);
        }
        catch (MalformedURLException e) {
            throw new JsonDeserializationException((Throwable)e);
        }
        String courseTemplateIdString = (String)json.get((Object)"courseTemplateId");
        CourseTemplate optionalCourseTemplate = null;
        if (courseTemplateIdString != null && !courseTemplateIdString.isEmpty()) {
            optionalCourseTemplate = this.sharedSailingData.getCourseTemplateById(UUID.fromString(courseTemplateIdString));
        }
        CourseConfigurationBuilder builder = new CourseConfigurationBuilder(this.sharedSailingData, this.regatta, optionalCourseTemplate, name, shortName, optionalImageURL);
        HashMap<UUID, MarkConfiguration<MarkConfigurationRequestAnnotation>> markConfigurationsByID = new HashMap<UUID, MarkConfiguration<MarkConfigurationRequestAnnotation>>();
        JSONArray markConfigurationsJSON = (JSONArray)json.get((Object)"markConfigurations");
        if (markConfigurationsJSON != null) {
            for (Object markConfigurationObject : markConfigurationsJSON) {
                UUID markRoleIdOrNull;
                Iterator markConfigurationJSON = (JSONObject)markConfigurationObject;
                String markTemplateID = (String)markConfigurationJSON.get("markTemplateId");
                String markPropertiesID = (String)markConfigurationJSON.get("markPropertiesId");
                String markID = (String)markConfigurationJSON.get("markId");
                JSONObject freestylePropertiesObject = (JSONObject)markConfigurationJSON.get("freestyleProperties");
                Iterator optionalFreestyleProperties = freestylePropertiesObject == null ? null : this.commonMarkPropertiesJsonDeserializer.deserialize(freestylePropertiesObject);
                Object positioningObject = markConfigurationJSON.get("positioning");
                Positioning positioning = positioningObject instanceof JSONObject ? this.positioningJsonDeserializer.deserialize((JSONObject)positioningObject) : null;
                boolean storeToInventory = Boolean.TRUE.equals(markConfigurationJSON.get("storeToInventory"));
                String markRoleNameOrNull = (String)markConfigurationJSON.get("associatedRole");
                String markRoleShortNameOrNull = (String)markConfigurationJSON.get("associatedRoleShortName");
                MarkConfigurationRequestAnnotationImpl.MarkRoleCreationRequestImpl markRoleCreationRequestOrNull = markRoleNameOrNull != null ? new MarkConfigurationRequestAnnotationImpl.MarkRoleCreationRequestImpl(markRoleNameOrNull, markRoleShortNameOrNull) : null;
                MarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration = builder.addMarkConfiguration(markTemplateID != null ? UUID.fromString(markTemplateID) : null, markPropertiesID != null ? UUID.fromString(markPropertiesID) : null, markID != null ? UUID.fromString(markID) : null, (FreestyleMarkProperties)optionalFreestyleProperties, positioning, storeToInventory, (MarkConfigurationRequestAnnotation.MarkRoleCreationRequest)markRoleCreationRequestOrNull);
                String markRoleIdOrNullAsString = (String)markConfigurationJSON.get("associatedRoleId");
                UUID uUID = markRoleIdOrNull = markRoleIdOrNullAsString == null ? null : UUID.fromString(markRoleIdOrNullAsString);
                if (markRoleIdOrNull != null) {
                    builder.setRole(markConfiguration, markRoleIdOrNull);
                }
                markConfigurationsByID.put(UUID.fromString((String)markConfigurationJSON.get("id")), markConfiguration);
            }
        }
        if ((wayPointsJSON = (JSONArray)json.get((Object)"waypoints")) != null) {
            for (Object waypointObject : wayPointsJSON) {
                JSONObject waypointJSON = (JSONObject)waypointObject;
                ArrayList<MarkConfiguration> resolvedMarkConfigurations = new ArrayList<MarkConfiguration>();
                JSONArray markConfigurationIDs = (JSONArray)waypointJSON.get((Object)"markConfigurationIds");
                for (Object markConfigurationIdObject : markConfigurationIDs) {
                    MarkConfiguration resolvedMarkTemplate = (MarkConfiguration)markConfigurationsByID.get(UUID.fromString(markConfigurationIdObject.toString()));
                    if (resolvedMarkTemplate == null) {
                        throw new JsonDeserializationException("Mark configuration with ID " + markConfigurationIdObject + " was not defined to be part of the course configuration");
                    }
                    resolvedMarkConfigurations.add(resolvedMarkTemplate);
                }
                PassingInstruction passingInstruction = PassingInstruction.valueOf((String)((String)waypointJSON.get((Object)"passingInstruction")));
                if (resolvedMarkConfigurations.size() == 1) {
                    builder.addWaypoint((MarkConfiguration<MarkConfigurationRequestAnnotation>)((MarkConfiguration)resolvedMarkConfigurations.get(0)), passingInstruction);
                    continue;
                }
                if (resolvedMarkConfigurations.size() == 2) {
                    String controlPointName = (String)waypointJSON.get((Object)"controlPointName");
                    String controlPointShortName = (String)waypointJSON.get((Object)"controlPointShortName");
                    builder.addWaypoint((MarkConfiguration<MarkConfigurationRequestAnnotation>)((MarkConfiguration)resolvedMarkConfigurations.get(0)), (MarkConfiguration<MarkConfigurationRequestAnnotation>)((MarkConfiguration)resolvedMarkConfigurations.get(1)), controlPointName, passingInstruction, controlPointShortName);
                    continue;
                }
                throw new JsonDeserializationException("Unexpected number of mark configurations found for waypoint");
            }
        }
        if ((repeatablePartJSON = (JSONObject)json.get((Object)"optionalRepeatablePart")) != null) {
            RepeatablePart optionalRepeatablePart = (RepeatablePart)this.repeatablePartJsonDeserializer.deserialize(repeatablePartJSON);
            builder.setOptionalRepeatablePart(optionalRepeatablePart);
        }
        Integer n = numberOfLaps = (numberOfLapsNumber = (Number)json.get((Object)"numberOfLaps")) == null ? null : Integer.valueOf(numberOfLapsNumber.intValue());
        if (numberOfLaps != null) {
            builder.setNumberOfLaps(numberOfLaps);
        }
        CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfiguration = builder.build();
        return courseConfiguration;
    }
}

