/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Competitor;
import java.util.function.Supplier;

public interface CompetitorSerializationCustomizer {
    public static final ThreadLocal<CompetitorSerializationCustomizer> threadLocalCustomizer = new ThreadLocal();
    public static final CompetitorSerializationCustomizer defaultCustomizer = new CompetitorSerializationCustomizer(){

        @Override
        public boolean removalOfPersonalDataNecessary(Competitor competitor) {
            return false;
        }
    };

    public boolean removalOfPersonalDataNecessary(Competitor var1);

    public static CompetitorSerializationCustomizer getCurrentCustomizer() {
        CompetitorSerializationCustomizer result = threadLocalCustomizer.get();
        if (result == null) {
            result = defaultCustomizer;
        }
        return result;
    }

    public static void doWithCustomizer(CompetitorSerializationCustomizer customizer, Runnable action) {
        threadLocalCustomizer.set(customizer);
        try {
            action.run();
        }
        finally {
            threadLocalCustomizer.remove();
        }
    }

    public static <T> T doWithCustomizer(CompetitorSerializationCustomizer customizer, Supplier<T> action) {
        threadLocalCustomizer.set(customizer);
        try {
            T t = action.get();
            return t;
        }
        finally {
            threadLocalCustomizer.remove();
        }
    }
}

