/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSailNumberCanonicalizerAndMatcher<CompetitorType> {
    protected static final String sailIdRegexpPattern = "^([A-Z][A-Z][A-Z])?\\s*[^0-9]*([0-9]*)$";

    protected abstract SailNumberMatch match(String var1);

    public String canonicalizeSailID(String sailID, String defaultNationality) {
        String result = null;
        SailNumberMatch m = this.match(sailID);
        if (m != null) {
            String iocCode = m.getIocCode();
            if (iocCode != null) {
                iocCode = iocCode.toUpperCase();
            }
            if (defaultNationality != null && (iocCode == null || iocCode.trim().length() == 0)) {
                iocCode = defaultNationality.toUpperCase();
            }
            if (iocCode != null && iocCode.trim().length() > 0) {
                String number = m.getNumber();
                result = String.valueOf(iocCode) + number;
            }
        }
        if (result == null) {
            result = sailID.substring(0, Math.min(20, sailID.length()));
        }
        return result;
    }

    public Map<String, CompetitorType> mapCompetitorsAndInitializeAllOfficialRaceIDs(Iterable<CompetitorType> competitors, Iterable<String> sailNumbers) {
        HashMap<String, CompetitorType> result = new HashMap<String, CompetitorType>();
        Map<String, CompetitorType> canonicalizedSailIDToCompetitors = this.canonicalizeLeaderboardSailIDs(competitors);
        for (String sailNumber : sailNumbers) {
            String canonicalizedSailNumber = this.canonicalizeSailID(sailNumber, null);
            CompetitorType competitor = canonicalizedSailIDToCompetitors.get(canonicalizedSailNumber);
            result.put(sailNumber, competitor);
        }
        return result;
    }

    public Map<String, CompetitorType> canonicalizeLeaderboardSailIDs(Iterable<CompetitorType> competitors) {
        HashMap<String, CompetitorType> result = new HashMap<String, CompetitorType>();
        for (CompetitorType competitor : competitors) {
            String competitorIdentifyingText = this.getCompetitorIdentifyingText(competitor);
            String canonicalizedSailID = this.canonicalizeSailID(competitorIdentifyingText.trim(), this.getThreeLetterIocCountryCode(competitor).trim());
            if (canonicalizedSailID == null) continue;
            result.put(canonicalizedSailID, competitor);
        }
        return result;
    }

    protected abstract String getThreeLetterIocCountryCode(CompetitorType var1);

    protected abstract String getCompetitorIdentifyingText(CompetitorType var1);

    public static class SailNumberMatch {
        private final String iocCode;
        private final String number;

        public SailNumberMatch(String iocCode, String number) {
            this.iocCode = iocCode;
            this.number = number;
        }

        public String getIocCode() {
            return this.iocCode;
        }

        public String getNumber() {
            return this.number;
        }
    }
}

