/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.impl.AbstractNodeWrapper;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class BoatResultsInRaceImpl
extends AbstractNodeWrapper
implements BoatResultInRace {
    private static final Logger logger = Logger.getLogger(BoatResultsInRaceImpl.class.getName());
    private static final Pattern leadingPercentagePattern = Pattern.compile("^[0-9][0-9]*%.*$");
    private static final Pattern pointsPattern = Pattern.compile("[0-9]*(,[0-9]*)");

    public BoatResultsInRaceImpl(Node node) {
        super(node);
    }

    @Override
    public boolean isDiscarded() {
        String pointsAsString = this.getNode().getAttributes().getNamedItem("points").getNodeValue().trim();
        return pointsAsString.startsWith("(") && pointsAsString.endsWith(")");
    }

    @Override
    public Double getPoints() {
        String pointsAsString;
        Matcher m = pointsPattern.matcher(this.getNode().getAttributes().getNamedItem("points").getNodeValue());
        Double result = null;
        if (m.find() && !(pointsAsString = m.group().replace(',', '.').trim()).trim().equals("-")) {
            try {
                result = Double.valueOf(pointsAsString);
            }
            catch (NumberFormatException nfe) {
                logger.throwing(BoatResultsInRaceImpl.class.getName(), "getPoints", nfe);
            }
        }
        return result;
    }

    @Override
    public Integer getRaceNumber() {
        return Integer.valueOf(this.getNode().getAttributes().getNamedItem("number").getNodeValue());
    }

    @Override
    public String getStatus() {
        Node namedItem = this.getNode().getAttributes().getNamedItem("status");
        return namedItem == null || namedItem.getNodeValue() == null || namedItem.getNodeValue().trim().length() == 0 ? null : namedItem.getNodeValue();
    }

    @Override
    public MaxPointsReason getMaxPointsReason() {
        String status = this.getStatus();
        MaxPointsReason result = status != null ? (this.startsWithPercentage(status) ? MaxPointsReason.ZFP : MaxPointsReason.valueOf((String)status.substring(0, 3))) : MaxPointsReason.NONE;
        return result;
    }

    private boolean startsWithPercentage(String status) {
        return leadingPercentagePattern.matcher(status).matches();
    }

    public String toString() {
        return "{" + this.getRaceNumber() + ": " + this.getMaxPointsReason() + ", " + this.getPoints() + (this.isDiscarded() ? ", discarded" : "") + "}";
    }
}

