/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.util.EnumMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class EnumMapUtil {
    public static <K extends Enum<K>, V> Class<K> getKeyType(java.util.EnumMap<K, V> enumMap) throws IOException, ClassNotFoundException {
        Class<Object> result;
        if (enumMap.isEmpty()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(enumMap);
            oos.close();
            MyObjectInputStream ois = new MyObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            EnumMap readMap = (EnumMap)ois.readObject();
            Class keyType = readMap.getKeyType();
            result = keyType;
        } else {
            result = ((Enum)enumMap.keySet().iterator().next()).getDeclaringClass();
        }
        return result;
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        public MyObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class result = null;
            if (desc.getName().equals("java.util.EnumMap")) {
                result = EnumMap.class;
            } else {
                try {
                    result = super.resolveClass(desc);
                }
                catch (ClassNotFoundException e) {
                    result = Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                }
            }
            return result;
        }
    }
}

