/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.grib;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.grib.GribWindField;
import com.sap.sailing.grib.GribWindFieldFactory;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GribWindImporter
extends AbstractWindImporter {
    private static final Logger logger = Logger.getLogger(GribWindImporter.class.getName());

    @Override
    protected WindSource getDefaultWindSource(AbstractWindImporter.UploadRequest uploadRequest) {
        Object windSource = uploadRequest.boatId == null ? new WindSourceImpl(WindSourceType.WEB) : new WindSourceWithAdditionalID(WindSourceType.WEB, uploadRequest.boatId);
        return windSource;
    }

    @Override
    protected Map<WindSource, Iterable<Wind>> importWind(WindSource defaultWindSource, Map<InputStream, Util.Pair<String, Charset>> inputStreamsAndFilenamesAndCharsets) throws IOException {
        HashMap<InputStream, String> inputStreamsAndFilenames = new HashMap<InputStream, String>();
        for (Map.Entry<InputStream, Util.Pair<String, Charset>> e : inputStreamsAndFilenamesAndCharsets.entrySet()) {
            inputStreamsAndFilenames.put(e.getKey(), (String)e.getValue().getA());
        }
        GribWindField windField = GribWindFieldFactory.INSTANCE.createGribWindFieldFromStreams(logger, Level.INFO, inputStreamsAndFilenames);
        HashMap<WindSource, Iterable<Wind>> result = new HashMap<WindSource, Iterable<Wind>>();
        HashMap<Position, WindSource> windSourcesByPosition = new HashMap<Position, WindSource>();
        HashMap writableResult = new HashMap();
        for (Wind windFix : windField.getAllWindFixes()) {
            WindSource windSourceForFix = this.getOrCreateWindSourceForPosition(windSourcesByPosition, windFix.getPosition(), defaultWindSource);
            Util.addToValueSet(writableResult, (Object)windSourceForFix, (Object)windFix);
        }
        result.putAll(writableResult);
        return result;
    }

    private WindSource getOrCreateWindSourceForPosition(Map<Position, WindSource> windSourcesByPosition, Position position, WindSource defaultWindSource) {
        return windSourcesByPosition.computeIfAbsent(position, p -> new WindSourceWithAdditionalID(defaultWindSource.getType(), defaultWindSource.getId() == null ? p.toString() : defaultWindSource.getId() + "@" + p.toString()));
    }
}

