/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.util.FileItemHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class AbstractWindImporter {
    public void importWindForUploadRequest(RacingEventService service, WindImportResult windImportResult, UploadRequest uploadRequest) throws Exception {
        WindSource windSource = this.getDefaultWindSource(uploadRequest);
        ArrayList<DynamicTrackedRace> trackedRaces = new ArrayList<DynamicTrackedRace>();
        if (uploadRequest.races.size() > 0) {
            for (RegattaAndRaceIdentifier raceEntry : uploadRequest.races) {
                DynamicTrackedRace trackedRace = service.getTrackedRace(raceEntry);
                if (trackedRace == null) continue;
                SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
                trackedRaces.add(trackedRace);
            }
        } else {
            for (Regatta regatta : service.getAllRegattas()) {
                for (RaceDefinition raceDefinition : regatta.getAllRaces()) {
                    DynamicTrackedRace trackedRace = service.getTrackedRegatta(regatta).getExistingTrackedRace(raceDefinition);
                    if (trackedRace == null || !SecurityUtils.getSubject().isPermitted(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE))) continue;
                    trackedRaces.add(trackedRace);
                }
            }
        }
        HashMap<InputStream, Util.Pair<String, Charset>> streamsWithFilenamesAndCharsets = new HashMap<InputStream, Util.Pair<String, Charset>>();
        for (FileItem file : uploadRequest.files) {
            streamsWithFilenamesAndCharsets.put(file.getInputStream(), (Util.Pair<String, Charset>)new Util.Pair((Object)file.getName(), (Object)FileItemHelper.getCharset((FileItem)file, (Charset)Charset.forName("UTF-8"))));
        }
        this.importWindToWindSourceAndTrackedRaces(service, windImportResult, windSource, trackedRaces, streamsWithFilenamesAndCharsets);
    }

    public void importWindToWindSourceAndTrackedRaces(RacingEventService service, WindImportResult windImportResult, WindSource defaultWindSource, List<DynamicTrackedRace> trackedRaces, Map<InputStream, Util.Pair<String, Charset>> streamsWithFilenamesAndCharsets) throws Exception {
        Map<WindSource, Iterable<Wind>> windFixes = this.importWind(defaultWindSource, streamsWithFilenamesAndCharsets);
        for (Map.Entry<WindSource, Iterable<Wind>> windForSource : windFixes.entrySet()) {
            if (Util.isEmpty(windForSource.getValue())) continue;
            for (DynamicTrackedRace trackedRace : trackedRaces) {
                RegattaAndRaceIdentifier raceIdentifier = trackedRace.getRaceIdentifier();
                WindImportResult.RaceEntry raceEntry = windImportResult.addRaceEntry(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName());
                for (Wind wind : windForSource.getValue()) {
                    windImportResult.update(wind);
                    if (!trackedRace.recordWind(wind, windForSource.getKey() == null ? defaultWindSource : windForSource.getKey())) continue;
                    raceEntry.update(wind);
                }
                service.getPolarDataService().insertExistingFixes((TrackedRace)trackedRace);
            }
        }
    }

    protected abstract Map<WindSource, Iterable<Wind>> importWind(WindSource var1, Map<InputStream, Util.Pair<String, Charset>> var2) throws IOException, InterruptedException, FormatNotSupportedException, Exception;

    protected abstract WindSource getDefaultWindSource(UploadRequest var1);

    public static class UploadRequest {
        public String boatId;
        public final List<FileItem> files = new ArrayList<FileItem>();
        public List<RegattaAndRaceIdentifier> races = new ArrayList<RegattaAndRaceIdentifier>();
    }

    public static class WindImportResult {
        private Date first;
        private Date last;
        public String error;
        public final List<RaceEntry> raceEntries = new ArrayList<RaceEntry>();

        public Date getFirst() {
            return this.first;
        }

        public Date getLast() {
            return this.last;
        }

        public void update(Wind newWind) {
            Date newDate = newWind.getTimePoint().asDate();
            if (this.first == null || newDate.before(this.first)) {
                this.first = newDate;
            }
            if (this.last == null || newDate.after(this.last)) {
                this.last = newDate;
            }
        }

        RaceEntry addRaceEntry(String regattaName, String raceName) {
            RaceEntry raceEntry = new RaceEntry(regattaName, raceName);
            this.raceEntries.add(raceEntry);
            return raceEntry;
        }

        public JSONObject json() {
            JSONObject result = new JSONObject();
            if (this.getFirst() != null) {
                result.put((Object)"first", (Object)this.getFirst().getTime());
            }
            if (this.getLast() != null) {
                result.put((Object)"last", (Object)this.getLast().getTime());
            }
            result.put((Object)"error", (Object)this.error);
            JSONArray raceEntriesJson = new JSONArray();
            for (RaceEntry raceEntry : this.raceEntries) {
                if (raceEntry.count <= 0) continue;
                raceEntriesJson.add((Object)raceEntry.json());
            }
            result.put((Object)"raceEntries", (Object)raceEntriesJson);
            return result;
        }

        static class RaceEntry {
            public final String regattaName;
            public final String raceName;
            private int count;
            private Date first;
            private Date last;

            private RaceEntry(String regattaName, String raceName) {
                this.regattaName = regattaName;
                this.raceName = raceName;
            }

            public void update(Wind newWind) {
                ++this.count;
                Date newDate = newWind.getTimePoint().asDate();
                if (this.first == null || newDate.before(this.first)) {
                    this.first = newDate;
                }
                if (this.last == null || newDate.after(this.last)) {
                    this.last = newDate;
                }
            }

            public int getCount() {
                return this.count;
            }

            public Date getFirst() {
                return this.first;
            }

            public Date getLast() {
                return this.last;
            }

            private JSONObject json() {
                JSONObject result = new JSONObject();
                result.put((Object)"regattaName", (Object)this.regattaName);
                result.put((Object)"raceName", (Object)this.raceName);
                result.put((Object)"count", (Object)this.getCount());
                if (this.getFirst() != null) {
                    result.put((Object)"first", (Object)this.getFirst().getTime());
                }
                if (this.getLast() != null) {
                    result.put((Object)"last", (Object)this.getLast().getTime());
                }
                return result;
            }
        }
    }
}

