/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.server.gateway.impl.AbstractFileUploadServlet;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResultSerializer;
import com.sap.sailing.server.gateway.trackfiles.impl.SensorDataImporter;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.json.simple.JSONAware;

public class SensorDataImportServlet
extends AbstractFileUploadServlet {
    private static final long serialVersionUID = 1120226743039934620L;
    private static final Logger logger = Logger.getLogger(SensorDataImportServlet.class.getName());

    @Override
    protected void process(List<FileItem> fileItems, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ImportResult importResult = new ImportResult(logger);
        boolean enableDownsampler = false;
        try {
            try {
                String importerName = null;
                for (FileItem fi : fileItems) {
                    if ("preferredImporter".equalsIgnoreCase(fi.getFieldName())) {
                        importerName = fi.getString();
                        continue;
                    }
                    if (!"downsample".equalsIgnoreCase(fi.getFieldName())) continue;
                    enableDownsampler = "on".equalsIgnoreCase(fi.getString());
                }
                if (importerName == null) {
                    throw new RuntimeException("Missing preferred importer");
                }
                ArrayList<Util.Pair<String, FileItem>> filesAndImporterNames = new ArrayList<Util.Pair<String, FileItem>>();
                for (FileItem fi : fileItems) {
                    if (!"file".equalsIgnoreCase(fi.getFieldName())) continue;
                    filesAndImporterNames.add((Util.Pair<String, FileItem>)new Util.Pair((Object)importerName, (Object)fi));
                }
                new SensorDataImporter(this.getService(), this.getContext()).importFiles(enableDownsampler, importResult, filesAndImporterNames);
            }
            catch (Exception e) {
                importResult.add(e);
                this.writeJsonIntoHtmlResponse(resp, (JSONAware)ImportResultSerializer.serializeImportResult(importResult));
            }
        }
        finally {
            this.writeJsonIntoHtmlResponse(resp, (JSONAware)ImportResultSerializer.serializeImportResult(importResult));
        }
    }
}

