/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogSetCompetitorTimeOnTimeFactorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.CompetitorImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneUUIDIdentifierImpl;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.shared.tracking.LineDetails;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceWindCalculator;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindSummary;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.jaxrs.api.BearingJsonSerializer;
import com.sap.sailing.server.gateway.jaxrs.api.DataMiningResource;
import com.sap.sailing.server.gateway.jaxrs.api.TrackingDeviceStatus;
import com.sap.sailing.server.gateway.jaxrs.api.TrackingDeviceStatusSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.ControlPointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseWithGeometryJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.GateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.BoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ColorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorTrackElementsJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorTrackWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompleteManeuverCurveWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompleteManeuverCurvesWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DefaultWindTrackJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DetailedBoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DeviceIdentifierJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DistanceJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.FleetJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.GPSFixJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.GPSFixMovingJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.GpsFixesWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverCurveBoundariesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverMainCurveWithEstimationDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverWindJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuversJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MarkPassingsJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.NationalityJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PersonJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RaceEntriesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RaceWindJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RegattaJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.SeriesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TargetTimeInfoSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TeamJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TrackedRaceJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.WindJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.operationaltransformation.AddColumnToSeries;
import com.sap.sailing.server.operationaltransformation.RemoveRegatta;
import com.sap.sailing.server.operationaltransformation.UpdateSeries;
import com.sap.sailing.server.operationaltransformation.UpdateSpecificRegatta;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.common.util.RoundingUtil;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.BearerAuthenticationToken;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import com.sap.sse.util.HttpRequestUtils;
import com.sap.sse.util.SingleCalculationPerSubjectCache;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/regattas")
public class RegattasResource
extends AbstractSailingServerResource {
    private static final String SECONDARY_USER_BEARER_TOKEN = "secondaryuserbearertoken";
    private static final Logger logger = Logger.getLogger(RegattasResource.class.getName());
    private DataMiningResource dataMiningResource;
    private final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
    private static final SingleCalculationPerSubjectCache<CompetitorRanksRequest, JSONObject> competitorRanksCache = new SingleCalculationPerSubjectCache(r -> r.getResource().computeCompetitorRanks(r.getRegatta(), r.getRaceColumn(), r.getFleet()), Duration.ONE_MINUTE.times(10L));
    private static final SingleCalculationPerSubjectCache<CompetitorLiveRanksRequest, JSONObject> competitorLiveRanksCache = new SingleCalculationPerSubjectCache(r -> r.getResource().computeCompetitorLiveRanks(r.getRegattaName(), r.getRaceName(), r.getTopN()), Duration.ONE_MINUTE.times(10L));

    private DataMiningResource getDataMiningResource() {
        if (this.dataMiningResource == null) {
            this.dataMiningResource = (DataMiningResource)((Object)this.getResourceContext().getResource(DataMiningResource.class));
        }
        return this.dataMiningResource;
    }

    private Response getBadRegattaErrorResponse(String regattaName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadRegattaRegistrationTypeErrorResponse(String regattaName) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Self-registration to regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "' is not allowed.")).type("text/plain").build();
    }

    private Response getBadRegattaRegistrationValidationErrorResponse(String errorText) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    private Response getAlreadyRegisteredDeviceErrorResponse(String regattaName, String deviceId) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Device is already registered to regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getDeregisterCompetitorErrorResponse(String regattaName, String competitorId, String errorText) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Deregistering competitor " + StringEscapeUtils.escapeHtml((String)competitorId) + " from regatta " + StringEscapeUtils.escapeHtml((String)regattaName) + " failed: " + errorText)).type("text/plain").build();
    }

    private Response getBadBoatClassResponse(String boatClassName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not use a boat class with name '" + StringEscapeUtils.escapeHtml((String)boatClassName) + "'.")).type("text/plain").build();
    }

    private Response getBadCompetitorIdResponse(Serializable competitorId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a competitor with ID '" + StringEscapeUtils.escapeHtml((String)competitorId.toString()) + "'.")).type("text/plain").build();
    }

    private Response getBadRaceErrorResponse(String regattaName, String raceName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadCourseErrorResponse(String regattaName, String raceColumn, String fleet) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No course found for given race with raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumn) + "' and fleet '" + StringEscapeUtils.escapeHtml((String)fleet) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).build();
    }

    private Response getBadRaceErrorResponse(String regattaName, String raceColumn, String fleet) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumn) + "' and fleet '" + StringEscapeUtils.escapeHtml((String)fleet) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadSeriesErrorResponse(String regattaName, String seriesName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a series with name '" + StringEscapeUtils.escapeHtml((String)seriesName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getNoTrackedRaceErrorResponse(String regattaName, String raceName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No tracked race for race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getNotEnoughDataAvailabeErrorResponse(String regattaName, String raceName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No wind or polar data for race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getRegattas() {
        RegattaJsonSerializer regattaJsonSerializer = new RegattaJsonSerializer(this.getSecurityService());
        JSONArray regattasJson = new JSONArray();
        for (Regatta regatta : this.getService().getAllRegattas()) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta)) continue;
            regattasJson.add((Object)regattaJsonSerializer.serialize(regatta));
        }
        return Response.ok((Object)this.streamingOutput(regattasJson)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}")
    public Response getRegatta(@PathParam(value="regattaname") String regattaName, @QueryParam(value="secret") String regattaSecret) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret);
            if (!skip) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            SeriesJsonSerializer seriesJsonSerializer = new SeriesJsonSerializer((JsonSerializer)new FleetJsonSerializer((JsonSerializer)new ColorJsonSerializer()), (RaceLogResolver)this.getService());
            RegattaJsonSerializer regattaSerializer = new RegattaJsonSerializer((JsonSerializer)seriesJsonSerializer, null, null, this.getSecurityService());
            JSONObject serializedRegatta = regattaSerializer.serialize((Object)regatta);
            response = Response.ok((Object)this.streamingOutput(serializedRegatta)).build();
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaName}")
    public Response updateRegatta(String jsonBody, @PathParam(value="regattaName") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            String competitorRegistrationTypeString;
            JSONObject requestObject;
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
            try {
                Object requestBody = JSONValue.parseWithException((String)jsonBody);
                requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
            }
            catch (JsonDeserializationException | ParseException e) {
                logger.log(Level.WARNING, "Exception while parsing post request", e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
            }
            Number startTimePointAsMillis = (Number)requestObject.get((Object)"startTimePointAsMillis");
            MillisecondsTimePoint startTimePoint = startTimePointAsMillis == null ? null : new MillisecondsTimePoint(startTimePointAsMillis.longValue());
            Number endTimePointAsMillis = (Number)requestObject.get((Object)"endTimePointAsMillis");
            MillisecondsTimePoint endTimePoint = endTimePointAsMillis == null ? null : new MillisecondsTimePoint(endTimePointAsMillis.longValue());
            String defaultCourseAreaUuidString = (String)requestObject.get((Object)"defaultCourseAreaUuid");
            UUID defaultCourseAreaUuid = defaultCourseAreaUuidString == null ? null : UUID.fromString(defaultCourseAreaUuidString);
            Number buoyZoneRadiusInHullLengthsNumber = (Number)requestObject.get((Object)"buoyZoneRadiusInHullLengths");
            Double buoyZoneRadiusInHullLengths = buoyZoneRadiusInHullLengthsNumber == null ? null : Double.valueOf(buoyZoneRadiusInHullLengthsNumber.doubleValue());
            boolean useStartTimeInference = Boolean.TRUE.equals(requestObject.get((Object)"useStartTimeInference"));
            boolean controlTrackingFromStartAndFinishTimes = Boolean.TRUE.equals(requestObject.get((Object)"controlTrackingFromStartAndFinishTimes"));
            boolean autoRestartTrackingUponCompetitorSetChange = Boolean.TRUE.equals(requestObject.get((Object)"autoRestartTrackingUponCompetitorSetChange"));
            String registrationLinkSecret = (String)requestObject.get((Object)"registrationLinkSecret");
            if (registrationLinkSecret == null) {
                registrationLinkSecret = regatta.getRegistrationLinkSecret();
            }
            CompetitorRegistrationType competitorRegistrationType = (competitorRegistrationTypeString = (String)requestObject.get((Object)"competitorRegistrationType")) == null ? regatta.getCompetitorRegistrationType() : CompetitorRegistrationType.valueOf((String)competitorRegistrationTypeString);
            this.getService().apply((OperationWithResult)new UpdateSpecificRegatta((RegattaIdentifier)new RegattaName(regattaName), (TimePoint)startTimePoint, (TimePoint)endTimePoint, defaultCourseAreaUuid, regatta.getRegattaConfiguration(), buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, registrationLinkSecret, competitorRegistrationType));
            SeriesJsonSerializer seriesJsonSerializer = new SeriesJsonSerializer((JsonSerializer)new FleetJsonSerializer((JsonSerializer)new ColorJsonSerializer()), (RaceLogResolver)this.getService());
            RegattaJsonSerializer regattaSerializer = new RegattaJsonSerializer((JsonSerializer)seriesJsonSerializer, null, null, this.getSecurityService());
            JSONObject serializedRegatta = regattaSerializer.serialize((Object)regatta);
            response = Response.ok((Object)this.streamingOutput(serializedRegatta)).build();
        }
        return response;
    }

    @DELETE
    @Path(value="{regattaname}")
    public Response delete(@PathParam(value="regattaname") String regattaName) {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta != null) {
            HashSet<QualifiedObjectIdentifier> objectsThatWillBeImplicitlyCleanedByRemoveRegatta = new HashSet<QualifiedObjectIdentifier>();
            objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(regatta.getIdentifier());
            for (RaceDefinition race : regatta.getAllRaces()) {
                TypeRelativeObjectIdentifier typeRelativeObjectIdentifier = RegattaNameAndRaceName.getTypeRelativeObjectIdentifier((String)regatta.getName(), (String)race.getName());
                QualifiedObjectIdentifier identifier = SecuredDomainType.TRACKED_RACE.getQualifiedObjectIdentifier(typeRelativeObjectIdentifier);
                objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(identifier);
            }
            for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
                RegattaLeaderboard regattaLeaderboard;
                if (!(leaderboard instanceof RegattaLeaderboard) || (regattaLeaderboard = (RegattaLeaderboard)leaderboard).getRegatta() != regatta) continue;
                objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(regattaLeaderboard.getIdentifier());
            }
            for (QualifiedObjectIdentifier toRemovePermissionObjects : objectsThatWillBeImplicitlyCleanedByRemoveRegatta) {
                this.getSecurityService().checkCurrentUserDeletePermission(toRemovePermissionObjects);
            }
            this.getService().apply((OperationWithResult)new RemoveRegatta(regatta.getRegattaIdentifier()));
            for (QualifiedObjectIdentifier toRemovePermissionObjects : objectsThatWillBeImplicitlyCleanedByRemoveRegatta) {
                this.getSecurityService().deleteAllDataForRemovedObject(toRemovePermissionObjects);
            }
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/entries")
    public Response getEntries(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            NationalityJsonSerializer nationalityJsonSerializer = new NationalityJsonSerializer();
            BoatJsonSerializer boatJsonSerializer = new BoatJsonSerializer((JsonSerializer)new BoatClassJsonSerializer());
            CompetitorJsonSerializer competitorJsonSerializer = new CompetitorJsonSerializer((JsonSerializer)new TeamJsonSerializer((JsonSerializer)new PersonJsonSerializer((JsonSerializer)nationalityJsonSerializer)), (JsonSerializer)boatJsonSerializer, false);
            RegattaJsonSerializer regattaSerializer = new RegattaJsonSerializer(null, (JsonSerializer)competitorJsonSerializer, (JsonSerializer)boatJsonSerializer, this.getSecurityService());
            JSONObject serializedRegatta = regattaSerializer.serialize((Object)regatta);
            response = Response.ok((Object)this.streamingOutput(serializedRegatta)).build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/entries")
    public Response getEntries(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                RaceEntriesJsonSerializer raceEntriesSerializer = new RaceEntriesJsonSerializer(this.getSecurityService());
                JSONObject serializedRaceEntries = raceEntriesSerializer.serialize((Object)race);
                response = Response.ok((Object)this.streamingOutput(serializedRaceEntries)).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/competitors")
    public Response getCompetitors(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            CompetitorJsonSerializer competitorSerializer = CompetitorJsonSerializer.create();
            JSONArray result = new JSONArray();
            for (Competitor competitor : regatta.getAllCompetitors()) {
                if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                double effectiveTimeOnTimeFactor = regatta.getTimeOnTimeFactor(competitor, Optional.empty());
                Duration effectiveTimeOnDistanceAllowancePerNauticalMile = regatta.getTimeOnDistanceAllowancePerNauticalMile(competitor, Optional.empty());
                JSONObject competitorJson = competitorSerializer.serialize(competitor);
                competitorJson.put((Object)"timeOnTimeFactor", (Object)effectiveTimeOnTimeFactor);
                competitorJson.put((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile", effectiveTimeOnDistanceAllowancePerNauticalMile == null ? null : Double.valueOf(effectiveTimeOnDistanceAllowancePerNauticalMile.asSeconds()));
                result.add((Object)competitorJson);
            }
            response = Response.ok((Object)this.streamingOutput(result)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        }
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/competitors/{competitorid}/add")
    public Response addCompetitor(@PathParam(value="regattaname") String regattaName, @PathParam(value="competitorid") String competitorIdAsString, @QueryParam(value="secret") String registrationLinkSecret) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            Object competitorId;
            boolean skipPermissionCheck = this.getService().skipChecksDueToCorrectSecret(regattaName, registrationLinkSecret);
            if (!skipPermissionCheck) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
            }
            try {
                competitorId = UUID.fromString(competitorIdAsString);
            }
            catch (IllegalArgumentException e) {
                competitorId = competitorIdAsString;
            }
            Competitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorById((Serializable)competitorId);
            if (competitor == null) {
                response = this.getBadCompetitorIdResponse((Serializable)competitorId);
            } else {
                this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
                regatta.registerCompetitor(competitor);
                response = Response.ok().build();
            }
        }
        return response;
    }

    private Response createAndAddCompetitor(String regattaName, String nationalityThreeLetterIOCCode, String rgbColor, Double timeOnTimeFactor, Long timeOnDistanceAllowancePerNauticalMileAsMillis, String searchTag, String competitorName, String competitorShortName, String competitorEmail, String flagImageURIString, String teamImageURIString, BoatObtainer boatObtainer, String deviceUuid, String registrationLinkSecret) {
        Response response;
        User user = this.getSecurityService().getCurrentUser();
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        OwnershipAnnotation regattaOwnershipAnnotation = this.getSecurityService().getOwnership(regatta.getIdentifier());
        if (regattaOwnershipAnnotation == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        boolean skipPermissionChecksBasedOnCorrectRegattaSecretProvided = Util.equalsWithNull((Object)regatta.getRegistrationLinkSecret(), (Object)registrationLinkSecret);
        if (!(this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta) || skipPermissionChecksBasedOnCorrectRegattaSecretProvided && regatta.getCompetitorRegistrationType().isOpen())) {
            return this.getBadRegattaRegistrationTypeErrorResponse(regattaName);
        }
        String eCompetitorName = null;
        String eCompetitorShortName = null;
        String eCompetitorEmail = null;
        if (competitorName == null && user == null) {
            return this.getBadRegattaRegistrationValidationErrorResponse("No competitor name specified and no user authenticated; can't derive competitor name");
        }
        eCompetitorName = competitorName == null ? (user.getFullName() == null ? user.getName() : user.getFullName()) : competitorName;
        String string = eCompetitorShortName = competitorShortName == null ? eCompetitorName : competitorShortName;
        eCompetitorEmail = competitorEmail == null ? (user != null ? user.getEmail() : null) : competitorEmail;
        boolean duplicateDeviceId = false;
        if (deviceUuid != null) {
            RegattaLog regattaLog = regatta.getRegattaLog();
            regattaLog.lockForRead();
            try {
                duplicateDeviceId = regattaLog.getUnrevokedEvents().stream().anyMatch(event -> {
                    if (event instanceof RegattaLogDeviceCompetitorMappingEvent) {
                        return deviceUuid.equals(((RegattaLogDeviceCompetitorMappingEvent)event).getDevice().getStringRepresentation());
                    }
                    return false;
                });
            }
            finally {
                regattaLog.unlockAfterRead();
            }
        }
        if (duplicateDeviceId) {
            response = this.getAlreadyRegisteredDeviceErrorResponse(regattaName, deviceUuid);
        } else {
            URI teamImageURI;
            URI flagImageURI;
            RGBColor color;
            DynamicBoat boat = boatObtainer.getBoat(eCompetitorShortName, regattaOwnershipAnnotation, skipPermissionChecksBasedOnCorrectRegattaSecretProvided);
            if (rgbColor == null || rgbColor.length() == 0) {
                color = null;
            } else {
                try {
                    color = new RGBColor(rgbColor);
                }
                catch (IllegalArgumentException iae) {
                    return this.getBadRegattaRegistrationValidationErrorResponse(String.format("invalid color %s", iae.getMessage()));
                }
            }
            if (flagImageURIString == null || flagImageURIString.length() == 0) {
                flagImageURI = null;
            } else {
                try {
                    flagImageURI = new URI(flagImageURIString);
                }
                catch (URISyntaxException use) {
                    return this.getBadRegattaRegistrationValidationErrorResponse(String.format("invalid flagImageURIString %s", flagImageURIString));
                }
            }
            if (teamImageURIString == null || teamImageURIString.length() == 0) {
                teamImageURI = null;
            } else {
                try {
                    teamImageURI = new URI(teamImageURIString);
                }
                catch (URISyntaxException use) {
                    return this.getBadRegattaRegistrationValidationErrorResponse(String.format("invalid flagImageURIString %s", teamImageURIString));
                }
            }
            TeamImpl team = new TeamImpl(eCompetitorShortName, Collections.singleton(new PersonImpl(eCompetitorName, this.getService().getBaseDomainFactory().getOrCreateNationality(nationalityThreeLetterIOCCode), null, null)), null, teamImageURI);
            UUID competitorUuid = UUID.randomUUID();
            String name = eCompetitorName;
            String shortName = eCompetitorShortName;
            String email = eCompetitorEmail;
            CompetitorWithBoat competitor = null;
            Callable<CompetitorWithBoat> createCompetitorJob = () -> this.lambda$3(competitorUuid, name, shortName, (Color)color, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMileAsMillis, searchTag, boat);
            if (skipPermissionChecksBasedOnCorrectRegattaSecretProvided) {
                try {
                    competitor = createCompetitorJob.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.getSecurityService().setOwnership(competitor.getIdentifier(), (User)((Ownership)regattaOwnershipAnnotation.getAnnotation()).getUserOwner(), (UserGroup)((Ownership)regattaOwnershipAnnotation.getAnnotation()).getTenantOwner(), name);
            } else {
                competitor = (CompetitorWithBoat)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.COMPETITOR, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitorUuid), name, createCompetitorJob);
            }
            regatta.registerCompetitor((Competitor)competitor);
            response = Response.ok((Object)this.streamingOutput(CompetitorJsonSerializer.create().serialize((Competitor)competitor))).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
            if (deviceUuid != null) {
                SmartphoneUUIDIdentifierImpl device = new SmartphoneUUIDIdentifierImpl(UUID.fromString(deviceUuid));
                TimePoint now = MillisecondsTimePoint.now();
                RegattaLogDeviceCompetitorMappingEventImpl event2 = new RegattaLogDeviceCompetitorMappingEventImpl(now, now, (AbstractLogEventAuthor)new LogEventAuthorImpl(eCompetitorName, 0), (Serializable)UUID.randomUUID(), (Competitor)competitor, (DeviceIdentifier)device, now, null);
                regatta.getRegattaLog().add((AbstractLogEvent)event2);
            }
        }
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/competitors/createandadd")
    public Response createAndAddCompetitor(@PathParam(value="regattaname") String regattaName, @QueryParam(value="boatclass") String boatClassName, @QueryParam(value="sailid") String sailId, @QueryParam(value="nationalityIOC") String nationalityThreeLetterIOCCode, @QueryParam(value="displayColor") String displayColor, @QueryParam(value="flagImageURI") String flagImageURI, @QueryParam(value="teamImageURI") String teamImageURI, @QueryParam(value="timeontimefactor") Double timeOnTimeFactor, @QueryParam(value="timeondistanceallowancepernauticalmileasmillis") Long timeOnDistanceAllowancePerNauticalMileAsMillis, @QueryParam(value="searchtag") String searchTag, @QueryParam(value="competitorName") String competitorName, @QueryParam(value="competitorShortName") String competitorShortName, @QueryParam(value="competitorEmail") String competitorEmail, @QueryParam(value="deviceUuid") String deviceUuid, @QueryParam(value="secret") String registrationLinkSecret) {
        Response response = boatClassName == null ? this.getBadBoatClassResponse(boatClassName) : this.createAndAddCompetitor(regattaName, nationalityThreeLetterIOCCode, displayColor, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMileAsMillis, searchTag, competitorName, competitorShortName, competitorEmail, flagImageURI, teamImageURI, (shortName, regattaOwnershipAnnotation, skipPermissionChecksBasedOnCorrectRegattaSecretProvided) -> this.createBoat(shortName, boatClassName, sailId, regattaOwnershipAnnotation, skipPermissionChecksBasedOnCorrectRegattaSecretProvided), deviceUuid, registrationLinkSecret);
        return response;
    }

    private DynamicBoat createBoat(String name, String boatClassName, String sailId, OwnershipAnnotation regattaOwnershipAnnotation, boolean skipPermissionChecksBasedOnCorrectRegattaSecretProvided) {
        DynamicBoat boat;
        UUID boatUUID = UUID.randomUUID();
        Callable<DynamicBoat> job = () -> new BoatImpl((Serializable)boatUUID, name, this.getService().getBaseDomainFactory().getOrCreateBoatClass(boatClassName, true), sailId);
        if (skipPermissionChecksBasedOnCorrectRegattaSecretProvided) {
            try {
                boat = job.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.getSecurityService().getOwnership(boat.getIdentifier()) == null) {
                this.getSecurityService().setOwnership(boat.getIdentifier(), (User)((Ownership)regattaOwnershipAnnotation.getAnnotation()).getUserOwner(), (UserGroup)((Ownership)regattaOwnershipAnnotation.getAnnotation()).getTenantOwner(), name);
            }
        } else {
            boat = (DynamicBoat)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.BOAT, BoatImpl.getTypeRelativeObjectIdentifier((Serializable)boatUUID), name, job);
        }
        return boat;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/competitors/createandaddwithboat")
    public Response createAndAddCompetitorWithBoat(@PathParam(value="regattaname") String regattaName, @QueryParam(value="boatId") String boatId, @QueryParam(value="sailid") String sailId, @QueryParam(value="nationalityIOC") String nationalityThreeLetterIOCCode, @QueryParam(value="flagImageURI") String flagImageURI, @QueryParam(value="teamImageURI") String teamImageURI, @QueryParam(value="displayColor") String displayColor, @QueryParam(value="timeontimefactor") Double timeOnTimeFactor, @QueryParam(value="timeondistanceallowancepernauticalmileasmillis") Long timeOnDistanceAllowancePerNauticalMileAsMillis, @QueryParam(value="searchtag") String searchTag, @QueryParam(value="competitorName") String competitorName, @QueryParam(value="competitorShortName") String competitorShortName, @QueryParam(value="competitorEmail") String competitorEmail, @QueryParam(value="deviceUuid") String deviceUuid, @QueryParam(value="secret") String registrationLinkSecret) {
        Response response;
        DynamicBoat boat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(boatId);
        if (boat == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Boat is not valid").type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)boat, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
            response = this.createAndAddCompetitor(regattaName, nationalityThreeLetterIOCCode, displayColor, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMileAsMillis, searchTag, competitorName, competitorShortName, competitorEmail, flagImageURI, teamImageURI, (t, regattaOwnershipAnnotation, skipPermissionChecks) -> boat, deviceUuid, registrationLinkSecret);
        }
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/competitors/{competitorid}/remove")
    public Response removeCompetitor(@PathParam(value="regattaname") String regattaName, @PathParam(value="competitorid") String competitorIdAsString, @QueryParam(value="secret") String registrationLinkSecret) {
        Response response;
        Subject subject = SecurityUtils.getSubject();
        User user = this.getSecurityService().getCurrentUser();
        Regatta regatta = this.findRegattaByName(regattaName);
        if (registrationLinkSecret != null && registrationLinkSecret.length() > 0 && !CompetitorRegistrationType.CLOSED.equals((Object)regatta.getCompetitorRegistrationType())) {
            if (!regatta.getRegistrationLinkSecret().equals(registrationLinkSecret)) {
                return this.getBadRegattaRegistrationTypeErrorResponse(regattaName);
            }
            RegattaLog regattaLog = regatta.getRegattaLog();
            HashSet<RegattaLogDeviceCompetitorMappingEvent> eventsToRevoke = new HashSet<RegattaLogDeviceCompetitorMappingEvent>();
            regattaLog.lockForRead();
            try {
                for (RegattaLogEvent event : regattaLog.getUnrevokedEvents()) {
                    if (!(event instanceof RegattaLogDeviceCompetitorMappingEvent)) continue;
                    eventsToRevoke.add((RegattaLogDeviceCompetitorMappingEvent)event);
                }
            }
            finally {
                regattaLog.unlockAfterRead();
            }
            for (RegattaLogDeviceCompetitorMappingEvent eventToRevoke : eventsToRevoke) {
                try {
                    regattaLog.revokeEvent((AbstractLogEventAuthor)new LogEventAuthorImpl(user == null ? "anonymous" : user.getFullName(), 0), (AbstractLogEvent)eventToRevoke, "deregister device " + eventToRevoke.getDevice().getStringRepresentation());
                }
                catch (NotRevokableException e) {
                    return this.getDeregisterCompetitorErrorResponse(regattaName, competitorIdAsString, e.getMessage());
                }
            }
        } else {
            subject.checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            Object competitorId;
            try {
                competitorId = UUID.fromString(competitorIdAsString);
            }
            catch (IllegalArgumentException e) {
                competitorId = competitorIdAsString;
            }
            Competitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorById((Serializable)competitorId);
            if (competitor == null) {
                response = this.getBadCompetitorIdResponse((Serializable)competitorId);
            } else {
                this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
                regatta.deregisterCompetitor(competitor);
                response = Response.ok().build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/competitors/positions")
    public Response getCompetitorPositions(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="fromtime") String fromtime, @QueryParam(value="fromtimeasmillis") Long fromtimeasmillis, @QueryParam(value="totime") String totime, @QueryParam(value="totimeasmillis") Long totimeasmillis, @QueryParam(value="withtack") Boolean withTack, @QueryParam(value="competitorId") Set<String> competitorIds, @DefaultValue(value="false") @QueryParam(value="lastknown") boolean addLastKnown, @DefaultValue(value="false") @QueryParam(value="raw") boolean raw, @HeaderParam(value="secondaryuserbearertoken") String secondaryUserBearerToken, @Context HttpServletRequest request) {
        Response response;
        String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)request);
        String userAgent = HttpRequestUtils.getUserAgent((HttpServletRequest)request);
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                TimePoint to;
                TimePoint from;
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                this.checkExportPermission(trackedRace, secondaryUserBearerToken, clientIP, userAgent);
                try {
                    from = this.parseTimePoint(fromtime, fromtimeasmillis, (TimePoint)(trackedRace.getStartOfRace() == null ? new MillisecondsTimePoint(0L) : new MillisecondsTimePoint(trackedRace.getStartOfRace().asMillis() - 86400000L)));
                }
                catch (InvalidDateException e1) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'from' time.").type("text/plain").build();
                }
                try {
                    to = this.parseTimePoint(totime, totimeasmillis, MillisecondsTimePoint.now());
                }
                catch (InvalidDateException e1) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'to' time.").type("text/plain").build();
                }
                JSONObject jsonRace = new JSONObject();
                jsonRace.put((Object)"name", (Object)trackedRace.getRace().getName());
                jsonRace.put((Object)"regatta", (Object)regatta.getName());
                JSONArray jsonCompetitors = new JSONArray();
                for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                    JSONArray jsonFixes;
                    JSONObject jsonCompetitor;
                    block24: {
                        if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS) || competitorIds != null && !competitorIds.isEmpty() && !competitorIds.contains(competitor.getId().toString())) continue;
                        jsonCompetitor = new JSONObject();
                        jsonCompetitor.put((Object)"id", competitor.getId() != null ? competitor.getId().toString() : null);
                        jsonCompetitor.put((Object)"name", (Object)competitor.getName());
                        jsonCompetitor.put((Object)"sailNumber", (Object)trackedRace.getBoatOfCompetitor(competitor).getSailID());
                        jsonCompetitor.put((Object)"color", competitor.getColor() != null ? competitor.getColor().getAsHtml() : null);
                        if (competitor.getFlagImage() != null) {
                            jsonCompetitor.put((Object)"flagImage", (Object)competitor.getFlagImage().toString());
                        }
                        GPSFixTrack track = trackedRace.getTrack(competitor);
                        jsonFixes = new JSONArray();
                        track.lockForRead();
                        try {
                            Iterator<Object> fixIter = from == null ? (raw ? track.getRawFixes().iterator() : track.getFixes().iterator()) : (raw ? track.getRawFixesIterator(from, true) : track.getFixesIterator(from, true));
                            GPSFixMoving fix = null;
                            boolean lastAdded = false;
                            while (fixIter.hasNext()) {
                                fix = (GPSFixMoving)fixIter.next();
                                if (to != null && fix.getTimePoint() != null && to.compareTo((Object)fix.getTimePoint()) < 0) {
                                    lastAdded = false;
                                    break;
                                }
                                Tack tack = null;
                                if (withTack != null && withTack.booleanValue()) {
                                    try {
                                        tack = trackedRace.getTack(competitor, fix.getTimePoint());
                                    }
                                    catch (NoWindException noWindException) {
                                        // empty catch block
                                    }
                                }
                                this.addCompetitorFixToJsonFixes(jsonFixes, fix, tack);
                                lastAdded = true;
                            }
                            if (!addLastKnown || lastAdded) break block24;
                            Iterator earlierFixIter = raw ? track.getRawFixesDescendingIterator(from, false) : track.getFixesDescendingIterator(from, false);
                            GPSFixMoving earlierFix = earlierFixIter.hasNext() ? (GPSFixMoving)earlierFixIter.next() : null;
                            Tack tack = null;
                            if (withTack != null && withTack.booleanValue()) {
                                try {
                                    tack = trackedRace.getTack(competitor, fix.getTimePoint());
                                }
                                catch (NoWindException noWindException) {
                                    // empty catch block
                                }
                            }
                            if (earlierFix != null && (fix == null || earlierFix.getTimePoint().until(from).compareTo((Object)to.until(fix.getTimePoint())) <= 0)) {
                                this.addCompetitorFixToJsonFixes(jsonFixes, earlierFix, tack);
                            } else if (fix != null) {
                                this.addCompetitorFixToJsonFixes(jsonFixes, fix, tack);
                            }
                        }
                        finally {
                            track.unlockAfterRead();
                        }
                    }
                    jsonCompetitor.put((Object)"track", (Object)jsonFixes);
                    jsonCompetitors.add((Object)jsonCompetitor);
                }
                jsonRace.put((Object)"competitors", (Object)jsonCompetitors);
                response = Response.ok((Object)this.streamingOutput(jsonRace)).build();
            }
        }
        return response;
    }

    private void checkExportPermission(TrackedRace trackedRace, String secondaryUserBearerToken, String clientIP, String userAgent) {
        if (Util.hasLength((String)secondaryUserBearerToken)) {
            logger.info("Found secondary user bearer token");
            Subject secondarySubject = new Subject.Builder().buildSubject();
            secondarySubject.login((AuthenticationToken)new BearerAuthenticationToken(secondaryUserBearerToken, clientIP, userAgent));
            logger.info("Authenticated secondary subject for export permission: " + secondarySubject.getPrincipal());
            secondarySubject.checkPermission(trackedRace.getPermissionType().getStringPermissionForObject((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.EXPORT, (WithQualifiedObjectIdentifier)trackedRace));
            logger.info("Secondary subject has export permission for " + trackedRace);
        } else {
            this.getSecurityService().checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)trackedRace, new HasPermissions.Action[]{SecuredDomainType.TrackedRaceActions.EXPORT});
        }
    }

    private JSONObject addCompetitorFixToJsonFixes(JSONArray jsonFixes, GPSFixMoving fix, Tack tack) {
        JSONObject jsonFix = new JSONObject();
        jsonFix.put((Object)"timepoint-ms", (Object)fix.getTimePoint().asMillis());
        jsonFix.put((Object)"lat-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(fix.getPosition().getLatDeg()));
        jsonFix.put((Object)"lng-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(fix.getPosition().getLngDeg()));
        jsonFix.put((Object)"truebearing-deg", (Object)fix.getSpeed().getBearing().getDegrees());
        jsonFix.put((Object)"speed-kts", (Object)RoundingUtil.knotsDecimalFormatter.format(fix.getSpeed().getKnots()));
        if (tack != null) {
            jsonFix.put((Object)"tack", (Object)tack.name());
        }
        if (fix.getOptionalTrueHeading() != null) {
            jsonFix.put((Object)"trueheading-deg", (Object)fix.getOptionalTrueHeading().getDegrees());
        }
        jsonFixes.add((Object)jsonFix);
        return jsonFix;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/marks/positions")
    public Response getMarkPositions(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="fromtime") String fromtime, @QueryParam(value="fromtimeasmillis") Long fromtimeasmillis, @QueryParam(value="totime") String totime, @QueryParam(value="totimeasmillis") Long totimeasmillis, @DefaultValue(value="false") @QueryParam(value="lastknown") boolean addLastKnown, @HeaderParam(value="secondaryuserbearertoken") String secondaryUserBearerToken, @Context HttpServletRequest request) {
        TimePoint to;
        TimePoint from;
        String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)request);
        String userAgent = HttpRequestUtils.getUserAgent((HttpServletRequest)request);
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        RaceDefinition race = this.findRaceByName(regatta, raceName);
        if (race == null) {
            return this.getBadRaceErrorResponse(regattaName, raceName);
        }
        TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        this.checkExportPermission(trackedRace, secondaryUserBearerToken, clientIP, userAgent);
        try {
            from = this.parseTimePoint(fromtime, fromtimeasmillis, (TimePoint)(trackedRace.getStartOfRace() == null ? new MillisecondsTimePoint(0L) : new MillisecondsTimePoint(trackedRace.getStartOfRace().asMillis() - 86400000L)));
        }
        catch (InvalidDateException e1) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'from' time.").type("text/plain").build();
        }
        try {
            to = this.parseTimePoint(totime, totimeasmillis, MillisecondsTimePoint.now());
        }
        catch (InvalidDateException e1) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'to' time.").type("text/plain").build();
        }
        JSONObject jsonRace = new JSONObject();
        jsonRace.put((Object)"name", (Object)trackedRace.getRace().getName());
        jsonRace.put((Object)"regatta", (Object)regatta.getName());
        JSONArray jsonMarks = new JSONArray();
        HashSet<Mark> marks = new HashSet<Mark>();
        Course course = trackedRace.getRace().getCourse();
        for (Waypoint waypoint : course.getWaypoints()) {
            for (Mark mark : waypoint.getMarks()) {
                marks.add(mark);
            }
        }
        for (Mark mark : marks) {
            JSONObject jsonMark = new JSONObject();
            jsonMark.put((Object)"name", (Object)mark.getName());
            jsonMark.put((Object)"id", mark.getId() != null ? mark.getId().toString() : null);
            GPSFixTrack track = trackedRace.getOrCreateTrack(mark);
            JSONArray jsonFixes = new JSONArray();
            track.lockForRead();
            try {
                Iterator fixIter = from == null ? track.getFixes().iterator() : track.getFixesIterator(from, true);
                GPSFix fix = null;
                boolean lastAdded = false;
                while (fixIter.hasNext()) {
                    fix = (GPSFix)fixIter.next();
                    if (to != null && fix.getTimePoint() != null && to.compareTo((Object)fix.getTimePoint()) < 0) {
                        lastAdded = false;
                        break;
                    }
                    this.addMarkFixToJsonFixes(jsonFixes, fix);
                    lastAdded = true;
                }
                if (addLastKnown && !lastAdded) {
                    Iterator earlierFixIter = track.getFixesDescendingIterator(from, false);
                    GPSFix earlierFix = earlierFixIter.hasNext() ? (GPSFix)earlierFixIter.next() : null;
                    if (earlierFix != null && (fix == null || earlierFix.getTimePoint().until(from).compareTo((Object)to.until(fix.getTimePoint())) <= 0)) {
                        this.addMarkFixToJsonFixes(jsonFixes, earlierFix);
                    } else if (fix != null) {
                        this.addMarkFixToJsonFixes(jsonFixes, fix);
                    }
                }
            }
            finally {
                track.unlockAfterRead();
            }
            jsonMark.put((Object)"track", (Object)jsonFixes);
            jsonMarks.add((Object)jsonMark);
        }
        jsonRace.put((Object)"marks", (Object)jsonMarks);
        return Response.ok((Object)this.streamingOutput(jsonRace)).build();
    }

    private JSONObject addMarkFixToJsonFixes(JSONArray jsonFixes, GPSFix fix) {
        JSONObject jsonFix = new JSONObject();
        jsonFix.put((Object)"timepoint-ms", (Object)fix.getTimePoint().asMillis());
        jsonFix.put((Object)"lat-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(fix.getPosition().getLatDeg()));
        jsonFix.put((Object)"lng-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(fix.getPosition().getLngDeg()));
        jsonFixes.add((Object)jsonFix);
        return jsonFix;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/course")
    public Response getCourse(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            TrackedRace trackedRace = this.findTrackedRace(regatta, raceName);
            if (trackedRace == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                Course course = trackedRace.getRace().getCourse();
                response = this.getCourseResult((CourseBase)course, trackedRace);
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/structure/{raceColumn}/{fleet}/course")
    public Response getCourse(@PathParam(value="regattaname") String regattaName, @PathParam(value="raceColumn") String raceColumnName, @PathParam(value="fleet") String fleetName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceColumn raceColumn = this.findRaceColumnByName(regatta, raceColumnName);
            Fleet fleet = this.findFleetByName(raceColumn, fleetName);
            if (raceColumn == null || fleet == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceColumnName, fleetName);
            } else {
                Course course;
                RaceDefinition raceDefinition;
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                RaceDefinition raceDefinition2 = raceDefinition = trackedRace == null ? null : trackedRace.getRace();
                if (raceDefinition != null) {
                    course = raceDefinition.getCourse();
                } else {
                    LastPublishedCourseDesignFinder courseDesginFinder = new LastPublishedCourseDesignFinder(raceColumn.getRaceLog(fleet), true);
                    course = (CourseBase)courseDesginFinder.analyze();
                }
                response = course == null ? this.getBadCourseErrorResponse(regattaName, raceColumnName, fleetName) : this.getCourseResult((CourseBase)course, trackedRace);
            }
        }
        return response;
    }

    private Response getCourseResult(CourseBase course, TrackedRace optionalTrackedRace) {
        JSONObject jsonCourse;
        WaypointJsonSerializer waypointSerializer = new WaypointJsonSerializer((JsonSerializer)new ControlPointJsonSerializer((JsonSerializer)new MarkJsonSerializer(), (JsonSerializer)new GateJsonSerializer((JsonSerializer)new MarkJsonSerializer())));
        if (optionalTrackedRace == null) {
            jsonCourse = new CourseBaseJsonSerializer((JsonSerializer)waypointSerializer).serialize(course);
        } else {
            CourseBaseWithGeometryJsonSerializer.CourseGeometry geometry = this.getCourseGeometry(optionalTrackedRace);
            TimePoint timePointForStartLine = optionalTrackedRace.getStartOfRace() != null ? optionalTrackedRace.getStartOfRace() : (optionalTrackedRace.getStartOfTracking() != null ? optionalTrackedRace.getStartOfTracking() : MillisecondsTimePoint.now());
            LineDetails startLineDetails = optionalTrackedRace.getStartLine(timePointForStartLine);
            jsonCourse = new CourseBaseWithGeometryJsonSerializer(waypointSerializer).serialize(new Util.Triple((Object)course, (Object)geometry, (Object)startLineDetails));
        }
        Response response = Response.ok((Object)this.streamingOutput(jsonCourse)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        return response;
    }

    private CourseBaseWithGeometryJsonSerializer.CourseGeometry getCourseGeometry(TrackedRace trackedRace) {
        assert (trackedRace != null);
        Course course = trackedRace.getRace().getCourse();
        Distance.NullDistance totalDistance = Distance.NULL;
        HashMap<Leg, Distance> legDistances = new HashMap<Leg, Distance>();
        HashMap<Leg, Bearing> legBearings = new HashMap<Leg, Bearing>();
        course.lockForRead();
        try {
            for (Leg leg : course.getLegs()) {
                TrackedLeg trackedLeg = trackedRace.getTrackedLeg(leg);
                TimePoint timePointForLegGeometry = this.getTimePointForLegGeometry(trackedRace, leg);
                Distance legDistance = trackedLeg.getGreatCircleDistance(timePointForLegGeometry);
                legDistances.put(leg, legDistance);
                legBearings.put(leg, trackedLeg.getLegBearing(timePointForLegGeometry));
                Distance distance = totalDistance = legDistance == null || totalDistance == null ? null : totalDistance.add(legDistance);
            }
        }
        finally {
            course.unlockAfterRead();
        }
        return new CourseBaseWithGeometryJsonSerializer.CourseGeometry((Distance)totalDistance, legDistances, legBearings);
    }

    private TimePoint getTimePointForLegGeometry(TrackedRace trackedRace, Leg leg) {
        TimePoint startOfTracking;
        TimePoint raceStartTime;
        Iterable markPassingsForLegStart = trackedRace.getMarkPassingsInOrder(leg.getFrom());
        Iterator firstMarkPassingForLegStartIter = markPassingsForLegStart.iterator();
        TimePoint result = firstMarkPassingForLegStartIter.hasNext() ? ((MarkPassing)firstMarkPassingForLegStartIter.next()).getTimePoint() : ((raceStartTime = trackedRace.getStartOfRace()) != null ? raceStartTime : ((startOfTracking = trackedRace.getStartOfTracking()) != null ? startOfTracking : MillisecondsTimePoint.now()));
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/targettime")
    public Response getTargetTime(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="timeasmillis") Long timeasmillis) {
        Response response;
        if (timeasmillis == null) {
            timeasmillis = System.currentTimeMillis();
        }
        MillisecondsTimePoint timePoint = new MillisecondsTimePoint(timeasmillis.longValue());
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                DynamicTrackedRace trackedRace = this.getService().getTrackedRace(regatta, race);
                if (trackedRace != null) {
                    try {
                        TargetTimeInfo targetTime = trackedRace.getEstimatedTimeToComplete((TimePoint)timePoint);
                        TargetTimeInfoSerializer serializer = new TargetTimeInfoSerializer((JsonSerializer)new WindJsonSerializer((JsonSerializer)new PositionJsonSerializer()));
                        JSONObject jsonCourse = serializer.serialize(targetTime);
                        response = Response.ok((Object)this.streamingOutput(jsonCourse)).build();
                    }
                    catch (NoWindException | NotEnoughDataHasBeenAddedException e) {
                        response = this.getNotEnoughDataAvailabeErrorResponse(regattaName, raceName);
                    }
                } else {
                    response = this.getNoTrackedRaceErrorResponse(regattaName, raceName);
                }
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/times")
    public Response getMultiTimes(@PathParam(value="regattaname") String regattaName, @QueryParam(value="racename") List<String> raceNames, @QueryParam(value="secret") String regattaSecret) {
        JSONArray resultJson = new JSONArray();
        Response response = null;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            if (!this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret)) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            for (String raceName : raceNames) {
                RaceDefinition race = this.findRaceByName(regatta, raceName);
                if (race == null) continue;
                resultJson.add((Object)this.getRaceTimesJSONForRaceName(raceName, regatta));
            }
            response = Response.ok((Object)this.streamingOutput(resultJson)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/startanalysis")
    public Response getStartAnalysis(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="secret") String regattaSecret) {
        Response response = null;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            TrackedRace trackedRace;
            if (!this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret)) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            if ((trackedRace = this.findTrackedRace(regatta, raceName)) == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                try {
                    JSONObject jsonStartAnalysis = this.getStartAnalysis(trackedRace, regatta);
                    response = Response.ok((Object)this.streamingOutput(jsonStartAnalysis)).build();
                }
                catch (NoWindException | InterruptedException | ExecutionException e) {
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error computing start analysis for race '" + StringEscapeUtils.escapeHtml((String)raceName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "': " + StringEscapeUtils.escapeHtml((String)e.getMessage()))).type("text/plain").build();
                }
            }
        }
        return response;
    }

    private JSONObject getStartAnalysis(TrackedRace trackedRace, Regatta regatta) throws NoWindException, InterruptedException, ExecutionException {
        assert (trackedRace != null);
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regatta.getName());
        CompetitorJsonSerializer competitorSerializer = new CompetitorJsonSerializer((JsonSerializer)new TeamJsonSerializer((JsonSerializer)new PersonJsonSerializer((JsonSerializer)new NationalityJsonSerializer())), (JsonSerializer)BoatJsonSerializer.create(), false);
        JSONObject result = new JSONObject();
        JSONArray competitorStartAnalysis = new JSONArray();
        if (leaderboard != null) {
            LeaderboardDTO latestLeaderboard;
            RaceDefinition race = trackedRace.getRace();
            HashMap<String, Competitor> competitorByIdAsString = new HashMap<String, Competitor>();
            for (Competitor c : race.getCompetitors()) {
                competitorByIdAsString.put(c.getId().toString(), c);
            }
            Util.Pair raceColumnAndFleet = regatta.getRaceColumnAndFleet(trackedRace);
            if (raceColumnAndFleet != null && raceColumnAndFleet.getA() != null && (latestLeaderboard = leaderboard.getLeaderboardDTO(null, Arrays.asList(((RaceColumn)raceColumnAndFleet.getA()).getName()), false, (TrackedRegattaRegistry)this.getService(), this.getService().getBaseDomainFactory(), false)) != null) {
                result.put((Object)"startline", (Object)this.getStartLineData(trackedRace));
                for (Map.Entry e : latestLeaderboard.rows.entrySet()) {
                    Competitor competitor = (Competitor)competitorByIdAsString.get(((CompetitorDTO)e.getKey()).getIdAsString());
                    if (competitor == null) continue;
                    LeaderboardRowDTO competitorRow = (LeaderboardRowDTO)e.getValue();
                    LeaderboardEntryDTO entry = (LeaderboardEntryDTO)competitorRow.fieldsByRaceColumnName.get(((RaceColumn)raceColumnAndFleet.getA()).getName());
                    if (entry == null) continue;
                    JSONObject competitorStartAnalysisJson = new JSONObject();
                    competitorStartAnalysisJson.put((Object)"competitor", (Object)competitorSerializer.serialize(competitor));
                    competitorStartAnalysisJson.put((Object)"distanceToStarboardSideOfStartLineInMeters", (Object)entry.distanceToStarboardSideOfStartLineInMeters);
                    competitorStartAnalysisJson.put((Object)"distanceToStartLineAtStartOfRaceInMeters", (Object)entry.distanceToStartLineAtStartOfRaceInMeters);
                    competitorStartAnalysisJson.put((Object)"distanceToStartLineFiveSecondsBeforeStartInMeters", (Object)entry.distanceToStartLineFiveSecondsBeforeStartInMeters);
                    competitorStartAnalysisJson.put((Object)"speedOverGroundAtPassingStartWaypointInKnots", (Object)entry.speedOverGroundAtPassingStartWaypointInKnots);
                    competitorStartAnalysisJson.put((Object)"speedOverGroundAtStartOfRaceInKnots", (Object)entry.speedOverGroundAtStartOfRaceInKnots);
                    competitorStartAnalysisJson.put((Object)"speedOverGroundFiveSecondsBeforeStartInKnots", (Object)entry.speedOverGroundFiveSecondsBeforeStartInKnots);
                    competitorStartAnalysisJson.put((Object)"timeBetweenRaceStartAndCompetitorStartInSeconds", (Object)entry.timeBetweenRaceStartAndCompetitorStartInSeconds);
                    competitorStartAnalysisJson.put((Object)"startTack", (Object)entry.startTack);
                    competitorStartAnalysis.add((Object)competitorStartAnalysisJson);
                }
            }
        }
        result.put((Object)"competitors", (Object)competitorStartAnalysis);
        return result;
    }

    private JSONObject getStartLineData(TrackedRace trackedRace) {
        JSONObject result;
        TimePoint startOfRace = trackedRace.getStartOfRace();
        if (startOfRace != null) {
            LineDetails lineInfo = trackedRace.getStartLine(startOfRace);
            result = new JSONObject();
            result.put((Object)"lengthInMeters", (Object)lineInfo.getLength().getMeters());
            result.put((Object)"favoredEnd", (Object)lineInfo.getAdvantageousSideWhileApproachingLine().name());
            result.put((Object)"biasInMeters", (Object)lineInfo.getAdvantage().getMeters());
        } else {
            result = null;
        }
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/times")
    public Response getTimes(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="secret") String regattaSecret) {
        Response response = null;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            RaceDefinition race;
            if (!this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret)) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            if ((race = this.findRaceByName(regatta, raceName)) == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                JSONObject jsonRaceTimes = this.getRaceTimesJSONForRaceName(raceName, regatta);
                response = Response.ok((Object)this.streamingOutput(jsonRaceTimes)).build();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getRaceTimesJSONForRaceName(String raceName, Regatta regatta) {
        Iterable markPassingsTimes;
        TrackedRace trackedRace = this.findTrackedRace(regatta.getName(), raceName);
        JSONObject jsonRaceTimes = new JSONObject();
        jsonRaceTimes.put((Object)"name", (Object)trackedRace.getRace().getName());
        jsonRaceTimes.put((Object)"regatta", (Object)regatta.getName());
        jsonRaceTimes.put((Object)"startOfRace-ms", trackedRace.getStartOfRace() == null ? null : Long.valueOf(trackedRace.getStartOfRace().asMillis()));
        jsonRaceTimes.put((Object)"startOfTracking-ms", trackedRace.getStartOfTracking() == null ? null : Long.valueOf(trackedRace.getStartOfTracking().asMillis()));
        jsonRaceTimes.put((Object)"newestTrackingEvent-ms", trackedRace.getTimePointOfNewestEvent() == null ? null : Long.valueOf(trackedRace.getTimePointOfNewestEvent().asMillis()));
        jsonRaceTimes.put((Object)"endOfTracking-ms", trackedRace.getEndOfTracking() == null ? null : Long.valueOf(trackedRace.getEndOfTracking().asMillis()));
        jsonRaceTimes.put((Object)"endOfRace-ms", trackedRace.getEndOfRace() == null ? null : Long.valueOf(trackedRace.getEndOfRace().asMillis()));
        jsonRaceTimes.put((Object)"delayToLive-ms", (Object)trackedRace.getDelayToLiveInMillis());
        JSONArray jsonMarkPassingTimes = new JSONArray();
        ArrayList<TimePoint> firstPassingTimepoints = new ArrayList<TimePoint>();
        Iterable iterable = markPassingsTimes = trackedRace.getMarkPassingsTimes();
        synchronized (iterable) {
            int numberOfWaypoints = Util.size((Iterable)markPassingsTimes);
            int wayPointNumber = 1;
            for (Util.Pair markPassingTimes : markPassingsTimes) {
                JSONObject jsonMarkPassing = new JSONObject();
                String name = "M" + (wayPointNumber - 1);
                if (wayPointNumber == numberOfWaypoints) {
                    name = "F";
                }
                jsonMarkPassing.put((Object)"name", (Object)name);
                Util.Pair timesPair = (Util.Pair)markPassingTimes.getB();
                TimePoint firstPassingTime = (TimePoint)timesPair.getA();
                TimePoint lastPassingTime = (TimePoint)timesPair.getB();
                jsonMarkPassing.put((Object)"firstPassing-ms", firstPassingTime == null ? null : Long.valueOf(firstPassingTime.asMillis()));
                jsonMarkPassing.put((Object)"lastPassing-ms", lastPassingTime == null ? null : Long.valueOf(lastPassingTime.asMillis()));
                firstPassingTimepoints.add(firstPassingTime);
                jsonMarkPassingTimes.add((Object)jsonMarkPassing);
                ++wayPointNumber;
            }
        }
        jsonRaceTimes.put((Object)"markPassings", (Object)jsonMarkPassingTimes);
        JSONArray jsonLegInfos = new JSONArray();
        trackedRace.getRace().getCourse().lockForRead();
        try {
            Iterable trackedLegs = trackedRace.getTrackedLegs();
            int legNumber = 1;
            for (TrackedLeg trackedLeg : trackedLegs) {
                JSONObject jsonLegInfo = new JSONObject();
                jsonLegInfo.put((Object)"name", (Object)("L" + legNumber));
                try {
                    TimePoint firstPassingTime = (TimePoint)firstPassingTimepoints.get(legNumber - 1);
                    if (firstPassingTime != null) {
                        jsonLegInfo.put((Object)"type", (Object)trackedLeg.getLegType(firstPassingTime));
                        jsonLegInfo.put((Object)"bearing-deg", (Object)RoundingUtil.bearingDecimalFormatter.format(trackedLeg.getLegBearing(firstPassingTime).getDegrees()));
                    }
                }
                catch (NoWindException noWindException) {
                    // empty catch block
                }
                jsonLegInfos.add((Object)jsonLegInfo);
                ++legNumber;
            }
        }
        finally {
            trackedRace.getRace().getCourse().unlockAfterRead();
        }
        jsonRaceTimes.put((Object)"legs", (Object)jsonLegInfos);
        Date now = new Date();
        jsonRaceTimes.put((Object)"currentServerTime-ms", (Object)now.getTime());
        return jsonRaceTimes;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/windsources")
    public Response getWindSources(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                JSONArray windSourcesAvailable = new JSONArray();
                if (trackedRace != null) {
                    for (WindSource windSource : trackedRace.getWindSources()) {
                        JSONObject windSourceJson = new JSONObject();
                        windSourceJson.put((Object)"typeName", (Object)windSource.getType().name());
                        windSourceJson.put((Object)"id", (Object)(windSource.getId() != null ? windSource.getId().toString() : ""));
                        windSourcesAvailable.add((Object)windSourceJson);
                    }
                }
                return Response.ok((Object)windSourcesAvailable.toString()).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/highQualityWindFixes")
    public Response getHighQualityWindFixes(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @HeaderParam(value="secondaryuserbearertoken") String secondaryUserBearerToken, @Context HttpServletRequest request) {
        Response response;
        String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)request);
        String userAgent = HttpRequestUtils.getUserAgent((HttpServletRequest)request);
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                this.checkExportPermission(trackedRace, secondaryUserBearerToken, clientIP, userAgent);
                RaceWindJsonSerializer serializer = new RaceWindJsonSerializer();
                JSONObject jsonWindTracks = serializer.serialize(trackedRace);
                return Response.ok((Object)this.streamingOutput(jsonWindTracks)).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/wind")
    public Response getWind(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @DefaultValue(value="COMBINED") @QueryParam(value="windsource") String windSource, @QueryParam(value="windsourceid") String windSourceId, @QueryParam(value="fromtime") String fromtime, @QueryParam(value="fromtimeasmillis") Long fromtimeasmillis, @QueryParam(value="totime") String totime, @QueryParam(value="totimeasmillis") Long totimeasmillis, @HeaderParam(value="secondaryuserbearertoken") String secondaryUserBearerToken, @Context HttpServletRequest request) {
        Response response;
        String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)request);
        String userAgent = HttpRequestUtils.getUserAgent((HttpServletRequest)request);
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            if (!(fromtime != null && totime != null || fromtimeasmillis != null && totimeasmillis != null)) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Either the 'fromtime' and 'totime' or the 'fromtimeasmillis' and 'totimeasmillis' parameter must be set.").type("text/plain").build();
            } else {
                RaceDefinition race = this.findRaceByName(regatta, raceName);
                if (race == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
                } else {
                    TimePoint to;
                    TimePoint from;
                    TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                    this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                    this.checkExportPermission(trackedRace, secondaryUserBearerToken, clientIP, userAgent);
                    try {
                        from = this.parseTimePoint(fromtime, fromtimeasmillis, (TimePoint)(trackedRace.getStartOfRace() == null ? new MillisecondsTimePoint(0L) : new MillisecondsTimePoint(trackedRace.getStartOfRace().asMillis() - 86400000L)));
                    }
                    catch (InvalidDateException e1) {
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'from' time.").type("text/plain").build();
                    }
                    try {
                        to = this.parseTimePoint(totime, totimeasmillis, MillisecondsTimePoint.now());
                    }
                    catch (InvalidDateException e1) {
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'to' time.").type("text/plain").build();
                    }
                    TimePoint finalFrom = Util.getLatestOfTimePoints((TimePoint)from, (TimePoint)trackedRace.getStartOfTracking());
                    TimePoint finalTo = Util.getEarliestOfTimePoints((TimePoint)to, (TimePoint)Util.getEarliestOfTimePoints((TimePoint)trackedRace.getEndOfTracking(), (TimePoint)trackedRace.getTimePointOfNewestEvent()));
                    TrackedRaceJsonSerializer serializer = new TrackedRaceJsonSerializer(ws -> new DefaultWindTrackJsonSerializer(10000, finalFrom, finalTo, ws), windSource, windSourceId);
                    JSONObject jsonWindTracks = serializer.serialize(trackedRace);
                    response = Response.ok((Object)this.streamingOutput(jsonWindTracks)).build();
                }
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/windsummary")
    public Response getWindSummary(@PathParam(value="regattaname") String regattaName, @QueryParam(value="racecolumn") String raceColumnName, @QueryParam(value="fleet") String fleetName, @QueryParam(value="secret") String regattaSecret) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            Set<RaceColumn> raceColumns;
            boolean skip = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret);
            if (!skip) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            JSONArray result = new JSONArray();
            if (raceColumnName != null) {
                RaceColumn raceColumn = regatta.getRaceColumnByName(raceColumnName);
                if (raceColumn == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column with name '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "'.")).type("text/plain").build();
                }
                raceColumns = Collections.singleton(raceColumn);
            } else {
                raceColumns = regatta.getRaceColumns();
            }
            for (RaceColumn raceColumn : raceColumns) {
                Set<Fleet> fleets;
                if (fleetName != null) {
                    Fleet fleet = raceColumn.getFleetByName(fleetName);
                    if (fleet == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a fleet with name '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in race column '" + raceColumn.getName() + "'.")).type("text/plain").build();
                    }
                    fleets = Collections.singleton(fleet);
                } else {
                    fleets = raceColumn.getFleets();
                }
                for (Fleet fleet : fleets) {
                    TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                    RaceLog raceLog = raceColumn.getRaceLog(fleet);
                    WindSummary windSummary = new RaceWindCalculator().getWindSummary(trackedRace, raceLog);
                    result.add((Object)this.toJson(raceColumn, fleet, windSummary));
                }
            }
            response = Response.ok((Object)this.streamingOutput(result)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        }
        return response;
    }

    private JSONObject toJson(RaceColumn raceColumn, Fleet fleet, WindSummary windSummary) {
        JSONObject result = new JSONObject();
        result.put((Object)"racecolumn", (Object)raceColumn.getName());
        result.put((Object)"fleet", (Object)fleet.getName());
        result.put((Object)"trueLowerboundWindInKnots", windSummary == null ? null : Double.valueOf(windSummary.getTrueLowerboundWind().getKnots()));
        result.put((Object)"trueUppwerboundWindInKnots", windSummary == null ? null : Double.valueOf(windSummary.getTrueUpperboundWind().getKnots()));
        result.put((Object)"trueWindDirectionInDegrees", windSummary == null ? null : Double.valueOf(windSummary.getTrueWindDirection().getDegrees()));
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/firstlegbearing")
    public Response getFirstLegBearing(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="time") String time, @QueryParam(value="timeasmillis") Long timeasmillis) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TimePoint timePoint;
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                try {
                    timePoint = this.parseTimePoint(time, timeasmillis, (TimePoint)(trackedRace.getStartOfRace() == null ? new MillisecondsTimePoint(0L) : trackedRace.getStartOfRace()));
                }
                catch (InvalidDateException e1) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'from' time.").type("text/plain").build();
                }
                BearingJsonSerializer serializer = new BearingJsonSerializer();
                JSONObject jsonBearing = serializer.serialize(trackedRace.getDirectionFromStartToNextMark(timePoint).getFrom());
                return Response.ok((Object)this.streamingOutput(jsonBearing)).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/markpassings")
    public Response getMarkPassings(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="leaderboard") String leaderboardName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                Leaderboard leaderboard = leaderboardName == null ? this.getService().getLeaderboardByName(regattaName) : this.getService().getLeaderboardByName(leaderboardName);
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                MarkPassingsJsonSerializer serializer = new MarkPassingsJsonSerializer(leaderboard, null);
                JSONObject jsonMarkPassings = serializer.serialize((Object)trackedRace);
                return Response.ok((Object)this.streamingOutput(jsonMarkPassings)).build();
            }
        }
        return response;
    }

    private TimePoint determineEndTimeForManeuverDetection(TrackedRace trackedRace) {
        TimePoint endOfTracking;
        TimePoint endOfRace = trackedRace.getEndOfRace();
        TimePoint endTime = endOfRace != null ? endOfRace : ((endOfTracking = trackedRace.getEndOfTracking()) == null || endOfTracking.after(MillisecondsTimePoint.now()) ? MillisecondsTimePoint.now() : endOfTracking);
        return endTime;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/maneuvers")
    public Response getManeuvers(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="competitorId") String competitorId, @QueryParam(value="fromTime") String fromTime) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                if (trackedRace == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a trackedrace with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
                } else {
                    ArrayList<Util.Pair> data = new ArrayList<Util.Pair>();
                    Iterable competitors = trackedRace.getRace().getCompetitors();
                    UUID competitorFilter = null;
                    if (competitorId != null) {
                        competitorFilter = UUID.fromString(competitorId);
                    }
                    TimePoint endTime = this.determineEndTimeForManeuverDetection(trackedRace);
                    Object startTime = fromTime != null ? new MillisecondsTimePoint(Long.parseLong(fromTime)) : trackedRace.getStartOfRace();
                    for (Competitor competitor : competitors) {
                        if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS) || competitorFilter != null && !competitor.getId().equals(competitorFilter)) continue;
                        Iterable maneuversForCompetitor = trackedRace.getManeuvers(competitor, startTime, endTime, false);
                        data.add(new Util.Pair((Object)competitor, (Object)maneuversForCompetitor));
                    }
                    ManeuversJsonSerializer serializer = new ManeuversJsonSerializer(new ManeuverJsonSerializer(new GPSFixJsonSerializer(), new DistanceJsonSerializer()));
                    JSONObject jsonMarkPassings = serializer.serialize(data);
                    return Response.ok((Object)this.streamingOutput(jsonMarkPassings)).build();
                }
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/completeManeuverCurvesWithEstimationData")
    public Response getCompleteManeuverCurvesWithEstimationData(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="startBeforeStartLineInSeconds") @DefaultValue(value="-2147483648") Integer startBeforeStartLineInSeconds, @QueryParam(value="endBeforeStartLineInSeconds") @DefaultValue(value="-2147483648") Integer endBeforeStartLineInSeconds, @QueryParam(value="startAfterFinishLineInSeconds") @DefaultValue(value="-2147483648") Integer startAfterFinishLineInSeconds, @QueryParam(value="endAfterFinishLineInSeconds") @DefaultValue(value="-2147483648") Integer endAfterFinishLineInSeconds) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                CompetitorTrackWithEstimationDataJsonSerializer serializer = new CompetitorTrackWithEstimationDataJsonSerializer(this.getService().getPolarDataService(), this.getSecurityService(), (BoatClassJsonSerializer)new DetailedBoatClassJsonSerializer(), (CompetitorTrackElementsJsonSerializer)new CompleteManeuverCurvesWithEstimationDataJsonSerializer(this.getService().getPolarDataService(), new CompleteManeuverCurveWithEstimationDataJsonSerializer((ManeuverCurveBoundariesJsonSerializer)new ManeuverMainCurveWithEstimationDataJsonSerializer(), (ManeuverCurveBoundariesJsonSerializer)new ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonSerializer(), new ManeuverWindJsonSerializer(), new PositionJsonSerializer())), this.getNullableValueFromDefault(startBeforeStartLineInSeconds), this.getNullableValueFromDefault(endBeforeStartLineInSeconds), this.getNullableValueFromDefault(startAfterFinishLineInSeconds), this.getNullableValueFromDefault(endAfterFinishLineInSeconds));
                JSONObject jsonMarkPassings = serializer.serialize(trackedRace);
                return Response.ok((Object)this.streamingOutput(jsonMarkPassings)).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/gpsFixesWithEstimationData")
    public Response getGpsFixesWithEstimationData(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="addWind") @DefaultValue(value="true") Boolean addWind, @QueryParam(value="addNextWaypoint") @DefaultValue(value="true") Boolean addNextWaypoint, @QueryParam(value="smoothFixes") @DefaultValue(value="true") Boolean smoothFixes, @QueryParam(value="startBeforeStartLineInSeconds") @DefaultValue(value="-2147483648") Integer startBeforeStartLineInSeconds, @QueryParam(value="endBeforeStartLineInSeconds") @DefaultValue(value="-2147483648") Integer endBeforeStartLineInSeconds, @QueryParam(value="startAfterFinishLineInSeconds") @DefaultValue(value="-2147483648") Integer startAfterFinishLineInSeconds, @QueryParam(value="endAfterFinishLineInSeconds") @DefaultValue(value="-2147483648") Integer endAfterFinishLineInSeconds) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                CompetitorTrackWithEstimationDataJsonSerializer serializer = new CompetitorTrackWithEstimationDataJsonSerializer(this.getService().getPolarDataService(), this.getSecurityService(), (BoatClassJsonSerializer)new DetailedBoatClassJsonSerializer(), (CompetitorTrackElementsJsonSerializer)new GpsFixesWithEstimationDataJsonSerializer(new GPSFixMovingJsonSerializer(), new ManeuverWindJsonSerializer(), addWind.booleanValue(), addNextWaypoint.booleanValue(), smoothFixes), this.getNullableValueFromDefault(startBeforeStartLineInSeconds), this.getNullableValueFromDefault(endBeforeStartLineInSeconds), this.getNullableValueFromDefault(startAfterFinishLineInSeconds), this.getNullableValueFromDefault(endAfterFinishLineInSeconds));
                JSONObject jsonMarkPassings = serializer.serialize(trackedRace);
                return Response.ok((Object)this.streamingOutput(jsonMarkPassings)).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/competitordata")
    public Response getCompetitorRaceData(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="fromtime") String fromtime, @QueryParam(value="fromtimeasmillis") Long fromtimeasmillis, @QueryParam(value="totime") String totime, @QueryParam(value="totimeasmillis") Long totimeasmillis, @QueryParam(value="competitorId") Set<String> competitorIds, final @QueryParam(value="detailType") Set<DetailType> detailTypes, @QueryParam(value="leaderboardGroupNameOrUUID") String leaderboardGroupName, @QueryParam(value="leaderboardName") String leaderboardName, @QueryParam(value="stepSizeMillis") @DefaultValue(value="1000") long stepSizeMillis) {
        Response response;
        final ConcurrentHashMap cachesByTimePoint = new ConcurrentHashMap();
        Regatta regatta = this.findRegattaByName(regattaName);
        Serializable uuid = UUIDHelper.tryUuidConversion((Serializable)((Object)leaderboardGroupName));
        LeaderboardGroup leaderboardGroup = uuid != leaderboardGroupName ? this.getService().getLeaderboardGroupByID((UUID)uuid) : this.getService().getLeaderboardGroupByName(leaderboardGroupName);
        if (leaderboardGroup == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard group with name '" + StringEscapeUtils.escapeHtml((String)leaderboardGroupName) + "'.")).type("text/plain").build();
        } else {
            TimePoint to;
            TimePoint from;
            if (regatta == null) {
                return this.getBadRegattaErrorResponse(regattaName);
            }
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                return this.getBadRaceErrorResponse(regattaName, raceName);
            }
            final TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
            if (trackedRace == null) {
                return this.getBadRaceErrorResponse(regattaName, raceName);
            }
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            try {
                from = this.parseTimePoint(fromtime, fromtimeasmillis, (TimePoint)(trackedRace.getStartOfRace() == null ? new MillisecondsTimePoint(0L) : new MillisecondsTimePoint(trackedRace.getStartOfRace().asMillis() - 86400000L)));
            }
            catch (InvalidDateException e1) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'from' time.").type("text/plain").build();
            }
            try {
                to = this.parseTimePoint(totime, totimeasmillis, MillisecondsTimePoint.now());
            }
            catch (InvalidDateException e1) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the 'to' time.").type("text/plain").build();
            }
            Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
            int MAX_NUMBER_OF_FIXES_TO_QUERY = this.getSecurityService().hasCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)leaderboard, new HasPermissions.Action[]{SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION}) ? 1000 : 50000;
            TimePoint newestEvent = trackedRace.getTimePointOfNewestEvent();
            final TimePoint startTime = from == null ? trackedRace.getStartOfTracking() : from;
            final TimePoint endTime = to == null || to.after(newestEvent) ? newestEvent : to;
            long adjustedStepSizeInMillis = (long)Math.max((double)stepSizeMillis, (double)startTime.until(endTime).divide((long)MAX_NUMBER_OF_FIXES_TO_QUERY).asMillis());
            final int MAX_CACHE_SIZE = MAX_NUMBER_OF_FIXES_TO_QUERY;
            for (DetailType detailType : detailTypes) {
                if (detailType.getPremiumAction() == null || !leaderboard.getPermissionType().supports(detailType.getPremiumAction())) continue;
                this.getSecurityService().checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)leaderboard, new HasPermissions.Action[]{detailType.getPremiumAction()});
            }
            HashMap<DynamicCompetitor, FutureTask<Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>>>> resultFutures = new HashMap<DynamicCompetitor, FutureTask<Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>>>>();
            for (String competitorIdAsString : competitorIds) {
                DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorIdAsString);
                if (competitor == null) {
                    return this.getBadCompetitorIdResponse((Serializable)((Object)competitorIdAsString));
                }
                this.getSecurityService().checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)competitor, new HasPermissions.Action[]{SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC});
                FutureTask<Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>>> future = new FutureTask<Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>>>(new Callable<Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>>>((Competitor)competitor, leaderboardGroup, leaderboardName, adjustedStepSizeInMillis){
                    private final /* synthetic */ Competitor val$competitor;
                    private final /* synthetic */ LeaderboardGroup val$leaderboardGroup;
                    private final /* synthetic */ String val$leaderboardName;
                    private final /* synthetic */ long val$adjustedStepSizeInMillis;
                    {
                        this.val$competitor = competitor;
                        this.val$leaderboardGroup = leaderboardGroup;
                        this.val$leaderboardName = string;
                        this.val$adjustedStepSizeInMillis = l;
                    }

                    @Override
                    public Iterable<Util.Pair<TimePoint, Map<DetailType, Double>>> call() throws NoWindException, NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException {
                        ArrayList<Util.Pair<TimePoint, Map<DetailType, Double>>> raceData = new ArrayList<Util.Pair<TimePoint, Map<DetailType, Double>>>();
                        if (startTime != null && endTime != null) {
                            long i = startTime.asMillis();
                            while (i <= endTime.asMillis()) {
                                TimePoint time = TimePoint.of((long)i);
                                WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache = (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cachesByTimePoint.get(time);
                                if (cache == null) {
                                    cache = new LeaderboardDTOCalculationReuseCache(time);
                                    if (cachesByTimePoint.size() >= MAX_CACHE_SIZE) {
                                        Iterator iterator = cachesByTimePoint.entrySet().iterator();
                                        while (cachesByTimePoint.size() >= MAX_CACHE_SIZE && iterator.hasNext()) {
                                            iterator.next();
                                            iterator.remove();
                                        }
                                    }
                                    cachesByTimePoint.put(time, cache);
                                }
                                HashMap<DetailType, Double> valuesForTimepoint = new HashMap<DetailType, Double>();
                                raceData.add((Util.Pair<TimePoint, Map<DetailType, Double>>)new Util.Pair((Object)time, valuesForTimepoint));
                                for (DetailType detailType : detailTypes) {
                                    Double competitorRaceData = RegattasResource.this.getService().getCompetitorRaceDataEntry(detailType, trackedRace, this.val$competitor, time, this.val$leaderboardGroup, this.val$leaderboardName, cache);
                                    if (competitorRaceData == null) continue;
                                    valuesForTimepoint.put(detailType, competitorRaceData);
                                }
                                i += this.val$adjustedStepSizeInMillis;
                            }
                        }
                        return raceData;
                    }
                });
                resultFutures.put(competitor, future);
                this.executor.execute(future);
            }
            JSONObject result = new JSONObject();
            for (Map.Entry e : resultFutures.entrySet()) {
                try {
                    JSONArray resultsForCompetitor = new JSONArray();
                    result.put((Object)((Competitor)e.getKey()).getId().toString(), (Object)resultsForCompetitor);
                    for (Util.Pair competitorData : (Iterable)((FutureTask)e.getValue()).get()) {
                        JSONObject resultsForCompetitorAtTimepoint = new JSONObject();
                        resultsForCompetitorAtTimepoint.put((Object)"timepoint-ms", (Object)((TimePoint)competitorData.getA()).asMillis());
                        JSONObject resultsForCompetitorByDetailType = new JSONObject();
                        for (Map.Entry entry : ((Map)competitorData.getB()).entrySet()) {
                            resultsForCompetitorByDetailType.put((Object)((DetailType)entry.getKey()).name(), entry.getValue());
                        }
                        resultsForCompetitorAtTimepoint.put((Object)"values", (Object)resultsForCompetitorByDetailType);
                        resultsForCompetitor.add((Object)resultsForCompetitorAtTimepoint);
                    }
                }
                catch (InterruptedException | ExecutionException e1) {
                    logger.log(Level.SEVERE, "Exception while trying to compute competitor data " + detailTypes + " for competitor " + ((Competitor)e.getKey()).getName(), e1);
                }
            }
            response = Response.ok((Object)this.streamingOutput(result)).build();
        }
        return response;
    }

    private Integer getNullableValueFromDefault(Integer value) {
        return Integer.MIN_VALUE == value ? null : value;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races")
    public Response getRaces(@PathParam(value="regattaname") String regattaName, @QueryParam(value="secret") String regattaSecret) {
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta != null) {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret);
            if (!skip) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            }
            JSONObject jsonRaceResults = new JSONObject();
            jsonRaceResults.put((Object)"regatta", (Object)regatta.getName());
            JSONArray jsonRaces = new JSONArray();
            jsonRaceResults.put((Object)"races", (Object)jsonRaces);
            for (RaceDefinition race : regatta.getAllRaces()) {
                JSONObject jsonRace = new JSONObject();
                jsonRaces.add((Object)jsonRace);
                jsonRace.put((Object)"name", (Object)race.getName());
                jsonRace.put((Object)"courseName", (Object)(race.getCourse() != null ? race.getCourse().getName() : ""));
                jsonRace.put((Object)"id", (Object)race.getId().toString());
            }
            return Response.ok((Object)this.streamingOutput(jsonRaceResults)).build();
        }
        Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/competitors/legs")
    public Response getCompetitorRanks(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaName);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
                if (leaderboard == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
                } else {
                    Util.Pair raceColumnAndFleet = leaderboard.getRaceColumnAndFleet(trackedRace);
                    if (raceColumnAndFleet == null) {
                        response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column for race " + StringEscapeUtils.escapeHtml((String)raceName) + " in leaderboard with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
                    } else {
                        CompetitorRanksRequest cacheKey = new CompetitorRanksRequest(regatta, (RaceColumn)raceColumnAndFleet.getA(), (Fleet)raceColumnAndFleet.getB());
                        try {
                            JSONObject jsonRaceResults = (JSONObject)competitorRanksCache.get((Object)cacheKey);
                            response = Response.ok((Object)this.streamingOutput(jsonRaceResults)).build();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Exception while trying to compute competitor ranks for regatta " + regattaName + ", race " + raceName, e);
                            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Exception while trying to compute leaderboard '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
                        }
                    }
                }
            }
        }
        return response;
    }

    private JSONObject computeCompetitorRanks(Regatta regatta, RaceColumn raceColumn, Fleet fleet) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regatta.getName());
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        String raceColumnName = raceColumn.getName();
        try {
            LeaderboardDTO leaderboardDTO;
            ShardingContext.setShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME, (String)regatta.getName());
            try {
                leaderboardDTO = leaderboard.getLeaderboardDTO(null, Collections.singleton(raceColumnName), false, (TrackedRegattaRegistry)this.getService(), this.getService().getBaseDomainFactory(), false);
            }
            finally {
                ShardingContext.clearShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME);
            }
            HashMap<String, CompetitorDTO> competitorDTOsByIdAsString = new HashMap<String, CompetitorDTO>();
            for (CompetitorDTO competitorDTO : leaderboardDTO.rows.keySet()) {
                competitorDTOsByIdAsString.put(competitorDTO.getIdAsString(), competitorDTO);
            }
            TimePoint timePoint = TimePoint.of((Date)leaderboardDTO.getTimePoint());
            LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePoint);
            RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
            JSONObject jsonRaceResults = new JSONObject();
            jsonRaceResults.put((Object)"name", (Object)trackedRace.getRace().getName());
            jsonRaceResults.put((Object)"regatta", (Object)regatta.getName());
            jsonRaceResults.put((Object)"startOfRace-ms", trackedRace.getStartOfRace() == null ? null : Long.valueOf(trackedRace.getStartOfRace().asMillis()));
            JSONArray jsonLegs = new JSONArray();
            Course course = trackedRace.getRace().getCourse();
            course.lockForRead();
            try {
                int zeroBasedLegIndex = 0;
                for (TrackedLeg leg : trackedRace.getTrackedLegs()) {
                    JSONObject jsonLeg = new JSONObject();
                    jsonLeg.put((Object)"from", (Object)leg.getLeg().getFrom().getName());
                    jsonLeg.put((Object)"fromWaypointId", leg.getLeg().getFrom().getId() != null ? leg.getLeg().getFrom().getId().toString() : null);
                    jsonLeg.put((Object)"to", (Object)leg.getLeg().getTo().getName());
                    jsonLeg.put((Object)"toWaypointId", leg.getLeg().getTo().getId() != null ? leg.getLeg().getTo().getId().toString() : null);
                    try {
                        jsonLeg.put((Object)"upOrDownwindLeg", (Object)leg.isUpOrDownwindLeg(timePoint));
                    }
                    catch (NoWindException e) {
                        jsonLeg.put((Object)"upOrDownwindLeg", (Object)"false");
                    }
                    JSONArray jsonCompetitors = new JSONArray();
                    for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                        LegEntryDTO legDetail;
                        TrackedLegOfCompetitor trackedLegOfCompetitor;
                        JSONObject jsonCompetitorInLeg;
                        block29: {
                            Double distanceTraveledIncludingGateStartInMeters;
                            Double distanceTraveledInMeters;
                            Integer numberOfJibes;
                            Integer numberOfTacks;
                            Distance averageAbsolutXTE;
                            Distance averageSignedXTE;
                            boolean hasFinishedLeg;
                            Util.Pair maxSpeedOverGround;
                            Double averageSpeedOverGroundInKnots;
                            if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                            jsonCompetitorInLeg = new JSONObject();
                            trackedLegOfCompetitor = leg.getTrackedLeg(competitor);
                            LeaderboardRowDTO row = (LeaderboardRowDTO)leaderboardDTO.rows.get(competitorDTOsByIdAsString.get(competitor.getId().toString()));
                            LeaderboardEntryDTO entry = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(raceColumnName);
                            legDetail = (LegEntryDTO)entry.legDetails.get(zeroBasedLegIndex);
                            if (trackedLegOfCompetitor == null) continue;
                            jsonCompetitorInLeg.put((Object)"id", competitor.getId() != null ? competitor.getId().toString() : null);
                            jsonCompetitorInLeg.put((Object)"name", (Object)competitor.getName());
                            jsonCompetitorInLeg.put((Object)"sailNumber", (Object)trackedRace.getBoatOfCompetitor(competitor).getSailID());
                            jsonCompetitorInLeg.put((Object)"color", competitor.getColor() != null ? competitor.getColor().getAsHtml() : null);
                            Double d = averageSpeedOverGroundInKnots = legDetail == null ? null : legDetail.averageSpeedOverGroundInKnots;
                            if (averageSpeedOverGroundInKnots != null) {
                                jsonCompetitorInLeg.put((Object)"averageSOG-kts", (Object)RoundingUtil.knotsDecimalFormatter.format(averageSpeedOverGroundInKnots.doubleValue()));
                            }
                            if ((maxSpeedOverGround = trackedLegOfCompetitor.getMaximumSpeedOverGround(timePoint)) != null) {
                                jsonCompetitorInLeg.put((Object)"maxSOG-kts", (Object)RoundingUtil.knotsDecimalFormatter.format(((Speed)maxSpeedOverGround.getB()).getKnots()));
                                jsonCompetitorInLeg.put((Object)"maxSOGTimePoint-millis", (Object)RoundingUtil.knotsDecimalFormatter.format((double)((GPSFixMoving)maxSpeedOverGround.getA()).getTimePoint().asMillis()));
                            }
                            if (!(hasFinishedLeg = trackedLegOfCompetitor.hasFinishedLeg(timePoint))) {
                                Distance currentAbsolutXTE;
                                Distance currentSignedXTE = trackedLegOfCompetitor.getSignedCrossTrackError(timePoint);
                                if (currentSignedXTE != null) {
                                    jsonCompetitorInLeg.put((Object)"currentSignedXTE-m", (Object)currentSignedXTE.getMeters());
                                }
                                if ((currentAbsolutXTE = trackedLegOfCompetitor.getAbsoluteCrossTrackError(timePoint)) != null) {
                                    jsonCompetitorInLeg.put((Object)"currentAbsolutXTE-m", (Object)currentAbsolutXTE.getMeters());
                                }
                            }
                            if ((averageSignedXTE = trackedLegOfCompetitor.getAverageSignedCrossTrackError(timePoint, false)) != null) {
                                jsonCompetitorInLeg.put((Object)"averageSignedXTE-m", (Object)averageSignedXTE.getMeters());
                            }
                            if ((averageAbsolutXTE = trackedLegOfCompetitor.getAverageAbsoluteCrossTrackError(timePoint, false)) != null) {
                                jsonCompetitorInLeg.put((Object)"averageAbsolutXTE-m", (Object)averageAbsolutXTE.getMeters());
                            }
                            Integer n = legDetail == null ? null : (numberOfTacks = Integer.valueOf(legDetail.numberOfManeuvers == null ? 0 : legDetail.numberOfManeuvers.getOrDefault(ManeuverType.TACK, 0)));
                            Integer n2 = legDetail == null ? null : (numberOfJibes = Integer.valueOf(legDetail.numberOfManeuvers == null ? 0 : legDetail.numberOfManeuvers.getOrDefault(ManeuverType.JIBE, 0)));
                            Integer numberOfPenaltyCircles = legDetail == null ? null : Integer.valueOf(legDetail.numberOfManeuvers == null ? 0 : legDetail.numberOfManeuvers.getOrDefault(ManeuverType.PENALTY_CIRCLE, 0));
                            jsonCompetitorInLeg.put((Object)"tacks", (Object)numberOfTacks);
                            jsonCompetitorInLeg.put((Object)"jibes", (Object)numberOfJibes);
                            jsonCompetitorInLeg.put((Object)"penaltyCircles", (Object)numberOfPenaltyCircles);
                            TimePoint startTime = trackedLegOfCompetitor.getStartTime();
                            TimePoint finishTime = trackedLegOfCompetitor.getFinishTime();
                            TimePoint startOfRace = trackedRace.getStartOfRace();
                            if (startOfRace != null && startTime != null) {
                                Distance distanceSinceGun;
                                long timeSinceGun = -1L;
                                timeSinceGun = finishTime != null ? finishTime.asMillis() - startOfRace.asMillis() : timePoint.asMillis() - startOfRace.asMillis();
                                if (timeSinceGun > 0L) {
                                    jsonCompetitorInLeg.put((Object)"timeSinceGun-ms", (Object)timeSinceGun);
                                }
                                if ((distanceSinceGun = trackedRace.getTrack(competitor).getDistanceTraveled(startOfRace, finishTime != null ? finishTime : timePoint)) != null) {
                                    jsonCompetitorInLeg.put((Object)"distanceSinceGun-m", (Object)RoundingUtil.distanceDecimalFormatter.format(distanceSinceGun.getMeters()));
                                }
                            }
                            Double d2 = distanceTraveledInMeters = legDetail == null ? null : legDetail.distanceTraveledInMeters;
                            if (distanceTraveledInMeters != null) {
                                jsonCompetitorInLeg.put((Object)"distanceTraveled-m", (Object)RoundingUtil.distanceDecimalFormatter.format(distanceTraveledInMeters.doubleValue()));
                            }
                            Double d3 = distanceTraveledIncludingGateStartInMeters = legDetail == null ? null : legDetail.distanceTraveledIncludingGateStartInMeters;
                            if (distanceTraveledIncludingGateStartInMeters != null) {
                                jsonCompetitorInLeg.put((Object)"distanceTraveledIncludingGateStart-m", (Object)RoundingUtil.distanceDecimalFormatter.format(distanceTraveledIncludingGateStartInMeters.doubleValue()));
                            }
                            try {
                                int rank = legDetail == null ? 0 : legDetail.rank;
                                jsonCompetitorInLeg.put((Object)"rank", (Object)(rank == 0 ? null : Integer.valueOf(rank)));
                            }
                            catch (RuntimeException re) {
                                if (re.getCause() != null && re.getCause() instanceof NoWindException) break block29;
                                throw re;
                            }
                        }
                        if (SecurityUtils.getSubject().isPermitted(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, (WithQualifiedObjectIdentifier)leaderboard))) {
                            Double gapToLeaderInSeconds = legDetail == null ? null : legDetail.gapToLeaderInSeconds;
                            jsonCompetitorInLeg.put((Object)"gapToLeader-s", (Object)(gapToLeaderInSeconds != null ? gapToLeaderInSeconds : 0.0));
                            Distance gapToLeaderDistance = trackedLegOfCompetitor.getWindwardDistanceToCompetitorFarthestAhead(timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                            jsonCompetitorInLeg.put((Object)"gapToLeader-m", (Object)(gapToLeaderDistance != null ? gapToLeaderDistance.getMeters() : 0.0));
                        }
                        jsonCompetitorInLeg.put((Object)"started", (Object)trackedLegOfCompetitor.hasStartedLeg(timePoint));
                        jsonCompetitorInLeg.put((Object)"finished", (Object)trackedLegOfCompetitor.hasFinishedLeg(timePoint));
                        jsonCompetitors.add((Object)jsonCompetitorInLeg);
                    }
                    jsonLeg.put((Object)"competitors", (Object)jsonCompetitors);
                    jsonLegs.add((Object)jsonLeg);
                    ++zeroBasedLegIndex;
                }
                jsonRaceResults.put((Object)"legs", (Object)jsonLegs);
            }
            finally {
                course.unlockAfterRead();
            }
            return jsonRaceResults;
        }
        catch (NoWindException | InterruptedException | ExecutionException e1) {
            throw new RuntimeException(e1);
        }
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/competitors/live")
    public Response getCompetitorLiveRanks(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @DefaultValue(value="-1") @QueryParam(value="topN") Integer topN) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
            } else {
                CompetitorLiveRanksRequest cacheKey = new CompetitorLiveRanksRequest(regattaName, raceName, topN);
                JSONObject jsonLiveData = (JSONObject)competitorLiveRanksCache.get((Object)cacheKey);
                response = Response.ok((Object)this.streamingOutput(jsonLiveData)).build();
            }
        }
        return response;
    }

    private JSONObject computeCompetitorLiveRanks(String regattaName, String raceName, Integer topN) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaName);
        TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
        Course course = trackedRace.getRace().getCourse();
        Waypoint lastWaypoint = course.getLastWaypoint();
        TimePoint timePoint = MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis());
        LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePoint);
        RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
        JSONObject jsonLiveData = new JSONObject();
        jsonLiveData.put((Object)"name", (Object)trackedRace.getRace().getName());
        jsonLiveData.put((Object)"regatta", (Object)regattaName);
        if (trackedRace.getStartOfRace() != null) {
            TimePoint startOfRace = trackedRace.getStartOfRace();
            TimePoint now = MillisecondsTimePoint.now();
            jsonLiveData.put((Object)"startTime", (Object)startOfRace.asMillis());
            jsonLiveData.put((Object)"liveTime", (Object)now.asMillis());
            if (startOfRace.before(now)) {
                jsonLiveData.put((Object)"timeSinceStart-s", (Object)((double)(now.asMillis() - startOfRace.asMillis()) / 1000.0));
            } else {
                jsonLiveData.put((Object)"timeToStart-s", (Object)((double)(startOfRace.asMillis() - now.asMillis()) / 1000.0));
            }
        }
        JSONArray jsonCompetitors = new JSONArray();
        Iterable competitorsFromBestToWorst = trackedRace.getCompetitorsFromBestToWorst(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
        HashMap<Competitor, Integer> overallRankPerCompetitor = new HashMap<Competitor, Integer>();
        if (leaderboard != null) {
            Iterable overallRanking = leaderboard.getCompetitorsFromBestToWorst(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
            Integer overallRank = 1;
            for (Competitor competitor : overallRanking) {
                if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                Integer n = overallRank;
                overallRank = n + 1;
                overallRankPerCompetitor.put(competitor, n);
            }
        }
        Integer rank = 1;
        for (Competitor competitor : competitorsFromBestToWorst) {
            TrackedLegOfCompetitor currentLegOfCompetitor;
            SpeedWithBearing estimatedSpeed;
            GPSFixTrack competitorTrack;
            if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
            JSONObject jsonCompetitorInLeg = new JSONObject();
            if (topN != null && topN > 0 && rank > topN) break;
            jsonCompetitorInLeg.put((Object)"id", competitor.getId() != null ? competitor.getId().toString() : null);
            jsonCompetitorInLeg.put((Object)"name", (Object)competitor.getName());
            jsonCompetitorInLeg.put((Object)"sailNumber", (Object)trackedRace.getBoatOfCompetitor(competitor).getSailID());
            jsonCompetitorInLeg.put((Object)"color", competitor.getColor() != null ? competitor.getColor().getAsHtml() : null);
            Integer n = rank;
            rank = n + 1;
            jsonCompetitorInLeg.put((Object)"rank", (Object)n);
            Integer overallRank = (Integer)overallRankPerCompetitor.get(competitor);
            if (overallRank != null) {
                jsonCompetitorInLeg.put((Object)"overallRank", (Object)overallRank);
            }
            if ((trackedRace.getEndOfTracking() == null || trackedRace.getEndOfTracking().after(timePoint)) && (competitorTrack = trackedRace.getTrack(competitor)) != null && (estimatedSpeed = competitorTrack.getEstimatedSpeed(timePoint)) != null) {
                jsonCompetitorInLeg.put((Object)"speedOverGround-kts", (Object)RegattasResource.roundDouble((Double)estimatedSpeed.getKnots(), (int)2));
            }
            if ((currentLegOfCompetitor = trackedRace.getCurrentLeg(competitor, timePoint)) != null) {
                Distance distanceTraveledConsideringGateStart;
                int indexOfWaypoint = course.getIndexOfWaypoint(currentLegOfCompetitor.getLeg().getFrom());
                jsonCompetitorInLeg.put((Object)"leg", (Object)(indexOfWaypoint + 1));
                Distance distanceTraveled = currentLegOfCompetitor.getDistanceTraveled(timePoint);
                if (distanceTraveled != null) {
                    jsonCompetitorInLeg.put((Object)"distanceTraveled-m", (Object)RegattasResource.roundDouble((Double)distanceTraveled.getMeters(), (int)2));
                }
                if ((distanceTraveledConsideringGateStart = currentLegOfCompetitor.getDistanceTraveledConsideringGateStart(timePoint)) != null) {
                    jsonCompetitorInLeg.put((Object)"distanceTraveledConsideringGateStart-m", (Object)RegattasResource.roundDouble((Double)distanceTraveledConsideringGateStart.getMeters(), (int)2));
                }
                if (SecurityUtils.getSubject().isPermitted(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, (WithQualifiedObjectIdentifier)leaderboard))) {
                    Distance windwardDistanceToCompetitorFarthestAhead;
                    Duration gapToLeader = currentLegOfCompetitor.getGapToLeader(timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                    if (gapToLeader != null) {
                        double gapToLeaderAsSeconds = gapToLeader.asSeconds();
                        jsonCompetitorInLeg.put((Object)"gapToLeader-s", Double.isFinite(gapToLeaderAsSeconds) ? RegattasResource.roundDouble((Double)gapToLeaderAsSeconds, (int)2) : null);
                    }
                    if ((windwardDistanceToCompetitorFarthestAhead = currentLegOfCompetitor.getWindwardDistanceToCompetitorFarthestAhead(timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache)) != null) {
                        jsonCompetitorInLeg.put((Object)"gapToLeader-m", (Object)RegattasResource.roundDouble((Double)windwardDistanceToCompetitorFarthestAhead.getMeters(), (int)2));
                    }
                }
                jsonCompetitorInLeg.put((Object)"finished", (Object)false);
            } else if (trackedRace.getMarkPassing(competitor, lastWaypoint) != null) {
                jsonCompetitorInLeg.put((Object)"finished", (Object)true);
            } else {
                jsonCompetitorInLeg.put((Object)"finished", (Object)false);
            }
            jsonCompetitors.add((Object)jsonCompetitorInLeg);
        }
        jsonLiveData.put((Object)"competitors", (Object)jsonCompetitors);
        return jsonLiveData;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="datamining")
    public Response getRegattaPredefinedQueries() {
        List<PredefinedQueryIdentifier> predefinedRegattaQueries = this.getDataMiningResource().getPredefinedRegattaDataMiningQueries();
        return this.getDataMiningResource().predefinedQueryIdentifiersToJSON(predefinedRegattaQueries);
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/datamining/AvgSpeed_Per_Competitor-LegType")
    public Response avgSpeedPerCompetitorAndLegType(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            response = this.getDataMiningResource().avgSpeedPerCompetitorAndLegType(regattaName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/datamining/AvgSpeed_Per_Competitor-LegType")
    public Response avgSpeedPerCompetitorAndLegType(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            response = race == null ? this.getBadRaceErrorResponse(regattaName, raceName) : this.getDataMiningResource().avgSpeedPerCompetitorAndLegType(regattaName, raceName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/datamining/DistanceTraveled_Per_Competitor-LegType")
    public Response sumDistancePerCompetitorAndLegType(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            response = this.getDataMiningResource().sumDistanceTraveledPerCompetitorAndLegType(regattaName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/datamining/DistanceTraveled_Per_Competitor-LegType")
    public Response sumDistancePerCompetitorAndLegType(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            response = race == null ? this.getBadRaceErrorResponse(regattaName, raceName) : this.getDataMiningResource().sumDistanceTraveledPerCompetitorAndLegType(regattaName, raceName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/datamining/Maneuvers_Per_Competitor")
    public Response sumManeuversPerCompetitor(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            response = this.getDataMiningResource().sumManeuversPerCompetitor(regattaName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/datamining/Maneuvers_Per_Competitor")
    public Response sumManeuversPerCompetitor(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            response = race == null ? this.getBadRaceErrorResponse(regattaName, raceName) : this.getDataMiningResource().sumManeuversPerCompetitor(regattaName, raceName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/datamining/AvgSpeed_Per_Competitor")
    public Response avgSpeedPerCompetitor(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            response = this.getDataMiningResource().avgSpeedPerCompetitor(regattaName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/datamining/AvgSpeed_Per_Competitor")
    public Response avgSpeedPerCompetitor(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            response = race == null ? this.getBadRaceErrorResponse(regattaName, raceName) : this.getDataMiningResource().avgSpeedPerCompetitor(regattaName, raceName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/datamining/DistanceTraveled_Per_Competitor")
    public Response sumDistancePerCompetitor(@PathParam(value="regattaname") String regattaName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            response = this.getDataMiningResource().sumDistanceTraveledPerCompetitor(regattaName);
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/races/{racename}/datamining/DistanceTraveled_Per_Competitor")
    public Response sumDistancePerCompetitor(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            response = race == null ? this.getBadRaceErrorResponse(regattaName, raceName) : this.getDataMiningResource().sumDistanceTraveledPerCompetitor(regattaName, raceName);
        }
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaname}/addracecolumns")
    public Response addRaceColumns(@PathParam(value="regattaname") String regattaName, @QueryParam(value="numberofraces") Integer numberOfRaces, @QueryParam(value="prefix") String prefix, @QueryParam(value="toseries") String toSeries) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            JSONArray jsonResponse = new JSONArray();
            Series series = this.getSeriesUsingLastAsDefault(regatta, toSeries);
            if (series == null) {
                response = this.getBadSeriesErrorResponse(regattaName, toSeries);
            } else {
                String raceNamePrefix = prefix == null ? "R" : prefix;
                int oneBasedNumberOfLast = Util.size((Iterable)series.getRaceColumns());
                int i = 1;
                while (i <= (numberOfRaces == null ? 1 : numberOfRaces)) {
                    int oneBasedNumberOfNext = this.findNextFreeRaceName(series, raceNamePrefix, oneBasedNumberOfLast);
                    RaceColumnInSeries raceColumn = this.addRaceColumn(regatta, series.getName(), this.getRaceName(raceNamePrefix, oneBasedNumberOfNext));
                    JSONObject raceColumnDataAsJson = new JSONObject();
                    raceColumnDataAsJson.put((Object)"seriesname", (Object)raceColumn.getSeries().getName());
                    raceColumnDataAsJson.put((Object)"racename", (Object)raceColumn.getName());
                    jsonResponse.add((Object)raceColumnDataAsJson);
                    oneBasedNumberOfLast = oneBasedNumberOfNext;
                    ++i;
                }
                response = Response.ok((Object)this.streamingOutput(jsonResponse)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
            }
        }
        return response;
    }

    @POST
    @Path(value="{regattaname}/removeracecolumn")
    public Response removeRaceColumns(@PathParam(value="regattaname") String regattaName, @QueryParam(value="racecolumn") String raceColumnName) {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            boolean found = false;
            for (Series series : regatta.getSeries()) {
                if (series.getRaceColumnByName(raceColumnName) == null) continue;
                series.removeRaceColumn(raceColumnName);
                found = true;
                break;
            }
            response = !found ? this.getBadRaceErrorResponse(regattaName, raceColumnName) : Response.ok().build();
        }
        return response;
    }

    private String getRaceName(String raceNamePrefix, int number) {
        return String.valueOf(raceNamePrefix) + number;
    }

    private int findNextFreeRaceName(Series series, String raceNamePrefix, int oneBasedNumberOfLast) {
        int result = oneBasedNumberOfLast;
        boolean clash = false;
        block0: do {
            clash = false;
            String raceNameCandidate = this.getRaceName(raceNamePrefix, ++result);
            for (RaceColumnInSeries raceColumn : series.getRaceColumns()) {
                if (!raceColumn.getName().equals(raceNameCandidate)) continue;
                clash = true;
                continue block0;
            }
        } while (clash);
        return result;
    }

    private RaceColumnInSeries addRaceColumn(Regatta regatta, String seriesName, String columnName) {
        SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        return (RaceColumnInSeries)this.getService().apply((OperationWithResult)new AddColumnToSeries((RegattaIdentifier)new RegattaName(regatta.getName()), seriesName, columnName));
    }

    private Series getSeriesUsingLastAsDefault(Regatta regatta, String seriesName) {
        Iterator i;
        Object result = seriesName != null ? regatta.getSeriesByName(seriesName) : ((i = regatta.getSeries().iterator()).hasNext() ? (Series)i.next() : null);
        return result;
    }

    @POST
    @Path(value="/updateOrCreateSeries")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateOrCreateSeries(String json) throws ParseException, JsonDeserializationException {
        ArrayList<FleetDTO> fleets;
        int[] resultDiscardingThresholds;
        Integer maximumNumberOfDiscards;
        boolean oneAlwaysStaysOne;
        boolean hasCrossFleetMergedRanking;
        boolean hasSplitFleetContiguousScoring;
        boolean firstColumnIsNonDiscardableCarryForward;
        boolean startsWithZeroScore;
        boolean isFleetsCanRunInParallel;
        boolean isMedal;
        String seriesNameNew;
        String seriesName;
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String regattaName = (String)requestObject.get((Object)"regattaName");
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
            seriesName = (String)requestObject.get((Object)"seriesName");
            seriesNameNew = (String)requestObject.get((Object)"seriesNameNew");
            isMedal = (Boolean)requestObject.get((Object)"isMedal");
            isFleetsCanRunInParallel = (Boolean)requestObject.get((Object)"isFleetsCanRunInParallel");
            startsWithZeroScore = (Boolean)requestObject.get((Object)"startsWithZeroScore");
            firstColumnIsNonDiscardableCarryForward = (Boolean)requestObject.get((Object)"firstColumnIsNonDiscardableCarryForward");
            hasSplitFleetContiguousScoring = (Boolean)requestObject.get((Object)"hasSplitFleetContiguousScoring");
            hasCrossFleetMergedRanking = (Boolean)requestObject.get((Object)"hasCrossFleetMergedRanking");
            oneAlwaysStaysOne = (Boolean)requestObject.get((Object)"oneAlwaysStaysOne");
            maximumNumberOfDiscards = null;
            if (requestObject.containsKey((Object)"maximumNumberOfDiscards")) {
                maximumNumberOfDiscards = ((Long)requestObject.get((Object)"maximumNumberOfDiscards")).intValue();
            }
            resultDiscardingThresholds = null;
            if (requestObject.containsKey((Object)"resultDiscardingThresholds")) {
                JSONArray resultDiscardingThresholdsRaw = (JSONArray)requestObject.get((Object)"resultDiscardingThresholds");
                resultDiscardingThresholds = new int[resultDiscardingThresholdsRaw.size()];
                int i = 0;
                while (i < resultDiscardingThresholdsRaw.size()) {
                    resultDiscardingThresholds[i] = ((Long)resultDiscardingThresholdsRaw.get(i)).intValue();
                    ++i;
                }
            }
            JSONArray fleetsRaw = (JSONArray)requestObject.get((Object)"fleets");
            fleets = new ArrayList<FleetDTO>();
            for (Object fleetRaw : fleetsRaw) {
                JSONObject fleet = Helpers.toJSONObjectSafe(fleetRaw);
                String fleetName = (String)fleet.get((Object)"fleetName");
                int orderNo = ((Long)fleet.get((Object)"orderNo")).intValue();
                String htmlColor = (String)fleet.get((Object)"htmlColor");
                fleets.add(new FleetDTO(fleetName, orderNo, (Color)new RGBColor(htmlColor)));
            }
        } else {
            throw new IllegalStateException("RegattaName could not be resolved to regatta " + regattaName);
        }
        this.getService().apply((OperationWithResult)new UpdateSeries(regatta.getRegattaIdentifier(), seriesName, seriesNameNew, isMedal, isFleetsCanRunInParallel, resultDiscardingThresholds, startsWithZeroScore, firstColumnIsNonDiscardableCarryForward, hasSplitFleetContiguousScoring, hasCrossFleetMergedRanking, maximumNumberOfDiscards, oneAlwaysStaysOne, fleets));
        return Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{regattaName}/tracking_devices")
    public Response getTrackingStatus(@PathParam(value="regattaName") String regattaName, @QueryParam(value="deviceUuid") String optionalDeviceUuid, @QueryParam(value="secret") String regattaSecret) {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta != null) {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaSecret);
            if (!skip || !Util.hasLength((String)optionalDeviceUuid)) {
                SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
            }
            TrackingDeviceStatusSerializer serializer = new TrackingDeviceStatusSerializer((JsonSerializer<DeviceIdentifier>)new DeviceIdentifierJsonSerializer(this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class)));
            RegattaLogDeviceMappingFinder regattaLogDeviceMappingFinder = new RegattaLogDeviceMappingFinder(regatta.getRegattaLog());
            Map foundMappings = (Map)regattaLogDeviceMappingFinder.analyze();
            JSONObject result = new JSONObject();
            foundMappings.forEach((item, mappings) -> {
                HashMap<DeviceIdentifier, DeviceMappingWithRegattaLogEvent> mappingByDeviceID = new HashMap<DeviceIdentifier, DeviceMappingWithRegattaLogEvent>();
                for (DeviceMappingWithRegattaLogEvent mapping : mappings) {
                    mappingByDeviceID.compute(mapping.getDevice(), (di, existingMapping) -> {
                        if (existingMapping == null) {
                            return mapping;
                        }
                        TimeRange existingTimeRange = existingMapping.getTimeRange();
                        TimeRange newTimeRange = mapping.getTimeRange();
                        if (!existingTimeRange.hasOpenEnd() && newTimeRange.hasOpenEnd() || newTimeRange.endsAfter(existingTimeRange) || newTimeRange.to().compareTo((Object)existingTimeRange.to()) == 0 && newTimeRange.startsAfter(existingTimeRange)) {
                            return mapping;
                        }
                        return existingMapping;
                    });
                }
                JSONArray deviceStatusesOfTrackedItem = new JSONArray();
                for (DeviceMappingWithRegattaLogEvent deviceMapping : mappingByDeviceID.values()) {
                    if (Util.hasLength((String)optionalDeviceUuid) && !Util.equalsWithNull((Object)deviceMapping.getDevice().getStringRepresentation(), (Object)optionalDeviceUuid)) continue;
                    JSONObject serializedDeviceStatus = serializer.serialize(TrackingDeviceStatus.calculateDeviceStatus(deviceMapping.getDevice(), this.getService()));
                    deviceStatusesOfTrackedItem.add((Object)serializedDeviceStatus);
                    TimeRange mappedTimeRange = deviceMapping.getTimeRange();
                    serializedDeviceStatus.put((Object)"mappedFrom", (Object)mappedTimeRange.from().asMillis());
                    serializedDeviceStatus.put((Object)"mappedTo", mappedTimeRange.hasOpenEnd() ? null : Long.valueOf(mappedTimeRange.to().asMillis()));
                }
                JSONObject itemObject = new JSONObject();
                itemObject.put((Object)"deviceStatuses", (Object)deviceStatusesOfTrackedItem);
                if (item instanceof Competitor) {
                    itemObject.put((Object)"competitorId", (Object)item.getId().toString());
                    ((JSONArray)result.computeIfAbsent((Object)"competitors", k -> new JSONArray())).add((Object)itemObject);
                } else if (item instanceof Boat) {
                    itemObject.put((Object)"boatId", (Object)item.getId().toString());
                    ((JSONArray)result.computeIfAbsent((Object)"boats", k -> new JSONArray())).add((Object)itemObject);
                } else if (item instanceof Mark) {
                    itemObject.put((Object)"markId", (Object)item.getId().toString());
                    ((JSONArray)result.computeIfAbsent((Object)"marks", k -> new JSONArray())).add((Object)itemObject);
                } else {
                    logger.log(Level.WARNING, "Unexpected tracked item found while calculating the tracker status. ID: " + item.getId() + "; type: " + item.getClass().getName());
                }
            });
            return Response.ok((Object)this.streamingOutput(result)).build();
        }
        throw new IllegalStateException("Regatta named " + regattaName + " could not be resolved");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="{regattaname}/competitors/{competitorid}/updateToTHandicap")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateCompetitorToTHandicap(@PathParam(value="regattaname") String regattaName, @PathParam(value="competitorid") String competitorId, @QueryParam(value="timeOnTimeFactor") Double timeOnTimeFactor) throws IllegalStateException, ParseException {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta == null) throw new IllegalStateException("RegattaName could not be resolved to regatta " + regattaName);
        SecurityService securityService = this.getSecurityService();
        securityService.checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        Serializable potentialUUID = UUIDHelper.tryUuidConversion((Serializable)((Object)competitorId));
        Competitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorById(potentialUUID);
        if (competitor == null) return this.getBadCompetitorIdResponse((Serializable)((Object)competitorId));
        if (timeOnTimeFactor == null) {
            throw new IllegalStateException("Missing required parameter: timeOnTimeFactor");
        }
        User author = securityService.getCurrentUser();
        LogEventAuthorImpl logEventAuthor = new LogEventAuthorImpl(author.getName(), 0);
        TimePoint now = MillisecondsTimePoint.now();
        RegattaLogSetCompetitorTimeOnTimeFactorEventImpl event = new RegattaLogSetCompetitorTimeOnTimeFactorEventImpl(now, now, (AbstractLogEventAuthor)logEventAuthor, (Serializable)UUID.randomUUID(), competitor, timeOnTimeFactor);
        RegattaLog regattaLog = regatta.getRegattaLog();
        regattaLog.add((AbstractLogEvent)event);
        return Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="{regattaname}/competitors/{competitorId}/updateToDHandicap")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateCompetitorToDHandicap(@PathParam(value="regattaname") String regattaName, @PathParam(value="competitorId") String competitorId, @QueryParam(value="timeOnDistanceAllowancePerNauticalMile") Long timeOnDistanceAllowancePerNauticalMile) throws IllegalStateException, ParseException {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        SecurityService securityService = this.getSecurityService();
        securityService.checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        if (regatta == null) throw new IllegalStateException("RegattaName could not be resolved to regatta " + regattaName);
        Serializable potentialUUID = UUIDHelper.tryUuidConversion((Serializable)((Object)competitorId));
        Competitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorById(potentialUUID);
        if (competitor == null) return this.getBadCompetitorIdResponse((Serializable)((Object)competitorId));
        if (timeOnDistanceAllowancePerNauticalMile == null) {
            throw new IllegalStateException("Missing required parameter: timeOnDistanceAllowancePerNauticalMile");
        }
        MillisecondsDurationImpl durationTimeOnDistanceAllowancePerNauticalMile = new MillisecondsDurationImpl(timeOnDistanceAllowancePerNauticalMile.longValue());
        User author = securityService.getCurrentUser();
        LogEventAuthorImpl logEventAuthor = new LogEventAuthorImpl(author.getName(), 0);
        TimePoint now = MillisecondsTimePoint.now();
        RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEventImpl event = new RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEventImpl(now, now, (AbstractLogEventAuthor)logEventAuthor, (Serializable)UUID.randomUUID(), competitor, (Duration)durationTimeOnDistanceAllowancePerNauticalMile);
        RegattaLog regattaLog = regatta.getRegattaLog();
        regattaLog.add((AbstractLogEvent)event);
        return Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    private /* synthetic */ CompetitorWithBoat lambda$3(UUID uUID, String string, String string2, Color color, String string3, URI uRI, TeamImpl teamImpl, Double d, Long l, String string4, DynamicBoat dynamicBoat) throws Exception {
        return this.getService().getCompetitorAndBoatStore().getOrCreateCompetitorWithBoat((Serializable)uUID, string, string2, color, string3, uRI, (DynamicTeam)teamImpl, d, (Duration)(l == null ? null : new MillisecondsDurationImpl(l.longValue())), string4, dynamicBoat, true);
    }

    @FunctionalInterface
    private static interface BoatObtainer {
        public DynamicBoat getBoat(String var1, OwnershipAnnotation var2, boolean var3);
    }

    private class CompetitorLiveRanksRequest {
        private final String regattaName;
        private final String raceName;
        private final Integer topN;

        public CompetitorLiveRanksRequest(String regattaName, String raceName, Integer topN) {
            this.regattaName = regattaName;
            this.raceName = raceName;
            this.topN = topN;
        }

        public String getRegattaName() {
            return this.regattaName;
        }

        public String getRaceName() {
            return this.raceName;
        }

        public Integer getTopN() {
            return this.topN;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.raceName == null ? 0 : this.raceName.hashCode());
            result = 31 * result + (this.regattaName == null ? 0 : this.regattaName.hashCode());
            result = 31 * result + (this.topN == null ? 0 : this.topN.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompetitorLiveRanksRequest other = (CompetitorLiveRanksRequest)obj;
            if (this.raceName == null ? other.raceName != null : !this.raceName.equals(other.raceName)) {
                return false;
            }
            if (this.regattaName == null ? other.regattaName != null : !this.regattaName.equals(other.regattaName)) {
                return false;
            }
            return !(this.topN == null ? other.topN != null : !this.topN.equals(other.topN));
        }

        public RegattasResource getResource() {
            return RegattasResource.this;
        }
    }

    private class CompetitorRanksRequest {
        private final Regatta regatta;
        private final RaceColumn raceColumn;
        private final Fleet fleet;

        public Regatta getRegatta() {
            return this.regatta;
        }

        public RaceColumn getRaceColumn() {
            return this.raceColumn;
        }

        public Fleet getFleet() {
            return this.fleet;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fleet == null ? 0 : this.fleet.hashCode());
            result = 31 * result + (this.raceColumn == null ? 0 : this.raceColumn.hashCode());
            result = 31 * result + (this.regatta == null ? 0 : this.regatta.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompetitorRanksRequest other = (CompetitorRanksRequest)obj;
            if (this.fleet == null ? other.fleet != null : !this.fleet.equals(other.fleet)) {
                return false;
            }
            if (this.raceColumn == null ? other.raceColumn != null : !this.raceColumn.equals(other.raceColumn)) {
                return false;
            }
            return !(this.regatta == null ? other.regatta != null : !this.regatta.equals(other.regatta));
        }

        public CompetitorRanksRequest(Regatta regatta, RaceColumn raceColumn, Fleet fleet) {
            this.regatta = regatta;
            this.raceColumn = raceColumn;
            this.fleet = fleet;
        }

        public RegattasResource getResource() {
            return RegattasResource.this;
        }
    }
}

