/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasMarkPassingContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.MarkPassingWithContext;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class MarkPassingRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedLegOfCompetitorContext, HasMarkPassingContext> {
    public MarkPassingRetrievalProcessor(ExecutorService executor, Collection<Processor<HasMarkPassingContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedLegOfCompetitorContext.class, HasMarkPassingContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasMarkPassingContext> retrieveData(HasTrackedLegOfCompetitorContext element) {
        ArrayList<HasMarkPassingContext> maneuversWithContext = new ArrayList<HasMarkPassingContext>();
        TimePoint finishTime = element.getTrackedLegOfCompetitor().getFinishTime();
        if (finishTime != null) {
            try {
                Iterable maneuvers = element.getTrackedLegOfCompetitor().getManeuvers(finishTime, false);
                for (Maneuver maneuver : maneuvers) {
                    if (!this.isAborted()) {
                        if (!maneuver.isMarkPassing()) continue;
                        maneuversWithContext.add(new MarkPassingWithContext(element, maneuver));
                        continue;
                    }
                    break;
                }
            }
            catch (NoWindException e) {
                throw new IllegalStateException("No wind retrieving the mark passings", e);
            }
        }
        return maneuversWithContext;
    }
}

