/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import java.io.Serializable;

public class RecordCompetitorGPSFix
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = 5847067037829132465L;
    private final Serializable competitorID;
    private final GPSFixMoving gpsFix;

    public RecordCompetitorGPSFix(RegattaAndRaceIdentifier raceIdentifier, Competitor competitor, GPSFixMoving gpsFix) {
        super(raceIdentifier);
        this.competitorID = competitor.getId();
        this.gpsFix = gpsFix;
    }

    public boolean requiresSynchronousExecution() {
        return false;
    }

    @Override
    protected Object getRaceSpecificKeyComponentForAsynchronousExecution() {
        return this.competitorID;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            Competitor competitor = trackedRace.getRace().getCompetitorById(this.competitorID);
            trackedRace.recordFix(competitor, this.gpsFix, false);
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

