/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.QueryState;
import com.sap.sse.datamining.components.management.DataMiningQueryManager;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.shared.DataMiningSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public abstract class SingleQueryPerKeyManager<T>
implements DataMiningQueryManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ConcurrentMap<T, Query<?>> queryMap = new ConcurrentHashMap();

    @Override
    public <ResultType> QueryResult<ResultType> runNewAndAbortPrevious(DataMiningSession session, Query<ResultType> query) {
        if (session == null || query == null) {
            throw new NullPointerException();
        }
        Iterable<T> keys = this.getKeysFor(session, query);
        this.validate(keys);
        this.abortPreviousQueries(keys);
        this.registerNewQuery(keys, query);
        this.logger.info("Running query " + query + ", that has been registered for the keys " + keys);
        QueryResult<ResultType> result = query.run();
        this.logger.info("Done running query " + query);
        this.unregisterQuery(keys, query);
        return result;
    }

    @Override
    public void abortRandomQuery() {
        Random generator = new Random();
        boolean abortedQuery = false;
        Set keySet = this.queryMap.keySet();
        while (!abortedQuery) {
            ArrayList keys = new ArrayList(keySet);
            Object randomKey = keys.get(generator.nextInt(keys.size()));
            abortedQuery = this.abortQuery(randomKey);
        }
    }

    @Override
    public void abortAllQueries() {
        HashSet queries = new HashSet(this.queryMap.entrySet());
        this.queryMap.clear();
        queries.parallelStream().forEach(element -> {
            Object key = element.getKey();
            Query query = (Query)element.getValue();
            this.logger.info("Aborting query " + query + " for the key " + key);
            query.abort();
        });
    }

    @Override
    public int getNumberOfRunningQueries() {
        return this.queryMap.size();
    }

    protected abstract <ResultType> Iterable<T> getKeysFor(DataMiningSession var1, Query<ResultType> var2);

    private void validate(Iterable<T> keys) {
        int size = 0;
        for (T key : keys) {
            if (key == null) {
                throw new IllegalArgumentException("Null key was created for query.");
            }
            ++size;
        }
        if (size == 0) {
            throw new IllegalArgumentException("Unable to create keys for query.");
        }
    }

    private void abortPreviousQueries(Iterable<T> keys) {
        for (T key : keys) {
            if (!this.queryMap.containsKey(key)) continue;
            this.abortQuery(key);
        }
    }

    private boolean abortQuery(T key) {
        boolean abortedQuery = false;
        Query query = (Query)this.queryMap.get(key);
        if (query.getState() == QueryState.RUNNING) {
            this.logger.info("Aborting query " + query + " for the key " + key);
            query.abort();
            abortedQuery = true;
        }
        this.queryMap.remove(key, query);
        return abortedQuery;
    }

    private <ResultType> void registerNewQuery(Iterable<T> keys, Query<ResultType> query) {
        for (T key : keys) {
            Query<ResultType> previousValue = this.queryMap.putIfAbsent(key, query);
            if (previousValue == null) continue;
            throw new UnsupportedOperationException("There's allready a query for the key: " + key);
        }
    }

    private void unregisterQuery(Iterable<T> keys, Query<?> finishedQuery) {
        for (T key : keys) {
            this.queryMap.remove(key, finishedQuery);
        }
    }
}

