/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.components.Processor;

public class DataRetrieverLevel<InputType, RetrievedDataType> {
    private final int retrieverLevel;
    private final Class<? extends Processor<InputType, RetrievedDataType>> retrieverType;
    private final Class<RetrievedDataType> retrievedDataType;
    private final Class<?> settingsType;
    private final String retrievedDataTypeMessageKey;
    private final SerializableSettings defaultSettings;

    public DataRetrieverLevel(int retrieverLevel, Class<? extends Processor<InputType, RetrievedDataType>> retrieverType, Class<RetrievedDataType> retrievedDataType, Class<?> settingsType, String retrievedDataTypeMessageKey, SerializableSettings defaultSettings) {
        this.retrieverLevel = retrieverLevel;
        this.retrieverType = retrieverType;
        this.retrievedDataType = retrievedDataType;
        this.settingsType = settingsType;
        this.retrievedDataTypeMessageKey = retrievedDataTypeMessageKey;
        this.defaultSettings = defaultSettings;
    }

    public int getLevel() {
        return this.retrieverLevel;
    }

    public Class<? extends Processor<InputType, RetrievedDataType>> getRetrieverType() {
        return this.retrieverType;
    }

    public Class<RetrievedDataType> getRetrievedDataType() {
        return this.retrievedDataType;
    }

    public String getRetrievedDataTypeMessageKey() {
        return this.retrievedDataTypeMessageKey;
    }

    public boolean hasSettings() {
        return this.getDefaultSettings() != null;
    }

    public Class<?> getSettingsType() {
        return this.settingsType;
    }

    public SerializableSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public String toString() {
        return "Level " + this.retrieverLevel + " [retrieverType: " + this.retrieverType.getSimpleName() + ", retrievedDataType: " + this.retrievedDataType.getSimpleName() + ", settingsType: " + (this.settingsType == null ? "null" : this.settingsType.getSimpleName()) + ", messageKey: " + this.retrievedDataTypeMessageKey + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.retrievedDataType == null ? 0 : this.retrievedDataType.hashCode());
        result = 31 * result + this.retrieverLevel;
        result = 31 * result + (this.retrieverType == null ? 0 : this.retrieverType.hashCode());
        result = 31 * result + (this.settingsType == null ? 0 : this.settingsType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRetrieverLevel other = (DataRetrieverLevel)obj;
        if (this.retrievedDataType == null ? other.retrievedDataType != null : !this.retrievedDataType.equals(other.retrievedDataType)) {
            return false;
        }
        if (this.retrieverLevel != other.retrieverLevel) {
            return false;
        }
        if (this.retrieverType == null ? other.retrieverType != null : !this.retrieverType.equals(other.retrieverType)) {
            return false;
        }
        return !(this.settingsType == null ? other.settingsType != null : !this.settingsType.equals(other.settingsType));
    }
}

