/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableManagedRuleGroupVersionsResponse extends Wafv2Response implements
        ToCopyableBuilder<ListAvailableManagedRuleGroupVersionsResponse.Builder, ListAvailableManagedRuleGroupVersionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListAvailableManagedRuleGroupVersionsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<ManagedRuleGroupVersion>> VERSIONS_FIELD = SdkField
            .<List<ManagedRuleGroupVersion>> builder(MarshallingType.LIST)
            .memberName("Versions")
            .getter(getter(ListAvailableManagedRuleGroupVersionsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedRuleGroupVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedRuleGroupVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CURRENT_DEFAULT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentDefaultVersion")
            .getter(getter(ListAvailableManagedRuleGroupVersionsResponse::currentDefaultVersion))
            .setter(setter(Builder::currentDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentDefaultVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            VERSIONS_FIELD, CURRENT_DEFAULT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<ManagedRuleGroupVersion> versions;

    private final String currentDefaultVersion;

    private ListAvailableManagedRuleGroupVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.versions = builder.versions;
        this.currentDefaultVersion = builder.currentDefaultVersion;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Versions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The versions that are currently available for the specified managed rule group. If you specified a
     * <code>Limit</code> in your request, this might not be the full list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersions} method.
     * </p>
     * 
     * @return The versions that are currently available for the specified managed rule group. If you specified a
     *         <code>Limit</code> in your request, this might not be the full list.
     */
    public final List<ManagedRuleGroupVersion> versions() {
        return versions;
    }

    /**
     * <p>
     * The name of the version that's currently set as the default.
     * </p>
     * 
     * @return The name of the version that's currently set as the default.
     */
    public final String currentDefaultVersion() {
        return currentDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(currentDefaultVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableManagedRuleGroupVersionsResponse)) {
            return false;
        }
        ListAvailableManagedRuleGroupVersionsResponse other = (ListAvailableManagedRuleGroupVersionsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasVersions() == other.hasVersions()
                && Objects.equals(versions(), other.versions())
                && Objects.equals(currentDefaultVersion(), other.currentDefaultVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableManagedRuleGroupVersionsResponse").add("NextMarker", nextMarker())
                .add("Versions", hasVersions() ? versions() : null).add("CurrentDefaultVersion", currentDefaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "CurrentDefaultVersion":
            return Optional.ofNullable(clazz.cast(currentDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("Versions", VERSIONS_FIELD);
        map.put("CurrentDefaultVersion", CURRENT_DEFAULT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableManagedRuleGroupVersionsResponse, T> g) {
        return obj -> g.apply((ListAvailableManagedRuleGroupVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Wafv2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableManagedRuleGroupVersionsResponse> {
        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
         * retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in
         *        the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The versions that are currently available for the specified managed rule group. If you specified a
         * <code>Limit</code> in your request, this might not be the full list.
         * </p>
         * 
         * @param versions
         *        The versions that are currently available for the specified managed rule group. If you specified a
         *        <code>Limit</code> in your request, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<ManagedRuleGroupVersion> versions);

        /**
         * <p>
         * The versions that are currently available for the specified managed rule group. If you specified a
         * <code>Limit</code> in your request, this might not be the full list.
         * </p>
         * 
         * @param versions
         *        The versions that are currently available for the specified managed rule group. If you specified a
         *        <code>Limit</code> in your request, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(ManagedRuleGroupVersion... versions);

        /**
         * <p>
         * The versions that are currently available for the specified managed rule group. If you specified a
         * <code>Limit</code> in your request, this might not be the full list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #versions(List<ManagedRuleGroupVersion>)}.
         * 
         * @param versions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(java.util.Collection<ManagedRuleGroupVersion>)
         */
        Builder versions(Consumer<ManagedRuleGroupVersion.Builder>... versions);

        /**
         * <p>
         * The name of the version that's currently set as the default.
         * </p>
         * 
         * @param currentDefaultVersion
         *        The name of the version that's currently set as the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDefaultVersion(String currentDefaultVersion);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextMarker;

        private List<ManagedRuleGroupVersion> versions = DefaultSdkAutoConstructList.getInstance();

        private String currentDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableManagedRuleGroupVersionsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            versions(model.versions);
            currentDefaultVersion(model.currentDefaultVersion);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ManagedRuleGroupVersion.Builder> getVersions() {
            List<ManagedRuleGroupVersion.Builder> result = ManagedRuleGroupVersionsCopier.copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersions(Collection<ManagedRuleGroupVersion.BuilderImpl> versions) {
            this.versions = ManagedRuleGroupVersionsCopier.copyFromBuilder(versions);
        }

        @Override
        public final Builder versions(Collection<ManagedRuleGroupVersion> versions) {
            this.versions = ManagedRuleGroupVersionsCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(ManagedRuleGroupVersion... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<ManagedRuleGroupVersion.Builder>... versions) {
            versions(Stream.of(versions).map(c -> ManagedRuleGroupVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCurrentDefaultVersion() {
            return currentDefaultVersion;
        }

        public final void setCurrentDefaultVersion(String currentDefaultVersion) {
            this.currentDefaultVersion = currentDefaultVersion;
        }

        @Override
        public final Builder currentDefaultVersion(String currentDefaultVersion) {
            this.currentDefaultVersion = currentDefaultVersion;
            return this;
        }

        @Override
        public ListAvailableManagedRuleGroupVersionsResponse build() {
            return new ListAvailableManagedRuleGroupVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
