/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CPU performance to consider, using an instance family as the baseline reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CpuPerformanceFactorRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CpuPerformanceFactorRequest.Builder, CpuPerformanceFactorRequest> {
    private static final SdkField<List<PerformanceFactorReferenceRequest>> REFERENCES_FIELD = SdkField
            .<List<PerformanceFactorReferenceRequest>> builder(MarshallingType.LIST)
            .memberName("References")
            .getter(getter(CpuPerformanceFactorRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reference").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PerformanceFactorReferenceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PerformanceFactorReferenceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("item").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PerformanceFactorReferenceRequest> references;

    private CpuPerformanceFactorRequest(BuilderImpl builder) {
        this.references = builder.references;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify an instance family to use as the baseline reference for CPU performance. All instance types that match
     * your specified attributes will be compared against the CPU performance of the referenced instance family,
     * regardless of CPU manufacturer or architecture differences.
     * </p>
     * <note>
     * <p>
     * Currently only one instance family can be specified in the list.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return Specify an instance family to use as the baseline reference for CPU performance. All instance types that
     *         match your specified attributes will be compared against the CPU performance of the referenced instance
     *         family, regardless of CPU manufacturer or architecture differences. </p> <note>
     *         <p>
     *         Currently only one instance family can be specified in the list.
     *         </p>
     */
    public final List<PerformanceFactorReferenceRequest> references() {
        return references;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuPerformanceFactorRequest)) {
            return false;
        }
        CpuPerformanceFactorRequest other = (CpuPerformanceFactorRequest) obj;
        return hasReferences() == other.hasReferences() && Objects.equals(references(), other.references());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CpuPerformanceFactorRequest").add("References", hasReferences() ? references() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reference", REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CpuPerformanceFactorRequest, T> g) {
        return obj -> g.apply((CpuPerformanceFactorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CpuPerformanceFactorRequest> {
        /**
         * <p>
         * Specify an instance family to use as the baseline reference for CPU performance. All instance types that
         * match your specified attributes will be compared against the CPU performance of the referenced instance
         * family, regardless of CPU manufacturer or architecture differences.
         * </p>
         * <note>
         * <p>
         * Currently only one instance family can be specified in the list.
         * </p>
         * </note>
         * 
         * @param references
         *        Specify an instance family to use as the baseline reference for CPU performance. All instance types
         *        that match your specified attributes will be compared against the CPU performance of the referenced
         *        instance family, regardless of CPU manufacturer or architecture differences. </p> <note>
         *        <p>
         *        Currently only one instance family can be specified in the list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Collection<PerformanceFactorReferenceRequest> references);

        /**
         * <p>
         * Specify an instance family to use as the baseline reference for CPU performance. All instance types that
         * match your specified attributes will be compared against the CPU performance of the referenced instance
         * family, regardless of CPU manufacturer or architecture differences.
         * </p>
         * <note>
         * <p>
         * Currently only one instance family can be specified in the list.
         * </p>
         * </note>
         * 
         * @param references
         *        Specify an instance family to use as the baseline reference for CPU performance. All instance types
         *        that match your specified attributes will be compared against the CPU performance of the referenced
         *        instance family, regardless of CPU manufacturer or architecture differences. </p> <note>
         *        <p>
         *        Currently only one instance family can be specified in the list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(PerformanceFactorReferenceRequest... references);

        /**
         * <p>
         * Specify an instance family to use as the baseline reference for CPU performance. All instance types that
         * match your specified attributes will be compared against the CPU performance of the referenced instance
         * family, regardless of CPU manufacturer or architecture differences.
         * </p>
         * <note>
         * <p>
         * Currently only one instance family can be specified in the list.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.PerformanceFactorReferenceRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.PerformanceFactorReferenceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.PerformanceFactorReferenceRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #references(List<PerformanceFactorReferenceRequest>)}.
         * 
         * @param references
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.PerformanceFactorReferenceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #references(java.util.Collection<PerformanceFactorReferenceRequest>)
         */
        Builder references(Consumer<PerformanceFactorReferenceRequest.Builder>... references);
    }

    static final class BuilderImpl implements Builder {
        private List<PerformanceFactorReferenceRequest> references = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CpuPerformanceFactorRequest model) {
            references(model.references);
        }

        public final List<PerformanceFactorReferenceRequest.Builder> getReferences() {
            List<PerformanceFactorReferenceRequest.Builder> result = PerformanceFactorReferenceSetRequestCopier
                    .copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<PerformanceFactorReferenceRequest.BuilderImpl> references) {
            this.references = PerformanceFactorReferenceSetRequestCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<PerformanceFactorReferenceRequest> references) {
            this.references = PerformanceFactorReferenceSetRequestCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(PerformanceFactorReferenceRequest... references) {
            references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<PerformanceFactorReferenceRequest.Builder>... references) {
            references(Stream.of(references).map(c -> PerformanceFactorReferenceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CpuPerformanceFactorRequest build() {
            return new CpuPerformanceFactorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
