/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.RedisBatchExecutor;
import org.redisson.command.RedisCommonBatchExecutor;
import org.redisson.command.RedisExecutor;
import org.redisson.command.RedisQueuedBatchExecutor;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.CompletableFutureWrapper;

public class CommandBatchService
extends CommandAsyncService {
    private final AtomicInteger index = new AtomicInteger();
    private final ConcurrentMap<NodeSource, Entry> commands = new ConcurrentHashMap<NodeSource, Entry>();
    private Map<MasterSlaveEntry, Entry> aggregatedCommands = Collections.emptyMap();
    private final ConcurrentMap<MasterSlaveEntry, ConnectionEntry> connections = new ConcurrentHashMap<MasterSlaveEntry, ConnectionEntry>();
    private final BatchOptions options;
    private final Map<CompletableFuture<?>, List<CommandBatchService>> nestedServices = new ConcurrentHashMap();
    private final AtomicBoolean executed = new AtomicBoolean();
    private final long retryInterval;
    private final int retryAttempts;

    public CommandBatchService(CommandAsyncExecutor executor) {
        this(executor, RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), BatchOptions.defaults(), executor.getObjectBuilder(), referenceType);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), referenceType);
    }

    private CommandBatchService(ConnectionManager connectionManager, BatchOptions options, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        super(connectionManager, objectBuilder, referenceType);
        this.options = options;
        this.retryAttempts = options.getRetryAttempts() >= 0 ? options.getRetryAttempts() : connectionManager.getServiceManager().getConfig().getRetryAttempts();
        this.retryInterval = options.getRetryInterval() > 0L ? this.options.getRetryInterval() : (long)connectionManager.getServiceManager().getConfig().getRetryInterval();
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public void add(CompletableFuture<?> future, List<CommandBatchService> services) {
        this.nestedServices.put(future, services);
    }

    @Override
    public <V, R> RFuture<R> async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, boolean ignoreRedirect, boolean noRetry) {
        CompletableFuture<R> mainPromise = this.createPromise();
        if (this.isRedisBasedQueue()) {
            boolean isReadOnly = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC;
            RedisQueuedBatchExecutor<V, R> executor = new RedisQueuedBatchExecutor<V, R>(isReadOnly, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.connections, this.options, this.index, this.executed, this.referenceType, noRetry, this.aggregatedCommands);
            ((RedisExecutor)executor).execute();
        } else {
            RedisBatchExecutor<V, R> executor = new RedisBatchExecutor<V, R>(readOnlyMode, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.options, this.index, this.executed, this.referenceType, noRetry);
            ((RedisExecutor)executor).execute();
        }
        return new CompletableFutureWrapper<R>(mainPromise);
    }

    @Override
    public <R> CompletableFuture<R> createPromise() {
        if (this.isRedisBasedQueue()) {
            return new BatchPromise();
        }
        return new CompletableFuture();
    }

    public void discard() {
        this.get(this.discardAsync());
    }

    public RFuture<Void> discardAsync() {
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        this.executed.set(true);
        if (this.isRedisBasedQueue()) {
            return this.writeAllVoidAsync(RedisCommands.DISCARD, new Object[0]);
        }
        this.commands.values().stream().flatMap(e -> e.getCommands().stream()).flatMap(c -> Arrays.stream(c.getParams())).forEach(obj -> ReferenceCountUtil.safeRelease((Object)obj));
        return new CompletableFutureWrapper<Void>((Void)null);
    }

    public BatchResult<?> execute() {
        RFuture<BatchResult<?>> f = this.executeAsync();
        return this.get(f);
    }

    public RFuture<Void> executeAsyncVoid() {
        CompletableFuture resFuture = this.executeAsync().toCompletableFuture();
        CompletionStage s = resFuture.thenApply(res -> null);
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)s);
    }

    public boolean isExecuted() {
        return this.executed.get();
    }

    public RFuture<BatchResult<?>> executeAsync() {
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty() && this.nestedServices.isEmpty()) {
            this.executed.set(true);
            BatchResult result = new BatchResult(Collections.emptyList(), 0);
            return new CompletableFutureWrapper(result);
        }
        if (this.isRedisBasedQueue()) {
            return this.executeRedisBasedQueue();
        }
        CompletableFuture promise = new CompletableFuture();
        CompletableFuture<Map<NodeSource, Entry>> voidPromise = new CompletableFuture<Map<NodeSource, Entry>>();
        if (this.options.isSkipResult() && this.options.getSyncSlaves() == 0) {
            voidPromise.whenComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.completeExceptionally((Throwable)ex);
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                this.commands.clear();
                this.nestedServices.clear();
                promise.complete(new BatchResult(Collections.emptyList(), 0));
            });
        } else {
            voidPromise.whenComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.completeExceptionally((Throwable)ex);
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                try {
                    ArrayList<Object> responses = new ArrayList<Object>();
                    int syncedSlaves = 0;
                    if (!res.isEmpty()) {
                        ArrayList entries = new ArrayList();
                        for (Entry e : res.values()) {
                            entries.addAll(e.getCommands());
                        }
                        Collections.sort(entries);
                        Iterator iterator = entries.iterator();
                        while (iterator.hasNext()) {
                            BatchCommandData commandEntry = (BatchCommandData)iterator.next();
                            if (this.isWaitCommand(commandEntry)) {
                                if (commandEntry.getCommand().getName().equals(RedisCommands.WAIT.getName())) {
                                    syncedSlaves += commandEntry.getPromise().getNow(0).intValue();
                                    continue;
                                }
                                List<Integer> list = commandEntry.getPromise().getNow(Arrays.asList(0, 0));
                                syncedSlaves += list.get(1).intValue();
                                continue;
                            }
                            if (commandEntry.getCommand().getName().equals(RedisCommands.MULTI.getName()) || commandEntry.getCommand().getName().equals(RedisCommands.EXEC.getName()) || this.options.isSkipResult() || commandEntry.getPromise().isCancelled()) continue;
                            Object entryResult = commandEntry.getPromise().getNow(null);
                            try {
                                if (this.objectBuilder != null) {
                                    entryResult = this.objectBuilder.tryHandleReference(entryResult, this.referenceType);
                                }
                            }
                            catch (ReflectiveOperationException exc) {
                                log.error("Unable to handle reference from {}", entryResult, (Object)exc);
                            }
                            responses.add(entryResult);
                        }
                    }
                    if (!this.nestedServices.isEmpty()) {
                        for (CompletableFuture completableFuture : this.nestedServices.keySet()) {
                            responses.add(completableFuture.getNow(null));
                        }
                    }
                    BatchResult result = new BatchResult(responses, syncedSlaves);
                    promise.complete(result);
                }
                catch (Exception e) {
                    promise.completeExceptionally((Throwable)ex);
                    throw e;
                }
                this.commands.clear();
                this.nestedServices.clear();
            });
        }
        this.execute(voidPromise);
        return new CompletableFutureWrapper(promise);
    }

    private void execute(CompletableFuture<Map<NodeSource, Entry>> voidPromise) {
        AtomicInteger attempt = new AtomicInteger();
        CompletableFuture<Map<NodeSource, Entry>> future = new CompletableFuture<Map<NodeSource, Entry>>();
        this.resolveCommandsInMemory(attempt, future);
        future.whenComplete((r, ex) -> {
            try {
                if (ex != null) {
                    voidPromise.completeExceptionally((Throwable)ex);
                    return;
                }
                AtomicInteger slots = new AtomicInteger(r.size());
                for (Map.Entry<CompletableFuture<?>, List<CommandBatchService>> entry : this.nestedServices.entrySet()) {
                    slots.incrementAndGet();
                    for (CommandBatchService service : entry.getValue()) {
                        service.executeAsync();
                    }
                    entry.getKey().whenComplete((res, e) -> {
                        if (e == null) {
                            if (slots.decrementAndGet() == 0) {
                                voidPromise.complete((Map<NodeSource, Entry>)r);
                            }
                        } else if (((CompletableFuture)entry.getKey()).isCancelled()) {
                            voidPromise.completeExceptionally((Throwable)e);
                        } else {
                            voidPromise.completeExceptionally(e.getCause());
                        }
                    });
                }
                CompletionStage<Void> f = this.loadScripts((Map<NodeSource, Entry>)r);
                f.whenComplete((res, ex1) -> {
                    try {
                        if (ex1 != null) {
                            voidPromise.completeExceptionally(ex1.getCause());
                            return;
                        }
                        for (Map.Entry e : r.entrySet()) {
                            if (this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY) {
                                for (Entry entry : r.values()) {
                                    BatchCommandData multiCommand = new BatchCommandData(RedisCommands.MULTI, new Object[0], this.index.incrementAndGet());
                                    entry.addFirstCommand(multiCommand);
                                    BatchCommandData execCommand = new BatchCommandData(RedisCommands.EXEC, new Object[0], this.index.incrementAndGet());
                                    entry.add(execCommand);
                                }
                            }
                            if (this.options.isSkipResult()) {
                                for (Entry entry : r.values()) {
                                    BatchCommandData offCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                                    entry.addFirstCommand(offCommand);
                                    BatchCommandData onCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                                    entry.add(onCommand);
                                }
                            }
                            if (this.options.getSyncSlaves() > 0) {
                                BatchCommandData waitCommand;
                                if (this.options.isSyncAOF()) {
                                    for (Entry entry : r.values()) {
                                        waitCommand = new BatchCommandData(RedisCommands.WAITAOF, new Object[]{this.options.getSyncLocals(), this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                                        entry.add(waitCommand);
                                    }
                                } else {
                                    for (Entry entry : r.values()) {
                                        waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                                        entry.add(waitCommand);
                                    }
                                }
                            }
                            BatchOptions options = BatchOptions.defaults().executionMode(this.options.getExecutionMode()).responseTimeout(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS).retryAttempts(Math.max(0, this.retryAttempts - attempt.get())).retryInterval(this.retryInterval, TimeUnit.MILLISECONDS);
                            if (this.options.isSkipResult()) {
                                options.skipResult();
                            }
                            if (this.options.isSyncAOF()) {
                                options.syncAOF(this.options.getSyncLocals(), this.options.getSyncSlaves(), Duration.ofMillis(this.options.getSyncTimeout()));
                            } else {
                                options.sync(this.options.getSyncSlaves(), Duration.ofMillis(this.options.getSyncTimeout()));
                            }
                            CompletableFuture<Void> mainPromise = new CompletableFuture<Void>();
                            mainPromise.whenComplete((res1, ex2) -> {
                                if (ex2 != null) {
                                    voidPromise.completeExceptionally((Throwable)ex2);
                                    return;
                                }
                                voidPromise.complete((Map<NodeSource, Entry>)r);
                            });
                            RedisCommonBatchExecutor executor = new RedisCommonBatchExecutor((NodeSource)e.getKey(), mainPromise, this.connectionManager, options, (Entry)e.getValue(), slots, this.referenceType, false);
                            executor.execute();
                        }
                    }
                    catch (Exception e) {
                        voidPromise.completeExceptionally(e);
                    }
                });
            }
            catch (Exception e2) {
                voidPromise.completeExceptionally(e2);
            }
        });
    }

    private CompletionStage<Void> loadScripts(Map<NodeSource, Entry> r) {
        if (!this.connectionManager.getServiceManager().getCfg().isUseScriptCache()) {
            return CompletableFuture.completedFuture(null);
        }
        CommandBatchService bb = new CommandBatchService(this.connectionManager, BatchOptions.defaults(), this.objectBuilder, this.referenceType);
        HashMap<MasterSlaveEntry, Set> newScripts = new HashMap<MasterSlaveEntry, Set>();
        for (Map.Entry<NodeSource, Entry> e : r.entrySet()) {
            for (BatchCommandData<?, ?> data : e.getValue().getEvalCommands()) {
                Set newShas;
                RedisCommand command = data.getCommand();
                String script = (String)data.getParams()[0];
                MasterSlaveEntry entry = e.getKey().getEntry();
                if (!this.connectionManager.getServiceManager().isCached(entry.getClient().getAddr(), script) && (newShas = newScripts.computeIfAbsent(entry, k -> new HashSet())).add(script)) {
                    if (e.getValue().isReadOnlyMode()) {
                        bb.executeAllAsync(entry, RedisCommands.SCRIPT_LOAD, script);
                    } else {
                        bb.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, script);
                    }
                }
                RedisCommand cmd = new RedisCommand(command, "EVALSHA");
                data.updateCommand(cmd);
                String sha1 = this.getServiceManager().calcSHA(script);
                data.getParams()[0] = sha1;
            }
        }
        return bb.executeAsync().thenAccept(res -> {
            for (Map.Entry e : newScripts.entrySet()) {
                this.connectionManager.getServiceManager().cacheScripts(((MasterSlaveEntry)e.getKey()).getClient().getAddr(), (Set)e.getValue());
            }
        });
    }

    private void resolveCommands(AtomicInteger attempt, CompletableFuture<Map<MasterSlaveEntry, Entry>> future) {
        HashMap<MasterSlaveEntry, Entry> result = new HashMap<MasterSlaveEntry, Entry>();
        for (Map.Entry e : this.commands.entrySet()) {
            MasterSlaveEntry entry = this.getEntry((NodeSource)e.getKey());
            if (entry == null) {
                if (attempt.incrementAndGet() == this.retryAttempts + 1) {
                    future.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException((NodeSource)e.getKey()));
                    return;
                }
                this.connectionManager.getServiceManager().newTimeout(task -> this.resolveCommands(attempt, future), this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            Entry ee = result.computeIfAbsent(entry, k -> new Entry());
            if (!((Entry)e.getValue()).isReadOnlyMode()) {
                ee.setReadOnlyMode(false);
            }
            ee.getCommands().addAll(((Entry)e.getValue()).getCommands());
            ee.getEvalCommands().addAll(((Entry)e.getValue()).getEvalCommands());
        }
        for (Entry entry : result.values()) {
            entry.sortCommands();
        }
        future.complete(result);
    }

    private void resolveCommandsInMemory(AtomicInteger attempt, CompletableFuture<Map<NodeSource, Entry>> future) {
        HashMap<NodeSource, Entry> result = new HashMap<NodeSource, Entry>();
        for (Map.Entry e : this.commands.entrySet()) {
            ClientConnectionsEntry ce;
            MasterSlaveEntry entry = this.getEntry((NodeSource)e.getKey());
            if (entry == null) {
                if (attempt.incrementAndGet() == this.retryAttempts + 1) {
                    future.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException((NodeSource)e.getKey()));
                    return;
                }
                this.connectionManager.getServiceManager().newTimeout(task -> this.resolveCommandsInMemory(attempt, future), this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            RedisClient client = ((NodeSource)e.getKey()).getRedisClient();
            if (client != null && ((ce = entry.getEntry(client)) == null || ce.isFreezed())) {
                client = null;
            }
            Entry ee = result.computeIfAbsent(new NodeSource(entry, client), k -> new Entry());
            if (!((Entry)e.getValue()).isReadOnlyMode()) {
                ee.setReadOnlyMode(false);
            }
            ee.getCommands().addAll(((Entry)e.getValue()).getCommands());
            ee.getEvalCommands().addAll(((Entry)e.getValue()).getEvalCommands());
        }
        for (Entry entry : result.values()) {
            entry.sortCommands();
        }
        future.complete(result);
    }

    private MasterSlaveEntry getEntry(NodeSource source) {
        if (source.getSlot() != null) {
            return this.connectionManager.getWriteEntry(source.getSlot());
        }
        return source.getEntry();
    }

    protected Throwable cause(CompletableFuture<?> future) {
        try {
            future.getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    private <R> RFuture<R> executeRedisBasedQueue() {
        final CompletableFuture resultPromise = new CompletableFuture();
        final long responseTimeout = this.options.getResponseTimeout() > 0L ? this.options.getResponseTimeout() : (long)this.connectionManager.getServiceManager().getConfig().getTimeout();
        Timeout timeout = this.connectionManager.getServiceManager().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                CommandBatchService.this.connections.values().forEach(c -> c.getCancelCallback().run());
                resultPromise.completeExceptionally(new RedisTimeoutException("Response timeout for queued commands " + responseTimeout + ": " + CommandBatchService.this.commands.values().stream().flatMap(e -> e.getCommands().stream().map(d -> d.getCommand())).collect(Collectors.toList())));
            }
        }, responseTimeout, TimeUnit.MILLISECONDS);
        CompletableFuture<Void> allFutures = CompletableFuture.allOf((CompletableFuture[])this.commands.values().stream().flatMap(m -> m.getCommands().stream().map(c -> ((BatchPromise)c.getPromise()).getSentPromise())).toArray(CompletableFuture[]::new));
        allFutures.whenComplete((fr, exc) -> {
            if (!timeout.cancel()) {
                return;
            }
            block0: for (Entry entry : this.commands.values()) {
                for (BatchCommandData<?, ?> command : entry.getCommands()) {
                    if (!command.getPromise().isDone() || !command.getPromise().isCompletedExceptionally()) continue;
                    resultPromise.completeExceptionally(this.cause(command.getPromise()));
                    continue block0;
                }
            }
            if (resultPromise.isDone()) {
                return;
            }
            ConcurrentHashMap result = new ConcurrentHashMap();
            AtomicInteger attempt = new AtomicInteger();
            CompletableFuture<Map<MasterSlaveEntry, Entry>> resolvedEntriesFuture = new CompletableFuture<Map<MasterSlaveEntry, Entry>>();
            this.resolveCommands(attempt, resolvedEntriesFuture);
            resolvedEntriesFuture.whenComplete((map, ee) -> {
                if (ee != null) {
                    resultPromise.completeExceptionally((Throwable)ee);
                    return;
                }
                AtomicInteger slots = new AtomicInteger(this.nestedServices.size());
                CompletableFuture<Object> nestedServicesFuture = this.nestedServices.isEmpty() ? CompletableFuture.completedFuture(null) : new CompletableFuture();
                for (Map.Entry<CompletableFuture<?>, List<CommandBatchService>> entry : this.nestedServices.entrySet()) {
                    for (CommandBatchService service : entry.getValue()) {
                        service.executeAsync();
                    }
                    entry.getKey().whenComplete((res, e) -> {
                        if (e == null) {
                            if (slots.decrementAndGet() == 0) {
                                nestedServicesFuture.complete(null);
                            }
                        } else if (((CompletableFuture)entry.getKey()).isCancelled()) {
                            nestedServicesFuture.completeExceptionally((Throwable)e);
                        } else {
                            nestedServicesFuture.completeExceptionally(e.getCause());
                        }
                    });
                }
                nestedServicesFuture.whenComplete((r1, exc2) -> {
                    if (exc2 != null) {
                        resultPromise.completeExceptionally((Throwable)exc2);
                        return;
                    }
                    this.aggregatedCommands = map;
                    ArrayList futures = new ArrayList(map.size());
                    for (Map.Entry<MasterSlaveEntry, Entry> entry : this.aggregatedCommands.entrySet()) {
                        boolean isReadOnly = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC;
                        CompletableFuture execPromise = this.createPromise();
                        RedisQueuedBatchExecutor executor = new RedisQueuedBatchExecutor(isReadOnly, new NodeSource(entry.getKey()), this.codec, RedisCommands.EXEC, new Object[0], execPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.connections, this.options, this.index, this.executed, this.referenceType, false, this.aggregatedCommands);
                        ((RedisExecutor)executor).execute();
                        CompletionStage f = execPromise.thenCompose(r -> {
                            BatchCommandData<?, ?> lastCommand = ((Entry)entry.getValue()).getCommands().peekLast();
                            result.put((MasterSlaveEntry)entry.getKey(), r);
                            if (RedisCommands.WAIT.getName().equals(lastCommand.getCommand().getName())) {
                                return lastCommand.getPromise().thenApply(i -> null);
                            }
                            return CompletableFuture.completedFuture(null);
                        });
                        futures.add(f.toCompletableFuture());
                    }
                    CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                    future.whenComplete((res, ex) -> {
                        this.executed.set(true);
                        if (ex != null) {
                            resultPromise.completeExceptionally((Throwable)ex);
                            return;
                        }
                        try {
                            for (Map.Entry entry : result.entrySet()) {
                                Entry commandEntry = this.aggregatedCommands.get(entry.getKey());
                                Iterator<Object> resultIter = ((List)entry.getValue()).iterator();
                                for (BatchCommandData<?, ?> data : commandEntry.getCommands()) {
                                    if (data.getCommand().getName().equals(RedisCommands.EXEC.getName())) break;
                                    CompletableFuture promise = data.getPromise();
                                    if (resultIter.hasNext()) {
                                        promise.complete(resultIter.next());
                                        continue;
                                    }
                                    promise.complete(null);
                                }
                            }
                            ArrayList entries = new ArrayList();
                            for (Entry e : this.aggregatedCommands.values()) {
                                entries.addAll(e.getCommands());
                            }
                            Collections.sort(entries);
                            ArrayList<Object> arrayList = new ArrayList<Object>(entries.size());
                            int syncedSlaves = 0;
                            for (BatchCommandData batchCommandData : entries) {
                                if (this.isWaitCommand(batchCommandData)) {
                                    if (batchCommandData.getCommand().getName().equals(RedisCommands.WAIT.getName())) {
                                        syncedSlaves += batchCommandData.getPromise().getNow(0).intValue();
                                        continue;
                                    }
                                    List<Integer> list = batchCommandData.getPromise().getNow(Arrays.asList(0, 0));
                                    syncedSlaves += list.get(1).intValue();
                                    continue;
                                }
                                if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName())) continue;
                                Object entryResult = batchCommandData.getPromise().getNow(null);
                                if (this.objectBuilder != null) {
                                    entryResult = this.objectBuilder.tryHandleReference(entryResult, this.referenceType);
                                }
                                arrayList.add(entryResult);
                            }
                            if (!this.nestedServices.isEmpty()) {
                                for (CompletableFuture completableFuture : this.nestedServices.keySet()) {
                                    arrayList.add(completableFuture.getNow(null));
                                }
                            }
                            BatchResult r = new BatchResult(arrayList, syncedSlaves);
                            resultPromise.complete(r);
                        }
                        catch (Exception e) {
                            resultPromise.completeExceptionally(e);
                        }
                    });
                });
            });
        });
        return new CompletableFutureWrapper(resultPromise);
    }

    protected boolean isRedisBasedQueue() {
        return this.options != null && (this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
    }

    protected boolean isWaitCommand(CommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName()) || c.getCommand().getName().equals(RedisCommands.WAITAOF.getName());
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    @Override
    protected CommandBatchService createCommandBatchService(int availableSlaves) {
        return this;
    }

    public static class Entry {
        final List<BatchCommandData<?, ?>> evalCommands = new LinkedList();
        final Deque<BatchCommandData<?, ?>> commands = new ConcurrentLinkedDeque();
        volatile boolean readOnlyMode = true;

        public void addCommand(BatchCommandData<?, ?> command) {
            if (RedisCommands.EVAL_OBJECT.getName().equals(command.getCommand().getName())) {
                this.evalCommands.add(command);
            }
            this.commands.add(command);
        }

        public List<BatchCommandData<?, ?>> getEvalCommands() {
            return this.evalCommands;
        }

        public void addFirstCommand(BatchCommandData<?, ?> command) {
            this.commands.addFirst(command);
        }

        public void add(BatchCommandData<?, ?> command) {
            this.commands.add(command);
        }

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void sortCommands() {
            int index = 0;
            boolean sorted = true;
            for (BatchCommandData<?, ?> command : this.commands) {
                if (command.getIndex() > index) {
                    index = command.getIndex();
                    continue;
                }
                sorted = false;
                break;
            }
            if (sorted) {
                return;
            }
            Object[] cmds = this.commands.toArray(new BatchCommandData[0]);
            Arrays.sort(cmds);
            this.commands.clear();
            Collections.addAll(this.commands, cmds);
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }

    public static class ConnectionEntry {
        boolean firstCommand = true;
        final CompletableFuture<RedisConnection> connectionFuture;
        Runnable cancelCallback;

        public ConnectionEntry(CompletableFuture<RedisConnection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public CompletableFuture<RedisConnection> getConnectionFuture() {
            return this.connectionFuture;
        }

        public boolean isFirstCommand() {
            return this.firstCommand;
        }

        public void setFirstCommand(boolean firstCommand) {
            this.firstCommand = firstCommand;
        }

        public Runnable getCancelCallback() {
            return this.cancelCallback;
        }

        public void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }
    }
}

