/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.impl;

import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.impl.AbstractReleaseRepository;
import com.sap.sse.landscape.impl.FolderBasedReleaseImpl;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FolderBasedReleaseRepositoryImpl
extends AbstractReleaseRepository {
    private static final Logger logger = Logger.getLogger(FolderBasedReleaseRepositoryImpl.class.getName());
    private final String repositoryBase;

    public FolderBasedReleaseRepositoryImpl(String repositoryBase, String defaultReleaseNamePrefix) {
        super(defaultReleaseNamePrefix);
        this.repositoryBase = repositoryBase;
    }

    private String getRepositoryBase() {
        return this.repositoryBase;
    }

    @Override
    public Iterator<Release> iterator() {
        return this.getAvailableReleases().iterator();
    }

    private Iterable<Release> getAvailableReleases() {
        LinkedList<Release> result = new LinkedList<Release>();
        try {
            URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(this.getRepositoryBase()));
            InputStream index = (InputStream)connection.getContent();
            int read = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((read = index.read()) != -1) {
                bos.write(read);
            }
            index.close();
            String contents = bos.toString();
            Pattern pattern = Pattern.compile("<a href=\"(([^/]*)-([0-9]*))/\">([^/]*)-([0-9]*)/</a>");
            Matcher m = pattern.matcher(contents);
            int lastMatch = 0;
            while (m.find(lastMatch)) {
                result.add(new FolderBasedReleaseImpl(m.group(1), this.getRepositoryBase()));
                lastMatch = m.end();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error loading releases from repository at " + this.getRepositoryBase() + ". Continuing empty.", e);
            return Collections.emptyList();
        }
        return result;
    }
}

