/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogExcludeWindSourcesEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningConfirmedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFixedMarkPassingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPassChangeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogSuppressedMarkPassingsEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogWindFixEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbortingFlagFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ExcludedWindSourcesFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.MarkPassingDataFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.WindFixesFinder;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.BaseRaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.markpassingcalculation.MarkPassingUpdateListener;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceLogWindFixDeclinationHelper;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class DynamicTrackedRaceLogListener
extends BaseRaceLogEventVisitor {
    private static final Logger logger = Logger.getLogger(DynamicTrackedRaceLogListener.class.getName());
    private ConcurrentMap<RaceLog, ReadonlyRaceState> raceLogs = new ConcurrentHashMap<RaceLog, ReadonlyRaceState>();
    private DynamicTrackedRace trackedRace;
    private final WindSource raceCommitteeWindSource;
    private MarkPassingDataFinder markPassingDataFinder;
    private MarkPassingUpdateListener markPassingUpdateListener;

    public DynamicTrackedRaceLogListener(DynamicTrackedRace trackedRace) {
        this.trackedRace = trackedRace;
        this.raceCommitteeWindSource = new WindSourceImpl(WindSourceType.RACECOMMITTEE);
    }

    public void beforeAttaching(RaceLog raceLog) {
        if (raceLog == null) {
            logger.severe("Trying to add " + (Object)((Object)this) + " as listener to a null race log for tracked race " + this.trackedRace.getRace());
        } else {
            raceLog.addListener((Object)this);
            ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.trackedRace.getRaceLogResolver(), (RaceLog)raceLog);
            this.raceLogs.put(raceLog, raceState);
            raceState.addChangedListener((RaceStateChangedListener)new BaseRaceStateChangedListener(){

                public void onFinishedTimeChanged(ReadonlyRaceState state) {
                    DynamicTrackedRaceLogListener.this.trackedRace.setFinishedTime(state.getFinishedTime());
                }

                public void onFinishingTimeChanged(ReadonlyRaceState state) {
                    DynamicTrackedRaceLogListener.this.trackedRace.setFinishingTime(state.getFinishingTime());
                }
            });
        }
    }

    public void afterAttaching(RaceLog raceLog) {
        this.trackedRace.invalidateStartTime();
        this.trackedRace.invalidateEndTime();
        this.analyze(raceLog);
    }

    public TimePoint getFinishingTime() {
        TimePoint result = null;
        for (ReadonlyRaceState raceState : this.raceLogs.values()) {
            result = raceState.getFinishingTime();
            if (result != null) break;
        }
        return result;
    }

    public TimePoint getFinishedTime() {
        TimePoint result = null;
        for (ReadonlyRaceState raceState : this.raceLogs.values()) {
            result = raceState.getFinishedTime();
            if (result != null) break;
        }
        return result;
    }

    private LastPublishedCourseDesignFinder createCourseDesignFinder(RaceLog raceLog) {
        return new LastPublishedCourseDesignFinder(raceLog, false);
    }

    private AbortingFlagFinder createAbortingFlagFinder(RaceLog raceLog) {
        return new AbortingFlagFinder(raceLog);
    }

    private StartTimeFinder createStartTimeFinder(RaceLog raceLog) {
        return new StartTimeFinder((RaceLogResolver)this.trackedRace.getRaceLogResolver(), raceLog);
    }

    public void setMarkPassingUpdateListener(MarkPassingUpdateListener listener) {
        this.markPassingUpdateListener = listener;
    }

    private void initializeWindTrack(RaceLog raceLog) {
        WindFixesFinder windFixesFinder = new WindFixesFinder(raceLog);
        for (RaceLogWindFixEvent raceLogWindFixEvent : (List)windFixesFinder.analyze()) {
            Wind wind = new RaceLogWindFixDeclinationHelper().getOptionallyDeclinationCorrectedWind(raceLogWindFixEvent);
            this.trackedRace.recordWind(wind, this.raceCommitteeWindSource, false);
        }
    }

    public void beforeDetaching(RaceLog raceLog) {
        if (raceLog != null) {
            raceLog.removeListener((Object)this);
            this.raceLogs.remove(raceLog);
            if (this.markPassingUpdateListener != null) {
                this.removeMarkPassingEvents();
            }
        }
    }

    public void afterDetaching(RaceLog raceLog) {
        if (raceLog != null) {
            this.trackedRace.invalidateStartTime();
            this.removeAllWindFixesFromWindTrack(raceLog);
            this.trackedRace.updateMarkPassingsAfterRaceLogChanges();
        }
    }

    private void removeAllWindFixesFromWindTrack(RaceLog raceLog) {
        WindFixesFinder windFixesFinder = new WindFixesFinder(raceLog);
        for (RaceLogWindFixEvent raceLogWindFixEvent : (List)windFixesFinder.analyze()) {
            Wind wind = new RaceLogWindFixDeclinationHelper().getOptionallyDeclinationCorrectedWind(raceLogWindFixEvent);
            this.trackedRace.removeWind(wind, this.raceCommitteeWindSource);
        }
    }

    private void removeMarkPassingEvents() {
        for (Util.Triple triple : (Set)this.markPassingDataFinder.analyze()) {
            if (triple.getC() == null) {
                this.markPassingUpdateListener.removeSuppressedPassing((Competitor)triple.getA());
                continue;
            }
            this.markPassingUpdateListener.removeFixedPassing((Competitor)triple.getA(), (Integer)triple.getB());
        }
    }

    private void analyze(RaceLog raceLog) {
        this.trackedRace.setFinishingTime(this.getFinishingTime());
        this.trackedRace.setFinishedTime(this.getFinishedTime());
        this.analyzeCourseDesign(null);
        this.initializeWindTrack(raceLog);
        this.updateWindSourcesToExclude();
        if (this.markPassingUpdateListener != null) {
            this.markPassingDataFinder = new MarkPassingDataFinder(raceLog);
            this.analyzeMarkPassings();
        }
        this.trackedRace.updateMarkPassingsAfterRaceLogChanges();
    }

    private void analyzeCourseDesign(CourseBase courseBaseProvidedByEvent) {
        CourseBase courseDesign = null;
        for (RaceLog raceLog : this.raceLogs.keySet()) {
            courseDesign = (CourseBase)this.createCourseDesignFinder(raceLog).analyze();
            if (courseDesign != null) break;
        }
        if (courseDesign == null) {
            courseDesign = courseBaseProvidedByEvent;
        }
        if (courseDesign != null) {
            this.trackedRace.onCourseDesignChangedByRaceCommittee(courseDesign);
        } else {
            logger.info("Could not find any course design update on race log of " + this.trackedRace.getRace().getName() + "! Not sending out any events.");
        }
    }

    private void analyzeStartTime(TimePoint startTimeProvidedByEvent) {
        this.trackedRace.invalidateStartTime();
        TimePoint startTime = null;
        for (RaceLog raceLog : this.raceLogs.keySet()) {
            startTime = ((StartTimeFinderResult)this.createStartTimeFinder(raceLog).analyze()).getStartTime();
            if (startTime != null) break;
        }
        if (startTime == null) {
            startTime = startTimeProvidedByEvent;
        }
        if (startTime != null) {
            this.trackedRace.onStartTimeChangedByRaceCommittee(startTime);
        } else {
            logger.info("Could not find any valid start time on race log of " + this.trackedRace.getRace().getName() + "! Not sending out any events.");
        }
    }

    private void analyzeMarkPassings() {
        for (Util.Triple triple : (Set)this.markPassingDataFinder.analyze()) {
            if (triple.getC() == null) {
                this.markPassingUpdateListener.addSuppressedPassing((Competitor)triple.getA(), (Integer)triple.getB());
                continue;
            }
            this.markPassingUpdateListener.addFixedPassing((Competitor)triple.getA(), (Integer)triple.getB(), (TimePoint)triple.getC());
        }
    }

    public void visit(RaceLogPassChangeEvent event) {
        this.trackedRace.invalidateStartTime();
        this.trackedRace.onStartTimeChangedByRaceCommittee(null);
        RaceLogFlagEvent abortingFlag = null;
        for (RaceLog raceLog : this.raceLogs.keySet()) {
            abortingFlag = (RaceLogFlagEvent)this.createAbortingFlagFinder(raceLog).analyze();
            if (abortingFlag != null) break;
        }
        if (abortingFlag != null) {
            this.trackedRace.onAbortedByRaceCommittee(abortingFlag.getUpperFlag());
        }
        this.trackedRace.updateMarkPassingsAfterRaceLogChanges();
    }

    public void visit(RaceLogStartTimeEvent event) {
        this.analyzeStartTime(event.getStartTime());
    }

    public void visit(RaceLogCourseDesignChangedEvent event) {
        this.analyzeCourseDesign(event.getCourseDesign());
    }

    public void visit(RaceLogFinishPositioningConfirmedEvent event) {
        this.trackedRace.updateMarkPassingsAfterRaceLogChanges();
    }

    public void visit(RaceLogWindFixEvent event) {
        Wind wind = new RaceLogWindFixDeclinationHelper().getOptionallyDeclinationCorrectedWind(event);
        this.trackedRace.recordWind(wind, this.raceCommitteeWindSource);
    }

    public void visit(RaceLogFixedMarkPassingEvent event) {
        if (this.markPassingUpdateListener != null) {
            this.markPassingUpdateListener.addFixedPassing((Competitor)event.getInvolvedCompetitors().get(0), event.getZeroBasedIndexOfPassedWaypoint(), event.getTimePointOfFixedPassing());
        }
    }

    public void visit(RaceLogSuppressedMarkPassingsEvent event) {
        if (this.markPassingUpdateListener != null) {
            this.markPassingUpdateListener.addSuppressedPassing((Competitor)event.getInvolvedCompetitors().get(0), event.getZeroBasedIndexOfFirstSuppressedWaypoint());
        }
    }

    public void visit(RaceLogRevokeEvent event) {
        if (this.markPassingUpdateListener != null) {
            RaceLogEvent revokedEvent = null;
            for (RaceLog log : this.raceLogs.keySet()) {
                try {
                    log.lockForRead();
                    revokedEvent = (RaceLogEvent)log.getEventById(event.getRevokedEventId());
                    if (revokedEvent == null) continue;
                    break;
                }
                finally {
                    log.unlockAfterRead();
                }
            }
            if (revokedEvent instanceof RaceLogSuppressedMarkPassingsEvent) {
                this.markPassingUpdateListener.removeSuppressedPassing((Competitor)revokedEvent.getInvolvedCompetitors().get(0));
            } else if (revokedEvent instanceof RaceLogFixedMarkPassingEvent) {
                this.markPassingUpdateListener.removeFixedPassing((Competitor)revokedEvent.getInvolvedCompetitors().get(0), ((RaceLogFixedMarkPassingEvent)revokedEvent).getZeroBasedIndexOfPassedWaypoint());
            }
        }
    }

    public void visit(RaceLogDependentStartTimeEvent event) {
        this.analyzeStartTime(null);
    }

    public void visit(RaceLogStartOfTrackingEvent event) {
        this.trackedRace.updateStartAndEndOfTracking(false);
    }

    public void visit(RaceLogEndOfTrackingEvent event) {
        this.trackedRace.updateStartAndEndOfTracking(false);
    }

    public void visit(RaceLogRaceStatusEvent event) {
        if (event.getNextStatus().equals((Object)RaceLogRaceStatus.FINISHED)) {
            this.trackedRace.invalidateEndTime();
        }
    }

    public void visit(RaceLogExcludeWindSourcesEvent event) {
        this.updateWindSourcesToExclude();
    }

    private void updateWindSourcesToExclude() {
        for (RaceLog raceLog : this.raceLogs.keySet()) {
            Iterable windSourcesToExclude = (Iterable)new ExcludedWindSourcesFinder(raceLog).analyze();
            if (windSourcesToExclude == null) continue;
            this.trackedRace.setWindSourcesToExclude(windSourcesToExclude);
        }
    }
}

