/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.ApproximatedFixesCalculator;
import com.sap.sailing.domain.maneuverdetection.IncrementalApproximatedFixesCalculator;
import com.sap.sailing.domain.maneuverdetection.IncrementalManeuverDetector;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.ApproximatedFixesCalculatorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverSpot;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverSpotWithTypedManeuvers;
import com.sap.sailing.domain.maneuverdetection.impl.WindMeasurement;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.windestimation.WindEstimationInteraction;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class IncrementalManeuverDetectorImpl
extends ManeuverDetectorImpl
implements IncrementalManeuverDetector {
    private static final double WIND_COURSE_TOLERANCE_IN_DEGREES_TO_IGNORE_FOR_MANEUVER_REUSE = 5.0;
    private static final double DOUGLAS_PEUCKER_FIXES_TIME_POINT_TOLERANCE_IN_SECONDS_TO_IGNORE_FOR_MANEUVER_REUSE = 1.0;
    private volatile ManeuverDetectionResult lastManeuverDetectionResult = null;
    private final ApproximatedFixesCalculator approximatedFixesCalculator;
    private final WindEstimationInteraction windEstimationInteraction;

    public IncrementalManeuverDetectorImpl(TrackedRace trackedRace, Competitor competitor, WindEstimationInteraction windEstimationInteraction) {
        super(trackedRace, competitor);
        this.windEstimationInteraction = windEstimationInteraction;
        this.approximatedFixesCalculator = new ApproximatedFixesCalculatorImpl(trackedRace, competitor);
    }

    @Override
    public List<Maneuver> getAlreadyDetectedManeuvers() {
        ManeuverDetectionResult lastManeuverDetectionResult = this.lastManeuverDetectionResult;
        if (lastManeuverDetectionResult != null) {
            return this.getAllManeuversFromManeuverSpots(lastManeuverDetectionResult.getManeuverSpots());
        }
        return Collections.emptyList();
    }

    @Override
    public List<CompleteManeuverCurve> getAlreadyDetectedManeuverCurves() {
        ManeuverDetectionResult lastManeuverDetectionResult = this.lastManeuverDetectionResult;
        if (lastManeuverDetectionResult != null) {
            return lastManeuverDetectionResult.getManeuverSpots().stream().filter(maneuverSpot -> maneuverSpot.getManeuverCurve() != null).map(maneuverSpot -> maneuverSpot.getManeuverCurve()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void clearState() {
        this.lastManeuverDetectionResult = null;
        if (this.approximatedFixesCalculator instanceof IncrementalApproximatedFixesCalculator) {
            ((IncrementalApproximatedFixesCalculator)this.approximatedFixesCalculator).clearState();
        }
    }

    @Override
    public List<Maneuver> detectManeuvers() {
        List<ManeuverSpotWithTypedManeuvers> maneuverSpots = this.detectManeuverSpots();
        List<Maneuver> maneuvers = this.getAllManeuversFromManeuverSpots(maneuverSpots);
        return maneuvers;
    }

    private List<Maneuver> getAllManeuversFromManeuverSpots(List<ManeuverSpotWithTypedManeuvers> maneuverSpots) {
        ArrayList<Maneuver> maneuvers = new ArrayList<Maneuver>(maneuverSpots.size());
        for (ManeuverSpotWithTypedManeuvers maneuverSpot : maneuverSpots) {
            for (Maneuver maneuver : maneuverSpot.getManeuvers()) {
                maneuvers.add(maneuver);
            }
        }
        return maneuvers;
    }

    protected List<ManeuverSpotWithTypedManeuvers> detectManeuverSpots() {
        TrackTimeInfo trackTimeInfo = this.getTrackTimeInfo();
        if (trackTimeInfo != null) {
            ArrayList<ManeuverSpotWithTypedManeuvers> maneuverSpotsWithTypedManeuvers;
            TimePoint earliestManeuverStart = trackTimeInfo.getTrackStartTimePoint();
            TimePoint latestManeuverEnd = trackTimeInfo.getTrackEndTimePoint();
            TimePoint latestRawFixTimePoint = trackTimeInfo.getLatestRawFixTimePoint();
            ManeuverDetectionResult lastManeuverDetectionResult = this.lastManeuverDetectionResult;
            if (lastManeuverDetectionResult != null && latestRawFixTimePoint.equals(lastManeuverDetectionResult.getLatestRawFixTimePoint())) {
                maneuverSpotsWithTypedManeuvers = new ArrayList<ManeuverSpotWithTypedManeuvers>();
                for (ManeuverSpotWithTypedManeuvers existingManeuverSpot : lastManeuverDetectionResult.getManeuverSpots()) {
                    ManeuverSpotWithTypedManeuvers newManeuverSpot = this.getManeuverSpotWithTypedManeuversFromExistingManeuverSpotConsideringPossibleWindChange(existingManeuverSpot);
                    maneuverSpotsWithTypedManeuvers.add(newManeuverSpot);
                }
            } else {
                Iterable<GPSFixMoving> douglasPeuckerFixes = this.approximatedFixesCalculator.approximate(earliestManeuverStart, latestManeuverEnd);
                if (lastManeuverDetectionResult == null) {
                    List<ManeuverSpot> maneuverSpots = this.detectManeuverSpots(douglasPeuckerFixes, earliestManeuverStart, latestManeuverEnd);
                    this.notifyWindEstimationAboutNewManeuversDetected(latestRawFixTimePoint, null, maneuverSpots, trackTimeInfo);
                    maneuverSpotsWithTypedManeuvers = new ArrayList();
                    for (ManeuverSpot maneuverSpot : maneuverSpots) {
                        ManeuverSpotWithTypedManeuvers maneuverSpotWithTypedManeuvers = this.createManeuverSpotWithTypedManeuversFromManeuverCurve(maneuverSpot.getDouglasPeuckerFixes(), maneuverSpot.getManeuverSpotDirection(), maneuverSpot.getManeuverCurve());
                        maneuverSpotsWithTypedManeuvers.add(maneuverSpotWithTypedManeuvers);
                    }
                } else {
                    IncrementalManeuverSpotDetectionResult detectionResult = this.detectManeuverSpotsIncrementally(trackTimeInfo, douglasPeuckerFixes, lastManeuverDetectionResult);
                    this.notifyWindEstimationAboutNewManeuversDetected(latestRawFixTimePoint, lastManeuverDetectionResult.getLatestRawFixTimePoint(), detectionResult.getNewManeuverSpots(), trackTimeInfo);
                    maneuverSpotsWithTypedManeuvers = this.getAllManeuverSpotsWithTypedManeuversFromDetectionResultSortedByTimePoint(detectionResult);
                }
            }
            int incrementalRunsCount = lastManeuverDetectionResult == null ? 1 : (lastManeuverDetectionResult.getIncrementalRunsCount() < Integer.MAX_VALUE ? lastManeuverDetectionResult.getIncrementalRunsCount() + 1 : Integer.MAX_VALUE);
            this.lastManeuverDetectionResult = new ManeuverDetectionResult(latestRawFixTimePoint, maneuverSpotsWithTypedManeuvers, incrementalRunsCount);
            return maneuverSpotsWithTypedManeuvers;
        }
        return Collections.emptyList();
    }

    private void notifyWindEstimationAboutNewManeuversDetected(TimePoint latestRawFixTimePoint, TimePoint latestRawFixTimePointOfPreviousManeuverDetectionIteration, List<ManeuverSpot> maneuverSpots, TrackTimeInfo trackTimeInfo) {
        if (this.windEstimationInteraction != null) {
            long maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis = this.getMaxDurationForDouglasPeuckerFixExtensionInManeuverAnalysis().asMillis();
            List<CompleteManeuverCurve> filteredManeuverSpots = maneuverSpots.stream().filter(maneuverSpot -> maneuverSpot.getManeuverCurve() != null && this.isManeuverSpotFarEnoughFromLatestRawFix(latestRawFixTimePoint, maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis, latestRawFixTimePointOfPreviousManeuverDetectionIteration, (ManeuverSpot)maneuverSpot)).map(maneuverSpot -> maneuverSpot.getManeuverCurve()).collect(Collectors.toList());
            if (!filteredManeuverSpots.isEmpty()) {
                this.windEstimationInteraction.newManeuverSpotsDetected(this.competitor, filteredManeuverSpots, trackTimeInfo);
            }
        }
    }

    public List<ManeuverSpotWithTypedManeuvers> getAllManeuverSpotsWithTypedManeuversFromDetectionResultSortedByTimePoint(IncrementalManeuverSpotDetectionResult detectionResult) {
        ManeuverSpotWithTypedManeuvers currentExistingManeuverSpot;
        ArrayList<ManeuverSpotWithTypedManeuvers> result = new ArrayList<ManeuverSpotWithTypedManeuvers>();
        Iterator<ManeuverSpotWithTypedManeuvers> exitingManeuverSpotsIterator = detectionResult.getManeuverSpotsToReuse().iterator();
        Iterator<ManeuverSpot> newManeuverSpotsIterator = detectionResult.getNewManeuverSpots().iterator();
        ManeuverSpot currentNewManeuverSpot = newManeuverSpotsIterator.hasNext() ? newManeuverSpotsIterator.next() : null;
        ManeuverSpotWithTypedManeuvers maneuverSpotWithTypedManeuvers = currentExistingManeuverSpot = exitingManeuverSpotsIterator.hasNext() ? exitingManeuverSpotsIterator.next() : null;
        while (true) {
            ManeuverSpotWithTypedManeuvers maneuverSpotWithTypedManeuvers2;
            if (!(currentExistingManeuverSpot == null || currentNewManeuverSpot != null && currentExistingManeuverSpot.getTimePoint().after(currentNewManeuverSpot.getTimePoint()))) {
                maneuverSpotWithTypedManeuvers2 = this.getManeuverSpotWithTypedManeuversFromExistingManeuverSpotConsideringPossibleWindChange(currentExistingManeuverSpot);
                result.add(maneuverSpotWithTypedManeuvers2);
                currentExistingManeuverSpot = exitingManeuverSpotsIterator.hasNext() ? exitingManeuverSpotsIterator.next() : null;
                continue;
            }
            if (currentNewManeuverSpot == null) break;
            maneuverSpotWithTypedManeuvers2 = this.createManeuverSpotWithTypedManeuversFromManeuverCurve(currentNewManeuverSpot.getDouglasPeuckerFixes(), currentNewManeuverSpot.getManeuverSpotDirection(), currentNewManeuverSpot.getManeuverCurve());
            result.add(maneuverSpotWithTypedManeuvers2);
            currentNewManeuverSpot = newManeuverSpotsIterator.hasNext() ? newManeuverSpotsIterator.next() : null;
        }
        return result;
    }

    private ManeuverSpotWithTypedManeuvers getManeuverSpotWithTypedManeuversFromExistingManeuverSpotConsideringPossibleWindChange(ManeuverSpotWithTypedManeuvers currentExistingManeuverSpot) {
        ManeuverSpotWithTypedManeuvers maneuverSpotWithTypedManeuvers;
        if (currentExistingManeuverSpot.getManeuverCurve() == null || this.isManeuverSpotWindNearlySame(currentExistingManeuverSpot)) {
            maneuverSpotWithTypedManeuvers = currentExistingManeuverSpot;
        } else {
            CompleteManeuverCurve maneuverCurve = currentExistingManeuverSpot.getManeuverCurve();
            WindMeasurement windMeasurement = currentExistingManeuverSpot.getWindMeasurement();
            Wind wind = this.trackedRace.getWind(windMeasurement.getPosition(), windMeasurement.getTimePoint(), this.trackedRace.getWindSources(WindSourceType.MANEUVER_BASED_ESTIMATION));
            List<Maneuver> maneuvers = this.determineManeuversFromManeuverCurve(maneuverCurve.getMainCurveBoundaries(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries(), wind, maneuverCurve.getMarkPassing());
            maneuverSpotWithTypedManeuvers = new ManeuverSpotWithTypedManeuvers(currentExistingManeuverSpot.getDouglasPeuckerFixes(), currentExistingManeuverSpot.getManeuverSpotDirection(), maneuverCurve, maneuvers, new WindMeasurement(windMeasurement.getTimePoint(), windMeasurement.getPosition(), wind == null ? null : wind.getBearing()));
        }
        return maneuverSpotWithTypedManeuvers;
    }

    public IncrementalManeuverSpotDetectionResult detectManeuverSpotsIncrementally(TrackTimeInfo trackTimeInfo, Iterable<GPSFixMoving> approximatingFixesToAnalyze, ManeuverDetectionResult lastManeuverDetectionResult) {
        ArrayList<ManeuverSpotWithTypedManeuvers> existingManeuverSpots = new ArrayList<ManeuverSpotWithTypedManeuvers>();
        ArrayList<ManeuverSpot> newManeuverSpots = new ArrayList<ManeuverSpot>();
        TimePoint earliestManeuverStart = trackTimeInfo.getTrackStartTimePoint();
        TimePoint latestManeuverEnd = trackTimeInfo.getTrackEndTimePoint();
        TimePoint latestRawFixTimePoint = trackTimeInfo.getLatestRawFixTimePoint();
        long maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis = this.getMaxDurationForDouglasPeuckerFixExtensionInManeuverAnalysis().asMillis();
        TimePoint latestRawFixTimePointOfPreviousManeuverDetectionIteration = lastManeuverDetectionResult.getLatestRawFixTimePoint();
        if (Util.size(approximatingFixesToAnalyze) > 2) {
            ArrayList<GPSFixMoving> fixesGroupForManeuverSpotAnalysis = new ArrayList<GPSFixMoving>();
            Iterator<GPSFixMoving> approximationPointsIter = approximatingFixesToAnalyze.iterator();
            GPSFixMoving previous = approximationPointsIter.next();
            GPSFixMoving current = approximationPointsIter.next();
            NauticalSide lastCourseChangeDirection = null;
            ManeuverSpotWithTypedManeuvers matchingManeuverSpotFromState = null;
            Iterator<GPSFixMoving> matchingFixesGroupFromStateIterator = null;
            ListIterator<ManeuverSpotWithTypedManeuvers> lastManeuverSpotIteratorUsed = this.getExistingManeuverSpotByFirstDouglasPeuckerFix(lastManeuverDetectionResult, null, current);
            ManeuverSpotWithTypedManeuvers nextExistingSpot = lastManeuverSpotIteratorUsed != null ? lastManeuverSpotIteratorUsed.next() : null;
            do {
                GPSFixMoving next = approximationPointsIter.next();
                if (matchingManeuverSpotFromState != null) {
                    if (matchingFixesGroupFromStateIterator.hasNext()) {
                        GPSFixMoving existingDouglasPeuckerFix = (GPSFixMoving)matchingFixesGroupFromStateIterator.next();
                        if (!this.isDouglasPeuckerFixesNearlySame(existingDouglasPeuckerFix, current)) {
                            matchingManeuverSpotFromState = null;
                        }
                    } else {
                        ListIterator<ManeuverSpotWithTypedManeuvers> maneuverSpotIterator = this.getExistingManeuverSpotByFirstDouglasPeuckerFix(lastManeuverDetectionResult, lastManeuverSpotIteratorUsed, current);
                        if (maneuverSpotIterator != null) {
                            nextExistingSpot = maneuverSpotIterator.next();
                            lastManeuverSpotIteratorUsed = maneuverSpotIterator;
                            existingManeuverSpots.add(matchingManeuverSpotFromState);
                            fixesGroupForManeuverSpotAnalysis.clear();
                        }
                        matchingManeuverSpotFromState = null;
                    }
                }
                if (matchingManeuverSpotFromState == null && nextExistingSpot == null) {
                    NauticalSide courseChangeDirectionOnOriginalFixes = this.getCourseChangeDirectionAroundFix(previous.getTimePoint(), current, next.getTimePoint());
                    if (!fixesGroupForManeuverSpotAnalysis.isEmpty() && !this.checkDouglasPeuckerFixesGroupable(lastCourseChangeDirection, courseChangeDirectionOnOriginalFixes, previous, current)) {
                        ManeuverSpot maneuverSpot = this.createManeuverSpotWithManeuversFromFixesGroup(fixesGroupForManeuverSpotAnalysis, lastCourseChangeDirection, earliestManeuverStart, latestManeuverEnd);
                        newManeuverSpots.add(maneuverSpot);
                        fixesGroupForManeuverSpotAnalysis.clear();
                    }
                    lastCourseChangeDirection = courseChangeDirectionOnOriginalFixes;
                }
                fixesGroupForManeuverSpotAnalysis.add(current);
                if (fixesGroupForManeuverSpotAnalysis.size() == 1) {
                    ManeuverSpotWithTypedManeuvers maneuverSpot;
                    if (nextExistingSpot != null) {
                        maneuverSpot = nextExistingSpot;
                        nextExistingSpot = null;
                    } else {
                        ListIterator<ManeuverSpotWithTypedManeuvers> maneuverSpotIterator = this.getExistingManeuverSpotByFirstDouglasPeuckerFix(lastManeuverDetectionResult, lastManeuverSpotIteratorUsed, current);
                        if (maneuverSpotIterator != null) {
                            maneuverSpot = maneuverSpotIterator.next();
                            lastManeuverSpotIteratorUsed = maneuverSpotIterator;
                        } else {
                            maneuverSpot = null;
                        }
                    }
                    if (maneuverSpot != null) {
                        boolean maneuverSpotIsFarEnoughFromLatestRawFix = this.isManeuverSpotFarEnoughFromLatestRawFix(latestRawFixTimePoint, maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis, latestRawFixTimePointOfPreviousManeuverDetectionIteration, maneuverSpot);
                        if (maneuverSpotIsFarEnoughFromLatestRawFix) {
                            matchingManeuverSpotFromState = maneuverSpot;
                            matchingFixesGroupFromStateIterator = maneuverSpot.getDouglasPeuckerFixes().iterator();
                            matchingFixesGroupFromStateIterator.next();
                        }
                        lastCourseChangeDirection = maneuverSpot.getManeuverSpotDirection();
                    }
                }
                previous = current;
                current = next;
            } while (approximationPointsIter.hasNext());
            if (!fixesGroupForManeuverSpotAnalysis.isEmpty()) {
                ManeuverSpot maneuverSpot = this.createManeuverSpotWithManeuversFromFixesGroup(fixesGroupForManeuverSpotAnalysis, lastCourseChangeDirection, earliestManeuverStart, latestManeuverEnd);
                newManeuverSpots.add(maneuverSpot);
            }
        }
        return new IncrementalManeuverSpotDetectionResult(existingManeuverSpots, newManeuverSpots);
    }

    private boolean isManeuverSpotFarEnoughFromLatestRawFix(TimePoint latestRawFixTimePoint, long maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis, TimePoint latestRawFixTimePointOfPreviousManeuverDetectionIteration, ManeuverSpot previouslyDetectedManeuverSpotWithSameDouglasPeuckerPoints) {
        if (latestRawFixTimePointOfPreviousManeuverDetectionIteration == null || latestRawFixTimePoint.after(latestRawFixTimePointOfPreviousManeuverDetectionIteration)) {
            GPSFixMoving latestDouglasPeuckerFix = null;
            Iterator<GPSFixMoving> iterator = previouslyDetectedManeuverSpotWithSameDouglasPeuckerPoints.getDouglasPeuckerFixes().iterator();
            while (iterator.hasNext()) {
                GPSFixMoving fix;
                latestDouglasPeuckerFix = fix = iterator.next();
            }
            if (latestDouglasPeuckerFix.getTimePoint().until(latestRawFixTimePointOfPreviousManeuverDetectionIteration == null ? latestRawFixTimePoint : latestRawFixTimePoint).asMillis() < maxDurationForDouglasPeuckerFixExtensionInManeuverAnalysisInMillis) {
                return false;
            }
        }
        return true;
    }

    private Duration getMaxDurationForDouglasPeuckerFixExtensionInManeuverAnalysis() {
        Duration approximateManeuverDuration = this.getApproximateManeuverDuration();
        return this.getDurationForDouglasPeuckerExtensionForMainCurveAnalysis(approximateManeuverDuration).plus(this.getMaxDurationForAfterManeuverSectionExtension(approximateManeuverDuration));
    }

    private boolean isManeuverSpotWindNearlySame(ManeuverSpotWithTypedManeuvers maneuverSpot) {
        if (maneuverSpot.getWindMeasurement() != null) {
            WindMeasurement windMeasurement = maneuverSpot.getWindMeasurement();
            Bearing lastWindCourse = windMeasurement.getWindCourse();
            Wind currentWind = this.trackedRace.getWind(windMeasurement.getPosition(), windMeasurement.getTimePoint());
            if (lastWindCourse == null && currentWind == null) {
                return true;
            }
            if (lastWindCourse == null || currentWind == null) {
                return false;
            }
            double bearingInDegrees = lastWindCourse.getDifferenceTo(currentWind.getBearing()).abs().getDegrees();
            if (bearingInDegrees > 5.0) {
                return false;
            }
        }
        return true;
    }

    private boolean isDouglasPeuckerFixesNearlySame(GPSFixMoving existingDouglasPeuckerFix, GPSFixMoving newDouglasPeuckerFix) {
        double secondsDifference = existingDouglasPeuckerFix.getTimePoint().until(newDouglasPeuckerFix.getTimePoint()).asSeconds();
        return !(Math.abs(secondsDifference) > 1.0);
    }

    public void setLastManeuverDetectionResult(ManeuverDetectionResult lastManeuverDetectionResult) {
        this.lastManeuverDetectionResult = lastManeuverDetectionResult;
    }

    @Override
    public int getIncrementalRunsCount() {
        ManeuverDetectionResult lastManeuverDetectionResult = this.lastManeuverDetectionResult;
        return lastManeuverDetectionResult != null ? lastManeuverDetectionResult.getIncrementalRunsCount() : 0;
    }

    private ListIterator<ManeuverSpotWithTypedManeuvers> getExistingManeuverSpotByFirstDouglasPeuckerFix(ManeuverDetectionResult lastManeuverDetectionResult, ListIterator<ManeuverSpotWithTypedManeuvers> lastIteratorUsed, GPSFixMoving newDouglasPeuckerFix) {
        ManeuverSpotWithTypedManeuvers firstManeuverSpotIterated = null;
        if (lastIteratorUsed != null) {
            while (lastIteratorUsed.hasNext()) {
                GPSFixMoving firstFix;
                ManeuverSpotWithTypedManeuvers maneuverSpot = lastIteratorUsed.next();
                if (firstManeuverSpotIterated == null) {
                    firstManeuverSpotIterated = maneuverSpot;
                }
                if (!this.isDouglasPeuckerFixesNearlySame(newDouglasPeuckerFix, firstFix = maneuverSpot.getDouglasPeuckerFixes().iterator().next())) continue;
                lastIteratorUsed.previous();
                return lastIteratorUsed;
            }
        }
        ListIterator<ManeuverSpotWithTypedManeuvers> newIterator = lastManeuverDetectionResult.getManeuverSpots().listIterator();
        while (newIterator.hasNext()) {
            ManeuverSpotWithTypedManeuvers maneuverSpot = newIterator.next();
            if (maneuverSpot == firstManeuverSpotIterated) break;
            GPSFixMoving firstFix = maneuverSpot.getDouglasPeuckerFixes().iterator().next();
            if (!this.isDouglasPeuckerFixesNearlySame(newDouglasPeuckerFix, firstFix)) continue;
            newIterator.previous();
            return newIterator;
        }
        return null;
    }

    public static class IncrementalManeuverSpotDetectionResult {
        private final List<ManeuverSpotWithTypedManeuvers> maneuverSpotsToReuse;
        private final List<ManeuverSpot> newManeuverSpots;

        public IncrementalManeuverSpotDetectionResult(List<ManeuverSpotWithTypedManeuvers> maneuverSpotsToReuse, List<ManeuverSpot> newManeuverSpots) {
            this.maneuverSpotsToReuse = maneuverSpotsToReuse;
            this.newManeuverSpots = newManeuverSpots;
        }

        public List<ManeuverSpotWithTypedManeuvers> getManeuverSpotsToReuse() {
            return this.maneuverSpotsToReuse;
        }

        public List<ManeuverSpot> getNewManeuverSpots() {
            return this.newManeuverSpots;
        }
    }

    public static class ManeuverDetectionResult {
        private final TimePoint latestFixTimePoint;
        private final List<ManeuverSpotWithTypedManeuvers> maneuverSpots;
        private final int incrementalRunsCount;

        public ManeuverDetectionResult(TimePoint latestFixTimePoint, List<ManeuverSpotWithTypedManeuvers> maneuverSpots, int incrementalRunsCount) {
            this.latestFixTimePoint = latestFixTimePoint;
            this.maneuverSpots = maneuverSpots;
            this.incrementalRunsCount = incrementalRunsCount;
        }

        public TimePoint getLatestRawFixTimePoint() {
            return this.latestFixTimePoint;
        }

        public List<ManeuverSpotWithTypedManeuvers> getManeuverSpots() {
            return this.maneuverSpots;
        }

        public int getIncrementalRunsCount() {
            return this.incrementalRunsCount;
        }
    }
}

