/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.function.BiFunction;

public class LowPointFirstToWinTwoRaces
extends LowPoint {
    private static final long serialVersionUID = 7072175334160798617L;

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_FIRST_TO_WIN_TWO_RACES;
    }

    @Override
    public boolean isMedalWinAmountCriteria() {
        return true;
    }

    @Override
    public boolean isCarryForwardInMedalsCriteria() {
        return true;
    }

    @Override
    public int compareByLastMedalRacesCriteria(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, boolean nullScoresAreBetter, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache, TimePoint timePoint, int zeroBasedIndexOfLastMedalSeriesInWhichBothScored, int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        Util.Pair<RaceColumn, Double> o1LastNonNullMedalRaceScore = this.getLastNonNullMedalRaceScore(o1Scores);
        Util.Pair<RaceColumn, Double> o2LastNonNullMedalRaceScore = this.getLastNonNullMedalRaceScore(o2Scores);
        int result = o1LastNonNullMedalRaceScore == null ? (o2LastNonNullMedalRaceScore == null ? 0 : (nullScoresAreBetter ? -1 : 1)) : (o2LastNonNullMedalRaceScore == null ? (nullScoresAreBetter ? 1 : -1) : this.compareBySingleRaceColumnScore((Double)o1LastNonNullMedalRaceScore.getB(), (Double)o2LastNonNullMedalRaceScore.getB(), nullScoresAreBetter));
        return result;
    }

    private Util.Pair<RaceColumn, Double> getLastNonNullMedalRaceScore(List<Util.Pair<RaceColumn, Double>> o2Scores) {
        return (Util.Pair)Util.first((Iterable)Util.filter(() -> o2Scores.listIterator(o2Scores.size()), raceColumnAndScore -> ((RaceColumn)raceColumnAndScore.getA()).isMedalRace() && raceColumnAndScore.getB() != null));
    }

    private int getTargetAmountOfMedalRaceWins() {
        return 2;
    }

    @Override
    public double getScoreFactor(RaceColumn raceColumn) {
        Double factor = raceColumn.getExplicitFactor();
        if (factor == null) {
            factor = 1.0;
        }
        return factor;
    }

    @Override
    public int compareByMedalRacesWon(int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        int targetAmount = this.getTargetAmountOfMedalRaceWins();
        int result = numberOfMedalRacesWonO1 >= targetAmount || numberOfMedalRacesWonO2 >= targetAmount ? Integer.compare(numberOfMedalRacesWonO2, numberOfMedalRacesWonO1) : 0;
        return result;
    }
}

