/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import com.sap.sailing.domain.swisstimingreplayadapter.CompetitorStatus;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayListener;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayParser;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.BoatType;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.MarkType;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.RaceStatus;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.Weather;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class SwissTimingReplayParserImpl
implements SwissTimingReplayParser {
    private static final int STX = 2;
    private static final int ETX = 3;
    private static final int EOT = 4;
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");

    @Override
    public void readData(InputStream urlInputStream, SwissTimingReplayListener replayListener) throws IOException, UnknownMessageIdentificationCode, UnexpectedStartByte, PayloadMismatch, PrematureEndOfData {
        replayListener.progress(0.0);
        long numberOfBytesRead = 0L;
        long initiallyAvailable = urlInputStream.available();
        DataInputStream data = new DataInputStream(urlInputStream);
        byte[] startByteBuffer = new byte[1];
        int readSuccess = data.read(startByteBuffer);
        while (readSuccess != -1) {
            numberOfBytesRead += (long)readSuccess;
            replayListener.progress((double)(initiallyAvailable - (long)urlInputStream.available()) / (double)initiallyAvailable);
            byte startByte = startByteBuffer[0];
            if (startByte != 2) {
                throw new UnexpectedStartByte(startByte, numberOfBytesRead - 1L);
            }
            byte messageIdentificationCode = data.readByte();
            ++numberOfBytesRead;
            short messageLength = data.readShort();
            numberOfBytesRead += 2L;
            if (messageLength > 0) {
                short payloadSize;
                short remainingPayloadSize = payloadSize = (short)(messageLength - 5);
                switch (messageIdentificationCode) {
                    case 0: {
                        while (remainingPayloadSize > 0) {
                            long referenceTimestamp = data.readLong();
                            replayListener.referenceTimestamp(referenceTimestamp);
                            remainingPayloadSize = (short)(remainingPayloadSize - 8);
                        }
                        break;
                    }
                    case 1: {
                        while (remainingPayloadSize > 0) {
                            int latitude = data.readInt();
                            int longitude = data.readInt();
                            replayListener.referenceLocation(latitude, longitude);
                            remainingPayloadSize = (short)(remainingPayloadSize - 8);
                        }
                        break;
                    }
                    case 9: {
                        int keyFrameIndex = data.readInt();
                        replayListener.keyFrameIndex(keyFrameIndex);
                        remainingPayloadSize = (short)(remainingPayloadSize - 4);
                        while (remainingPayloadSize > 0) {
                            int keyFrameIndexPosition = data.readInt();
                            replayListener.keyFrameIndexPosition(keyFrameIndexPosition);
                            remainingPayloadSize = (short)(remainingPayloadSize - 4);
                        }
                        break;
                    }
                    case 10: {
                        while (remainingPayloadSize > 0) {
                            int length = 9;
                            String text = SwissTimingReplayParserImpl.readString(data, length);
                            replayListener.raceID(text);
                            remainingPayloadSize = (short)(remainingPayloadSize - length);
                        }
                        break;
                    }
                    case 113: {
                        while (remainingPayloadSize > 0) {
                            byte markType = data.readByte();
                            String identifier = SwissTimingReplayParserImpl.readString(data, 8);
                            byte index = data.readByte();
                            String id1 = SwissTimingReplayParserImpl.readString(data, 8);
                            String id2 = SwissTimingReplayParserImpl.readString(data, 8);
                            short windSpeed = data.readShort();
                            short windDirection = data.readShort();
                            replayListener.mark(new MarkType(markType), identifier, index, id1, id2, windSpeed, windDirection);
                            remainingPayloadSize = (short)(remainingPayloadSize - 30);
                        }
                        break;
                    }
                    case 121: {
                        short competitorsCount = data.readShort();
                        replayListener.competitorsCount(competitorsCount);
                        remainingPayloadSize = (short)(remainingPayloadSize - 2);
                        while (remainingPayloadSize > 0) {
                            int hashValue = data.readInt();
                            String nation = SwissTimingReplayParserImpl.readString(data, 3);
                            byte sailNumberLength = data.readByte();
                            String sailNumber = SwissTimingReplayParserImpl.readString(data, sailNumberLength);
                            byte nameLength = data.readByte();
                            String name = SwissTimingReplayParserImpl.readString(data, nameLength);
                            byte competitorStatus = data.readByte();
                            byte boatType = data.readByte();
                            short cRank_Bracket = data.readShort();
                            short cnPoints_x10_Bracket = data.readShort();
                            short ctPoints_x10_Winner = data.readShort();
                            replayListener.competitor(hashValue, nation, sailNumber, name, CompetitorStatus.byCode(competitorStatus), BoatType.byCode(boatType), cRank_Bracket, cnPoints_x10_Bracket, ctPoints_x10_Winner);
                            remainingPayloadSize = (short)(remainingPayloadSize - (8 + sailNumberLength + 1 + nameLength + 1 + 1 + 2 + 2 + 2));
                        }
                        break;
                    }
                    case 122: {
                        while (remainingPayloadSize > 0) {
                            byte cid = data.readByte();
                            int raceTime = SwissTimingReplayParserImpl.read3ByteInt(data);
                            int startTime = SwissTimingReplayParserImpl.read3ByteInt(data);
                            int estimatedStartTime = SwissTimingReplayParserImpl.read3ByteInt(data);
                            byte raceStatus = data.readByte();
                            short distanceToNextMark = data.readShort();
                            byte weather = data.readByte();
                            short humidity = data.readShort();
                            short temperature = data.readShort();
                            byte messageTextLength = data.readByte();
                            String messageText = SwissTimingReplayParserImpl.readString(data, messageTextLength);
                            byte cFlag = data.readByte();
                            byte rFlag = data.readByte();
                            byte duration = data.readByte();
                            short nm = data.readShort();
                            replayListener.frameMetaData(cid, raceTime, startTime, estimatedStartTime, RaceStatus.byCode(raceStatus), distanceToNextMark, Weather.byCode(weather), humidity, temperature, messageText, cFlag, rFlag, duration, nm);
                            remainingPayloadSize = (short)(remainingPayloadSize - (19 + messageTextLength + 1 + 1 + 1 + 2));
                        }
                        break;
                    }
                    case 123: {
                        short entriesCount = data.readShort();
                        replayListener.rankingsCount(entriesCount);
                        remainingPayloadSize = (short)(remainingPayloadSize - 2);
                        while (remainingPayloadSize > 0) {
                            int hashValue = data.readInt();
                            short rank = data.readShort();
                            short rankIndex = data.readShort();
                            short racePoints = data.readShort();
                            byte competitorStatus = data.readByte();
                            short finishRank = data.readShort();
                            short finishRankIndex = data.readShort();
                            int gap = SwissTimingReplayParserImpl.read3ByteInt(data);
                            int raceTime = SwissTimingReplayParserImpl.read3ByteInt(data);
                            int marksCount = data.readShort();
                            replayListener.ranking(hashValue, rank, rankIndex, racePoints, CompetitorStatus.byCode(competitorStatus), finishRank, finishRankIndex, gap, raceTime);
                            remainingPayloadSize = (short)(remainingPayloadSize - 23);
                            int i = 0;
                            while (i < marksCount) {
                                short marksRank = data.readShort();
                                short marksRankIndex = data.readShort();
                                int marksGap = SwissTimingReplayParserImpl.read3ByteInt(data);
                                int marksRaceTime = SwissTimingReplayParserImpl.read3ByteInt(data);
                                replayListener.rankingMark(marksRank, marksRankIndex, marksGap, marksRaceTime);
                                remainingPayloadSize = (short)(remainingPayloadSize - 10);
                                ++i;
                            }
                        }
                        break;
                    }
                    case 124: {
                        short trackersCount = data.readShort();
                        replayListener.trackersCount(trackersCount);
                        remainingPayloadSize = (short)(remainingPayloadSize - 2);
                        while (remainingPayloadSize > 0) {
                            int hashValue = data.readInt();
                            int latitude = data.readInt();
                            int longitude = data.readInt();
                            short cog = data.readShort();
                            short sog = data.readShort();
                            short average_sog = data.readShort();
                            short vmg = data.readShort();
                            byte competitorStatus = data.readByte();
                            short rank = data.readShort();
                            short dtl = data.readShort();
                            short dtnm = data.readShort();
                            short nm = data.readShort();
                            short pRank = data.readShort();
                            short ptPoints = data.readShort();
                            short pnPoints = data.readShort();
                            replayListener.trackers(hashValue, latitude, longitude, cog, sog, average_sog, vmg, CompetitorStatus.byCode(competitorStatus), rank, dtl, dtnm, nm, pRank, ptPoints, pnPoints);
                            remainingPayloadSize = (short)(remainingPayloadSize - 35);
                        }
                        break;
                    }
                    default: {
                        throw new UnknownMessageIdentificationCode(messageIdentificationCode, numberOfBytesRead - 3L);
                    }
                }
                if (remainingPayloadSize != 0) {
                    throw new PayloadMismatch(remainingPayloadSize, numberOfBytesRead);
                }
                numberOfBytesRead += (long)payloadSize;
                replayListener.progress((double)(initiallyAvailable - (long)urlInputStream.available()) / (double)initiallyAvailable);
            }
            byte endByte = data.readByte();
            ++numberOfBytesRead;
            if (endByte == 4) {
                replayListener.eot();
            } else if (endByte != 3) {
                throw new PrematureEndOfData(endByte, numberOfBytesRead - 1L);
            }
            readSuccess = data.read(startByteBuffer);
        }
        replayListener.progress(1.0);
    }

    private static int read3ByteInt(DataInputStream data) throws IOException {
        byte highByte = data.readByte();
        byte midByte = data.readByte();
        byte lowByte = data.readByte();
        int highInt = (highByte & 0xFF) << 16;
        int midInt = (midByte & 0xFF) << 8;
        int lowInt = lowByte & 0xFF;
        return highInt | midInt | lowInt;
    }

    private static String readString(DataInputStream data, int length) throws IOException {
        byte[] bytes = new byte[length];
        data.read(bytes);
        String text = new String(bytes, CHARSET);
        return text;
    }

    public static class PayloadMismatch
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PayloadMismatch(short remainingPayloadSize, long position) {
            super("Payload mismatch. Remaining payload: " + remainingPayloadSize + " at position " + position);
        }
    }

    public static class PrematureEndOfData
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PrematureEndOfData(byte endByte, long position) {
            super("Premature end of data: " + endByte + " at position " + position);
        }
    }

    public static class UnexpectedStartByte
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnexpectedStartByte(byte unexpectedStartByte, long position) {
            super("Unexpected start byte: " + unexpectedStartByte + " at position " + position);
        }
    }

    public static class UnknownMessageIdentificationCode
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnknownMessageIdentificationCode(byte messageIdentificationCode, long position) {
            super("Unknown message identification code: " + messageIdentificationCode + " at position " + position);
        }
    }
}

