/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.interfaces;

import com.sap.sse.common.Stoppable;
import com.sap.sse.security.interfaces.PreferenceConverter;
import com.sap.sse.security.interfaces.UserStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PreferenceConverterRegistrationManager
implements Stoppable {
    private static final Logger logger = Logger.getLogger(PreferenceConverterRegistrationManager.class.getName());
    private final BundleContext context;
    private final UserStore userStore;
    private final ServiceTracker<PreferenceConverter<?>, PreferenceConverter<?>> tracker;

    public PreferenceConverterRegistrationManager(BundleContext bundleContext, UserStore userStore) {
        this.context = bundleContext;
        this.userStore = userStore;
        this.tracker = this.createTracker(bundleContext);
        this.tracker.open();
    }

    private ServiceTracker<PreferenceConverter<?>, PreferenceConverter<?>> createTracker(BundleContext bundleContext) {
        return new ServiceTracker(bundleContext, PreferenceConverter.class, (ServiceTrackerCustomizer)new Cutomizer());
    }

    public void stop() {
        this.tracker.close();
    }

    private class Cutomizer
    implements ServiceTrackerCustomizer<PreferenceConverter<?>, PreferenceConverter<?>> {
        private Cutomizer() {
        }

        public PreferenceConverter<?> addingService(ServiceReference<PreferenceConverter<?>> reference) {
            String preferenceKey = (String)reference.getProperty("key");
            PreferenceConverter converter = (PreferenceConverter)PreferenceConverterRegistrationManager.this.context.getService(reference);
            if (preferenceKey == null) {
                logger.log(Level.SEVERE, "Found PreferenceConverter \"" + converter + "\" in OSGi registry without property " + "key" + " defining the preference key");
            } else {
                logger.log(Level.FINE, "Registering PreferenceConverter \"" + converter + "\" found as OSGi service with key \"" + preferenceKey + "\"");
                PreferenceConverterRegistrationManager.this.userStore.registerPreferenceConverter(preferenceKey, converter);
            }
            return converter;
        }

        public void modifiedService(ServiceReference<PreferenceConverter<?>> reference, PreferenceConverter<?> service) {
        }

        public void removedService(ServiceReference<PreferenceConverter<?>> reference, PreferenceConverter<?> service) {
            String preferenceKey = (String)reference.getProperty("key");
            if (preferenceKey != null) {
                logger.log(Level.FINE, "Removing PreferenceConverter \"" + service + "\" with key \"" + preferenceKey + "\"");
                PreferenceConverterRegistrationManager.this.userStore.removePreferenceConverter(preferenceKey);
            }
        }
    }
}

