/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.AverageWithStats;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProvider;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.DataProvidersPrecedenceList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AverageWithStatsDataProvider
extends AbstractNumericDataProvider<AverageWithStats<? extends Serializable>> {
    static final Class<?> _c = AverageWithStats.class;
    static final Class<AverageWithStats<? extends Serializable>> _cc = _c;
    private final DataProvidersPrecedenceList innerProviders;

    public AverageWithStatsDataProvider(DataProvidersPrecedenceList innerProviders) {
        super(_cc);
        this.innerProviders = innerProviders;
    }

    @Override
    public Map<GroupKey, Util.Triple<Number, Number, Long>> getErrorData(QueryResultDTO<?> result, String dataKey) {
        if (!this.acceptsResultsOfType(result.getResultType())) {
            throw new IllegalArgumentException("This data provider doesn't work for results of the type '" + result.getResultType() + "'");
        }
        return this.getErrorDataInternal(result, dataKey);
    }

    private <T> Map<GroupKey, Util.Triple<Number, Number, Long>> getErrorDataInternal(QueryResultDTO<?> result, String dataKey) {
        Function<?, Number> mapping = this.getInnerMapping(result, dataKey);
        if (mapping == null) {
            throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
        }
        HashMap<GroupKey, Util.Triple<Number, Number, Long>> data = new HashMap<GroupKey, Util.Triple<Number, Number, Long>>();
        for (Map.Entry e : result.getResults().entrySet()) {
            AverageWithStats aws = (AverageWithStats)e.getValue();
            if (aws.getMin() == null || aws.getMax() == null) continue;
            data.put((GroupKey)e.getKey(), (Util.Triple<Number, Number, Long>)new Util.Triple((Object)mapping.apply(aws.getMin()), (Object)mapping.apply(aws.getMax()), (Object)aws.getCount()));
        }
        return data.isEmpty() ? null : data;
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return provider == null ? "" : provider.getDefaultDataKeyFor(result);
    }

    private AbstractNumericDataProvider<? extends Serializable> getProviderFromGenericResult(QueryResultDTO<?> result) {
        QueryResultDTO<?> typedResult = result;
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProvider(typedResult);
        return provider;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return provider == null ? "" : provider.getLocalizedNameForDataKey(result, stringMessages, dataKey);
    }

    private AbstractNumericDataProvider<? extends Serializable> getProvider(QueryResultDTO<AverageWithStats<?>> result) {
        AbstractNumericDataProvider<? extends Serializable> provider = null;
        Map results = result.getResults();
        for (Map.Entry e : results.entrySet()) {
            if (e.getValue() == null) continue;
            provider = this.innerProviders.selectCurrentDataProvider(((AverageWithStats)e.getValue()).getResultType());
            break;
        }
        return provider;
    }

    @Override
    public Collection<String> getDataKeys(QueryResultDTO<?> result) {
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return provider == null ? Collections.emptySet() : provider.getDataKeys(result);
    }

    @Override
    public boolean isValidDataKey(QueryResultDTO<?> result, String dataKey) {
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return provider == null ? false : provider.isValidDataKey(result, dataKey);
    }

    @Override
    protected Function<AverageWithStats<? extends Serializable>, Number> getMapping(final QueryResultDTO<?> result, final String dataKey) {
        final AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return new Function<AverageWithStats<? extends Serializable>, Number>(){

            @Override
            public Number apply(AverageWithStats<? extends Serializable> t) {
                Function mapping = provider.getMapping(result, dataKey);
                return this.doApply(mapping, (Serializable)t.getAverage());
            }

            private <U extends Serializable, V extends Serializable> Number doApply(Function<U, Number> mapping, V average) {
                V castAverage = average;
                return mapping.apply(castAverage);
            }
        };
    }

    protected Function<?, Number> getInnerMapping(QueryResultDTO<?> result, String dataKey) {
        AbstractNumericDataProvider<? extends Serializable> provider = this.getProviderFromGenericResult(result);
        return provider == null ? null : provider.getMapping(result, dataKey);
    }
}

