/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.tractrac.model.lib.api.data.IStartStopData;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.race.IRaceStartStopTimesChangeListener;
import java.util.logging.Logger;

public class RaceStartedAndFinishedReceiver
extends AbstractReceiverWithQueue<IRace, IStartStopData, IStartStopData> {
    private static final Logger logger = Logger.getLogger(RaceStartedAndFinishedReceiver.class.getName());
    private final IRaceStartStopTimesChangeListener listener = new IRaceStartStopTimesChangeListener(){

        public void gotTrackingStartStopTime(IRace race, IStartStopData startStopData) {
            RaceStartedAndFinishedReceiver.this.enqueue(new Util.Triple((Object)race, (Object)startStopData, null));
        }

        public void gotRaceStartStopTime(IRace race, IStartStopData startStopData) {
            RaceStartedAndFinishedReceiver.this.enqueue(new Util.Triple((Object)race, null, (Object)startStopData));
        }
    };

    public RaceStartedAndFinishedReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, Simulator simulator, DomainFactory domainFactory, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribeRaceTimesChanges(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribeRaceTimesChanges(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IRace, IStartStopData, IStartStopData> event) {
        System.out.print("StartStop");
        DynamicTrackedRace trackedRace = this.getTrackedRace((IRace)event.getA());
        if (trackedRace != null) {
            IRace race = (IRace)event.getA();
            IStartStopData startEndRaceTimesData = (IStartStopData)event.getC();
            if (startEndRaceTimesData != null) {
                long startTime = startEndRaceTimesData.getStartTime();
                MillisecondsTimePoint startOfRace = startTime == 0L ? null : (this.getSimulator() == null ? new MillisecondsTimePoint(startTime) : this.getSimulator().advance((TimePoint)new MillisecondsTimePoint(startTime)));
                trackedRace.setStartTimeReceived((TimePoint)startOfRace);
                logger.info("Received race start time update for race " + race.getName() + ": " + startTime);
            }
            if (!race.isInitialized()) {
                trackedRace.setStartOfTrackingReceived(null);
                trackedRace.setEndOfTrackingReceived(null);
                logger.info("Received isInitialized()==false for race " + race.getName());
            } else {
                IStartStopData startEndTrackingTimesData = (IStartStopData)event.getB();
                if (startEndTrackingTimesData != null) {
                    long startTrackingTime = startEndTrackingTimesData.getStartTime();
                    MillisecondsTimePoint startOfTracking = startTrackingTime == 0L ? null : (this.getSimulator() == null ? new MillisecondsTimePoint(startTrackingTime) : this.getSimulator().advance((TimePoint)new MillisecondsTimePoint(startTrackingTime)));
                    trackedRace.setStartOfTrackingReceived((TimePoint)startOfTracking);
                    long endTrackingTime = startEndTrackingTimesData.getStopTime();
                    MillisecondsTimePoint endOfTracking = endTrackingTime == 0L ? null : (this.getSimulator() == null ? new MillisecondsTimePoint(endTrackingTime) : this.getSimulator().advance((TimePoint)new MillisecondsTimePoint(endTrackingTime)));
                    trackedRace.setEndOfTrackingReceived((TimePoint)endOfTracking);
                    logger.info("Received tracking times update for race " + race.getName() + ": " + startOfTracking + ".." + endOfTracking);
                }
            }
        } else {
            logger.warning("Couldn't find tracked race for race " + ((IRace)event.getA()).getName() + ". Dropping start/stop event " + event);
        }
    }
}

