/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.ListResult;
import com.chargebee.internal.ListRequest;
import com.chargebee.models.Invoice;
import com.chargebee.models.Subscription;
import com.chargebee.models.Transaction;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiSubscriptionData;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeSubscriptionListRequest
extends ChargebeeApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeSubscriptionListRequest.class.getName());
    private final OnResultListener listener;
    private final String offset;
    private List<ChargebeeApiSubscriptionData> subscriptions;
    private String nextOffset;
    private int resultSize;

    public ChargebeeSubscriptionListRequest(String offset, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.offset = offset;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        Subscription.SubscriptionListRequest request = ((Subscription.SubscriptionListRequest)Subscription.list().limit(100)).includeDeleted(Boolean.valueOf(false));
        if (this.offset != null && !this.offset.isEmpty()) {
            request.offset(this.offset);
        }
        return new ChargebeeInternalApiRequestWrapper((ListRequest<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        ListResult result = request.getListResult();
        if (result != null) {
            this.resultSize = result.size();
            this.nextOffset = result.nextOffset();
            this.processListResult(result);
        } else {
            this.onDone(null, null);
        }
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Fetching subscription list failed, offset: " + (this.offset == null ? "" : this.offset), e);
        this.onDone(null, null);
    }

    private void processListResult(ListResult result) {
        this.subscriptions = new ArrayList<ChargebeeApiSubscriptionData>();
        for (ListResult.Entry entry : result) {
            Subscription subscription = entry.subscription();
            Invoice invoice = entry.invoice();
            Transaction transaction = entry.transaction();
            this.subscriptions.add(new ChargebeeApiSubscriptionData(subscription, invoice, transaction));
        }
        if (this.subscriptions.size() == this.resultSize) {
            this.onDone(this.subscriptions, this.nextOffset);
        }
    }

    private void onDone(Iterable<ChargebeeApiSubscriptionData> subscriptions, String nextOffset) {
        if (this.listener != null) {
            this.listener.onSubscriptionListResult(subscriptions, nextOffset);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onSubscriptionListResult(Iterable<ChargebeeApiSubscriptionData> var1, String var2);
    }
}

