/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.ParserFactory;
import com.sap.sailing.kiworesultimport.ResultList;
import com.sap.sailing.kiworesultimport.StartReport;
import com.sap.sailing.kiworesultimport.ZipFile;
import com.sap.sailing.kiworesultimport.ZipFileParser;
import com.sap.sailing.kiworesultimport.impl.ZipFileImpl;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ZipFileParserImpl
implements ZipFileParser {
    private final ParserFactory parserFactory;

    public ZipFileParserImpl(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    @Override
    public ZipFile parse(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        ZipInputStream zis = new ZipInputStream(inputStream);
        ArrayList<StartReport> startReports = new ArrayList<StartReport>();
        ArrayList<ResultList> resultLists = new ArrayList<ResultList>();
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (this.isStartReport(entry)) {
                startReports.add(this.parserFactory.createStartReportParser().parse(this.getNonClosableInputStream(zis), entry.getName()));
            } else if (this.isResultList(entry)) {
                resultLists.add(this.parserFactory.createResultListParser().parse(this.getNonClosableInputStream(zis), entry.getName()));
            }
            entry = zis.getNextEntry();
        }
        return new ZipFileImpl(startReports, resultLists);
    }

    private InputStream getNonClosableInputStream(ZipInputStream zis) {
        return new FilterInputStream(zis){

            @Override
            public void close() {
            }
        };
    }

    private boolean isResultList(ZipEntry entry) {
        return entry.getName().endsWith("_Extra.xml");
    }

    private boolean isStartReport(ZipEntry entry) {
        return entry.getName().startsWith("Startberichte\\");
    }
}

