/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse;

import com.sap.sse.ServerStartupConstants;
import com.sap.sse.common.TimePoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ServerInfo {
    private static final Logger logger = Logger.getLogger(ServerInfo.class.getName());
    public static final String COMMIT_ID_FIELD_NAME = "commit_id";
    public static final String ACTIVE_BRANCH_FIELD_NAME = "active_branch";
    public static final String BUILD_DATE_FIELD_NAME = "build_date";
    public static final String RELEASE_FIELD_NAME = "release";
    public static final String START_TIME_MILLIS_FIELD_NAME = "start_time_millis";
    public static final String PORT_FIELD_NAME = "port";
    public static final String SERVER_GROUP_NAME_SUFFIX = "-server";
    private final String commitId;
    private final String activeBranch;
    private final TimePoint buildDate;
    private final String release;
    private final TimePoint startTime;
    private final Integer port;

    private ServerInfo(String commitId, String activeBranch, TimePoint buildDate, String release, TimePoint startTime, Integer port) {
        this.commitId = commitId;
        this.activeBranch = activeBranch;
        this.buildDate = buildDate;
        this.release = release;
        this.startTime = startTime;
        this.port = port;
    }

    public static String getBuildVersion() {
        String version = "Unknown or Development (" + ServerInfo.getName() + ")";
        File versionfile = new File(String.valueOf(ServerStartupConstants.JETTY_HOME) + File.separator + "version.txt");
        if (versionfile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(versionfile));){
                    version = bufferedReader.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error trying to obtain version info", ex);
            }
        }
        return version;
    }

    public static ServerInfo getServerInfo() throws FileNotFoundException, IOException, ParseException, NumberFormatException, java.text.ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmX");
        JSONObject buildVersionJson = ServerInfo.getBuildVersionJson();
        return new ServerInfo((String)buildVersionJson.get((Object)COMMIT_ID_FIELD_NAME), (String)buildVersionJson.get((Object)ACTIVE_BRANCH_FIELD_NAME), buildVersionJson.get((Object)BUILD_DATE_FIELD_NAME) == null ? null : TimePoint.of((Date)format.parse(String.valueOf((String)buildVersionJson.get((Object)BUILD_DATE_FIELD_NAME)) + "Z")), (String)buildVersionJson.get((Object)RELEASE_FIELD_NAME), buildVersionJson.get((Object)START_TIME_MILLIS_FIELD_NAME) == null ? null : TimePoint.of((long)((Number)buildVersionJson.get((Object)START_TIME_MILLIS_FIELD_NAME)).longValue()), buildVersionJson.get((Object)PORT_FIELD_NAME) == null ? null : Integer.valueOf(((Number)buildVersionJson.get((Object)PORT_FIELD_NAME)).intValue()));
    }

    public static JSONObject getBuildVersionJson() throws FileNotFoundException, IOException, ParseException {
        JSONObject result;
        File versionJsonFile = new File(String.valueOf(ServerStartupConstants.JETTY_HOME) + File.separator + "version.json");
        if (versionJsonFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(versionJsonFile));){
                    result = (JSONObject)new JSONParser().parse((Reader)br);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.warning("Unable to read version.json: " + e.getMessage());
                result = new JSONObject();
            }
        } else {
            result = new JSONObject();
        }
        return result;
    }

    public static File getServerDirectory() throws IOException {
        return new File(".").getCanonicalFile();
    }

    public static String getName() {
        return ServerStartupConstants.SERVER_NAME;
    }

    public static String getServerGroupName() {
        return String.valueOf(ServerInfo.getName()) + SERVER_GROUP_NAME_SUFFIX;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getActiveBranch() {
        return this.activeBranch;
    }

    public TimePoint getBuildDate() {
        return this.buildDate;
    }

    public String getRelease() {
        return this.release;
    }

    public TimePoint getStartTime() {
        return this.startTime;
    }

    public Integer getPort() {
        return this.port;
    }

    public static String getManageEventsBaseUrl() {
        return ServerStartupConstants.MANAGE_EVENTS_URL;
    }
}

