/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.data.HasWindTrackContext;
import com.sap.sailing.datamining.impl.data.WindTrackWithContext;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class WindTrackRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedRaceContext, HasWindTrackContext> {
    public WindTrackRetrievalProcessor(ExecutorService executor, Collection<Processor<HasWindTrackContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedRaceContext.class, HasWindTrackContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasWindTrackContext> retrieveData(HasTrackedRaceContext element) {
        ArrayList<HasWindTrackContext> windTracksWithContext = new ArrayList<HasWindTrackContext>();
        if (element != null && element.getTrackedRace() != null) {
            TrackedRace trackedRace = element.getTrackedRace();
            for (WindSource windSource : trackedRace.getWindSources()) {
                if (this.isAborted()) break;
                if (windSource.getType() != WindSourceType.RACECOMMITTEE && !windSource.getType().canBeStored() || trackedRace.getWindSourcesToExclude().contains(windSource)) continue;
                WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
                windTracksWithContext.add(new WindTrackWithContext(element, windTrack, windSource));
            }
        }
        return windTracksWithContext;
    }
}

