/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.Math;
import smile.math.distance.Distance;

public class CorrelationDistance
implements Distance<double[]> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "Correlation distance";
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.cor(x, y);
    }

    public static double pearson(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.cor(x, y);
    }

    public static double pearson(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.cor(x, y);
    }

    public static double pearson(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.cor(x, y);
    }

    public static double spearman(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.spearman(x, y);
    }

    public static double spearman(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.spearman(x, y);
    }

    public static double spearman(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.spearman(x, y);
    }

    public static double kendall(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.kendall(x, y);
    }

    public static double kendall(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.kendall(x, y);
    }

    public static double kendall(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return 1.0 - Math.kendall(x, y);
    }
}

