/*
 * Decompiled with CFR 0.152.
 */
package com.tractrac.subscription.app.tracapi;

import com.tractrac.model.lib.api.data.IControlPassings;
import com.tractrac.model.lib.api.data.IMessageData;
import com.tractrac.model.lib.api.data.IPosition;
import com.tractrac.model.lib.api.data.IPositionOffset;
import com.tractrac.model.lib.api.data.IPositionSnapped;
import com.tractrac.model.lib.api.data.IStartStopData;
import com.tractrac.model.lib.api.event.DataSource;
import com.tractrac.model.lib.api.event.ICompetitor;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.model.lib.api.map.IPositionedItem;
import com.tractrac.model.lib.api.route.IControlRoute;
import com.tractrac.model.lib.api.sensor.ISensorData;
import com.tractrac.subscription.app.tracapi.AbstractListener;
import com.tractrac.subscription.lib.api.event.ILiveDataEvent;
import com.tractrac.subscription.lib.api.event.IStoredDataEvent;
import com.tractrac.util.lib.api.TimeUtils;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EventListener
extends AbstractListener {
    private IRace race;
    private static final Map<UUID, Integer> controlPos = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> compPos = new HashMap<UUID, Integer>();

    private static void show(Object obj) {
        System.out.println(String.valueOf(TimeUtils.formatDateInMillis((long)new Date().getTime())) + ": " + obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotStoredDataEvent(IStoredDataEvent storedDataEvent) {
        EventListener.show(storedDataEvent);
        if (storedDataEvent.getType() == IStoredDataEvent.Type.End) {
            EventListener eventListener = this;
            synchronized (eventListener) {
                System.out.println("CONTROLS: " + controlPos);
                System.out.println("COMPETITORS: " + compPos);
            }
        }
    }

    @Override
    public void gotLiveDataEvent(ILiveDataEvent liveDataEvent) {
        EventListener.show(liveDataEvent);
    }

    @Override
    public void gotRouteChange(IControlRoute controlRoute, long timeStamp) {
        StringBuilder message = new StringBuilder();
        message.append("New route at ").append(timeStamp).append(": ").append(controlRoute.toString());
        int i = 0;
        while (i < controlRoute.getControls().size()) {
            message.append("\n\t").append(i).append(": ").append(((IMapItem)controlRoute.getControls().get(i)).getName());
            ++i;
        }
        message.append("\n\tMETADATA: ").append(controlRoute.getMetadata().getText());
        EventListener.show(message);
    }

    @Override
    public void gotControlPassings(long timestamp, IRaceCompetitor raceCompetitor, IControlPassings markPassings) {
        EventListener.show("New markpassings " + markPassings + " for the competitor " + raceCompetitor.getCompetitor().toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void gotPositionedItemPosition(IPositionedItem positionedItem, IPosition position) {
        if (this.race != null) {
            String markCourseArea = positionedItem.getCourseArea();
            String raceCourseArea = this.race.getCourseArea();
            if (markCourseArea != null && raceCourseArea != null && !markCourseArea.equals(raceCourseArea)) {
                return;
            }
        }
        String message = "COTRLPOS " + positionedItem.getName() + position.toString();
        int posNumber = this.increasePos(controlPos, positionedItem.getId());
        message = String.valueOf(message) + ", TOTAL POS: " + posNumber;
        EventListener.show(message);
    }

    private synchronized int increasePos(Map<UUID, Integer> map, UUID id) {
        map.merge(id, 1, Integer::sum);
        return map.get(id);
    }

    @Override
    public void gotPositionSnapped(IRaceCompetitor raceCompetitor, IPositionSnapped positionSnapped) {
        EventListener.show("New position " + positionSnapped + " for the competitor " + raceCompetitor.getCompetitor().toString());
    }

    @Override
    public void gotPositionOffset(IRaceCompetitor raceCompetitor, IPositionOffset position) {
        EventListener.show("New position " + position + " for the competitor " + raceCompetitor.getCompetitor().toString());
    }

    @Override
    public void gotPosition(IRaceCompetitor raceCompetitor, IPosition position) {
        StringBuilder message = new StringBuilder();
        message.append("POSITION");
        if (raceCompetitor != null) {
            message.append("\t").append(raceCompetitor.getCompetitor().getShortName()).append("\t");
        }
        message.append(position.toString());
        int posNumber = this.increasePos(compPos, raceCompetitor.getCompetitor().getId());
        message.append(", TOTAL POS: ").append(posNumber);
        EventListener.show(message.toString());
    }

    @Override
    public void gotRaceStartStopTime(IRace race, IStartStopData startStopData) {
        EventListener.show("RACE START TIME: " + (startStopData.getStartTime() == 0L ? "-" : TimeUtils.formatDate((long)startStopData.getStartTime())));
    }

    @Override
    public void gotTrackingStartStopTime(IRace race, IStartStopData startStopData) {
        EventListener.show("TRACKING TIMES: " + TimeUtils.formatDate((long)startStopData.getStartTime()) + " - " + TimeUtils.formatDate((long)startStopData.getStopTime()));
    }

    @Override
    public void gotRaceMessage(IRace race, IMessageData messageData) {
        EventListener.show("New race message " + messageData.toString());
    }

    @Override
    public void stopped(Object object) {
        EventListener.show("Stopping the connection with " + object.toString());
    }

    @Override
    public void gotEventMessage(IEvent event, IMessageData messageData) {
        EventListener.show("New event message " + messageData.toString());
    }

    @Override
    public void gotSensorData(IRaceCompetitor raceCompetitor, ISensorData sensorData) {
        StringBuilder message = new StringBuilder();
        message.append("SENSOR");
        if (raceCompetitor != null) {
            message.append("\t").append(raceCompetitor.getCompetitor().getShortName()).append("\t");
        }
        message.append(sensorData.toString());
        EventListener.show(message.toString());
    }

    @Override
    public void updateCompetitor(long timestamp, ICompetitor competitor) {
        EventListener.show("UPDATE COMPETITOR " + competitor.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void addCompetitor(long timestamp, ICompetitor competitor) {
        EventListener.show("ADD COMPETITOR " + competitor.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void deleteCompetitor(long timestamp, UUID competitorId) {
        EventListener.show("DELETE COMPETITOR at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void updateMapItem(long timestamp, IMapItem mapItem) {
        EventListener.show("UPDATE CONTROL " + mapItem.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void addMapItem(long timestamp, IMapItem mapItem) {
        EventListener.show("ADD CONTROL " + mapItem.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void deleteMapItem(long timestamp, UUID mapItemId) {
        EventListener.show("DELETE CONTROL " + mapItemId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void addRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
        EventListener.show("ADD RACE COMPETITOR " + raceCompetitor.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp) + "\n\t ENTRY STATUS: " + raceCompetitor.getStatus() + "\n\t ENTRY STATUS TIME: " + TimeUtils.formatDate((long)raceCompetitor.getStatusTime()) + "\n\t UPDATE ENTRY STATUS: " + TimeUtils.formatDateInMillis((long)raceCompetitor.getStatusLastChangedTime()) + "\n\t OFFICIAL RANK: " + (raceCompetitor.getOfficialRank() == 0 ? "-" : Integer.valueOf(raceCompetitor.getOfficialRank())) + "\n\t OFFICIAL RANK TIME: " + (raceCompetitor.getOfficialFinishTime() == 0L ? "-" : TimeUtils.formatDateInMillis((long)raceCompetitor.getOfficialFinishTime())));
    }

    @Override
    public void updateRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
        EventListener.show("UPDATE RACE COMPETITOR " + raceCompetitor.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp) + "\n\t ENTRY STATUS: " + raceCompetitor.getStatus() + "\n\t ENTRY STATUS TIME: " + TimeUtils.formatDate((long)raceCompetitor.getStatusTime()) + "\n\t UPDATE ENTRY STATUS: " + TimeUtils.formatDateInMillis((long)raceCompetitor.getStatusLastChangedTime()) + "\n\t OFFICIAL RANK: " + (raceCompetitor.getOfficialRank() == 0 ? "-" : Integer.valueOf(raceCompetitor.getOfficialRank())) + "\n\t OFFICIAL RANK TIME: " + (raceCompetitor.getOfficialFinishTime() == 0L ? "-" : TimeUtils.formatDateInMillis((long)raceCompetitor.getOfficialFinishTime())));
    }

    @Override
    public void deleteRaceCompetitor(long timestamp, UUID competitorId) {
        EventListener.show("DELETE RACE COMPETITOR " + competitorId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void updateRace(long timestamp, IRace race) {
        EventListener.show("UPDATE RACE " + race.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp) + "\n\tTrackingStartTime = " + TimeUtils.formatDate((long)race.getTrackingStartTime()) + "\n\tTrackingEndTime = " + TimeUtils.formatDate((long)race.getTrackingEndTime()) + "\n\tRaceStartTime = " + TimeUtils.formatDate((long)race.getRaceStartTime()) + "\n\tLiveDelay = " + race.getLiveDelay() + "\n\tRaceStatus = " + race.getStatus() + "\n\tRaceStatusTime = " + TimeUtils.formatDate((long)race.getStatusTime()) + "\n\tRaceStatusUpdatedAt: " + TimeUtils.formatDate((long)race.getStatusLastChangedTime()));
    }

    @Override
    public void addRace(long timestamp, IRace race) {
        EventListener.show("ADD RACE " + race.toString() + " at " + TimeUtils.formatDateInMillis((long)timestamp) + "\n\tTrackingStartTime = " + TimeUtils.formatDate((long)race.getTrackingStartTime()) + "\n\tTrackingEndTime = " + TimeUtils.formatDate((long)race.getTrackingEndTime()) + "\n\tRaceStartTime = " + TimeUtils.formatDate((long)race.getRaceStartTime()) + "\n\tLiveDelay = " + race.getLiveDelay() + "\n\tRaceStatus = " + race.getStatus() + "\n\tRaceStatusTime = " + TimeUtils.formatDate((long)race.getStatusTime()) + "\n\tRaceStatusUpdatedAt: " + TimeUtils.formatDate((long)race.getStatusLastChangedTime()));
    }

    @Override
    public void deleteRace(long timestamp, UUID raceId) {
        EventListener.show("DELETE RACE " + raceId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void reloadRace(long timestamp, UUID raceId) {
        EventListener.show("RELOAD RACE " + raceId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void abandonRace(long timestamp, UUID raceId) {
        EventListener.show("ABANDON RACE " + raceId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void startTracking(long timestamp, UUID raceId) {
        EventListener.show("START TRACKING " + raceId + " at " + TimeUtils.formatDateInMillis((long)timestamp));
    }

    @Override
    public void dataSourceChanged(long timestamp, IRace race, DataSource oldDataSource, URI oldLiveURI, URI oldStoredURI) {
        EventListener.show("DATA SOURCE CHANGE " + race + ":\n" + "\tLIVE URI: " + race.getLiveURI() + "\n" + "\tSTORED URI: " + race.getStoredURI());
    }

    public IRace getRace() {
        return this.race;
    }

    public void setRace(IRace race) {
        this.race = race;
    }
}

