/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.util;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;

public class RaceBoardLinkFactory {
    private static final URL defaultBaseURL;

    static {
        try {
            defaultBaseURL = new URL("https://www.sapsailing.com");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Internal Error", e);
        }
    }

    public static URL getBaseURL(Event event) {
        URL result = event.getBaseURL() == null ? defaultBaseURL : event.getBaseURL();
        return result;
    }

    public static String createRaceBoardLink(TrackedRace trackedRace, Leaderboard leaderboard, Event event, LeaderboardGroup leaderboardGroup, String raceboardMode, Locale locale) {
        String link;
        RegattaAndRaceIdentifier raceIdentifier = trackedRace.getRaceIdentifier();
        try {
            String eventBaseUrl = RaceBoardLinkFactory.getBaseURL(event).toString();
            link = String.valueOf(eventBaseUrl) + (eventBaseUrl.endsWith("/") ? "" : "/") + "gwt/RaceBoard.html?" + (locale == null ? "" : String.valueOf(locale.toLanguageTag()) + "&") + "eventId=" + event.getId() + "&leaderboardName=" + leaderboard.getName() + (leaderboardGroup != null ? "&leaderboardGroupId=" + leaderboardGroup.getId().toString() : "") + "&raceName=" + URLEncoder.encode(raceIdentifier.getRaceName(), "UTF-8") + "&showMapControls=true&regattaName=" + URLEncoder.encode(raceIdentifier.getRegattaName(), "UTF-8") + "&mode=" + raceboardMode;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Internal error: charset UTF-8 unknown");
        }
        return link;
    }
}

