/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.notification.impl;

import com.sap.sailing.server.notification.impl.NotificationMailTemplate;
import com.sap.sse.common.Util;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.mail.MailService;
import com.sap.sse.mail.SerializableDefaultMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableFileMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableMimeBodyPartSupplier;
import com.sap.sse.mail.SerializableMultipartSupplier;
import com.sap.sse.mail.queue.MailNotification;
import com.sap.sse.security.PreferenceObjectBasedNotificationSet;
import com.sap.sse.security.shared.impl.User;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NotificationSetNotification<T>
implements MailNotification {
    private static final Logger logger = Logger.getLogger(NotificationSetNotification.class.getName());
    private static final String TEMPLATE_FILE = "notification-mail-template.html";
    private static final String LOGO_FILE = "sap_logo_header.png";
    private static final String TEMPLATE = NotificationSetNotification.loadTemplateFile();
    private static final byte[] LOGO_BYTES = NotificationSetNotification.loadLogoFile();
    private final T objectToNotifyAbout;
    private final PreferenceObjectBasedNotificationSet<?, T> associatedNotificationSet;
    private static final ResourceBundleStringMessages messages = ResourceBundleStringMessages.create((String)"stringmessages/StringMessages", (ClassLoader)NotificationSetNotification.class.getClassLoader(), (String)StandardCharsets.UTF_8.name());

    private static String loadTemplateFile() {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(NotificationSetNotification.class.getResourceAsStream(TEMPLATE_FILE), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            logger.log(Level.SEVERE, "Error while loading notification mail template!", exc);
        }
        return content.toString();
    }

    /*
     * Loose catch block
     */
    private static byte[] loadLogoFile() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try {
                byte[] byArray;
                InputStream in;
                ByteArrayOutputStream baos;
                block19: {
                    block18: {
                        int bytesRead;
                        baos = new ByteArrayOutputStream();
                        in = NotificationSetNotification.class.getResourceAsStream(LOGO_FILE);
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = in.read(buffer)) >= 0) {
                            baos.write(buffer, 0, bytesRead);
                        }
                        byArray = baos.toByteArray();
                        if (in == null) break block18;
                        in.close();
                    }
                    if (baos == null) break block19;
                    baos.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (baos != null) {
                                baos.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            logger.log(Level.SEVERE, "Error while loading notification mail template!", exc);
            return null;
        }
    }

    public NotificationSetNotification(T objectToNotifyAbout, PreferenceObjectBasedNotificationSet<?, T> associatedNotificationSet) {
        this.objectToNotifyAbout = objectToNotifyAbout;
        this.associatedNotificationSet = associatedNotificationSet;
    }

    public void sendNotifications(MailService mailService) {
        this.associatedNotificationSet.forUsersWithVerifiedEmailMappedTo(this.objectToNotifyAbout, user -> {
            Locale locale = user.getLocaleOrDefault();
            NotificationMailTemplate mailTemplate = this.getMailTemplate(this.objectToNotifyAbout, locale);
            try {
                SerializableMultipartSupplier multipartSupplier = new SerializableMultipartSupplier("related");
                multipartSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableDefaultMimeBodyPartSupplier((Serializable)((Object)this.getMailContent(mailTemplate, (User)user, locale)), "text/html"));
                multipartSupplier.addBodyPart((SerializableMimeBodyPartSupplier)new SerializableFileMimeBodyPartSupplier(LOGO_BYTES, "image/png", "saplogo", "saplogo.png"));
                mailService.sendMail(user.getEmail(), mailTemplate.getSubject(), multipartSupplier);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not send mail notification for \"" + this.objectToNotifyAbout + "\" to user \"" + user + "\"", e);
            }
        });
    }

    private String getMailContent(NotificationMailTemplate notificationMailTemplate, User user, Locale locale) {
        StringBuilder bodyContent = new StringBuilder();
        if (notificationMailTemplate.getTitle() != null) {
            bodyContent.append("<h1>").append(notificationMailTemplate.getTitle()).append("</h1>");
        }
        String name = user.getFullName() == null || user.getFullName().isEmpty() ? user.getName() : user.getFullName();
        bodyContent.append("<div class=\"paragraph\" style=\" border-top: 5px solid white; border-bottom: 5px solid white;\">").append(this.htmlify(messages.get(locale, "salutation", new String[]{name}))).append("</div>");
        bodyContent.append("<div class=\"paragraph\" style=\" border-top: 5px solid white; border-bottom: 5px solid white;\">").append(this.htmlify(notificationMailTemplate.getText())).append("</div>");
        StringBuilder buttons = new StringBuilder();
        for (Util.Pair<String, String> link : notificationMailTemplate.getLabelsAndLinkUrls()) {
            buttons.append("<span class=\"buttonContainer\" style=\"border-top: 10px solid white; border-right: 10px solid white;\">").append("<a class=\"linkButton\" href=\"").append((String)link.getB()).append("\" style=\"display:inline-block;background-color:#337ab7;border-radius:4px;color:#ffffff;border:1px solid #2e6da4;text-decoration:none;\">").append("<span class=\"linkButtonContent\" style=\"border:15px solid #337ab7;display:inline-block;background-color: #337ab7;\">").append(this.htmlify((String)link.getA()).replaceAll(" ", "&nbsp;")).append("</span>").append("</a> ").append("</span>");
        }
        String siteLink = "<a href=\"" + notificationMailTemplate.getServerBaseUrl() + "/gwt/Home.html\">" + notificationMailTemplate.getServerBaseUrl() + "</a>";
        StringBuilder footerLinks = new StringBuilder();
        footerLinks.append("<a href=\"").append(notificationMailTemplate.getServerBaseUrl()).append("/gwt/Home.html#/user/profile/:\">").append(this.htmlify(messages.get(locale, "userProfile"))).append("</a>").append(" | ");
        footerLinks.append("<a href=\"http://go.sap.com/about/legal/impressum.html?campaigncode=CRM-XH21-OSP-Sailing\">").append(this.htmlify(messages.get(locale, "imprint"))).append("</a>").append(" | ");
        footerLinks.append("<a href=\"http://go.sap.com/about/legal/privacy.html?campaigncode=CRM-XH21-OSP-Sailing\">").append(this.htmlify(messages.get(locale, "privacy"))).append("</a>");
        String subscriptionInformation = this.htmlify(messages.get(locale, "subscriptionInformation"));
        return TEMPLATE.replace("${title}", notificationMailTemplate.getSubject()).replace("${content}", bodyContent.toString()).replace("${buttons}", buttons.toString()).replace("${subscription_information}", subscriptionInformation).replace("${site}", siteLink).replace("${footer_links}", footerLinks.toString());
    }

    private String htmlify(String source) {
        StringBuilder result = new StringBuilder();
        char[] cArray = source.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.append("\"<>&".indexOf(c) >= 0 || c > '\u007f' ? "&#" + c + ";" : Character.toString(c));
            ++n2;
        }
        return result.toString();
    }

    protected abstract NotificationMailTemplate getMailTemplate(T var1, Locale var2);
}

