/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEndOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogDenoteForTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogStartTrackingEventImpl;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.EventBaseImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.Placemark;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.dto.ExpeditionAllInOneConstants;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotedForRaceLogTrackingException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardGroupImpl;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.geocoding.ReverseGeocoder;
import com.sap.sailing.server.gateway.trackfiles.impl.AllInOneImportException;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionCourseInferrer;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionImportFilenameUtils;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionStartData;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sailing.server.gateway.trackfiles.impl.SensorDataImporter;
import com.sap.sailing.server.gateway.trackfiles.impl.TrackFilesImporter;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sailing.server.gateway.windimport.expedition.WindImporter;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AddColumnToSeries;
import com.sap.sailing.server.operationaltransformation.AddSpecificRegatta;
import com.sap.sailing.server.operationaltransformation.CreateLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.CreateRegattaLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateEvent;
import com.sap.sailing.server.security.PermissionAwareRaceTrackingHandler;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sailing.server.util.WaitForTrackedRaceUtil;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.util.FileItemHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.fileupload.FileItem;
import org.apache.shiro.SecurityUtils;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;

public class ExpeditionAllInOneImporter {
    private static final Logger logger = Logger.getLogger(ExpeditionAllInOneImporter.class.getName());
    private static final double VENUE_RANGE_CHECK = 10.0;
    private static final Duration TRACKING_DURATION_BEFORE_START = Duration.ONE_MINUTE.times(5L);
    private static final String START_PER_SESSION_RACE_COLUMN_NAME_PREFIX = "R";
    private final RacingEventService service;
    private final RaceLogTrackingAdapter adapter;
    private final TypeBasedServiceFinderFactory serviceFinderFactory;
    private final BundleContext context;
    private ResourceBundleStringMessages serverStringMessages;
    private Locale uiLocale;
    private final SecurityService securityService;

    public ExpeditionAllInOneImporter(ResourceBundleStringMessages serverStringMessages, Locale uiLocale, RacingEventService service, SecurityService securityService, RaceLogTrackingAdapter adapter, TypeBasedServiceFinderFactory serviceFinderFactory, BundleContext context) {
        this.serverStringMessages = serverStringMessages;
        this.uiLocale = uiLocale;
        this.service = service;
        this.securityService = securityService;
        this.adapter = adapter;
        this.serviceFinderFactory = serviceFinderFactory;
        this.context = context;
    }

    private TimePointsOfFirstAndLastFix importFixes(String filenameWithSuffix, FileItem fileItem, ImportResult jsonHolderForGpsFixImport, ImportResult jsonHolderForSensorFixImport, List<ImportResult.ErrorImportDTO> errors) throws AllInOneImportException {
        List<Util.Pair<String, FileItem>> filesForGpsFixImport = Arrays.asList(new Util.Pair((Object)filenameWithSuffix, (Object)fileItem));
        try {
            new TrackFilesImporter(this.service, this.serviceFinderFactory, this.context).importFixes(jsonHolderForGpsFixImport, "Expedition", filesForGpsFixImport);
            this.ensureSuccessfulImport(jsonHolderForGpsFixImport, this.serverStringMessages.get(this.uiLocale, "allInOneErrorGPSDataImportFailed"));
        }
        catch (IOException e1) {
            errors.addAll(jsonHolderForGpsFixImport.getErrorList());
            throw new AllInOneImportException(e1, errors);
        }
        errors.addAll(jsonHolderForGpsFixImport.getErrorList());
        List<Util.Pair<String, FileItem>> importerNamesAndFilesForSensorFixImport = Arrays.asList(new Util.Pair((Object)"EXPEDITION_EXTENDED", (Object)fileItem));
        try {
            new SensorDataImporter(this.service, this.context).importFiles(false, jsonHolderForSensorFixImport, importerNamesAndFilesForSensorFixImport);
            this.ensureSuccessfulImport(jsonHolderForSensorFixImport, this.serverStringMessages.get(this.uiLocale, "allInOneErrorSensorDataImportFailed"));
        }
        catch (IOException e1) {
            errors.addAll(jsonHolderForSensorFixImport.getErrorList());
            throw new AllInOneImportException(e1, errors);
        }
        TimePoint firstFixAt = null;
        TimePoint lastFixAt = null;
        ArrayList<ImportResult.TrackImportDTO> allData = new ArrayList<ImportResult.TrackImportDTO>();
        allData.addAll(jsonHolderForGpsFixImport.getImportResult());
        allData.addAll(jsonHolderForSensorFixImport.getImportResult());
        for (ImportResult.TrackImportDTO result : allData) {
            TimePoint deviceTrackStart = result.getRange().from();
            TimePoint deviceTrackEnd = result.getRange().to();
            if (firstFixAt == null || deviceTrackStart.before(firstFixAt)) {
                firstFixAt = deviceTrackStart;
            }
            if (lastFixAt != null && !deviceTrackEnd.after(lastFixAt)) continue;
            lastFixAt = deviceTrackEnd;
        }
        return new TimePointsOfFirstAndLastFix(firstFixAt, lastFixAt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImporterResult importFiles(String filenameWithSuffix, FileItem fileItem, String boatClassName, ExpeditionAllInOneConstants.ImportMode importMode, String existingRegattaName, boolean importStartData) throws AllInOneImportException, IOException, FormatNotSupportedException {
        UUID eventId;
        String regattaNameAndleaderboardName;
        String leaderboardGroupName;
        Set<String> additionalTrackedRaceNames;
        String filenameWithDateTimeSuffix;
        this.securityService.checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
        ArrayList<ImportResult.ErrorImportDTO> errors = new ArrayList<ImportResult.ErrorImportDTO>();
        String importTimeString = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now(ZoneOffset.UTC));
        String filename = ExpeditionImportFilenameUtils.truncateFilenameExtentions(filenameWithSuffix, new ExpeditionImportFileHandler(){

            protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset) throws IOException, FormatNotSupportedException {
            }
        });
        String trackedRaceName = filenameWithDateTimeSuffix = String.valueOf(filename) + "_" + importTimeString;
        String windSourceId = filenameWithDateTimeSuffix;
        int[] discardThresholds = new int[]{};
        ImportResult jsonHolderForGpsFixImport = new ImportResult(logger);
        ImportResult jsonHolderForSensorFixImport = new ImportResult(logger);
        errors.addAll(jsonHolderForSensorFixImport.getErrorList());
        ArrayList<Util.Triple> raceNameRaceColumnNameFleetnameList = new ArrayList<Util.Triple>();
        ArrayList<DynamicTrackedRace> trackedRaces = new ArrayList<DynamicTrackedRace>();
        ExpeditionCourseInferrer expeditionCourseInferrer = new ExpeditionCourseInferrer(this.adapter);
        ExpeditionStartData startData = expeditionCourseInferrer.getStartData(fileItem.getInputStream(), filenameWithSuffix, FileItemHelper.getCharset((FileItem)fileItem, (Charset)Charset.forName("UTF-8")));
        Iterable<String> iterable = additionalTrackedRaceNames = importStartData ? this.getNextRaceColumnNames(1, Util.size(startData.getStartTimes())) : Collections.emptySet();
        if (importMode == ExpeditionAllInOneConstants.ImportMode.NEW_EVENT) {
            leaderboardGroupName = filenameWithDateTimeSuffix;
            regattaNameAndleaderboardName = filenameWithDateTimeSuffix;
            String raceColumnName = filename;
            eventId = UUID.randomUUID();
            String fleetName = "Default";
            String eventName = filenameWithDateTimeSuffix;
            String regattaName = filenameWithDateTimeSuffix;
            this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.EVENT, EventBaseImpl.getTypeRelativeObjectIdentifier((UUID)eventId), filenameWithDateTimeSuffix, () -> this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.REGATTA, Regatta.getTypeRelativeObjectIdentifier((String)regattaName), regattaName, () -> this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((String)regattaName), regattaName, () -> this.checkTrackedRacesCreationPermission(regattaName, trackedRaceName, additionalTrackedRaceNames, () -> {
                TimePointsOfFirstAndLastFix firstAndLastFixAt = this.importFixes(filenameWithSuffix, fileItem, jsonHolderForGpsFixImport, jsonHolderForSensorFixImport, errors);
                TimePoint eventStartDate = firstAndLastFixAt.getFirstFixAt();
                TimePoint eventEndDate = firstAndLastFixAt.getLastFixAt();
                logger.info("Trying to create event " + eventName + " and regatta " + regattaName + " on behalf of user " + SecurityUtils.getSubject().getPrincipal());
                Iterable<Util.Triple<DynamicTrackedRace, String, String>> trackedRacesAndRaceColumnNamesAndFleetNames = this.createEventStructureWithASingleRaceAndTrackIt(filenameWithSuffix, boatClassName, errors, importTimeString, filename, eventName, regattaName, trackedRaceName, discardThresholds, firstAndLastFixAt.getFirstFixAt(), firstAndLastFixAt.getLastFixAt(), eventStartDate, eventEndDate, eventId, leaderboardGroupName, regattaNameAndleaderboardName, fleetName, raceColumnName, importStartData ? startData : null);
                for (Util.Triple<DynamicTrackedRace, String, String> i : trackedRacesAndRaceColumnNamesAndFleetNames) {
                    trackedRaces.add((DynamicTrackedRace)i.getA());
                    raceNameRaceColumnNameFleetnameList.add(new Util.Triple((Object)((DynamicTrackedRace)i.getA()).getRace().getName(), (Object)((String)i.getB()), (Object)((String)i.getC())));
                }
                this.updateVenueName(filename, jsonHolderForGpsFixImport.getImportResult(), eventId);
                return null;
            }))));
        } else {
            regattaNameAndleaderboardName = existingRegattaName;
            if (existingRegattaName == null || existingRegattaName.isEmpty()) return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidRegattaName"));
            Regatta regatta = this.service.getRegattaByName(existingRegattaName);
            if (regatta == null) {
                return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidData"));
            }
            Leaderboard leaderboard = this.service.getLeaderboardByName(existingRegattaName);
            if (leaderboard == null || !(leaderboard instanceof RegattaLeaderboard)) {
                return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidLeaderBoard"));
            }
            RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
            Util.Pair<Event, LeaderboardGroup> foundEventAndLeaderboardGroup = this.findEventAndLeaderboardGroupForExistingLeaderboard(leaderboard);
            if (foundEventAndLeaderboardGroup == null) {
                return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidLeaderBoardEventLink"));
            }
            eventId = ((Event)foundEventAndLeaderboardGroup.getA()).getId();
            leaderboardGroupName = ((LeaderboardGroup)foundEventAndLeaderboardGroup.getB()).getName();
            this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)this.service.getEvent((Serializable)eventId), new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE});
            this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)this.service.getRegatta(new RegattaName(regattaNameAndleaderboardName)), new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE});
            this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)this.service.getLeaderboardByName(regattaNameAndleaderboardName), new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE});
            if (importMode == ExpeditionAllInOneConstants.ImportMode.NEW_COMPETITOR) {
                DynamicTrackedRace trackedRace = this.service.getTrackedRace((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regattaNameAndleaderboardName, trackedRaceName));
                if (trackedRace != null) {
                    this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)trackedRace, new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE});
                    TimePointsOfFirstAndLastFix firstAndLastFixAt = this.importFixes(filenameWithSuffix, fileItem, jsonHolderForGpsFixImport, jsonHolderForSensorFixImport, errors);
                    this.ensureEventLongEnough(firstAndLastFixAt.getFirstFixAt(), firstAndLastFixAt.getLastFixAt(), eventId);
                    Iterable raceColumns = regattaLeaderboard.getRaceColumns();
                    if (Util.isEmpty((Iterable)raceColumns)) {
                        return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidRace"));
                    }
                    try {
                        for (RaceColumn raceColumn : raceColumns) {
                            Iterable fleets = raceColumn.getFleets();
                            if (Util.size((Iterable)fleets) != 1) {
                                return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorSplitFleetNotSupported"));
                            }
                            Fleet fleet = (Fleet)fleets.iterator().next();
                            DynamicTrackedRace trackedRaceForColumn = (DynamicTrackedRace)raceColumn.getTrackedRace(fleet);
                            if (trackedRaceForColumn == null) {
                                trackedRaceForColumn = this.trackRace(regattaLeaderboard, raceColumn, fleet);
                            }
                            trackedRaces.add(trackedRaceForColumn);
                            raceNameRaceColumnNameFleetnameList.add(new Util.Triple((Object)trackedRaceForColumn.getRaceIdentifier().getRaceName(), (Object)raceColumn.getName(), (Object)fleet.getName()));
                        }
                    }
                    catch (Exception e) {
                        throw new AllInOneImportException(e, errors);
                    }
                }
            } else {
                if (importMode != ExpeditionAllInOneConstants.ImportMode.NEW_RACE) return new ImporterResult(String.valueOf(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidImportMode")) + importMode);
                String raceColumnName = regatta.getRaceColumnByName(filename) == null ? filename : filenameWithDateTimeSuffix;
                ImporterResult trackedRacesResult = this.checkTrackedRacesCreationPermission(regattaNameAndleaderboardName, trackedRaceName, additionalTrackedRaceNames, () -> {
                    TimePointsOfFirstAndLastFix firstAndLastFixAt = this.importFixes(filenameWithSuffix, fileItem, jsonHolderForGpsFixImport, jsonHolderForSensorFixImport, errors);
                    this.ensureEventLongEnough(firstAndLastFixAt.getFirstFixAt(), firstAndLastFixAt.getLastFixAt(), eventId);
                    Iterable seriesInRegatta = regatta.getSeries();
                    if (Util.isEmpty((Iterable)seriesInRegatta)) {
                        return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorInvalidSeries"));
                    }
                    Series series = (Series)Util.get((Iterable)seriesInRegatta, (int)(Util.size((Iterable)seriesInRegatta) - 1));
                    Iterable fleets = series.getFleets();
                    if (Util.size((Iterable)fleets) != 1) {
                        return new ImporterResult(this.serverStringMessages.get(this.uiLocale, "allInOneErrorMultiSeries"));
                    }
                    Util.Triple<DynamicTrackedRace, String, String> trackedRaceAndRaceColumnNameAndFleetName = this.addRace(errors, regatta, raceColumnName, trackedRaceName, regattaLeaderboard, firstAndLastFixAt.getFirstFixAt(), firstAndLastFixAt.getLastFixAt(), null);
                    trackedRaces.add((DynamicTrackedRace)trackedRaceAndRaceColumnNameAndFleetName.getA());
                    raceNameRaceColumnNameFleetnameList.add(new Util.Triple((Object)((DynamicTrackedRace)trackedRaceAndRaceColumnNameAndFleetName.getA()).getRace().getName(), (Object)((String)trackedRaceAndRaceColumnNameAndFleetName.getB()), (Object)((String)trackedRaceAndRaceColumnNameAndFleetName.getC())));
                    if (importStartData) {
                        this.createSessionsForStartTimes(errors, raceNameRaceColumnNameFleetnameList, trackedRaces, startData, regatta, regattaLeaderboard, firstAndLastFixAt);
                    }
                    return null;
                });
                if (trackedRacesResult != null) {
                    return trackedRacesResult;
                }
            }
        }
        if (importStartData) {
            expeditionCourseInferrer.setStartLine(startData, trackedRaces, this.service);
        }
        try {
            AbstractWindImporter.WindImportResult windImportResult = new AbstractWindImporter.WindImportResult();
            WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, windSourceId);
            HashMap<InputStream, Util.Pair<String, Charset>> streamsWithFilenames = new HashMap<InputStream, Util.Pair<String, Charset>>();
            streamsWithFilenames.put(fileItem.getInputStream(), new Util.Pair((Object)filenameWithSuffix, (Object)FileItemHelper.getCharset((FileItem)fileItem)));
            new WindImporter().importWindToWindSourceAndTrackedRaces(this.service, windImportResult, (WindSource)windSource, trackedRaces, streamsWithFilenames);
            return new ImporterResult(eventId, regattaNameAndleaderboardName, leaderboardGroupName, regattaNameAndleaderboardName, raceNameRaceColumnNameFleetnameList, jsonHolderForGpsFixImport.getImportResult(), jsonHolderForSensorFixImport.getImportResult(), "EXPEDITION_EXTENDED", errors, startData);
        }
        catch (Exception e) {
            throw new AllInOneImportException(e, errors);
        }
    }

    private <T> T checkTrackedRacesCreationPermission(String regattaName, String trackedRaceName, Iterable<String> additionalTrackedRaceNames, Callable<T> action) {
        Iterator<String> additionalTrackedRaceNamesIterator = additionalTrackedRaceNames.iterator();
        return (T)this.checkTrackedRaceCreationPermission(regattaName, trackedRaceName, () -> this.checkTrackedRaceCreationPermissionRecursively(regattaName, additionalTrackedRaceNamesIterator, action));
    }

    private <T> T checkTrackedRaceCreationPermissionRecursively(String regattaName, Iterator<String> additionalTrackedRaceNamesIterator, Callable<T> terminalAction) throws Exception {
        if (additionalTrackedRaceNamesIterator.hasNext()) {
            return (T)this.checkTrackedRaceCreationPermission(regattaName, additionalTrackedRaceNamesIterator.next(), () -> this.checkTrackedRaceCreationPermissionRecursively(regattaName, additionalTrackedRaceNamesIterator, terminalAction));
        }
        return terminalAction.call();
    }

    private <T> T checkTrackedRaceCreationPermission(String regattaName, String trackedRaceName, Callable<T> action) {
        return (T)this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(TrackedRace.getSecuredDomainType(), TrackedRace.getIdentifier((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regattaName, trackedRaceName)).getTypeRelativeObjectIdentifier(), trackedRaceName, action);
    }

    private void createSessionsForStartTimes(List<ImportResult.ErrorImportDTO> errors, List<Util.Triple<String, String, String>> raceNameRaceColumnNameFleetnameList, List<DynamicTrackedRace> trackedRaces, ExpeditionStartData startData, Regatta regatta, RegattaLeaderboard regattaLeaderboard, TimePointsOfFirstAndLastFix firstAndLastFixAt) throws AllInOneImportException {
        for (Util.Triple<TimePoint, TimePoint, TimePoint> startTimesAndStartAndEndOfTrackingTimes : this.getStartTimesAndStartAndEndOfTrackingTimes(startData.getStartTimes(), firstAndLastFixAt.getFirstFixAt(), firstAndLastFixAt.getLastFixAt())) {
            Util.Triple<DynamicTrackedRace, String, String> session = this.createSessionForStartTime((TimePoint)startTimesAndStartAndEndOfTrackingTimes.getA(), (TimePoint)startTimesAndStartAndEndOfTrackingTimes.getB(), (TimePoint)startTimesAndStartAndEndOfTrackingTimes.getC(), errors, regatta, regattaLeaderboard);
            trackedRaces.add((DynamicTrackedRace)session.getA());
            raceNameRaceColumnNameFleetnameList.add((Util.Triple<String, String, String>)new Util.Triple((Object)((DynamicTrackedRace)session.getA()).getRace().getName(), (Object)((String)session.getB()), (Object)((String)session.getC())));
        }
    }

    private Iterable<String> getNextRaceColumnNames(Regatta regatta, int howMany) {
        return this.getNextRaceColumnNames(this.getNextAvailableStartBasedSessionCount(regatta), howMany);
    }

    private Iterable<String> getNextRaceColumnNames(int startIndex, int howMany) {
        ArrayList<String> result = new ArrayList<String>(howMany);
        int counter = startIndex;
        int i = 0;
        while (i < howMany) {
            result.add(START_PER_SESSION_RACE_COLUMN_NAME_PREFIX + counter++);
            ++i;
        }
        return result;
    }

    private Util.Triple<DynamicTrackedRace, String, String> createSessionForStartTime(TimePoint startTime, TimePoint firstFixAt, TimePoint lastFixAt, List<ImportResult.ErrorImportDTO> errors, Regatta regatta, RegattaLeaderboard regattaLeaderboard) throws AllInOneImportException {
        String raceColumnName = this.getNextRaceColumnNames(regatta, 1).iterator().next();
        Util.Triple<DynamicTrackedRace, String, String> trackedRaceAndRaceColumnNameAndFleetName = this.addRace(errors, regatta, raceColumnName, raceColumnName, regattaLeaderboard, firstFixAt, lastFixAt, startTime);
        return trackedRaceAndRaceColumnNameAndFleetName;
    }

    private int getNextAvailableStartBasedSessionCount(Regatta regatta) {
        int maxNumberFound = 0;
        Pattern pattern = Pattern.compile("R([0-9]+)");
        for (RaceColumn raceColumn : regatta.getRaceColumns()) {
            int number;
            String numberAsString;
            Matcher matcher = pattern.matcher(raceColumn.getName());
            if (!matcher.matches() || matcher.groupCount() <= 0 || (numberAsString = matcher.group(1)).isEmpty() || (number = Integer.valueOf(numberAsString).intValue()) <= maxNumberFound) continue;
            maxNumberFound = number;
        }
        return maxNumberFound + 1;
    }

    private Util.Triple<DynamicTrackedRace, String, String> addRace(List<ImportResult.ErrorImportDTO> errors, Regatta regatta, String raceColumnName, String trackedRaceName, RegattaLeaderboard regattaLeaderboard, TimePoint startOfTracking, TimePoint endOfTracking, TimePoint startTime) throws AllInOneImportException {
        Iterable seriesInRegatta = regatta.getSeries();
        assert (!Util.isEmpty((Iterable)seriesInRegatta));
        Series series = (Series)Util.get((Iterable)seriesInRegatta, (int)(Util.size((Iterable)seriesInRegatta) - 1));
        Iterable fleets = series.getFleets();
        assert (!Util.isEmpty((Iterable)fleets));
        Fleet fleet = (Fleet)fleets.iterator().next();
        String fleetName = fleet.getName();
        RaceColumn raceColumn = (RaceColumn)this.service.apply((OperationWithResult)new AddColumnToSeries(regatta.getRegattaIdentifier(), series.getName(), raceColumnName));
        DynamicTrackedRace trackedRace = this.createTrackedRaceAndSetupRaceTimes(errors, trackedRaceName, startOfTracking, endOfTracking, regatta, regattaLeaderboard, raceColumn, fleet);
        if (startTime != null) {
            RaceLog raceLog = raceColumn.getRaceLog((Fleet)raceColumn.getFleets().iterator().next());
            raceLog.add((AbstractLogEvent)new RaceLogStartTimeEventImpl(startTime, this.service.getServerAuthor(), 0, startTime, null));
        }
        return new Util.Triple((Object)trackedRace, (Object)raceColumnName, (Object)fleetName);
    }

    private void ensureEventLongEnough(TimePoint firstFixAt, TimePoint lastFixAt, UUID eventId) {
        TimePoint endDate;
        Event event = this.service.getEvent((Serializable)eventId);
        TimePoint startDate = event.getStartDate();
        if (firstFixAt.before(startDate)) {
            startDate = firstFixAt;
        }
        if (lastFixAt.after(endDate = event.getEndDate())) {
            endDate = lastFixAt;
        }
        Iterable leaderboardGroups = StreamSupport.stream(event.getLeaderboardGroups().spliterator(), false).map(t -> t.getId()).collect(Collectors.toList());
        this.service.apply((OperationWithResult)new UpdateEvent(event.getId(), event.getName(), event.getDescription(), startDate, endDate, event.getVenue().getName(), event.isPublic(), leaderboardGroups, event.getOfficialWebsiteURL(), event.getBaseURL(), event.getSailorsInfoWebsiteURLs(), event.getImages(), event.getVideos(), event.getWindFinderReviewedSpotsCollectionIds()));
    }

    private Util.Pair<Event, LeaderboardGroup> findEventAndLeaderboardGroupForExistingLeaderboard(Leaderboard leaderboard) {
        for (Event event : this.service.getAllEvents()) {
            for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                for (Leaderboard lb : leaderboardGroup.getLeaderboards()) {
                    if (!lb.equals(leaderboard)) continue;
                    return new Util.Pair((Object)event, (Object)leaderboardGroup);
                }
            }
        }
        return null;
    }

    private Iterable<Util.Triple<DynamicTrackedRace, String, String>> createEventStructureWithASingleRaceAndTrackIt(String filenameWithSuffix, String boatClassName, List<ImportResult.ErrorImportDTO> errors, String importTimeString, String filename, String eventName, String regattaName, String trackedRaceName, int[] discardThresholds, TimePoint firstFixAt, TimePoint lastFixAt, TimePoint eventStartDate, TimePoint eventEndDate, UUID eventId, String leaderboardGroupName, String regattaNameAndleaderboardName, String fleetName, String raceColumnName, ExpeditionStartData startData) throws AllInOneImportException {
        String description = MessageFormat.format("Event imported from expedition file ''{0}'' on {1}", filenameWithSuffix, importTimeString);
        RegattaName regattaIdentifier = new RegattaName(regattaName);
        Double buoyZoneRadiusInHullLengths = 3.0;
        String seriesName = "Default";
        Event event = this.service.addEvent(eventName, description, eventStartDate, eventEndDate, filename, true, eventId);
        UUID courseAreaId = this.addDefaultCourseArea(event);
        Regatta regatta = this.createRegattaWithOneRaceColumn(boatClassName, regattaNameAndleaderboardName, fleetName, raceColumnName, (RegattaIdentifier)regattaIdentifier, courseAreaId, buoyZoneRadiusInHullLengths, "Default");
        RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)this.service.apply((OperationWithResult)new CreateRegattaLeaderboard((RegattaIdentifier)regattaIdentifier, null, discardThresholds));
        this.createLeaderboardGroupAndAddItToTheEvent(leaderboardGroupName, regattaNameAndleaderboardName, description, event);
        RaceColumn raceColumn = (RaceColumn)regattaLeaderboard.getRaceColumns().iterator().next();
        Fleet fleet = (Fleet)raceColumn.getFleets().iterator().next();
        DynamicTrackedRace trackedRace = this.createTrackedRaceAndSetupRaceTimes(errors, trackedRaceName, firstFixAt, lastFixAt, regatta, regattaLeaderboard, raceColumn, fleet);
        ArrayList<Util.Triple<DynamicTrackedRace, String, String>> result = new ArrayList<Util.Triple<DynamicTrackedRace, String, String>>();
        result.add(new Util.Triple((Object)trackedRace, (Object)raceColumnName, (Object)fleetName));
        if (startData != null) {
            for (Util.Triple<TimePoint, TimePoint, TimePoint> startTimesAndStartAndEndOfTrackingTimes : this.getStartTimesAndStartAndEndOfTrackingTimes(startData.getStartTimes(), firstFixAt, lastFixAt)) {
                Util.Triple<DynamicTrackedRace, String, String> session = this.createSessionForStartTime((TimePoint)startTimesAndStartAndEndOfTrackingTimes.getA(), (TimePoint)startTimesAndStartAndEndOfTrackingTimes.getB(), (TimePoint)startTimesAndStartAndEndOfTrackingTimes.getC(), errors, regatta, regattaLeaderboard);
                result.add(session);
            }
        }
        return result;
    }

    private Iterable<Util.Triple<TimePoint, TimePoint, TimePoint>> getStartTimesAndStartAndEndOfTrackingTimes(Iterable<TimePoint> startTimes, TimePoint firstFixAt, TimePoint lastFixAt) {
        ArrayList<Util.Triple<TimePoint, TimePoint, TimePoint>> result = new ArrayList<Util.Triple<TimePoint, TimePoint, TimePoint>>();
        TimePoint previousStartOfTracking = null;
        TimePoint previousStartTime = null;
        for (TimePoint startTime : startTimes) {
            TimePoint preferredStartOfTracking;
            if (previousStartOfTracking != null) {
                assert (previousStartTime != null);
                TimePoint preferredEndOfTracking = startTime.minus(TRACKING_DURATION_BEFORE_START);
                result.add(this.createInterval(previousStartOfTracking, preferredEndOfTracking, previousStartTime, firstFixAt, lastFixAt));
            }
            previousStartOfTracking = (preferredStartOfTracking = startTime.minus(TRACKING_DURATION_BEFORE_START)).before(firstFixAt) ? firstFixAt : preferredStartOfTracking;
            previousStartTime = startTime;
        }
        if (previousStartOfTracking != null) {
            result.add(this.createInterval(previousStartOfTracking, lastFixAt, previousStartTime, firstFixAt, lastFixAt));
        }
        return result;
    }

    private Util.Triple<TimePoint, TimePoint, TimePoint> createInterval(TimePoint startOfTracking, TimePoint preferredEndOfTracking, TimePoint startTime, TimePoint firstFixAt, TimePoint lastFixAt) {
        assert (startOfTracking != null);
        assert (startTime != null);
        TimePoint endOfTracking = preferredEndOfTracking.after(lastFixAt) ? lastFixAt : (preferredEndOfTracking.before(firstFixAt) ? firstFixAt : preferredEndOfTracking);
        return new Util.Triple((Object)startTime, (Object)startOfTracking, (Object)endOfTracking);
    }

    private void updateVenueName(String filename, List<ImportResult.TrackImportDTO> list, UUID eventId) {
        for (ImportResult.TrackImportDTO f : list) {
            TrackFileImportDeviceIdentifier deviceIdentifier = TrackFileImportDeviceIdentifierImpl.getOrCreate((UUID)f.getDevice());
            TimePoint end = f.getRange().to();
            try {
                Position pos;
                CompletableFuture<Object> waitForFix = new CompletableFuture<Object>();
                this.service.getSensorFixStore().loadFixes(waitForFix::complete, (DeviceIdentifier)deviceIdentifier, end, end, true);
                GPSFix gpsFix = waitForFix.getNow(null);
                if (gpsFix == null || (pos = gpsFix.getPosition()) == null) continue;
                try {
                    Placemark reverseVenue = ReverseGeocoder.INSTANCE.getPlacemarkFirst(pos, 10.0, (Comparator)new Placemark.ByPopulationDistanceRatio(pos));
                    if (reverseVenue == null) continue;
                    String newVenueName = reverseVenue.getName();
                    Event event = this.service.getEvent((Serializable)eventId);
                    Iterable leaderboardGroups = StreamSupport.stream(event.getLeaderboardGroups().spliterator(), false).map(t -> t.getId()).collect(Collectors.toList());
                    this.service.apply((OperationWithResult)new UpdateEvent(event.getId(), event.getName(), event.getDescription(), event.getStartDate(), event.getEndDate(), newVenueName, event.isPublic(), leaderboardGroups, event.getOfficialWebsiteURL(), event.getBaseURL(), event.getSailorsInfoWebsiteURLs(), event.getImages(), event.getVideos(), event.getWindFinderReviewedSpotsCollectionIds()));
                    break;
                }
                catch (IOException | ParseException e) {
                    logger.log(Level.WARNING, "Could not reverse determine location " + pos, e);
                }
            }
            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                logger.log(Level.WARNING, "Could not reverse determine location", e);
            }
        }
    }

    private UUID addDefaultCourseArea(Event event) {
        String courseAreaName = "Default";
        UUID courseAreaId = UUID.randomUUID();
        this.service.addCourseAreas(event.getId(), new String[]{"Default"}, new UUID[]{courseAreaId}, new Position[0], new Distance[0]);
        return courseAreaId;
    }

    private Regatta createRegattaWithOneRaceColumn(String boatClassName, String regattaNameAndleaderboardName, String fleetName, String raceColumnName, RegattaIdentifier regattaIdentifier, UUID courseAreaId, Double buoyZoneRadiusInHullLengths, String seriesName) throws AllInOneImportException {
        ScoringSchemeType scoringSchemeType = ScoringSchemeType.LOW_POINT;
        RankingMetrics rankingMetric = RankingMetrics.ONE_DESIGN;
        ScoringScheme scoringScheme = this.service.getBaseDomainFactory().createScoringScheme(scoringSchemeType);
        LinkedHashMap<String, SeriesCreationParametersDTO> seriesCreationParameters = new LinkedHashMap<String, SeriesCreationParametersDTO>();
        ArrayList<FleetDTO> fleets = new ArrayList<FleetDTO>();
        fleets.add(new FleetDTO(fleetName, 0, null));
        seriesCreationParameters.put(seriesName, new SeriesCreationParametersDTO(fleets, false, false, false, false, null, false, false, null, false));
        RegattaCreationParametersDTO regattaCreationParameters = new RegattaCreationParametersDTO(seriesCreationParameters);
        Regatta regatta = (Regatta)this.service.apply((OperationWithResult)new AddSpecificRegatta(regattaNameAndleaderboardName, boatClassName, false, CompetitorRegistrationType.CLOSED, UUID.randomUUID().toString(), null, null, (Serializable)UUID.randomUUID(), regattaCreationParameters, true, scoringScheme, courseAreaId == null ? Collections.emptySet() : Collections.singleton(courseAreaId), buoyZoneRadiusInHullLengths, true, false, false, rankingMetric));
        this.ensureBoatClassDetermination(regatta);
        this.service.apply((OperationWithResult)new AddColumnToSeries(regattaIdentifier, seriesName, raceColumnName));
        return regatta;
    }

    private void createLeaderboardGroupAndAddItToTheEvent(final String leaderboardGroupName, final String regattaNameAndleaderboardName, final String description, Event event) {
        final UUID newGroupid = UUID.randomUUID();
        LeaderboardGroup leaderboardGroup = (LeaderboardGroup)this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD_GROUP, LeaderboardGroupImpl.getTypeRelativeObjectIdentifier((UUID)newGroupid), null, (Callable)new Callable<LeaderboardGroup>(){

            @Override
            public LeaderboardGroup call() throws Exception {
                CreateLeaderboardGroup createLeaderboardGroup = new CreateLeaderboardGroup(newGroupid, leaderboardGroupName, description, null, false, Collections.singletonList(regattaNameAndleaderboardName), null, null);
                return (LeaderboardGroup)ExpeditionAllInOneImporter.this.service.apply((OperationWithResult)createLeaderboardGroup);
            }
        });
        this.service.apply((OperationWithResult)new UpdateEvent(event.getId(), event.getName(), event.getDescription(), event.getStartDate(), event.getEndDate(), event.getVenue().getName(), event.isPublic(), Collections.singleton(leaderboardGroup.getId()), event.getOfficialWebsiteURL(), event.getBaseURL(), event.getSailorsInfoWebsiteURLs(), event.getImages(), event.getVideos(), event.getWindFinderReviewedSpotsCollectionIds()));
    }

    private DynamicTrackedRace createTrackedRaceAndSetupRaceTimes(List<ImportResult.ErrorImportDTO> errors, String trackedRaceName, TimePoint firstFixAt, TimePoint lastFixAt, Regatta regatta, RegattaLeaderboard regattaLeaderboard, RaceColumn raceColumn, Fleet fleet) throws AllInOneImportException {
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        AbstractLogEventAuthor author = this.service.getServerAuthor();
        TimePoint startOfTracking = firstFixAt;
        TimePoint endOfTracking = lastFixAt;
        raceLog.add((AbstractLogEvent)new RaceLogStartOfTrackingEventImpl(startOfTracking, author, raceLog.getCurrentPassId()));
        raceLog.add((AbstractLogEvent)new RaceLogEndOfTrackingEventImpl(endOfTracking, author, raceLog.getCurrentPassId()));
        try {
            TimePoint startTrackingTimePoint = MillisecondsTimePoint.now();
            TimePoint denotationTimePoint = startTrackingTimePoint.minus(1L);
            raceLog.add((AbstractLogEvent)new RaceLogDenoteForTrackingEventImpl(denotationTimePoint, this.service.getServerAuthor(), raceLog.getCurrentPassId(), trackedRaceName, regatta.getBoatClass(), (Serializable)UUID.randomUUID()));
            raceLog.add((AbstractLogEvent)new RaceLogStartTrackingEventImpl(startTrackingTimePoint, author, raceLog.getCurrentPassId()));
            return this.trackRace(regattaLeaderboard, raceColumn, fleet);
        }
        catch (Exception e) {
            throw new AllInOneImportException(e, errors);
        }
    }

    private DynamicTrackedRace trackRace(RegattaLeaderboard regattaLeaderboard, RaceColumn raceColumn, Fleet fleet) throws NotDenotedForRaceLogTrackingException, Exception {
        RaceHandle raceHandle = this.adapter.startTracking(this.service, (Leaderboard)regattaLeaderboard, raceColumn, fleet, false, true, (RaceTrackingHandler)new PermissionAwareRaceTrackingHandler(this.securityService));
        raceHandle.getRace();
        DynamicTrackedRace trackedRace = (DynamicTrackedRace)WaitForTrackedRaceUtil.waitForTrackedRace((RaceColumn)raceColumn, (Fleet)fleet, (int)10);
        if (trackedRace == null) {
            throw new IllegalStateException("Could not obtain imported race");
        }
        return trackedRace;
    }

    private void ensureSuccessfulImport(ImportResult result, String errorMessage) throws AllInOneImportException {
        if (!result.getErrorList().isEmpty()) {
            throw new AllInOneImportException(errorMessage, result.getErrorList());
        }
    }

    private void ensureBoatClassDetermination(Regatta regatta) throws AllInOneImportException {
        if (regatta.getBoatClass() == null) {
            throw new AllInOneImportException(this.serverStringMessages.get(this.uiLocale, "allInOneErrorBoatClassDeterminationFailed"));
        }
    }

    public static class ImporterResult {
        final UUID eventId;
        final List<Util.Triple<String, String, String>> raceNameRaceColumnNameFleetnameList = new ArrayList<Util.Triple<String, String, String>>();
        final String leaderboardName;
        final String leaderboardGroupName;
        final String regattaName;
        final List<ImportResult.TrackImportDTO> importGpsFixData;
        final List<ImportResult.TrackImportDTO> importSensorFixData;
        final String sensorFixImporterType;
        final List<ImportResult.ErrorImportDTO> errorList = new ArrayList<ImportResult.ErrorImportDTO>();
        final ExpeditionStartData startData;

        public ImporterResult(String error) {
            this(null, "", "", "", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "", Collections.emptyList(), null);
            this.errorList.add(new ImportResult.ErrorImportDTO(error));
        }

        public ImporterResult(Throwable exception, List<ImportResult.ErrorImportDTO> additionalErrors) {
            this(null, "", "", "", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "", Collections.emptyList(), null);
            this.errorList.add(new ImportResult.ErrorImportDTO(exception.getClass().getName(), exception.getMessage()));
            if (additionalErrors != null) {
                this.errorList.addAll(additionalErrors);
            }
        }

        private ImporterResult(UUID eventId, String leaderboardName, String leaderboardGroupName, String regattaName, List<Util.Triple<String, String, String>> raceNameRaceColumnNameFleetnameList, List<ImportResult.TrackImportDTO> importGpsFixData, List<ImportResult.TrackImportDTO> importSensorFixData, String sensorFixImporterType, List<ImportResult.ErrorImportDTO> errors, ExpeditionStartData startData) {
            this.eventId = eventId;
            this.leaderboardName = leaderboardName;
            this.leaderboardGroupName = leaderboardGroupName;
            this.regattaName = regattaName;
            if (raceNameRaceColumnNameFleetnameList != null) {
                this.raceNameRaceColumnNameFleetnameList.addAll(raceNameRaceColumnNameFleetnameList);
            }
            this.importGpsFixData = importGpsFixData;
            this.importSensorFixData = importSensorFixData;
            this.sensorFixImporterType = sensorFixImporterType;
            this.errorList.addAll(errors);
            this.startData = startData;
        }
    }

    private static class TimePointsOfFirstAndLastFix {
        private final TimePoint firstFixAt;
        private final TimePoint lastFixAt;

        public TimePointsOfFirstAndLastFix(TimePoint firstFixAt, TimePoint lastFixAt) {
            this.firstFixAt = firstFixAt;
            this.lastFixAt = lastFixAt;
        }

        public TimePoint getFirstFixAt() {
            return this.firstFixAt;
        }

        public TimePoint getLastFixAt() {
            return this.lastFixAt;
        }
    }
}

