/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription;

import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookHandler;
import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookServlet;
import com.sap.sailing.server.gateway.subscription.chargebee.ChargebeeWebHookHandler;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubscriptionWebHookHandlerFactory {
    private static final Logger logger = Logger.getLogger(SubscriptionWebHookHandlerFactory.class.getName());
    private static SubscriptionWebHookHandlerFactory instance;
    private Map<String, Class<? extends SubscriptionWebHookHandler>> handlers = new HashMap<String, Class<? extends SubscriptionWebHookHandler>>();

    public static SubscriptionWebHookHandlerFactory getInstance() {
        if (instance == null) {
            instance = new SubscriptionWebHookHandlerFactory();
        }
        return instance;
    }

    private SubscriptionWebHookHandlerFactory() {
        this.registerSubscriptionHandlers();
    }

    public SubscriptionWebHookHandler getHandlerForPath(String path, SubscriptionWebHookServlet context) {
        Class<? extends SubscriptionWebHookHandler> handlerCls = this.handlers.get(path);
        SubscriptionWebHookHandler handler = null;
        if (handlerCls != null && (handler = this.createHandlerInstance(handlerCls)) != null) {
            handler.setServletContext(context);
        }
        return handler;
    }

    private void registerSubscriptionHandlers() {
        this.registerHandler(ChargebeeWebHookHandler.class);
    }

    private void registerHandler(Class<? extends SubscriptionWebHookHandler> handlerCls) {
        SubscriptionWebHookHandler inst = this.createHandlerInstance(handlerCls);
        if (inst != null) {
            this.handlers.put(inst.getHandlerPath(), handlerCls);
        }
    }

    private SubscriptionWebHookHandler createHandlerInstance(Class<? extends SubscriptionWebHookHandler> handlerCls) {
        SubscriptionWebHookHandler inst = null;
        try {
            Constructor<? extends SubscriptionWebHookHandler> cons = handlerCls.getConstructor(new Class[0]);
            inst = cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to create subscription webhook handler instance", e);
        }
        return inst;
    }
}

