/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.common.SharedLandscapeConstants;
import com.sap.sailing.server.gateway.dto.MasterDataImportResultImpl;
import com.sap.sailing.server.gateway.interfaces.MasterDataImportResult;
import com.sap.sailing.server.gateway.serialization.impl.DataImportProgressJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MasterDataImportResultJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.util.RemoteServerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.UnauthorizedException;
import org.json.simple.JSONObject;

@Path(value="/v1/masterdataimport")
public class MasterDataImportResource
extends AbstractSailingServerResource {
    public static final String PROGRESS_TRACKING_UUID = "progressTrackingUuid";
    public static final String V1_MASTERDATAIMPORT = "/v1/masterdataimport";
    public static final String PROGRESS = "/progress";
    public static final String REMOTE_SERVER_BEARER_TOKEN_FORM_PARAM = "remoteServerBearerToken";
    public static final String REMOTE_SERVER_PASSWORD_FORM_PARAM = "remoteServerPassword";
    public static final String REMOTE_SERVER_USERNAME_FORM_PARAM = "remoteServerUsername";
    public static final String REMOTE_SERVER_URL_FORM_PARAM = "remoteServerUrl";
    public static final String PROGRESS_TRACKING_UUID_FORM_PARAM = "progressTrackingUUID";
    private static final Logger logger = Logger.getLogger(MasterDataImportResource.class.getName());

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response importMasterData(@FormParam(value="remoteServerUrl") String remoteServerUrlAsString, @FormParam(value="remoteServerUsername") String remoteServerUsername, @FormParam(value="remoteServerPassword") String remoteServerPassword, @FormParam(value="remoteServerBearerToken") String remoteServerBearerToken, @FormParam(value="leaderboardgroupUUID[]") List<UUID> requestedLeaderboardGroupIds, @FormParam(value="override") @DefaultValue(value="false") Boolean override, @FormParam(value="compress") @DefaultValue(value="true") Boolean compress, @FormParam(value="exportWind") @DefaultValue(value="true") Boolean exportWind, @FormParam(value="exportDeviceConfigs") @DefaultValue(value="false") Boolean exportDeviceConfigs, @FormParam(value="exportTrackedRacesAndStartTracking") @DefaultValue(value="true") Boolean exportTrackedRacesAndStartTracking, @FormParam(value="progressTrackingUUID") String progressTrackingUuid) throws MalformedURLException {
        Response response = null;
        if (!Util.hasLength((String)remoteServerUrlAsString)) {
            response = this.badRequest("Remote server URL parameter remoteServerUrl must be present and non-empty");
        } else {
            URL url = RemoteServerUtil.createBaseUrl((String)remoteServerUrlAsString);
            if (!SharedLandscapeConstants.isTrustedDomain((String)url.getHost())) {
                response = this.badRequest("Untrusted domain for " + url);
            } else if (!this.validateAuthenticationParameters(remoteServerUsername, remoteServerPassword, remoteServerBearerToken)) {
                response = this.badRequest("Specify remoteServerUsername and remoteServerPassword or alternatively remoteServerBearerToken or none of them.");
            } else {
                UUID importMasterDataUid = progressTrackingUuid == null ? UUID.randomUUID() : UUID.fromString(progressTrackingUuid);
                try {
                    this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CAN_IMPORT_MASTERDATA);
                    Map eventsForLeaderboardGroups = this.getService().importMasterData(remoteServerUrlAsString, requestedLeaderboardGroupIds.toArray(new UUID[requestedLeaderboardGroupIds.size()]), override.booleanValue(), compress.booleanValue(), exportWind.booleanValue(), exportDeviceConfigs.booleanValue(), remoteServerUsername, remoteServerPassword, remoteServerBearerToken, exportTrackedRacesAndStartTracking.booleanValue(), importMasterDataUid);
                    MasterDataImportResultImpl result = new MasterDataImportResultImpl(eventsForLeaderboardGroups, remoteServerUrlAsString, override.booleanValue(), exportWind.booleanValue(), exportDeviceConfigs.booleanValue(), exportTrackedRacesAndStartTracking.booleanValue());
                    JSONObject jsonResponse = new MasterDataImportResultJsonSerializer().serialize((MasterDataImportResult)result);
                    response = Response.ok((Object)this.streamingOutput(jsonResponse)).build();
                }
                catch (UnauthorizedException e) {
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    logger.warning(String.valueOf(e.getMessage()) + " for user: " + this.getSecurityService().getCurrentUser());
                }
                catch (IllegalArgumentException e) {
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type("text/plain").build();
                    logger.warning(e.getMessage());
                }
                catch (Throwable e) {
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
                    logger.severe(e.toString());
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/progress")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getProgress(@QueryParam(value="progressTrackingUuid") String progressTrackingUuid) {
        Response response;
        try {
            this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CAN_IMPORT_MASTERDATA);
            DataImportProgress progress = this.getService().getDataImportLock().getProgress(UUID.fromString(progressTrackingUuid));
            if (progress == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("\"No progress found for progess tracking UUID " + progressTrackingUuid + "\"")).type("application/json").build();
            } else {
                JSONObject jsonResponse = new DataImportProgressJsonSerializer().serialize(progress);
                response = Response.ok((Object)this.streamingOutput(jsonResponse)).build();
            }
        }
        catch (UnauthorizedException e) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            logger.warning(String.valueOf(e.getMessage()) + " for user: " + this.getSecurityService().getCurrentUser());
        }
        return response;
    }
}

