/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.ShardTargetGroupName;
import com.sap.sse.landscape.aws.orchestration.ShardProcedure;
import com.sap.sse.shared.util.Wait;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PathPatternConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthStateEnum;

public class CreateShard<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ShardProcedure<ShardingKey, MetricsT, ProcessT> {
    private static int DEFAULT_INSTANCE_STARTUP_TIME = 180;
    private static final Logger logger = Logger.getLogger(ShardProcedure.class.getName());
    private final String targetGroupNamePrefix;

    public CreateShard(BuilderImpl<?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
        this.targetGroupNamePrefix = builder.getTargetGroupNamePrefix();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws Exception {
        if (this.shardName == null) {
            throw new Exception("Shardname is null, please enter a name");
        }
        ShardTargetGroupName name = this.replicaSet.getNewShardName(this.shardName, this.targetGroupNamePrefix);
        if (!this.isTargetGroupNameUnique(name.getTargetGroupName())) {
            throw new Exception("targetgroup name with this shardname is not unique. You may change the last or first two chars");
        }
        ApplicationLoadBalancer loadBalancer = this.getFreeLoadBalancerAndMoveReplicaSet();
        logger.info("Creating Targer group for Shard " + name + ". Inheriting from Replicaset: " + this.replicaSet.getName());
        TargetGroup targetGroup = this.getLandscape().createTargetGroupWithoutLoadbalancer(this.region, name.getTargetGroupName(), this.replicaSet.getMaster().getPort(), loadBalancer.getVpcId());
        this.getLandscape().addTargetGroupTag(targetGroup.getTargetGroupArn(), "shardname", name.getName(), this.region);
        AwsAutoScalingGroup autoScalingGroup = this.replicaSet.getAutoScalingGroup();
        logger.info("Creating Auto-Scaling Group for Shard " + this.shardName + ". Inheriting from Auto-Scaling Group: " + autoScalingGroup.getName());
        int minAutoscalingSize = this.getMinShardingStartInstanceNumber(autoScalingGroup);
        String newAutoscalingGroupName = this.getLandscape().createAutoScalingGroupFromExisting(autoScalingGroup, this.shardName, targetGroup, minAutoscalingSize, Optional.empty());
        if (loadBalancer == null) return;
        Iterable<Rule> rules = loadBalancer.getRules();
        if (Util.size(rules) >= 100 - this.numberOfRequiredRules(Util.size((Iterable)this.shardingKeys))) throw new Exception("Unexpected Error - Loadbalancer was null!");
        int rulePrio = this.getHighestAvailableIndex(rules);
        if (rulePrio <= 0) throw new Exception("Unexpected Error - No prio left?");
        Rule newRule = (Rule)Rule.builder().priority("" + rulePrio).conditions(new RuleCondition[]{loadBalancer.createHostHeaderRuleCondition(this.replicaSet.getHostname()), (RuleCondition)RuleCondition.builder().field("http-header").httpHeaderConfig(hhcb -> {
            HttpHeaderConditionConfig.Builder builder = hhcb.httpHeaderName("X-SAPSSE-Forward-Request-To").values(new String[]{(String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB()});
        }).build(), (RuleCondition)RuleCondition.builder().field("path-pattern").pathPatternConfig(ppc -> {
            PathPatternConditionConfig.Builder builder = ppc.values(new String[]{this.getPathConditionForShardingKey(this.SHARDING_KEY_UNUSED_BY_ANY_APPLICATION)});
        }).build()}).actions(new Action[]{(Action)Action.builder().forwardConfig((ForwardActionConfig)ForwardActionConfig.builder().targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build()}).build()).type(ActionTypeEnum.FORWARD).build()}).build();
        Iterable<Rule> newRuleSet = loadBalancer.addRules(newRule);
        this.getLandscape().putScalingPolicy(DEFAULT_INSTANCE_STARTUP_TIME, this.getLandscape().getAutoScalingGroupName(this.shardName), targetGroup, 15000, this.region);
        Wait.wait(() -> {
            boolean ret = true;
            Map healths = this.getLandscape().getTargetHealthDescriptions(targetGroup);
            if (healths.isEmpty() || healths.size() < minAutoscalingSize) {
                ret = false;
            } else {
                for (Map.Entry instance : healths.entrySet()) {
                    if (instance.getValue().state() == TargetHealthStateEnum.HEALTHY) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }, (Optional)Landscape.WAIT_FOR_HOST_TIMEOUT, (Duration)Duration.ONE_SECOND.times(30L), (Level)Level.INFO, (String)"Instances not yet healty");
        for (Rule r : newRuleSet) {
            loadBalancer.deleteRules(r);
        }
        Set<Object> shardingKeysToUse = this.shardingKeys.isEmpty() ? Collections.singleton(this.SHARDING_KEY_UNUSED_BY_ANY_APPLICATION) : this.shardingKeys;
        this.addShardingRules(loadBalancer, shardingKeysToUse, targetGroup);
        this.getLandscape().resetShardMinAutoscalingGroupSize(newAutoscalingGroupName, this.region);
    }

    protected int getMinShardingStartInstanceNumber(AwsAutoScalingGroup autoscalingGroupParent) {
        int currentMinSize = autoscalingGroupParent.getAutoScalingGroup().instances().size();
        return currentMinSize < 2 ? 2 : currentMinSize;
    }

    public static <MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, BuilderT extends Builder<BuilderT, CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey> Builder<BuilderT, CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> builder() {
        return new BuilderImpl();
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ShardProcedure.Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT> {
        public BuilderT setTargetGroupNamePrefix(String var1);
    }

    static class BuilderImpl<BuilderT extends Builder<BuilderT, CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ShardProcedure.BuilderImpl<BuilderT, CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>
    implements Builder<BuilderT, CreateShard<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> {
        private String targetGroupNamePrefix = "";

        BuilderImpl() {
        }

        String getTargetGroupNamePrefix() {
            return this.targetGroupNamePrefix;
        }

        @Override
        public BuilderT setTargetGroupNamePrefix(String targetGroupNamePrefix) {
            if (!ShardTargetGroupName.isValidTargetGroupNamePrefix((String)targetGroupNamePrefix)) {
                throw new IllegalArgumentException("Not a valid target group name prefix: " + targetGroupNamePrefix);
            }
            this.targetGroupNamePrefix = targetGroupNamePrefix;
            return (BuilderT)((Builder)this.self());
        }

        public CreateShard<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            assert (this.shardingKeys != null);
            assert (this.replicaSet != null);
            assert (this.region != null);
            return new CreateShard(this);
        }
    }
}

