/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.aws.AwsLandscapeOperation;
import com.sap.sse.landscape.aws.ReplicableAwsLandscapeState;
import com.sap.sse.landscape.aws.impl.SSHKeyPairListener;
import com.sap.sse.landscape.aws.persistence.DomainObjectFactory;
import com.sap.sse.landscape.aws.persistence.MongoObjectFactory;
import com.sap.sse.landscape.aws.persistence.PersistenceFactory;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AwsLandscapeStateImpl
extends AbstractReplicableWithObjectInputStream<ReplicableAwsLandscapeState, AwsLandscapeOperation<?>>
implements ReplicableAwsLandscapeState {
    private final MongoObjectFactory mongoObjectFactory;
    private ConcurrentMap<Util.Pair<String, String>, SSHKeyPair> sshKeyPairs;
    private final Set<SSHKeyPairListener> sshKeyPairListeners;

    public AwsLandscapeStateImpl() {
        this(PersistenceFactory.INSTANCE.getDomainObjectFactory(MongoDBService.INSTANCE), PersistenceFactory.INSTANCE.getMongoObjectFactory(MongoDBService.INSTANCE));
    }

    public AwsLandscapeStateImpl(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory) {
        this.mongoObjectFactory = mongoObjectFactory;
        this.sshKeyPairs = new ConcurrentHashMap<Util.Pair<String, String>, SSHKeyPair>();
        this.sshKeyPairListeners = new HashSet<SSHKeyPairListener>();
        for (SSHKeyPair keyPair : domainObjectFactory.loadSSHKeyPairs()) {
            this.addKeyPairToMap(keyPair);
        }
    }

    private void addKeyPairToMap(SSHKeyPair keyPair) {
        this.sshKeyPairs.put(this.getKey(keyPair), keyPair);
    }

    private Util.Pair<String, String> getKey(SSHKeyPair keyPair) {
        return new Util.Pair((Object)keyPair.getRegionId(), (Object)keyPair.getName());
    }

    @Override
    public void addSSHKeyPair(SSHKeyPair result) {
        this.apply((AwsLandscapeOperation & Serializable)s -> s.internalAddSSHKeyPair(result));
    }

    @Override
    public Void internalAddSSHKeyPair(SSHKeyPair keyPair) {
        for (SSHKeyPairListener sshKeyPairListener : this.sshKeyPairListeners) {
            sshKeyPairListener.sshKeyPairAdded(keyPair);
        }
        this.addKeyPairToMap(keyPair);
        this.mongoObjectFactory.storeSSHKeyPair(keyPair);
        return null;
    }

    @Override
    public void deleteKeyPair(String regionId, String keyName) {
        this.apply((AwsLandscapeOperation & Serializable)s -> s.internalDeleteKeyPair(regionId, keyName));
    }

    @Override
    public Void internalDeleteKeyPair(String regionId, String keyName) {
        SSHKeyPair removedKeyPair = (SSHKeyPair)this.sshKeyPairs.remove(new Util.Pair((Object)regionId, (Object)keyName));
        for (SSHKeyPairListener sshKeyPairListener : this.sshKeyPairListeners) {
            sshKeyPairListener.sshKeyPairRemoved(removedKeyPair);
        }
        this.mongoObjectFactory.removeSSHKeyPair(regionId, keyName);
        return null;
    }

    @Override
    public void addSSHKeyPairListener(SSHKeyPairListener listener) {
        this.sshKeyPairListeners.add(listener);
    }

    @Override
    public void removeSSHKeyPairListener(SSHKeyPairListener listener) {
        this.sshKeyPairListeners.remove(listener);
    }

    @Override
    public SSHKeyPair getSSHKeyPair(String regionId, String keyName) {
        return (SSHKeyPair)this.sshKeyPairs.get(new Util.Pair((Object)regionId, (Object)keyName));
    }

    @Override
    public Iterable<SSHKeyPair> getSSHKeyPairs() {
        return Collections.unmodifiableCollection(this.sshKeyPairs.values());
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.sshKeyPairs.clear();
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstCache<Object>(is, new Object(), null, classLoaderCache){};
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        Map sshKeyPairsReadFromStream = (Map)is.readObject();
        this.sshKeyPairs.putAll(sshKeyPairsReadFromStream);
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.sshKeyPairs);
    }
}

