/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedWithIDImpl;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.MachineImage;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.ApplicationProcessHost;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsLandscapeState;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.ReverseProxyCluster;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.impl.AmazonMachineImageImpl;
import com.sap.sse.landscape.aws.impl.ApacheReverseProxyCluster;
import com.sap.sse.landscape.aws.impl.ApplicationLoadBalancerImpl;
import com.sap.sse.landscape.aws.impl.AwsApplicationReplicaSetImpl;
import com.sap.sse.landscape.aws.impl.AwsAvailabilityZoneImpl;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.impl.AwsTargetGroupImpl;
import com.sap.sse.landscape.aws.impl.DNSCache;
import com.sap.sse.landscape.aws.impl.TagsImpl;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import com.sap.sse.landscape.aws.persistence.DomainObjectFactory;
import com.sap.sse.landscape.aws.persistence.MongoObjectFactory;
import com.sap.sse.landscape.aws.persistence.PersistenceFactory;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.MongoProcessInReplicaSet;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.DatabaseImpl;
import com.sap.sse.landscape.mongodb.impl.MongoProcessImpl;
import com.sap.sse.landscape.mongodb.impl.MongoProcessInReplicaSetImpl;
import com.sap.sse.landscape.mongodb.impl.MongoReplicaSetImpl;
import com.sap.sse.landscape.rabbitmq.RabbitMQEndpoint;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.acm.AcmAsyncClient;
import software.amazon.awssdk.services.acm.model.CertificateDetail;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.MetricType;
import software.amazon.awssdk.services.autoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.ResourceType;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Snapshot;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.iam.model.MFADevice;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsIterable;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.wafv2.Wafv2Client;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.Scope;

public class AwsLandscapeImpl<ShardingKey>
implements AwsLandscape<ShardingKey> {
    private static final String SSL_SECURITY_POLICY = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    private static final String AUTO_SCALING_GROUP_NAME_SUFFIX = "-auto-replicas";
    private static final String DEFAULT_TARGET_GROUP_PREFIX = "D";
    private static final Logger logger = Logger.getLogger(AwsLandscapeImpl.class.getName());
    public static final long DEFAULT_DNS_TTL_SECONDS = 60L;
    private static final String DEFAULT_CERTIFICATE_DOMAIN = "*.sapsailing.com";
    private static final String DEFAULT_NON_DNS_MAPPED_ALB_NAME = "DefDyn";
    private static final String SAILING_APP_SECURITY_GROUP_NAME = "Sailing Analytics App";
    private final String accessKeyId;
    private final String secretAccessKey;
    private final Optional<String> sessionToken;
    private final AwsRegion globalRegion;
    private final AwsLandscapeState landscapeState;
    private final String pathPrefixForShardingKey;
    private static final ConcurrentMap<String, Util.Pair<ResourceRecordSet, TimePoint>> reverseDNSCache = new ConcurrentHashMap<String, Util.Pair<ResourceRecordSet, TimePoint>>();
    private static final Duration MINIMUM_DNS_CACHE_TTL_FOR_NOT_FOUND_ENTRIES = Duration.ONE_SECOND.times(60L);
    private static TimePoint timePointOfLastDNSListing;
    private static final Object sequencer;

    static {
        sequencer = new Object();
    }

    public AwsLandscapeImpl(AwsLandscapeState awsLandscapeState, String pathPrefixForShardingKey) {
        this(awsLandscapeState, System.getProperty("com.sap.sse.landscape.aws.accesskeyid"), System.getProperty("com.sap.sse.landscape.aws.secretaccesskey"), pathPrefixForShardingKey);
    }

    public AwsLandscapeImpl(AwsLandscapeState awsLandscapeState, String accessKeyId, String secretAccessKey, String pathPrefixForShardingKey) {
        this(awsLandscapeState, accessKeyId, secretAccessKey, null, pathPrefixForShardingKey);
    }

    public AwsLandscapeImpl(AwsLandscapeState awsLandscapeState, String accessKeyId, String secretAccessKey, String sessionToken, String pathPrefixForShardingKey) {
        this(accessKeyId, secretAccessKey, sessionToken, PersistenceFactory.INSTANCE.getDomainObjectFactory(MongoDBService.INSTANCE), PersistenceFactory.INSTANCE.getMongoObjectFactory(MongoDBService.INSTANCE), awsLandscapeState, pathPrefixForShardingKey);
    }

    public AwsLandscapeImpl(String accessKeyId, String secretAccessKey, String sessionToken, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, AwsLandscapeState landscapeState, String pathPrefixForShardingKey) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = Optional.ofNullable(sessionToken);
        this.globalRegion = new AwsRegion(software.amazon.awssdk.regions.Region.AWS_GLOBAL, this);
        this.landscapeState = landscapeState;
        this.pathPrefixForShardingKey = pathPrefixForShardingKey;
    }

    private static byte[] getPrivateKeyBytes(KeyPair unencryptedKeyPair) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        unencryptedKeyPair.writePrivateKey((OutputStream)bos);
        return bos.toByteArray();
    }

    @Override
    public SSHKeyPair addSSHKeyPair(Region region, String creator, String keyName, KeyPair keyPairWithDecryptedPrivateKey) throws JSchException {
        assert (!keyPairWithDecryptedPrivateKey.isEncrypted());
        SSHKeyPair result = new SSHKeyPair(region.getId(), creator, TimePoint.now(), keyName, keyPairWithDecryptedPrivateKey.getPublicKeyBlob(), AwsLandscapeImpl.getPrivateKeyBytes(keyPairWithDecryptedPrivateKey));
        this.landscapeState.addSSHKeyPair(result);
        return result;
    }

    @Override
    public SSHKeyPair createKeyPair(Region region, String keyName, byte[] privateKeyEncryptionPassphrase) throws JSchException {
        Object principal;
        CreateKeyPairResponse keyPairResponse = this.getEc2Client(this.getRegion(region)).createKeyPair((CreateKeyPairRequest)CreateKeyPairRequest.builder().keyName(keyName).build());
        String keyMaterial = keyPairResponse.keyMaterial();
        try {
            principal = SessionUtils.getPrincipal();
        }
        catch (Exception e) {
            logger.severe("Problem determining current user: " + e.getMessage());
            principal = null;
        }
        byte[] privKey = keyMaterial.getBytes();
        KeyPair keyPair = KeyPair.load((JSch)new JSch(), (byte[])privKey, null);
        String creatorName = principal == null ? "" : principal.toString();
        ByteArrayOutputStream publicKeyBytes = new ByteArrayOutputStream();
        TimePoint now = TimePoint.now();
        keyPair.writePublicKey((OutputStream)publicKeyBytes, "public key " + keyName + " generated by user " + creatorName + " at " + now);
        SSHKeyPair result = new SSHKeyPair(region.getId(), creatorName, now, keyPairResponse.keyName(), publicKeyBytes.toByteArray(), privKey, privateKeyEncryptionPassphrase);
        this.landscapeState.addSSHKeyPair(result);
        return result;
    }

    private <B extends AwsClientBuilder<B, C>, C> C getClient(B clientBuilder, software.amazon.awssdk.regions.Region region) {
        return (C)clientBuilder.credentialsProvider(this::getCredentials).region(region).build();
    }

    private Ec2Client getEc2Client(software.amazon.awssdk.regions.Region region) {
        return (Ec2Client)this.getClient(Ec2Client.builder(), region);
    }

    private Ec2AsyncClient getEc2AsyncClient(software.amazon.awssdk.regions.Region region) {
        return (Ec2AsyncClient)this.getClient(Ec2AsyncClient.builder(), region);
    }

    private AcmAsyncClient getAcmAsyncClient(software.amazon.awssdk.regions.Region region) {
        return (AcmAsyncClient)this.getClient(AcmAsyncClient.builder(), region);
    }

    private ElasticLoadBalancingV2Client getLoadBalancingClient(software.amazon.awssdk.regions.Region region) {
        return (ElasticLoadBalancingV2Client)this.getClient(ElasticLoadBalancingV2Client.builder(), region);
    }

    private Wafv2Client getWafClient(software.amazon.awssdk.regions.Region region) {
        return (Wafv2Client)this.getClient(Wafv2Client.builder(), region);
    }

    private ElasticLoadBalancingV2AsyncClient getLoadBalancingAsyncClient(software.amazon.awssdk.regions.Region region) {
        return (ElasticLoadBalancingV2AsyncClient)this.getClient(ElasticLoadBalancingV2AsyncClient.builder(), region);
    }

    private AutoScalingClient getAutoScalingClient(software.amazon.awssdk.regions.Region region) {
        return (AutoScalingClient)this.getClient(AutoScalingClient.builder(), region);
    }

    private AutoScalingAsyncClient getAutoScalingAsyncClient(software.amazon.awssdk.regions.Region region) {
        return (AutoScalingAsyncClient)this.getClient(AutoScalingAsyncClient.builder(), region);
    }

    private String getS3BucketForAlbLogs(Region region) {
        String result = region.getId().equals(software.amazon.awssdk.regions.Region.EU_WEST_1.id()) ? "sapsailing-access-logs" : "sapsailing-access-logs-" + region.getId();
        return result;
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> createLoadBalancer(String name, Region region, SecurityGroup securityGroupForVpc) throws InterruptedException, ExecutionException {
        software.amazon.awssdk.regions.Region awsRegion = this.getRegion(region);
        ElasticLoadBalancingV2Client client = this.getLoadBalancingClient(awsRegion);
        Iterable<AwsAvailabilityZone> availabilityZones = this.getAvailabilityZones(region);
        SubnetMapping[] subnetMappings = (SubnetMapping[])Util.toArray((Iterable)Util.map(this.getSubnetsForAvailabilityZones(awsRegion, availabilityZones, securityGroupForVpc), subnet -> (SubnetMapping)SubnetMapping.builder().subnetId(subnet.subnetId()).build()), (Object[])new SubnetMapping[0]);
        CreateLoadBalancerResponse response = client.createLoadBalancer((CreateLoadBalancerRequest)CreateLoadBalancerRequest.builder().name(name).ipAddressType(IpAddressType.DUALSTACK).subnetMappings(subnetMappings).securityGroups(new String[]{this.getDefaultSecurityGroupForApplicationLoadBalancer(region).getId()}).build());
        client.modifyLoadBalancerAttributes(b -> {
            Object object = b.loadBalancerArn(((LoadBalancer)response.loadBalancers().iterator().next()).loadBalancerArn()).attributes(new LoadBalancerAttribute[]{(LoadBalancerAttribute)LoadBalancerAttribute.builder().key("access_logs.s3.enabled").value("true").build(), (LoadBalancerAttribute)LoadBalancerAttribute.builder().key("access_logs.s3.bucket").value(this.getS3BucketForAlbLogs(region)).build(), (LoadBalancerAttribute)LoadBalancerAttribute.builder().key("idle_timeout.timeout_seconds").value("4000").build()}).build();
        });
        ApplicationLoadBalancerImpl result = new ApplicationLoadBalancerImpl(region, (LoadBalancer)response.loadBalancers().iterator().next(), this);
        this.createLoadBalancerHttpListener(result);
        this.createLoadBalancerHttpsListener(result);
        this.getWafACLsByTagAndAssociateWithALB("web-acl-purpose", "geoblocking", result.getArn(), awsRegion);
        return result;
    }

    private void getWafACLsByTagAndAssociateWithALB(String tagKey, String tagValue, String albArn, software.amazon.awssdk.regions.Region region) {
        logger.info("Trying to find WAF ACLs with tag " + tagKey + "=" + tagValue + " to associate with ALB " + albArn + " in region " + region.id());
        Wafv2Client wafClient = this.getWafClient(region);
        ListWebAcLsResponse listResp = wafClient.listWebACLs(b -> {
            ListWebAcLsRequest.Builder builder = b.scope(Scope.REGIONAL);
        });
        listResp.webACLs().stream().filter(aclSummary -> wafClient.listTagsForResource(b -> {
            ListTagsForResourceRequest.Builder builder = b.resourceARN(aclSummary.arn());
        }).tagInfoForResource().tagList().stream().anyMatch(tag -> tag.key().equals(tagKey) && tag.value().equals(tagValue))).forEach(aclSummary -> {
            logger.info("Associating WAF ACL " + aclSummary.arn() + " with ALB " + albArn);
            wafClient.associateWebACL(b -> {
                AssociateWebAclRequest.Builder builder = b.webACLArn(aclSummary.arn()).resourceArn(albArn);
            });
        });
    }

    private Subnet getSubnetForAvailabilityZoneInSameVpcAsSecurityGroup(AwsAvailabilityZone az, SecurityGroup securityGroup, software.amazon.awssdk.regions.Region region) {
        Ec2Client ec2Client = this.getEc2Client(region);
        String vpcId = ((software.amazon.awssdk.services.ec2.model.SecurityGroup)ec2Client.describeSecurityGroups(b -> {
            DescribeSecurityGroupsRequest.Builder builder = b.groupIds(new String[]{securityGroup.getId()});
        }).securityGroups().iterator().next()).vpcId();
        return (Subnet)ec2Client.describeSubnets(b -> {
            DescribeSubnetsRequest.Builder builder = b.filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build(), (Filter)Filter.builder().name("availability-zone-id").values(new String[]{az.getId()}).build()});
        }).subnets().stream().filter(subnet -> !subnet.tags().stream().map(tag -> tag.key()).collect(Collectors.toList()).contains("noInstanceDeployment")).iterator().next();
    }

    private <MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> Listener createLoadBalancerHttpListener(ApplicationLoadBalancer<ShardingKey> alb) {
        return (Listener)this.getLoadBalancingClient(this.getRegion(alb.getRegion())).createListener(l -> l.loadBalancerArn(alb.getArn()).protocol(ProtocolEnum.HTTP).port(Integer.valueOf(80)).defaultActions(new Action[]{(Action)Action.builder().type(ActionTypeEnum.REDIRECT).redirectConfig(rcb -> {
            RedirectActionConfig.Builder builder = rcb.protocol(ProtocolEnum.HTTPS.name()).port("443").host("#{host}").path("/#{path}").query("#{query}").statusCode(RedirectActionStatusCodeEnum.HTTP_301);
        }).build()})).listeners().iterator().next();
    }

    private CompletableFuture<String> getDefaultCertificateArn(Region region, String domainName) {
        AcmAsyncClient acmClient = this.getAcmAsyncClient(this.getRegion(region));
        return acmClient.listCertificates(b -> {
            ListCertificatesRequest.Builder builder = b.certificateStatuses(new CertificateStatus[]{CertificateStatus.ISSUED});
        }).thenCompose(response -> {
            ArrayList certificateDetails = new ArrayList();
            response.certificateSummaryList().stream().filter(certificateSummary -> Util.equalsWithNull((Object)certificateSummary.domainName(), (Object)domainName)).forEach(certSummaryForDomain -> {
                boolean bl = certificateDetails.add(acmClient.describeCertificate(b -> {
                    DescribeCertificateRequest.Builder builder = b.certificateArn(certSummaryForDomain.certificateArn());
                }).thenApply(detailResponse -> detailResponse.certificate()));
            });
            CompletableFuture<Void> waitForCertificateDetails = CompletableFuture.allOf(certificateDetails.toArray(new CompletableFuture[0]));
            CompletionStage result = waitForCertificateDetails.thenApply(v -> certificateDetails.stream().map(cf -> {
                try {
                    return (CertificateDetail)cf.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException();
                }
            }).sorted((cd1, cd2) -> cd2.notAfter().compareTo(cd1.notAfter())).findFirst().map(cd -> cd.certificateArn()).get());
            return result;
        });
    }

    private <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> Listener createLoadBalancerHttpsListener(ApplicationLoadBalancer<ShardingKey> alb) throws InterruptedException, ExecutionException {
        CompletableFuture<String> defaultCertificateArnFuture = this.getDefaultCertificateArn(alb.getRegion(), DEFAULT_CERTIFICATE_DOMAIN);
        int httpPort = 80;
        int httpsPort = 443;
        ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> reverseProxy = this.getReverseProxyCluster(alb.getRegion());
        HashMap<String, String> tagKeyandValue = new HashMap<String, String>();
        tagKeyandValue.put("allReverseProxies", "");
        TargetGroup defaultTargetGroup = this.createTargetGroup(alb.getRegion(), DEFAULT_TARGET_GROUP_PREFIX + alb.getName() + "-" + ProtocolEnum.HTTP.name(), 80, reverseProxy.getHealthCheckPath(), 80, alb.getArn(), alb.getVpcId(), tagKeyandValue);
        this.setTargetGroupHealthCheckPath(defaultTargetGroup, reverseProxy.getTargetGroupHealthCheckPath(defaultTargetGroup.getTargetGroupArn()));
        defaultTargetGroup.addTargets(reverseProxy.getHosts());
        String defaultCertificateArn = defaultCertificateArnFuture.get();
        return (Listener)this.getLoadBalancingClient(this.getRegion(alb.getRegion())).createListener(l -> {
            l.loadBalancerArn(alb.getArn()).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).sslPolicy(SSL_SECURITY_POLICY).defaultActions(new Action[]{(Action)Action.builder().targetGroupArn(defaultTargetGroup.getTargetGroupArn()).type(ActionTypeEnum.FORWARD).forwardConfig(f -> {
                Object object = f.targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(defaultTargetGroup.getTargetGroupArn()).build()}).build();
            }).build()});
            l.certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(defaultCertificateArn).build()});
        }).listeners().iterator().next();
    }

    @Override
    public void deleteLoadBalancer(ApplicationLoadBalancer<ShardingKey> alb) {
        this.getLoadBalancingClient(this.getRegion(alb.getRegion())).deleteLoadBalancer((DeleteLoadBalancerRequest)DeleteLoadBalancerRequest.builder().loadBalancerArn(alb.getArn()).build());
    }

    @Override
    public Iterable<TargetGroup<ShardingKey>> getTargetGroupsByLoadBalancerArn(Region region, String loadBalancerArn) {
        return Util.map((Iterable)this.getLoadBalancingClient(this.getRegion(region)).describeTargetGroupsPaginator(tg -> {
            DescribeTargetGroupsRequest.Builder builder = tg.loadBalancerArn(loadBalancerArn);
        }).targetGroups(), tg -> this.createTargetGroup(this, region, tg.targetGroupName(), tg.targetGroupArn(), loadBalancerArn, tg.protocol(), tg.port(), tg.healthCheckProtocol(), AwsLandscapeImpl.getHealthCheckPort(tg), tg.healthCheckPath()));
    }

    private TargetGroup<ShardingKey> createTargetGroup(AwsLandscape<ShardingKey> landscape, Region region, String targetGroupName, String targetGroupArn, String loadBalancerArn, ProtocolEnum protocol, Integer port, ProtocolEnum healthCheckProtocol, Integer healthCheckPort, String healthCheckPath) {
        return new AwsTargetGroupImpl(this, region, targetGroupName, targetGroupArn, loadBalancerArn, protocol, port, healthCheckProtocol, healthCheckPort, healthCheckPath);
    }

    @Override
    public Iterable<TargetGroup<ShardingKey>> getTargetGroups(Region region) {
        return Util.map((Iterable)this.getLoadBalancingClient(this.getRegion(region)).describeTargetGroupsPaginator().targetGroups(), tg -> this.createTargetGroup(this, region, tg.targetGroupName(), tg.targetGroupArn(), tg.loadBalancerArns().isEmpty() ? null : (String)tg.loadBalancerArns().get(0), tg.protocol(), tg.port(), tg.healthCheckProtocol(), AwsLandscapeImpl.getHealthCheckPort(tg), tg.healthCheckPath()));
    }

    @Override
    public Iterable<Listener> getListeners(ApplicationLoadBalancer<ShardingKey> alb) {
        ElasticLoadBalancingV2Client client = this.getLoadBalancingClient(this.getRegion(alb.getRegion()));
        return client.describeListeners(b -> {
            DescribeListenersRequest.Builder builder = b.loadBalancerArn(alb.getArn());
        }).listeners();
    }

    @Override
    public LoadBalancerState getApplicationLoadBalancerStatus(ApplicationLoadBalancer<ShardingKey> alb) {
        ElasticLoadBalancingV2Client client = this.getLoadBalancingClient(this.getRegion(alb.getRegion()));
        DescribeLoadBalancersResponse response = client.describeLoadBalancers(b -> {
            DescribeLoadBalancersRequest.Builder builder = b.loadBalancerArns(new String[]{alb.getArn()});
        });
        return ((LoadBalancer)response.loadBalancers().iterator().next()).state();
    }

    @Override
    public Iterable<Rule> getLoadBalancerListenerRules(Listener loadBalancerListener, Region region) {
        return this.getLoadBalancingClient(this.getRegion(region)).describeRules(b -> {
            DescribeRulesRequest.Builder builder = b.listenerArn(loadBalancerListener.listenerArn());
        }).rules();
    }

    @Override
    public Iterable<Rule> modifyRuleConditions(Region region, Rule rule) {
        ModifyRuleResponse res = this.getLoadBalancingClient(this.getRegion(region)).modifyRule(t -> {
            Object object = t.conditions((Collection)rule.conditions()).ruleArn(rule.ruleArn()).build();
        });
        return res.rules();
    }

    @Override
    public Iterable<Rule> createLoadBalancerListenerRules(Region region, Listener loadBalancerListenerToAddRuleTo, Rule ... rulesToAdd) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        Rule[] ruleArray = rulesToAdd;
        int n = rulesToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            result.add((Rule)this.getLoadBalancingClient(this.getRegion(region)).createRule(b -> {
                CreateRuleRequest.Builder builder = b.listenerArn(loadBalancerListenerToAddRuleTo.listenerArn()).conditions((Collection)rule.conditions()).priority(Integer.valueOf(rule.priority())).actions((Collection)rule.actions());
            }).rules().iterator().next());
            ++n2;
        }
        return result;
    }

    @Override
    public void deleteLoadBalancerListenerRules(Region region, Rule ... rulesToDelete) {
        logger.info("Removing load balancer rules " + Util.joinStrings((String)", ", Arrays.asList(rulesToDelete)) + " in region " + region);
        Rule[] ruleArray = rulesToDelete;
        int n = rulesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            this.getLoadBalancingClient(this.getRegion(region)).deleteRule(b -> {
                DeleteRuleRequest.Builder builder = b.ruleArn(rule.ruleArn());
            });
            ++n2;
        }
    }

    @Override
    public void updateLoadBalancerListenerRule(Region region, Rule ruleToUpdate) {
        this.getLoadBalancingClient(this.getRegion(region)).modifyRule(b -> {
            ModifyRuleRequest.Builder builder = b.ruleArn(ruleToUpdate.ruleArn()).actions((Collection)ruleToUpdate.actions()).conditions((Collection)ruleToUpdate.conditions());
        });
    }

    @Override
    public void updateLoadBalancerListenerRulePriorities(Region region, Iterable<RulePriorityPair> newRulePriorities) {
        this.getLoadBalancingClient(this.getRegion(region)).setRulePriorities((SetRulePrioritiesRequest)SetRulePrioritiesRequest.builder().rulePriorities((Collection)Util.asList(newRulePriorities)).build());
    }

    @Override
    public void deleteLoadBalancerListener(Region region, Listener listener) {
        this.getLoadBalancingClient(this.getRegion(region)).deleteListener(b -> {
            DeleteListenerRequest.Builder builder = b.listenerArn(listener.listenerArn());
        });
    }

    private Iterable<Subnet> getSubnetsForAvailabilityZones(software.amazon.awssdk.regions.Region region, Iterable<AwsAvailabilityZone> azs, SecurityGroup securityGroupForVpc) {
        Ec2Client ec2Client = this.getEc2Client(region);
        Optional<String> securityGroupVpcId = Optional.ofNullable(securityGroupForVpc).map(sg -> ((software.amazon.awssdk.services.ec2.model.SecurityGroup)ec2Client.describeSecurityGroups(b -> {
            DescribeSecurityGroupsRequest.Builder builder = b.groupIds(new String[]{sg.getId()});
        }).securityGroups().get(0)).vpcId());
        return Util.filter((Iterable)ec2Client.describeSubnets().subnets(), subnet -> securityGroupVpcId.map(vpcId -> vpcId.equals(subnet.vpcId())).orElse(subnet.defaultForAz()) != false && Util.contains((Iterable)Util.map((Iterable)azs, az -> az.getId()), (Object)subnet.availabilityZoneId()) && subnet.tags().stream().map(tag -> tag.key()).filter(key -> key.equals("noInstanceDeployment")).count() == 0L);
    }

    @Override
    public AwsAvailabilityZone getAvailabilityZoneByName(Region region, String availabilityZoneName) {
        AvailabilityZone awsAz = (AvailabilityZone)this.getEc2Client(this.getRegion(region)).describeAvailabilityZones((DescribeAvailabilityZonesRequest)DescribeAvailabilityZonesRequest.builder().zoneNames(new String[]{availabilityZoneName}).build()).availabilityZones().iterator().next();
        return new AwsAvailabilityZoneImpl(awsAz, this);
    }

    @Override
    public Iterable<ApplicationLoadBalancer<ShardingKey>> getLoadBalancers(Region region) {
        List loadBalancers = this.getLoadBalancingClient(this.getRegion(region)).describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().build()).loadBalancers();
        return Util.map((Iterable)loadBalancers, lb -> new ApplicationLoadBalancerImpl(region, (LoadBalancer)lb, this));
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancerByName(String loadBalancerNameLowercase, Region region) {
        try {
            DescribeLoadBalancersResponse response = this.getLoadBalancingClient(this.getRegion(region)).describeLoadBalancers();
            return response.hasLoadBalancers() ? (ApplicationLoadBalancer)response.loadBalancers().stream().filter(lb -> Util.equalsWithNull((String)loadBalancerNameLowercase, (String)lb.loadBalancerName(), (boolean)true)).findFirst().map(lb -> new ApplicationLoadBalancerImpl(region, (LoadBalancer)lb, this)).orElse(null) : null;
        }
        catch (LoadBalancerNotFoundException e) {
            return null;
        }
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer(String loadBalancerArn, Region region) {
        LoadBalancer loadBalancer = (LoadBalancer)this.getLoadBalancingClient(this.getRegion(region)).describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{loadBalancerArn}).build()).loadBalancers().iterator().next();
        return new ApplicationLoadBalancerImpl(region, loadBalancer, this);
    }

    @Override
    public Instance getInstance(String instanceId, Region region) {
        return (Instance)((Reservation)this.getEc2Client(this.getRegion(region)).describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build()).reservations().iterator().next()).instances().iterator().next();
    }

    @Override
    public Instance getInstanceByPublicIpAddress(Region region, String publicIpAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(publicIpAddress);
            return (Instance)((Reservation)this.getEc2Client(this.getRegion(region)).describeInstances(b -> {
                DescribeInstancesRequest.Builder builder = b.filters(new Filter[]{(Filter)Filter.builder().name("ip-address").values(new String[]{inetAddress.getHostAddress()}).build()});
            }).reservations().iterator().next()).instances().iterator().next();
        }
        catch (UnknownHostException e) {
            logger.warning("IP address for " + publicIpAddress + " not found");
            return null;
        }
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByPublicIpAddress(Region region, String publicIpAddress, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHost(region, this.getInstanceByPublicIpAddress(region, publicIpAddress), hostSupplier);
    }

    @Override
    public Instance getInstanceByPrivateIpAddress(Region region, String privateIpAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(privateIpAddress);
            return (Instance)((Reservation)this.getEc2Client(this.getRegion(region)).describeInstances(b -> {
                DescribeInstancesRequest.Builder builder = b.filters(new Filter[]{(Filter)Filter.builder().name("private-ip-address").values(new String[]{inetAddress.getHostAddress()}).build()});
            }).reservations().iterator().next()).instances().iterator().next();
        }
        catch (UnknownHostException | NoSuchElementException e) {
            logger.warning("IP address for " + privateIpAddress + " not found");
            return null;
        }
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByPrivateIpAddress(Region region, String privateIpAddress, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHost(region, this.getInstanceByPrivateIpAddress(region, privateIpAddress), hostSupplier);
    }

    private Route53Client getRoute53Client() {
        return (Route53Client)this.getClient(Route53Client.builder(), this.getRegion(this.globalRegion));
    }

    private Route53AsyncClient getRoute53AsyncClient() {
        return (Route53AsyncClient)this.getClient(Route53AsyncClient.builder(), this.getRegion(this.globalRegion));
    }

    @Override
    public ChangeInfo setDNSRecordToHost(String hostedZoneId, String hostname, Host host, boolean force) {
        String ipAddressAsString = host.getPublicAddress().getHostAddress();
        return this.setDNSRecordToValue(hostedZoneId, hostname, ipAddressAsString, false);
    }

    @Override
    public ChangeInfo setDNSRecordToApplicationLoadBalancer(String hostedZoneId, String hostname, ApplicationLoadBalancer<ShardingKey> alb, boolean force) {
        String dnsName = alb.getDNSName();
        return this.setDNSRecord(hostedZoneId, hostname, RRType.CNAME, dnsName, force);
    }

    @Override
    public ChangeInfo setDNSRecordToValue(String hostedZoneId, String hostname, String value, boolean force) {
        return this.setDNSRecord(hostedZoneId, hostname, RRType.A, value, force);
    }

    @Override
    public String getDNSHostedZoneId(String hostedZoneName) {
        return ((HostedZone)this.getRoute53Client().listHostedZonesByName(b -> {
            ListHostedZonesByNameRequest.Builder builder = b.dnsName(hostedZoneName);
        }).hostedZones().iterator().next()).id().replaceFirst("^\\/hostedzone\\/", "");
    }

    private ChangeInfo setDNSRecord(String hostedZoneId, String hostname, RRType type, String value, boolean force) {
        Route53Client route53Client = this.getRoute53Client();
        ListResourceRecordSetsIterable existingResourceRecordSets = route53Client.listResourceRecordSetsPaginator(b -> {
            ListResourceRecordSetsRequest.Builder builder = b.hostedZoneId(hostedZoneId).startRecordName(hostname);
        });
        HashSet<String> oldValues = new HashSet<String>();
        boolean foundEqualValueForHostname = false;
        if (!force) {
            block0: for (ListResourceRecordSetsResponse rrrs : existingResourceRecordSets) {
                for (ResourceRecordSet rrs : rrrs.resourceRecordSets()) {
                    if (!AwsLandscape.removeTrailingDotFromHostname(rrs.name()).toLowerCase().equals(hostname.toLowerCase())) continue;
                    for (ResourceRecord rr : rrs.resourceRecords()) {
                        if (rr.value().equals(value)) {
                            foundEqualValueForHostname = true;
                            break block0;
                        }
                        oldValues.add(rr.value());
                    }
                }
            }
            if (!foundEqualValueForHostname && !oldValues.isEmpty()) {
                throw new IllegalStateException("A resource record set named " + hostname + " already exists in hosted zone " + hostedZoneId + ", its values " + oldValues + " do not contain the desired value " + value + " and the \"force\" option was not set");
            }
        }
        ChangeResourceRecordSetsResponse response = route53Client.changeResourceRecordSets((ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(hostedZoneId).changeBatch((ChangeBatch)ChangeBatch.builder().changes(new Change[]{(Change)Change.builder().action(ChangeAction.UPSERT).resourceRecordSet((ResourceRecordSet)ResourceRecordSet.builder().name(hostname.toLowerCase()).type(type).ttl(Long.valueOf(60L)).resourceRecords(new ResourceRecord[]{(ResourceRecord)ResourceRecord.builder().value(value).build()}).build()).build()}).build()).build());
        return response.changeInfo();
    }

    @Override
    public ChangeInfo removeDNSRecord(String hostedZoneId, String hostname, String value) {
        return this.removeDNSRecord(hostedZoneId, hostname, RRType.A, value);
    }

    @Override
    public ChangeInfo removeDNSRecord(String hostedZoneId, String hostname, RRType type, String value) {
        return this.getRoute53Client().changeResourceRecordSets((ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(hostedZoneId).changeBatch((ChangeBatch)ChangeBatch.builder().changes(new Change[]{(Change)Change.builder().action(ChangeAction.DELETE).resourceRecordSet((ResourceRecordSet)ResourceRecordSet.builder().name(hostname).type(type).ttl(Long.valueOf(60L)).resourceRecords(new ResourceRecord[]{(ResourceRecord)ResourceRecord.builder().value(value).build()}).build()).build()}).build()).build()).changeInfo();
    }

    @Override
    public ChangeInfo getUpdatedChangeInfo(ChangeInfo changeInfo) {
        return this.getRoute53Client().getChange((GetChangeRequest)GetChangeRequest.builder().id(changeInfo.id()).build()).changeInfo();
    }

    @Override
    public AmazonMachineImage<ShardingKey> getImage(Region region, String imageId) {
        DescribeImagesResponse response = this.getEc2Client(this.getRegion(region)).describeImages((DescribeImagesRequest)DescribeImagesRequest.builder().imageIds(new String[]{imageId}).build());
        return new AmazonMachineImageImpl((Image)response.images().iterator().next(), region, this);
    }

    @Override
    public AmazonMachineImage<ShardingKey> createImage(AwsInstance<ShardingKey> instance, String imageName, Optional<Tags> tags) {
        logger.info("Creating Amazon Machine Image (AMI) named " + imageName + " for instance " + instance.getInstanceId());
        Ec2Client client = this.getEc2Client(this.getRegion(instance.getRegion()));
        String imageId = client.createImage(b -> {
            CreateImageRequest.Builder builder = b.instanceId(instance.getInstanceId()).name(imageName);
        }).imageId();
        CreateTagsRequest.Builder createTagsRequestBuilder = CreateTagsRequest.builder().resources(new String[]{imageId});
        tags.ifPresent(t -> t.forEach(tag -> {
            CreateTagsRequest.Builder builder2 = createTagsRequestBuilder.tags(new software.amazon.awssdk.services.ec2.model.Tag[]{(software.amazon.awssdk.services.ec2.model.Tag)software.amazon.awssdk.services.ec2.model.Tag.builder().key((String)tag.getKey()).value((String)tag.getValue()).build()});
        }));
        client.createTags((CreateTagsRequest)createTagsRequestBuilder.build());
        return this.getImage(instance.getRegion(), imageId);
    }

    @Override
    public void deleteImage(Region region, String imageId) {
        this.getEc2Client(this.getRegion(region)).deregisterImage(b -> {
            DeregisterImageRequest.Builder builder = b.imageId(imageId);
        });
    }

    @Override
    public AmazonMachineImage<ShardingKey> getLatestImageWithTag(Region region, String tagName, String tagValue) {
        DescribeImagesResponse response = this.getEc2Client(this.getRegion(region)).describeImages((DescribeImagesRequest)DescribeImagesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("tag:" + tagName).values(new String[]{tagValue}).build(), (Filter)Filter.builder().name("state").values(new String[]{"available"}).build()}).build());
        return new AmazonMachineImageImpl(response.images().stream().max(this.getMachineImageCreationDateComparator()).get(), region, this);
    }

    @Override
    public Iterable<AmazonMachineImage<ShardingKey>> getAllImagesWithTag(Region region, String tagName, String tagValue) {
        DescribeImagesResponse response = this.getEc2Client(this.getRegion(region)).describeImages((DescribeImagesRequest)DescribeImagesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("tag:" + tagName).values(new String[]{tagValue}).build()}).build());
        return Util.map((Iterable)response.images(), image -> new AmazonMachineImageImpl((Image)image, region, this));
    }

    @Override
    public Iterable<String> getMachineImageTypes(Region region) {
        DescribeImagesResponse response = this.getEc2Client(this.getRegion(region)).describeImages((DescribeImagesRequest)DescribeImagesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("tag-key").values(new String[]{"image-type"}).build()}).build());
        HashSet<String> result = new HashSet<String>();
        Util.addAll((Iterable)Util.map((Iterable)response.images(), image -> image.tags().stream().filter(t -> t.key().equals("image-type")).findAny().get().value()), result);
        return result;
    }

    @Override
    public void setSnapshotName(Region region, String snapshotId, String snapshotName) {
        this.getEc2Client(this.getRegion(region)).createTags(b -> {
            CreateTagsRequest.Builder builder = b.resources(new String[]{snapshotId}).tags(new software.amazon.awssdk.services.ec2.model.Tag[]{(software.amazon.awssdk.services.ec2.model.Tag)software.amazon.awssdk.services.ec2.model.Tag.builder().key("Name").value(snapshotName).build()});
        });
    }

    @Override
    public void deleteSnapshot(Region region, String snapshotId) {
        this.getEc2Client(this.getRegion(region)).deleteSnapshot(b -> {
            DeleteSnapshotRequest.Builder builder = b.snapshotId(snapshotId);
        });
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getHostsWithTagValue(Region region, String tagName, String tagValue, HostSupplier<ShardingKey, HostT> hostSupplier) {
        Filter filter = (Filter)this.getHostsWithTagValueFilter(Filter.builder(), tagName, tagValue).build();
        return this.getHostsWithFilters(region, hostSupplier, filter);
    }

    private Filter.Builder getHostsWithTagValueFilter(Filter.Builder builder, String tagName, String tagValue) {
        return builder.name("tag:" + tagName).values(new String[]{tagValue});
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getRunningHostsWithTagValue(Region region, String tagName, String tagValue, HostSupplier<ShardingKey, HostT> hostSupplier) {
        Filter tagFilter = (Filter)this.getHostsWithTagValueFilter(Filter.builder(), tagName, tagValue).build();
        Filter runningFilter = this.getRunningHostsFilter();
        return this.getHostsWithFilters(region, hostSupplier, tagFilter, runningFilter);
    }

    private Filter getRunningHostsFilter() {
        return (Filter)this.getRunningHostsFilter(Filter.builder()).build();
    }

    private Filter.Builder getRunningHostsFilter(Filter.Builder builder) {
        return builder.name("instance-state-name").values(new String[]{"running"});
    }

    private <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getHostsWithFilters(Region region, HostSupplier<ShardingKey, HostT> hostSupplier, Filter ... filters) {
        ArrayList<HostT> result = new ArrayList<HostT>();
        DescribeInstancesResponse instanceResponse = this.getEc2Client(this.getRegion(region)).describeInstances(b -> {
            DescribeInstancesRequest.Builder builder = b.filters(filters);
        });
        for (Reservation r : instanceResponse.reservations()) {
            for (Instance i : r.instances()) {
                result.add(this.getHost(region, i, hostSupplier));
            }
        }
        return result;
    }

    private <HostT extends AwsInstance<ShardingKey>> HostT getHost(Region region, Instance instance, HostSupplier<ShardingKey, HostT> hostSupplier) {
        try {
            return hostSupplier.supply(instance.instanceId(), this.getAvailabilityZoneByName(region, instance.placement().availabilityZone()), InetAddress.getByName(instance.privateIpAddress()), TimePoint.of((long)instance.launchTime().toEpochMilli()), this);
        }
        catch (UnknownHostException e) {
            logger.warning("This shouldn't have occurred. " + instance.privateIpAddress() + " was expected to be parsable by InetAddress.getByName(...) but it wasn't.");
            throw new RuntimeException(e);
        }
    }

    private <HostT extends AwsInstance<ShardingKey>> HostT getHost(Region region, String instanceId, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHost(region, this.getInstance(instanceId, region), hostSupplier);
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByInstanceId(Region region, String instanceId, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHost(region, instanceId, hostSupplier);
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getRunningHostsWithTag(Region region, String tagName, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHostsWithFilters(region, hostSupplier, this.getFilterForHostWithTag(Filter.builder(), tagName), this.getRunningHostsFilter());
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getHostsWithTag(Region region, String tagName, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getHostsWithFilters(region, hostSupplier, this.getFilterForHostWithTag(Filter.builder(), tagName));
    }

    private Filter getFilterForHostWithTag(Filter.Builder builder, String tagName) {
        return (Filter)builder.name("tag-key").values(new String[]{tagName}).build();
    }

    private Comparator<? super Image> getMachineImageCreationDateComparator() {
        return (ami1, ami2) -> ami1.creationDate().compareTo(ami2.creationDate());
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.sessionToken.map(nonEmptySessionToken -> AwsSessionCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey, (String)nonEmptySessionToken)).orElse((AwsCredentials)AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey));
    }

    @Override
    public Credentials getMfaSessionCredentials(String nonEmptyMfaTokenCode) {
        AwsBasicCredentials basicCredentials = AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey);
        List mfaDevices = ((IamClient)((IamClientBuilder)((IamClientBuilder)IamClient.builder().region(software.amazon.awssdk.regions.Region.AWS_GLOBAL)).credentialsProvider(() -> basicCredentials)).build()).listMFADevices().mfaDevices();
        logger.info("Found the following MFA devices: " + Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)mfaDevices, d -> d.serialNumber())));
        String serialNumberOfMfaDevice = ((MFADevice)mfaDevices.iterator().next()).serialNumber();
        logger.info("Found MFA device " + serialNumberOfMfaDevice + "; using MFA token code " + nonEmptyMfaTokenCode);
        Credentials result = ((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(software.amazon.awssdk.regions.Region.AWS_GLOBAL)).credentialsProvider(() -> basicCredentials)).build()).getSessionToken(b -> {
            GetSessionTokenRequest.Builder builder = b.tokenCode(nonEmptyMfaTokenCode).serialNumber(serialNumberOfMfaDevice);
        }).credentials();
        logger.info("Produced valid MFA session credentials for access key ID " + result.accessKeyId());
        return result;
    }

    @Override
    public KeyPairInfo getKeyPairInfo(Region region, String keyName) {
        return (KeyPairInfo)this.getEc2Client(this.getRegion(region)).describeKeyPairs((DescribeKeyPairsRequest)DescribeKeyPairsRequest.builder().keyNames(new String[]{keyName}).build()).keyPairs().iterator().next();
    }

    @Override
    public Iterable<KeyPairInfo> getAllKeyPairInfos(Region region) {
        return this.getEc2Client(this.getRegion(region)).describeKeyPairs((DescribeKeyPairsRequest)DescribeKeyPairsRequest.builder().build()).keyPairs();
    }

    @Override
    public void deleteKeyPair(Region region, String keyName) {
        this.getEc2Client(this.getRegion(region)).deleteKeyPair((DeleteKeyPairRequest)DeleteKeyPairRequest.builder().keyName(keyName).build());
        this.landscapeState.deleteKeyPair(region.getId(), keyName);
    }

    @Override
    public SSHKeyPair importKeyPair(Region region, byte[] publicKey, byte[] encryptedPrivateKey, String keyName) throws JSchException {
        Object principal;
        if (!KeyPair.load((JSch)new JSch(), (byte[])encryptedPrivateKey, (byte[])publicKey).isEncrypted()) {
            throw new IllegalArgumentException("Expected an encrypted private key");
        }
        try {
            this.getEc2Client(this.getRegion(region)).importKeyPair((ImportKeyPairRequest)ImportKeyPairRequest.builder().keyName(keyName).publicKeyMaterial(SdkBytes.fromByteArray((byte[])publicKey)).build());
        }
        catch (Exception e) {
            if (e.getMessage().contains("The keypair ") && e.getMessage().contains("already exists")) {
                logger.info("A key named " + keyName + " already exists in the AWS region " + region.getId() + ". No problem; trying to import into this landscape.");
            }
            logger.info("Error trying to import a public key into the landscape: " + e.getMessage());
            throw e;
        }
        try {
            principal = SessionUtils.getPrincipal();
        }
        catch (Exception e) {
            logger.severe("Couldn't find current user; continuing anonymously");
            principal = null;
        }
        SSHKeyPair keyPair = new SSHKeyPair(region.getId(), principal == null ? "" : principal.toString(), TimePoint.now(), keyName, publicKey, encryptedPrivateKey);
        this.landscapeState.addSSHKeyPair(keyPair);
        return keyPair;
    }

    @Override
    public SSHKeyPair getSSHKeyPair(Region region, String keyName) {
        return this.landscapeState.getSSHKeyPair(region.getId(), keyName);
    }

    @Override
    public Iterable<SSHKeyPair> getSSHKeyPairs() {
        return this.landscapeState.getSSHKeyPairs();
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> launchHosts(HostSupplier<ShardingKey, HostT> hostSupplier, int numberOfHostsToLaunch, MachineImage fromImage, InstanceType instanceType, AwsAvailabilityZone az, String keyName, Iterable<SecurityGroup> securityGroups, Optional<Tags> tags, String ... userData) {
        if (!fromImage.getRegion().equals(az.getRegion())) {
            throw new IllegalArgumentException("Trying to launch an instance in region " + az.getRegion() + " with image " + fromImage + " that lives in region " + fromImage.getRegion() + " which is different." + " Consider copying the image to that region.");
        }
        Ec2Client ec2Client = this.getEc2Client(this.getRegion(az.getRegion()));
        RunInstancesRequest.Builder runInstancesRequestBuilder = RunInstancesRequest.builder().additionalInfo("Test " + this.getClass().getName()).imageId(fromImage.getId().toString()).minCount(Integer.valueOf(numberOfHostsToLaunch)).maxCount(Integer.valueOf(numberOfHostsToLaunch)).instanceType(instanceType).keyName(keyName).subnetId(this.getSubnetForAvailabilityZoneInSameVpcAsSecurityGroup(az, securityGroups.iterator().next(), this.getRegion(az.getRegion())).subnetId()).placement((Placement)Placement.builder().availabilityZone(az.getName()).build()).securityGroupIds((Collection)Util.mapToArrayList(securityGroups, SecurityGroup::getId));
        if (userData != null) {
            runInstancesRequestBuilder.userData(Base64.getEncoder().encodeToString(String.join((CharSequence)"\n", userData).getBytes()));
        }
        tags.ifPresent(theTags -> {
            Collection<software.amazon.awssdk.services.ec2.model.Tag> awsTags = this.getAwsTags((Tags)theTags);
            runInstancesRequestBuilder.tagSpecifications(new TagSpecification[]{(TagSpecification)TagSpecification.builder().resourceType(ResourceType.INSTANCE).tags(awsTags).build()});
        });
        RunInstancesRequest launchRequest = (RunInstancesRequest)runInstancesRequestBuilder.build();
        logger.info("Launching instance(s): " + launchRequest);
        RunInstancesResponse response = ec2Client.runInstances(launchRequest);
        ArrayList<HostT> result = new ArrayList<HostT>();
        for (Instance instance : response.instances()) {
            try {
                result.add(hostSupplier.supply(instance.instanceId(), az, InetAddress.getByName(instance.privateIpAddress()), TimePoint.of((long)instance.launchTime().toEpochMilli()), this));
            }
            catch (UnknownHostException e) {
                logger.warning("This shouldn't have occurred. " + instance.privateIpAddress() + " was expected to be parsable by InetAddress.getByName(...) but it wasn't.");
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private Collection<software.amazon.awssdk.services.ec2.model.Tag> getAwsTags(Tags tags) {
        ArrayList<software.amazon.awssdk.services.ec2.model.Tag> awsTags = new ArrayList<software.amazon.awssdk.services.ec2.model.Tag>();
        for (Map.Entry tag : tags) {
            awsTags.add((software.amazon.awssdk.services.ec2.model.Tag)software.amazon.awssdk.services.ec2.model.Tag.builder().key((String)tag.getKey()).value((String)tag.getValue()).build());
        }
        return awsTags;
    }

    @Override
    public void terminate(AwsInstance<ShardingKey> host) {
        logger.info("Terminating instance " + host);
        this.getEc2Client(this.getRegion(host.getAvailabilityZone().getRegion())).terminateInstances((TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(new String[]{host.getInstanceId()}).build());
    }

    private software.amazon.awssdk.regions.Region getRegion(Region region) {
        return software.amazon.awssdk.regions.Region.of((String)region.getId());
    }

    public static Integer getHealthCheckPort(software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup targetGroup) {
        return targetGroup.healthCheckPort() == null ? null : (targetGroup.healthCheckPort().equals("traffic-port") ? targetGroup.port() : Integer.valueOf(targetGroup.healthCheckPort()));
    }

    @Override
    public Iterable<AwsAvailabilityZone> getAvailabilityZones(Region awsRegion) {
        return this.getAvailabilityZones(awsRegion, Optional.empty());
    }

    @Override
    public Iterable<AwsAvailabilityZone> getAvailabilityZones(Region awsRegion, Optional<String> vpcId) {
        Ec2Client ec2Client = this.getEc2Client(this.getRegion(awsRegion));
        return ec2Client.describeSubnets(b -> vpcId.ifPresent(theVpcId -> {
            DescribeSubnetsRequest.Builder builder2 = b.filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{theVpcId}).build()});
        })).subnets().stream().map(subnet -> this.getAvailabilityZoneByName(awsRegion, subnet.availabilityZone())).distinct().collect(Collectors.toList());
    }

    @Override
    public TargetGroup<ShardingKey> getTargetGroup(Region region, String targetGroupName, String loadBalancerArn) {
        ElasticLoadBalancingV2Client loadBalancingClient = this.getLoadBalancingClient(this.getRegion(region));
        DescribeTargetGroupsResponse targetGroupResponse = loadBalancingClient.describeTargetGroups(b -> {
            DescribeTargetGroupsRequest.Builder builder = b.names(new String[]{targetGroupName});
        });
        software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup targetGroup = (software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup)targetGroupResponse.targetGroups().iterator().next();
        return targetGroupResponse.hasTargetGroups() ? this.createTargetGroup(this, region, targetGroupName, targetGroup.targetGroupArn(), loadBalancerArn == null ? (String)Util.first((Iterable)targetGroup.loadBalancerArns()) : loadBalancerArn, targetGroup.protocol(), targetGroup.port(), targetGroup.healthCheckProtocol(), AwsLandscapeImpl.getHealthCheckPort(targetGroup), targetGroup.healthCheckPath()) : null;
    }

    @Override
    public TargetGroup<ShardingKey> getTargetGroup(Region region, String targetGroupName) {
        return this.getTargetGroup(region, targetGroupName, null);
    }

    @Override
    public TargetGroup<ShardingKey> createTargetGroup(Region region, String targetGroupName, int port, String healthCheckPath, int healthCheckPort, String loadBalancerArn, String vpcId) {
        return this.createTargetGroup(region, targetGroupName, port, healthCheckPath, healthCheckPort, loadBalancerArn, vpcId, Collections.emptyMap());
    }

    private TargetGroup<ShardingKey> createTargetGroup(Region region, String targetGroupName, int port, String healthCheckPath, int healthCheckPort, String loadBalancerArn, String vpcId, Map<String, String> tagKeyAndValues) {
        Tag[] tags = (Tag[])tagKeyAndValues.entrySet().stream().map(entry -> (Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).toArray(Tag[]::new);
        ElasticLoadBalancingV2Client loadBalancingClient = this.getLoadBalancingClient(this.getRegion(region));
        CreateTargetGroupRequest.Builder targetGroupRequestBuilder = CreateTargetGroupRequest.builder().name(targetGroupName).healthyThresholdCount(Integer.valueOf(2)).unhealthyThresholdCount(Integer.valueOf(2)).healthCheckTimeoutSeconds(Integer.valueOf(4)).healthCheckEnabled(Boolean.valueOf(true)).healthCheckIntervalSeconds(Integer.valueOf(10)).healthCheckPath(healthCheckPath).healthCheckPort("" + healthCheckPort).healthCheckProtocol(this.guessProtocolFromPort(healthCheckPort)).port(Integer.valueOf(port)).vpcId(vpcId == null ? this.getVpcId(region) : vpcId).protocol(this.guessProtocolFromPort(port)).targetType(TargetTypeEnum.INSTANCE);
        if (tags.length > 0) {
            targetGroupRequestBuilder.tags(tags);
        }
        software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup targetGroup = (software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup)loadBalancingClient.createTargetGroup((CreateTargetGroupRequest)targetGroupRequestBuilder.build()).targetGroups().iterator().next();
        String targetGroupArn = targetGroup.targetGroupArn();
        int numberOfRetries = 3;
        Duration TIME_BETWEEN_RETRIES = Duration.ONE_SECOND;
        boolean success = false;
        while (!success && numberOfRetries-- > 0) {
            try {
                loadBalancingClient.modifyTargetGroupAttributes((ModifyTargetGroupAttributesRequest)ModifyTargetGroupAttributesRequest.builder().targetGroupArn(targetGroupArn).attributes(new TargetGroupAttribute[]{(TargetGroupAttribute)TargetGroupAttribute.builder().key("stickiness.enabled").value("true").build(), (TargetGroupAttribute)TargetGroupAttribute.builder().key("load_balancing.algorithm.type").value("least_outstanding_requests").build()}).build());
                success = true;
            }
            catch (TargetGroupNotFoundException e) {
                logger.log(Level.WARNING, "Couldn't find target group with ARN " + targetGroupArn + " that was just created successfully." + (numberOfRetries > 0 ? " Trying again..." : ""), e);
                if (numberOfRetries <= 0) continue;
                try {
                    Thread.sleep(TIME_BETWEEN_RETRIES.asMillis());
                }
                catch (InterruptedException e1) {
                    logger.warning("Sleep got interrupted. Well, then we'll retry a bit sooner...");
                }
            }
        }
        return this.createTargetGroup(this, region, targetGroupName, targetGroupArn, loadBalancerArn, targetGroup.protocol(), port, targetGroup.healthCheckProtocol(), healthCheckPort, healthCheckPath);
    }

    private ProtocolEnum guessProtocolFromPort(int healthCheckPort) {
        return healthCheckPort == 443 ? ProtocolEnum.HTTPS : ProtocolEnum.HTTP;
    }

    private String getVpcId(Region region) {
        Vpc vpc = this.getEc2Client(this.getRegion(region)).describeVpcs().vpcs().stream().filter(myVpc -> myVpc.isDefault()).findAny().orElseThrow(() -> new IllegalStateException("No default VPC found in region " + region));
        return vpc.vpcId();
    }

    @Override
    public software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup getAwsTargetGroup(Region region, String targetGroupName) {
        return (software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup)Util.first((Iterable)this.getLoadBalancingClient(this.getRegion(region)).describeTargetGroups((DescribeTargetGroupsRequest)DescribeTargetGroupsRequest.builder().names(new String[]{targetGroupName}).build()).targetGroups());
    }

    @Override
    public software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup getAwsTargetGroupByArn(Region region, String targetGroupArn) {
        return (software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup)Util.first((Iterable)this.getLoadBalancingClient(this.getRegion(region)).describeTargetGroups((DescribeTargetGroupsRequest)DescribeTargetGroupsRequest.builder().targetGroupArns(new String[]{targetGroupArn}).build()).targetGroups());
    }

    @Override
    public <SK> void deleteTargetGroup(TargetGroup<SK> targetGroup) {
        logger.info("Deleting target group " + targetGroup);
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).deleteTargetGroup((DeleteTargetGroupRequest)DeleteTargetGroupRequest.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build());
    }

    @Override
    public Map<AwsInstance<ShardingKey>, TargetHealth> getTargetHealthDescriptions(TargetGroup<ShardingKey> targetGroup) {
        HashMap<AwsInstance<ShardingKey>, TargetHealth> result = new HashMap<AwsInstance<ShardingKey>, TargetHealth>();
        software.amazon.awssdk.regions.Region region = this.getRegion(targetGroup.getRegion());
        this.getLoadBalancingClient(region).describeTargetHealth((DescribeTargetHealthRequest)DescribeTargetHealthRequest.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build()).targetHealthDescriptions().forEach(targetHealthDescription -> {
            if (targetHealthDescription.target().id().matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+")) {
                AwsInstanceImpl awsInstance = this.getHostByPrivateIpAddress(targetGroup.getRegion(), targetHealthDescription.target().id().trim(), AwsInstanceImpl::new);
                result.put(awsInstance, targetHealthDescription.targetHealth());
            } else {
                result.put(this.getHost(targetGroup.getRegion(), targetHealthDescription.target().id(), AwsInstanceImpl::new), targetHealthDescription.targetHealth());
            }
        });
        return result;
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> getReverseProxyCluster(Region region) {
        ApacheReverseProxyCluster reverseProxyCluster = new ApacheReverseProxyCluster(this);
        for (AwsInstance awsInstance : this.getRunningHostsWithTag(region, "ReverseProxy", AwsInstanceImpl::new)) {
            reverseProxyCluster.addHost(awsInstance);
        }
        return reverseProxyCluster;
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> getCentralReverseProxy(Region region) {
        ApacheReverseProxyCluster reverseProxyCluster = new ApacheReverseProxyCluster(this);
        for (AwsInstance awsInstance : this.getRunningHostsWithTag(region, "CentralReverseProxy", AwsInstanceImpl::new)) {
            reverseProxyCluster.addHost(awsInstance);
        }
        Iterator iterator = reverseProxyCluster.getHosts().iterator();
        if (iterator.hasNext()) {
            iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("There should only be one central reverse proxy");
            }
        }
        return reverseProxyCluster;
    }

    @Override
    public SecurityGroup getSecurityGroup(String securityGroupId, Region region) {
        final software.amazon.awssdk.services.ec2.model.SecurityGroup securityGroup = (software.amazon.awssdk.services.ec2.model.SecurityGroup)this.getEc2Client(this.getRegion(region)).describeSecurityGroups(sg -> {
            DescribeSecurityGroupsRequest.Builder builder = sg.groupIds(new String[]{securityGroupId});
        }).securityGroups().iterator().next();
        return new SecurityGroup(){

            public String getId() {
                return securityGroup.groupId();
            }

            public String getVpcId() {
                return securityGroup.vpcId();
            }
        };
    }

    @Override
    public Optional<SecurityGroup> getSecurityGroupByName(String securityGroupName, Region region) {
        List securityGroups = this.getEc2Client(this.getRegion(region)).describeSecurityGroups(sg -> {
            DescribeSecurityGroupsRequest.Builder builder = sg.filters(new Filter[]{(Filter)Filter.builder().name("tag:Name").values(new String[]{securityGroupName}).build()});
        }).securityGroups();
        return securityGroups.stream().findFirst().map(sg -> new SecurityGroup((software.amazon.awssdk.services.ec2.model.SecurityGroup)sg){
            private final /* synthetic */ software.amazon.awssdk.services.ec2.model.SecurityGroup val$sg;
            {
                this.val$sg = securityGroup;
            }

            public String getId() {
                return this.val$sg.groupId();
            }

            public String getVpcId() {
                return this.val$sg.vpcId();
            }
        });
    }

    private void setTargetGroupHealthCheckPath(TargetGroup<ShardingKey> targetGroup, String path) {
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).modifyTargetGroup((ModifyTargetGroupRequest)ModifyTargetGroupRequest.builder().targetGroupArn(targetGroup.getTargetGroupArn()).healthCheckPath(path).build());
    }

    @Override
    public void addTargetsToTargetGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> targets) {
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).registerTargets(this.getRegisterTargetsRequestBuilderConsumer(targetGroup, targets));
    }

    @Override
    public void addIpTargetToTargetGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> hosts) {
        TargetDescription[] descriptions = (TargetDescription[])Util.toArray((Iterable)Util.map(hosts, t -> (TargetDescription)TargetDescription.builder().id(t.getPrivateAddress().getHostAddress()).port(Integer.valueOf(80)).build()), (Object[])new TargetDescription[0]);
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).registerTargets(t -> {
            RegisterTargetsRequest.Builder builder = t.targetGroupArn(targetGroup.getTargetGroupArn()).targets(descriptions);
        });
    }

    @Override
    public void removeIpTargetFromTargetGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> hosts) {
        TargetDescription[] descriptions = (TargetDescription[])Util.toArray((Iterable)Util.map(hosts, t -> (TargetDescription)TargetDescription.builder().id(t.getPrivateAddress().getHostAddress()).port(Integer.valueOf(80)).build()), (Object[])new TargetDescription[0]);
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).deregisterTargets(builder -> {
            DeregisterTargetsRequest.Builder builder2 = builder.targetGroupArn(targetGroup.getTargetGroupArn()).targets(descriptions);
        });
    }

    private TargetDescription[] getTargetDescriptions(Iterable<AwsInstance<ShardingKey>> targets) {
        return (TargetDescription[])Util.toArray((Iterable)Util.map(targets, t -> (TargetDescription)TargetDescription.builder().id(t.getInstanceId()).build()), (Object[])new TargetDescription[0]);
    }

    @Override
    public void removeTargetsFromTargetGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> targets) {
        this.getLoadBalancingClient(this.getRegion(targetGroup.getRegion())).deregisterTargets(this.getDeregisterTargetRequestBuilderConsumers(targetGroup, targets));
    }

    private Consumer<RegisterTargetsRequest.Builder> getRegisterTargetsRequestBuilderConsumer(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> targets) {
        TargetDescription[] targetDescriptions = this.getTargetDescriptions(targets);
        return b -> {
            RegisterTargetsRequest.Builder builder = b.targetGroupArn(targetGroup.getTargetGroupArn()).targets(targetDescriptions);
        };
    }

    private Consumer<DeregisterTargetsRequest.Builder> getDeregisterTargetRequestBuilderConsumers(TargetGroup<ShardingKey> targetGroup, Iterable<AwsInstance<ShardingKey>> targets) {
        TargetDescription[] targetDescriptions = this.getTargetDescriptions(targets);
        return b -> {
            DeregisterTargetsRequest.Builder builder = b.targetGroupArn(targetGroup.getTargetGroupArn()).targets(targetDescriptions);
        };
    }

    @Override
    public LoadBalancer getAwsLoadBalancer(String loadBalancerArn, Region region) {
        return (LoadBalancer)this.getLoadBalancingClient(this.getRegion(region)).describeLoadBalancers(lb -> {
            DescribeLoadBalancersRequest.Builder builder = lb.loadBalancerArns(new String[]{loadBalancerArn});
        }).loadBalancers().iterator().next();
    }

    public SecurityGroup getDefaultSecurityGroupForApplicationHosts(Region region) {
        return this.getSecurityGroupByName(SAILING_APP_SECURITY_GROUP_NAME, region).orElseGet(() -> {
            ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
            securityGroups.addAll(this.getSecurityGroupByTag("application-server-sg", region));
            return securityGroups.isEmpty() ? null : (SecurityGroup)securityGroups.get(0);
        });
    }

    public Iterable<SecurityGroup> getDefaultSecurityGroupsForReverseProxy(Region region) {
        return this.getSecurityGroupByTag("reverse-proxy-sg", region);
    }

    public List<SecurityGroup> getSecurityGroupByTag(String tag, Region region) {
        List securityGroups = this.getEc2Client(this.getRegion(region)).describeSecurityGroups(sg -> {
            DescribeSecurityGroupsRequest.Builder builder = sg.filters(new Filter[]{(Filter)Filter.builder().name("tag-key").values(new String[]{tag}).build()});
        }).securityGroups();
        return securityGroups.stream().map(sg -> new SecurityGroup((software.amazon.awssdk.services.ec2.model.SecurityGroup)sg){
            private final /* synthetic */ software.amazon.awssdk.services.ec2.model.SecurityGroup val$sg;
            {
                this.val$sg = securityGroup;
            }

            public String getVpcId() {
                return this.val$sg.vpcId();
            }

            public String getId() {
                return this.val$sg.groupId();
            }
        }).collect(Collectors.toList());
    }

    public SecurityGroup getDefaultSecurityGroupForApplicationLoadBalancer(Region region) {
        return this.getDefaultSecurityGroupForApplicationHosts(region);
    }

    public Iterable<SecurityGroup> getDefaultSecurityGroupsForMongoDBHosts(Region region) {
        return this.getSecurityGroupByTag("mongo-sg", region);
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getNonDNSMappedLoadBalancer(Region region, String wildcardDomain) {
        return this.getLoadBalancerByName(this.getNonDNSMappedLoadBalancerName(wildcardDomain), region);
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> createNonDNSMappedLoadBalancer(Region region, String wildcardDomain, SecurityGroup securityGroupForVpc) throws InterruptedException, ExecutionException {
        return this.createLoadBalancer(this.getNonDNSMappedLoadBalancerName(wildcardDomain), region, securityGroupForVpc);
    }

    private String getNonDNSMappedLoadBalancerName(String wildcardDomain) {
        return DEFAULT_NON_DNS_MAPPED_ALB_NAME + wildcardDomain.replaceAll("\\.", "-");
    }

    private boolean isLoadBalancerDNSName(String hostname) {
        return this.getLoadBalancerDescriptorForDNSName(hostname) != null;
    }

    private LoadBalancerDescriptor getLoadBalancerDescriptorForDNSName(String hostname) {
        Matcher m2;
        String loadBalancerNameAndIdPattern = "([^.]*)-([^.-]*)";
        String amazonAwsComSuffixPattern = "amazonaws\\.com";
        String elbInfixPattern = "\\.elb\\.";
        String regionIdPattern = "([^.]*)";
        Pattern p1 = Pattern.compile("^([^.]*)-([^.-]*)\\.elb\\.([^.]*)\\.amazonaws\\.com$");
        Pattern p2 = Pattern.compile("^([^.]*)-([^.-]*)\\.([^.]*)\\.elb\\.amazonaws\\.com$");
        Matcher m1 = p1.matcher(hostname);
        Matcher result = m1.matches() ? m1 : ((m2 = p2.matcher(hostname)).matches() ? m2 : null);
        return result == null ? null : new LoadBalancerDescriptor(result.group(1), result.group(2), software.amazon.awssdk.regions.Region.of((String)result.group(3)));
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getDNSMappedLoadBalancerFor(String hostname) {
        return Util.stream(this.getResourceRecordSets(hostname)).filter(rrs -> rrs.type() == RRType.CNAME).flatMap(rrs -> rrs.resourceRecords().stream()).filter(rr -> this.isLoadBalancerDNSName(rr.value())).map(rr -> this.getLoadBalancerDescriptorForDNSName(rr.value())).findAny().map(lbDesc -> this.getLoadBalancerByName(lbDesc.getName(), new AwsRegion(lbDesc.getRegion(), this))).orElse(null);
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getDNSMappedLoadBalancerFor(Region region, String hostname) {
        DescribeLoadBalancersResponse response = this.getLoadBalancingClient(this.getRegion(region)).describeLoadBalancers();
        for (LoadBalancer lb : response.loadBalancers()) {
            ApplicationLoadBalancerImpl alb = new ApplicationLoadBalancerImpl(region, lb, this);
            for (Rule rule : alb.getRules()) {
                if (!rule.conditions().stream().filter(r -> r.hostHeaderConfig() != null && r.hostHeaderConfig().values().contains(hostname)).findAny().isPresent()) continue;
                return alb;
            }
        }
        return null;
    }

    @Override
    public MongoEndpoint getDatabaseConfigurationForDefaultReplicaSet(Region region) {
        return this.getDatabaseConfigurationForReplicaSet(region, "live");
    }

    private int getMongoPort(String[] replicaSetNameAndOptionalPort) {
        int result = replicaSetNameAndOptionalPort.length < 2 ? 27017 : Integer.valueOf(replicaSetNameAndOptionalPort[1].trim());
        return result;
    }

    @Override
    public Optional<String> getTag(AwsInstance<ShardingKey> host, String tagName) {
        software.amazon.awssdk.services.ec2.model.DescribeTagsResponse tagResponse = this.getEc2Client(this.getRegion(host.getRegion())).describeTags(b -> {
            DescribeTagsRequest.Builder builder = b.filters(new Filter[]{(Filter)Filter.builder().name("resource-id").values(new String[]{host.getInstanceId()}).build(), (Filter)Filter.builder().name("key").values(new String[]{tagName}).build()});
        });
        return tagResponse.tags().stream().map(t -> t.value()).findAny();
    }

    @Override
    public Iterable<software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription> getTargetGroupTags(String arn, Region region) {
        DescribeTagsResponse tagResponse = this.getLoadBalancingClient(this.getRegion(region)).describeTags(t -> {
            DescribeTagsRequest.Builder builder = t.resourceArns(new String[]{arn});
        });
        return tagResponse.tagDescriptions();
    }

    @Override
    public Tags addTargetGroupTag(String arn, String key, String value, Region region) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add((Tag)Tag.builder().key(key).value(value).build());
        this.getLoadBalancingClient(this.getRegion(region)).addTags(t -> {
            AddTagsRequest.Builder builder = t.resourceArns(new String[]{arn}).tags(tags);
        });
        return new TagsImpl(key, value);
    }

    @Override
    public Tags getTagForMongoProcess(Tags tagsToAddTo, String replicaSetName, int port) {
        return tagsToAddTo.and("mongo-replica-sets", String.valueOf(replicaSetName == null ? "" : replicaSetName) + ":" + port);
    }

    @Override
    public MongoReplicaSet getDatabaseConfigurationForReplicaSet(Region region, String mongoReplicaSetName) {
        HashSet<Util.Pair<AwsInstance<ShardingKey>, Integer>> nodes = new HashSet<Util.Pair<AwsInstance<ShardingKey>, Integer>>();
        for (AwsInstance<ShardingKey> host : this.getMongoDBHosts(region)) {
            for (Util.Pair<String, Integer> replicaSetNameAndPort : this.getMongoEndpointSpecificationsAsReplicaSetNameAndPort(host)) {
                if (!((String)replicaSetNameAndPort.getA()).equals(mongoReplicaSetName)) continue;
                nodes.add(new Util.Pair(host, (Object)((Integer)replicaSetNameAndPort.getB())));
            }
        }
        return this.getDatabaseConfigurationForReplicaSet(mongoReplicaSetName, nodes);
    }

    @Override
    public MongoReplicaSet getDatabaseConfigurationForReplicaSet(String mongoReplicaSetName, Iterable<Util.Pair<AwsInstance<ShardingKey>, Integer>> hostsAndPortsOfNodes) {
        MongoReplicaSetImpl result = new MongoReplicaSetImpl(mongoReplicaSetName);
        for (Util.Pair<AwsInstance<ShardingKey>, Integer> hostAndPort : hostsAndPortsOfNodes) {
            result.addReplica((MongoProcessInReplicaSet)new MongoProcessInReplicaSetImpl((MongoReplicaSet)result, ((Integer)hostAndPort.getB()).intValue(), (Host)hostAndPort.getA()));
        }
        return result;
    }

    @Override
    public MongoProcessImpl getDatabaseConfigurationForSingleNode(AwsInstance<ShardingKey> host, int port) {
        return new MongoProcessImpl(host, port);
    }

    private Iterable<AwsInstance<ShardingKey>> getMongoDBHosts(Region region) {
        return this.getRunningHostsWithTag(region, "mongo-replica-sets", AwsInstanceImpl::new);
    }

    private Iterable<Util.Pair<String, Integer>> getMongoEndpointSpecificationsAsReplicaSetNameAndPort(AwsInstance<ShardingKey> host) {
        ArrayList<Util.Pair<String, Integer>> result = new ArrayList<Util.Pair<String, Integer>>();
        this.getTag(host, "mongo-replica-sets").ifPresent(tagValue -> {
            String[] stringArray = tagValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String replicaNameWithOptionalPortColonSeparated = stringArray[n2];
                String[] splitByColon = replicaNameWithOptionalPortColonSeparated.split(":");
                int port = this.getMongoPort(splitByColon);
                result.add(new Util.Pair((Object)splitByColon[0].trim(), (Object)port));
                ++n2;
            }
        });
        return result;
    }

    @Override
    public Iterable<MongoEndpoint> getMongoEndpoints(Region region) {
        HashSet<MongoEndpoint> result = new HashSet<MongoEndpoint>();
        HashSet<String> replicaSetsCreated = new HashSet<String>();
        for (AwsInstance<ShardingKey> mongoDBHost : this.getMongoDBHosts(region)) {
            for (Util.Pair<String, Integer> replicaSetNameAndPort : this.getMongoEndpointSpecificationsAsReplicaSetNameAndPort(mongoDBHost)) {
                if (replicaSetNameAndPort.getA() != null && !((String)replicaSetNameAndPort.getA()).isEmpty()) {
                    if (replicaSetsCreated.contains(replicaSetNameAndPort.getA())) continue;
                    replicaSetsCreated.add((String)replicaSetNameAndPort.getA());
                    result.add((MongoEndpoint)this.getDatabaseConfigurationForReplicaSet(region, (String)replicaSetNameAndPort.getA()));
                    continue;
                }
                result.add((MongoEndpoint)new MongoProcessImpl(mongoDBHost, ((Integer)replicaSetNameAndPort.getB()).intValue()));
            }
        }
        return result;
    }

    public RabbitMQEndpoint getDefaultRabbitConfiguration(Region region) {
        RabbitMQEndpoint result;
        RabbitMQEndpoint defaultRabbitMQInDefaultRegion = () -> "rabbit.internal.sapsailing.com";
        if (region.getId().equals(software.amazon.awssdk.regions.Region.EU_WEST_1.id())) {
            result = defaultRabbitMQInDefaultRegion;
        } else {
            Iterable<AwsInstance> rabbitMQHostsInRegion = this.getRunningHostsWithTag(region, "RabbitMQEndpoint", AwsInstanceImpl::new);
            if (rabbitMQHostsInRegion.iterator().hasNext()) {
                final AwsInstance anyRabbitMQHost = rabbitMQHostsInRegion.iterator().next();
                result = new RabbitMQEndpoint(){

                    public int getPort() {
                        return AwsLandscapeImpl.this.getTag(anyRabbitMQHost, "RabbitMQEndpoint").map(t -> t.trim().isEmpty() ? 5672 : Integer.valueOf(t.trim())).orElse(5672);
                    }

                    public String getNodeName() {
                        return anyRabbitMQHost.getHostname();
                    }
                };
            } else {
                result = defaultRabbitMQInDefaultRegion;
            }
        }
        return result;
    }

    @Override
    public Database getDatabase(Region region, String databaseName) {
        return new DatabaseImpl(this.getDatabaseConfigurationForDefaultReplicaSet(region), databaseName);
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> Iterable<HostT> getApplicationProcessHostsByTag(Region region, String tagName, HostSupplier<ShardingKey, HostT> hostSupplier) {
        return this.getRunningHostsWithTag(region, tagName, hostSupplier);
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getApplicationReplicaSetByTagValue(Region region, String tagName, String tagValue, HostSupplier<ShardingKey, HostT> hostSupplier, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return (AwsApplicationReplicaSet)Util.first(this.getApplicationReplicaSets(region, () -> this.getRunningHostsWithTagValue(region, tagName, tagValue, hostSupplier), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> Iterable<AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT>> getApplicationReplicaSetsByTag(Region region, String tagName, HostSupplier<ShardingKey, HostT> hostSupplier, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getApplicationReplicaSets(region, () -> this.getRunningHostsWithTag(region, tagName, hostSupplier), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> Iterable<AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT>> getApplicationReplicaSets(Region region, Supplier<Iterable<HostT>> hostsSupplier, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        Util.Pair taskToWaitForAndTimeoutString;
        CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion = this.getLoadBalancersAsync(region);
        CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> allTargetGroupsInRegion = this.getTargetGroupsAsync(region);
        CompletableFuture<Map<Listener, Iterable<Rule>>> allLoadBalancerRulesInRegion = this.getLoadBalancerListenerRulesAsync(region, allLoadBalancersInRegion);
        CompletableFuture<Iterable<AutoScalingGroup>> allAutoScalingGroups = this.getAutoScalingGroupsAsync(region);
        CompletableFuture<Iterable<LaunchTemplate>> allLaunchTemplates = this.getLaunchTemplatesAsync(region);
        CompletableFuture<Iterable<LaunchTemplateVersion>> allLaunchTemplateDefaultVersions = this.getLaunchTemplateDefaultVersionsAsync(region);
        Iterable<HostT> hosts = hostsSupplier.get();
        HashMap mastersByServerName = new HashMap();
        HashMap replicasByServerName = new HashMap();
        ConcurrentLinkedQueue<Util.Pair> tasksToWaitForAndLogStringForTimeout = new ConcurrentLinkedQueue<Util.Pair>();
        ScheduledExecutorService backgroundExecutor = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor("Application Process Discovery " + UUID.randomUUID());
        for (ApplicationProcessHost host : hosts) {
            tasksToWaitForAndLogStringForTimeout.add(new Util.Pair(backgroundExecutor.submit(() -> {
                try {
                    for (AwsApplicationProcess applicationProcess : host.getApplicationProcesses(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase)) {
                        tasksToWaitForAndLogStringForTimeout.add(new Util.Pair(backgroundExecutor.submit(() -> {
                            block11: {
                                try {
                                    String serverName = applicationProcess.getServerName(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
                                    String masterServerName = applicationProcess.getMasterServerName(optionalTimeout);
                                    if (masterServerName != null && Util.equalsWithNull((Object)masterServerName, (Object)serverName)) {
                                        Map map3 = replicasByServerName;
                                        synchronized (map3) {
                                            Util.addToValueSet((Map)replicasByServerName, (Object)serverName, (Object)applicationProcess);
                                            break block11;
                                        }
                                    }
                                    Map map4 = mastersByServerName;
                                    synchronized (map4) {
                                        if (!mastersByServerName.containsKey(serverName) || Comparator.nullsLast(Comparator.naturalOrder()).compare(((AwsApplicationProcess)mastersByServerName.get(serverName)).getStartTimePoint(optionalTimeout), applicationProcess.getStartTimePoint(optionalTimeout)) < 0) {
                                            if (mastersByServerName.containsKey(serverName)) {
                                                logger.warning("Replacing master " + mastersByServerName.get(serverName) + " with newer master " + applicationProcess);
                                            }
                                            mastersByServerName.put(serverName, applicationProcess);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }), (Object)("Host: " + host.toString() + ", process " + applicationProcess.toString())));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }), (Object)("Host: " + host.toString())));
        }
        while ((taskToWaitForAndTimeoutString = (Util.Pair)tasksToWaitForAndLogStringForTimeout.poll()) != null) {
            Future taskToWaitFor = (Future)taskToWaitForAndTimeoutString.getA();
            try {
                this.waitForFuture(taskToWaitFor, optionalTimeout);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem waiting for " + taskToWaitFor + " for " + (String)taskToWaitForAndTimeoutString.getB(), e);
            }
        }
        backgroundExecutor.shutdown();
        HashSet<AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT>> result = new HashSet<AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT>>();
        DNSCache dnsCache = this.getNewDNSCache();
        HashMap hashMap = mastersByServerName;
        synchronized (hashMap) {
            for (Map.Entry serverNameAndMaster : mastersByServerName.entrySet()) {
                String serverName = (String)serverNameAndMaster.getKey();
                AwsApplicationProcess master = (AwsApplicationProcess)serverNameAndMaster.getValue();
                Set replicas = (Set)replicasByServerName.get(serverName);
                AwsApplicationReplicaSet<ShardingKey, MetricsT, AwsApplicationProcess> replicaSet = this.getApplicationReplicaSet(serverName, master, replicas, allLoadBalancersInRegion, allTargetGroupsInRegion, allLoadBalancerRulesInRegion, allAutoScalingGroups, allLaunchTemplates, allLaunchTemplateDefaultVersions, dnsCache, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
                result.add(replicaSet);
            }
        }
        return result;
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getApplicationReplicaSet(Region region, String serverName, ProcessT master, Iterable<ProcessT> replicas, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion = this.getLoadBalancersAsync(region);
        CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> allTargetGroupsInRegion = this.getTargetGroupsAsync(region);
        CompletableFuture<Map<Listener, Iterable<Rule>>> allLoadBalancerRulesInRegion = this.getLoadBalancerListenerRulesAsync(region, allLoadBalancersInRegion);
        CompletableFuture<Iterable<AutoScalingGroup>> autoScalingGroups = this.getAutoScalingGroupsAsync(region);
        CompletableFuture<Iterable<LaunchTemplate>> launchTemplates = this.getLaunchTemplatesAsync(region);
        CompletableFuture<Iterable<LaunchTemplateVersion>> launchTemplateDefaultVersions = this.getLaunchTemplateDefaultVersionsAsync(region);
        DNSCache dnsCache = this.getNewDNSCache();
        return this.getApplicationReplicaSet(serverName, master, replicas, allLoadBalancersInRegion, allTargetGroupsInRegion, allLoadBalancerRulesInRegion, autoScalingGroups, launchTemplates, launchTemplateDefaultVersions, dnsCache, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    private <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getApplicationReplicaSet(String serverName, ProcessT master, Iterable<ProcessT> replicas, CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion, CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> allTargetGroupsInRegion, CompletableFuture<Map<Listener, Iterable<Rule>>> allLoadBalancerRulesInRegion, CompletableFuture<Iterable<AutoScalingGroup>> allAutoScalingGroups, CompletableFuture<Iterable<LaunchTemplate>> allLaunchTemplates, CompletableFuture<Iterable<LaunchTemplateVersion>> allLaunchTemplateDefaultVersions, DNSCache dnsCache, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws InterruptedException, ExecutionException, TimeoutException {
        AwsApplicationReplicaSetImpl replicaSet = new AwsApplicationReplicaSetImpl(serverName, master, Optional.ofNullable(replicas), allLoadBalancersInRegion, allTargetGroupsInRegion, allLoadBalancerRulesInRegion, this, allAutoScalingGroups, allLaunchTemplates, allLaunchTemplateDefaultVersions, dnsCache, this.pathPrefixForShardingKey, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        return replicaSet;
    }

    private <T> void waitForFuture(Future<T> future, Optional<Duration> optionalTimeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (optionalTimeout.isPresent()) {
            future.get(optionalTimeout.get().asMillis(), TimeUnit.MILLISECONDS);
        } else {
            future.get();
        }
    }

    private Util.Pair<String, AwsRegion> getLoadBalancerNameAndRegionFromLoadBalancerDNSName(String loadBalancerDNSName) {
        Pattern pattern = Pattern.compile("^([^.]*)-([^-.]*)\\.([^.]*)\\.elb\\.amazonaws\\.com\\.$");
        Matcher matcher = pattern.matcher(loadBalancerDNSName);
        Util.Pair result = matcher.matches() ? new Util.Pair((Object)matcher.group(1), (Object)new AwsRegion(matcher.group(3), this)) : null;
        return result;
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancerByHostname(String hostname) {
        ApplicationLoadBalancer<ShardingKey> result;
        TestDnsAnswerResponse dnsAnswer = this.getRoute53Client().testDNSAnswer(b -> {
            TestDnsAnswerRequest.Builder builder = b.hostedZoneId(this.getDNSHostedZoneId(AwsLandscape.getHostedZoneName(hostname))).recordType(RRType.CNAME).recordName(hostname);
        });
        if (dnsAnswer.hasRecordData()) {
            Util.Pair<String, AwsRegion> nameAndRegion = this.getLoadBalancerNameAndRegionFromLoadBalancerDNSName((String)dnsAnswer.recordData().iterator().next());
            result = this.getLoadBalancerByName((String)nameAndRegion.getA(), (Region)nameAndRegion.getB());
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public CompletableFuture<Iterable<ResourceRecordSet>> getResourceRecordSetsAsync(String hostname) {
        Route53AsyncClient route53Client = this.getRoute53AsyncClient();
        String hostedZoneId = this.getDNSHostedZoneId(AwsLandscape.getHostedZoneName(hostname));
        return route53Client.listResourceRecordSets(b -> {
            ListResourceRecordSetsRequest.Builder builder = b.hostedZoneId(hostedZoneId).startRecordName(hostname);
        }).handle((response, e) -> Util.filter((Iterable)response.resourceRecordSets(), resourceRecordSet -> AwsLandscape.removeTrailingDotFromHostname(resourceRecordSet.name()).equals(hostname)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findHostnamesForIP(String ipAddress) {
        ConcurrentMap<String, Util.Pair<ResourceRecordSet, TimePoint>> concurrentMap = reverseDNSCache;
        synchronized (concurrentMap) {
            String result;
            boolean validCacheEntryFound;
            ResourceRecordSet cachedRRS;
            TimePoint now = TimePoint.now();
            Util.Pair cacheEntryForPrivateIP = (Util.Pair)reverseDNSCache.get(ipAddress);
            if (cacheEntryForPrivateIP != null) {
                if (((TimePoint)cacheEntryForPrivateIP.getB()).plus(Duration.ONE_SECOND.times(((ResourceRecordSet)cacheEntryForPrivateIP.getA()).ttl().longValue())).before(now)) {
                    reverseDNSCache.remove(ipAddress);
                    cachedRRS = null;
                    validCacheEntryFound = false;
                } else {
                    cachedRRS = (ResourceRecordSet)cacheEntryForPrivateIP.getA();
                    validCacheEntryFound = true;
                }
            } else {
                cachedRRS = null;
                boolean bl = validCacheEntryFound = timePointOfLastDNSListing != null && !timePointOfLastDNSListing.plus(MINIMUM_DNS_CACHE_TTL_FOR_NOT_FOUND_ENTRIES).before(now);
            }
            if (validCacheEntryFound) {
                result = cachedRRS != null ? this.getNameWithoutTrailingDotFromRRS(cachedRRS) : null;
            } else {
                timePointOfLastDNSListing = now;
                result = null;
                Route53Client route53Client = this.getRoute53Client();
                for (HostedZone hostedZone : route53Client.listHostedZones().hostedZones()) {
                    for (ResourceRecordSet resourceRecordSet : route53Client.listResourceRecordSets(b -> {
                        ListResourceRecordSetsRequest.Builder builder = b.hostedZoneId(hostedZone.id());
                    }).resourceRecordSets()) {
                        for (ResourceRecord resourceRecord : resourceRecordSet.resourceRecords()) {
                            reverseDNSCache.put(resourceRecord.value(), (Util.Pair<ResourceRecordSet, TimePoint>)new Util.Pair((Object)resourceRecordSet, (Object)now));
                            if (!Util.equalsWithNull((Object)resourceRecord.value(), (Object)ipAddress)) continue;
                            result = this.getNameWithoutTrailingDotFromRRS(resourceRecordSet);
                        }
                    }
                }
            }
            return result;
        }
    }

    private String getNameWithoutTrailingDotFromRRS(ResourceRecordSet cachedRRS) {
        return cachedRRS.name().replaceFirst("\\.$", "");
    }

    @Override
    public Iterable<ResourceRecordSet> getResourceRecordSets(String hostname) {
        Route53Client route53Client = this.getRoute53Client();
        String hostedZoneId = this.getDNSHostedZoneId(AwsLandscape.getHostedZoneName(hostname));
        return Util.filter((Iterable)route53Client.listResourceRecordSets(b -> {
            ListResourceRecordSetsRequest.Builder builder = b.hostedZoneId(hostedZoneId).startRecordName(hostname);
        }).resourceRecordSets(), resourceRecordSet -> AwsLandscape.removeTrailingDotFromHostname(resourceRecordSet.name()).equals(hostname));
    }

    @Override
    public CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> getLoadBalancersAsync(Region region) {
        return this.getLoadBalancingAsyncClient(this.getRegion(region)).describeLoadBalancers().handleAsync((response, exception) -> Util.map((Iterable)response.loadBalancers(), lb -> new ApplicationLoadBalancerImpl(region, (LoadBalancer)lb, this)));
    }

    @Override
    public CompletableFuture<Listener> getHttpsListenerAsync(Region region, ApplicationLoadBalancer<ShardingKey> loadBalancer) {
        return this.getLoadBalancingAsyncClient(this.getRegion(region)).describeListeners(b -> {
            DescribeListenersRequest.Builder builder = b.loadBalancerArn(loadBalancer.getArn());
        }).handleAsync((response, exception) -> (Listener)Util.first((Iterable)Util.filter((Iterable)response.listeners(), l -> l.protocol() == ProtocolEnum.HTTPS)));
    }

    @Override
    public CompletableFuture<Map<Listener, Iterable<Rule>>> getLoadBalancerListenerRulesAsync(Region region, CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion) {
        return allLoadBalancersInRegion.thenCompose(loadBalancers -> this.getListenerToRulesMap(region, (Iterable<ApplicationLoadBalancer<ShardingKey>>)loadBalancers));
    }

    @Override
    public CompletableFuture<Iterable<AutoScalingGroup>> getAutoScalingGroupsAsync(Region region) {
        HashSet result = new HashSet();
        return this.getAutoScalingAsyncClient(this.getRegion(region)).describeAutoScalingGroupsPaginator().subscribe(response -> {
            boolean bl = result.addAll(response.autoScalingGroups());
        }).handle((v, e) -> Collections.unmodifiableCollection(result));
    }

    @Override
    public void updateAutoScalingGroupMinSize(AwsAutoScalingGroup autoScalingGroup, int minSize) {
        logger.info("Setting minimum size of auto-scaling group " + autoScalingGroup.getName() + " to " + minSize);
        this.getAutoScalingClient(this.getRegion(autoScalingGroup.getRegion())).updateAutoScalingGroup(b -> {
            UpdateAutoScalingGroupRequest.Builder builder = b.autoScalingGroupName(autoScalingGroup.getAutoScalingGroup().autoScalingGroupName()).minSize(Integer.valueOf(minSize)).desiredCapacity(Integer.valueOf(minSize));
        });
    }

    @Override
    public CompletableFuture<Iterable<LaunchTemplate>> getLaunchTemplatesAsync(Region region) {
        HashSet result = new HashSet();
        return this.getEc2AsyncClient(this.getRegion(region)).describeLaunchTemplatesPaginator().subscribe(response -> {
            boolean bl = result.addAll(response.launchTemplates());
        }).handle((v, e) -> Collections.unmodifiableCollection(result));
    }

    @Override
    public CompletableFuture<Iterable<LaunchTemplateVersion>> getLaunchTemplateDefaultVersionsAsync(Region region) {
        HashSet result = new HashSet();
        return this.getEc2AsyncClient(this.getRegion(region)).describeLaunchTemplateVersionsPaginator(b -> {
            DescribeLaunchTemplateVersionsRequest.Builder builder = b.versions(new String[]{"$Default"});
        }).subscribe(response -> {
            boolean bl = result.addAll(response.launchTemplateVersions());
        }).handle((v, e) -> Collections.unmodifiableCollection(result));
    }

    private CompletableFuture<Map<Listener, Iterable<Rule>>> getListenerToRulesMap(Region region, Iterable<ApplicationLoadBalancer<ShardingKey>> loadBalancers) {
        ElasticLoadBalancingV2AsyncClient loadBalancingClient = this.getLoadBalancingAsyncClient(this.getRegion(region));
        HashSet<CompletionStage> mapEntryFutures = new HashSet<CompletionStage>();
        for (ApplicationLoadBalancer<ShardingKey> loadBalancer : loadBalancers) {
            CompletableFuture<Listener> listenerFuture = this.getHttpsListenerAsync(region, loadBalancer);
            CompletionStage mapEntryFuture = listenerFuture.thenCompose(listener -> {
                CompletionStage<Object> result;
                if (listener == null) {
                    result = new CompletableFuture<Object>();
                    result.complete(null);
                } else {
                    result = loadBalancingClient.describeRules(b -> {
                        DescribeRulesRequest.Builder builder = b.listenerArn(listener.listenerArn());
                    }).handle((describeRulesResponse, e) -> {
                        Util.Pair rulesResult;
                        if (e != null) {
                            logger.log(Level.WARNING, "Problem trying to get load balancer listener rules for " + loadBalancer.getName() + ". Trying synchronously...", (Throwable)e);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e1) {
                                logger.log(Level.WARNING, "Strange; sleeping was interrupted", e1);
                            }
                            rulesResult = new Util.Pair(listener, (Object)this.getLoadBalancingClient(this.getRegion(region)).describeRules(b -> {
                                DescribeRulesRequest.Builder builder = b.listenerArn(listener.listenerArn());
                            }).rules());
                        } else {
                            rulesResult = new Util.Pair(listener, (Object)describeRulesResponse.rules());
                        }
                        return rulesResult;
                    });
                }
                return result;
            });
            mapEntryFutures.add(mapEntryFuture);
        }
        return CompletableFuture.allOf(mapEntryFutures.toArray(new CompletableFuture[0])).handle((v, e) -> {
            HashMap<Listener, Iterable> result = new HashMap<Listener, Iterable>();
            for (CompletableFuture mapEntryFuture : mapEntryFutures) {
                try {
                    if (mapEntryFuture.get() == null) continue;
                    result.put((Listener)((Util.Pair)mapEntryFuture.get()).getA(), (Iterable)((Util.Pair)mapEntryFuture.get()).getB());
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Iterable<TargetHealthDescription>> getTargetHealthDescriptionsAsync(Region region, TargetGroup<ShardingKey> targetGroup) {
        Object object = sequencer;
        synchronized (object) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                logger.log(Level.WARNING, "Interrupted", e1);
            }
            CompletableFuture describeTargetHealthResponse = this.getLoadBalancingAsyncClient(this.getRegion(region)).describeTargetHealth(b -> {
                DescribeTargetHealthRequest.Builder builder = b.targetGroupArn(targetGroup.getTargetGroupArn());
            });
            return describeTargetHealthResponse.handleAsync((targetHealthResponse, e) -> {
                Collection<Object> result;
                if (e != null) {
                    logger.log(Level.WARNING, "Exception trying to obtain health status of target group " + targetGroup, (Throwable)e);
                    result = Collections.emptySet();
                } else {
                    result = targetHealthResponse.targetHealthDescriptions();
                }
                return result;
            });
        }
    }

    @Override
    public CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> getTargetGroupsAsync(Region region) {
        HashSet responses = new HashSet();
        return this.getLoadBalancingAsyncClient(this.getRegion(region)).describeTargetGroupsPaginator().subscribe(response -> {
            boolean bl = responses.add(response);
        }).thenCompose(someVoid -> {
            HashMap futures = new HashMap();
            for (DescribeTargetGroupsResponse response : responses) {
                for (software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup tg : response.targetGroups()) {
                    TargetGroup<ShardingKey> targetGroup = this.createTargetGroup(this, region, tg.targetGroupName(), tg.targetGroupArn(), (String)Util.first((Iterable)tg.loadBalancerArns()), tg.protocol(), tg.port(), tg.healthCheckProtocol(), AwsLandscapeImpl.getHealthCheckPort(tg), tg.healthCheckPath());
                    futures.put(targetGroup, this.getTargetHealthDescriptionsAsync(region, targetGroup));
                }
            }
            return CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0])).handle((v, e) -> {
                HashMap<TargetGroup, Iterable> result = new HashMap<TargetGroup, Iterable>();
                for (Map.Entry future : futures.entrySet()) {
                    try {
                        result.put((TargetGroup)future.getKey(), (Iterable)((CompletableFuture)future.getValue()).get());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return result;
            });
        });
    }

    @Override
    public AwsRegion getDefaultRegion() {
        return new AwsRegion(software.amazon.awssdk.regions.Region.EU_WEST_2, this);
    }

    public Iterable<Region> getRegions() {
        return Util.map((Iterable)software.amazon.awssdk.regions.Region.regions(), r -> new AwsRegion((software.amazon.awssdk.regions.Region)r, (AwsLandscape<?>)this));
    }

    @Override
    public void updateReleaseInAutoScalingGroups(Region region, LaunchTemplate oldLaunchTemplate, Iterable<AwsAutoScalingGroup> autoScalingGroups, String replicaSetName, Release release) {
        logger.info("Adjusting release for auto-scaling groups " + Util.join((String)", ", autoScalingGroups) + " to " + release);
        Ec2Client ec2Client = this.getEc2Client(this.getRegion(region));
        LaunchTemplateVersion oldLaunchTemplateVersion = (LaunchTemplateVersion)ec2Client.describeLaunchTemplateVersions(b -> {
            DescribeLaunchTemplateVersionsRequest.Builder builder = b.launchTemplateName(oldLaunchTemplate.launchTemplateName()).versions(new String[]{"$Default"});
        }).launchTemplateVersions().iterator().next();
        String oldUserData = new String(Base64.getDecoder().decode(oldLaunchTemplateVersion.launchTemplateData().userData().getBytes()));
        String newUserData = oldUserData.replaceFirst("(?m)^" + DefaultProcessConfigurationVariables.INSTALL_FROM_RELEASE.name() + "=(.*)$", String.valueOf(DefaultProcessConfigurationVariables.INSTALL_FROM_RELEASE.name()) + "=\"" + release.getName() + "\"");
        this.createUpdatedDefaultLaunchTemplateVersion(region, autoScalingGroups, "Using release " + release.getName(), b -> {
            CreateLaunchTemplateVersionRequest.Builder builder = b.launchTemplateData(ldtb -> {
                RequestLaunchTemplateData.Builder builder = ldtb.userData(Base64.getEncoder().encodeToString(newUserData.getBytes()));
            });
        });
    }

    private CreateLaunchTemplateVersionRequest.Builder copyLaunchTemplateVersionToCreateRequestBuilder(LaunchTemplate launchTemplateToCreateNewVersionFor, Region region) {
        return CreateLaunchTemplateVersionRequest.builder().launchTemplateId(launchTemplateToCreateNewVersionFor.launchTemplateId()).sourceVersion("$Default");
    }

    @Override
    public void updateImageInAutoScalingGroups(Region region, Iterable<AwsAutoScalingGroup> autoScalingGroups, String replicaSetName, AmazonMachineImage<ShardingKey> ami) {
        logger.info("Adjusting AMI for auto-scaling group(s) " + Util.join((String)", ", autoScalingGroups) + " to " + ami);
        this.createUpdatedDefaultLaunchTemplateVersion(region, autoScalingGroups, "Using AMI " + ami.getName() + " with ID " + ami.getId(), b -> {
            CreateLaunchTemplateVersionRequest.Builder builder = b.launchTemplateData(ltdb -> {
                RequestLaunchTemplateData.Builder builder = ltdb.imageId(ami.getId());
            });
        });
    }

    @Override
    public void updateInstanceTypeInAutoScalingGroup(Region region, Iterable<AwsAutoScalingGroup> autoScalingGroups, String replicaSetName, InstanceType instanceType) {
        logger.info("Adjusting instance type for auto-scaling group(s) " + Util.join((String)", ", autoScalingGroups) + " to " + instanceType);
        this.createUpdatedDefaultLaunchTemplateVersion(region, autoScalingGroups, "Using new instance type " + instanceType.name(), b -> {
            CreateLaunchTemplateVersionRequest.Builder builder = b.launchTemplateData(ltdb -> {
                RequestLaunchTemplateData.Builder builder = ltdb.instanceType(instanceType);
            });
        });
    }

    private void createUpdatedDefaultLaunchTemplateVersion(Region region, Iterable<AwsAutoScalingGroup> autoScalingGroups, String newLaunchTemplateVersionDescription, Consumer<CreateLaunchTemplateVersionRequest.Builder> builderConsumer) {
        if (Util.isEmpty(autoScalingGroups)) {
            throw new IllegalArgumentException("At least one auto-scaling group must be provided for updating a launch template");
        }
        logger.info("Creating a new, adjusted default launch template version for auto-scaling group(s) " + Util.join((String)", ", autoScalingGroups));
        LaunchTemplate launchTemplate = ((AwsAutoScalingGroup)Util.first(autoScalingGroups)).getLaunchTemplate();
        CreateLaunchTemplateVersionRequest.Builder createLaunchTemplateVersionRequestBuilder = this.copyLaunchTemplateVersionToCreateRequestBuilder(launchTemplate, region);
        createLaunchTemplateVersionRequestBuilder.versionDescription(newLaunchTemplateVersionDescription);
        builderConsumer.accept(createLaunchTemplateVersionRequestBuilder);
        CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest = (CreateLaunchTemplateVersionRequest)createLaunchTemplateVersionRequestBuilder.build();
        logger.info("Creating new launch template version \"" + newLaunchTemplateVersionDescription + "\" for launch template " + launchTemplate.launchTemplateName());
        Ec2Client ec2Client = this.getEc2Client(this.getRegion(region));
        CreateLaunchTemplateVersionResponse launchTemplateVersionResponse = ec2Client.createLaunchTemplateVersion(createLaunchTemplateVersionRequest);
        ec2Client.modifyLaunchTemplate(b -> {
            ModifyLaunchTemplateRequest.Builder builder = b.launchTemplateId(launchTemplate.launchTemplateId()).defaultVersion(launchTemplateVersionResponse.launchTemplateVersion().versionNumber().toString());
        });
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> void createLaunchTemplateAndAutoScalingGroup(Region region, String replicaSetName, Optional<Tags> tags, TargetGroup<ShardingKey> publicTargetGroup, String keyName, InstanceType instanceType, String imageId, AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> replicaConfiguration, int minReplicas, int maxReplicas, int maxRequestsPerTarget) {
        logger.info("Creating launch template for replica set " + replicaSetName);
        software.amazon.awssdk.regions.Region awsRegion = this.getRegion(region);
        Ec2Client ec2Client = this.getEc2Client(awsRegion);
        AutoScalingClient autoScalingClient = this.getAutoScalingClient(awsRegion);
        String launchTemplateName = replicaSetName;
        String autoScalingGroupName = this.getAutoScalingGroupName(replicaSetName);
        Iterable<AwsAvailabilityZone> availabilityZones = this.getAvailabilityZones(region);
        SecurityGroup securityGroup = this.getDefaultSecurityGroupForApplicationHosts(region);
        int instanceWarmupTimeInSeconds = (int)Duration.ONE_MINUTE.times(3L).asSeconds();
        ec2Client.createLaunchTemplate(b -> {
            CreateLaunchTemplateRequest.Builder builder = b.launchTemplateName(launchTemplateName).launchTemplateData(ltdb -> {
                RequestLaunchTemplateData.Builder builder = ltdb.keyName(keyName).imageId(imageId).monitoring(i -> {
                    LaunchTemplatesMonitoringRequest.Builder builder = i.enabled(Boolean.valueOf(true));
                }).securityGroupIds(new String[]{securityGroup.getId()}).userData(Base64.getEncoder().encodeToString(replicaConfiguration.getAsEnvironmentVariableAssignments().getBytes())).instanceType(instanceType.toString());
            });
        });
        logger.info("Creating auto-scaling group for replica set " + replicaSetName);
        String vpcIdentifier = String.join((CharSequence)",", (CharSequence[])Util.mapToArrayList(availabilityZones, az -> this.getSubnetForAvailabilityZoneInSameVpcAsSecurityGroup((AwsAvailabilityZone)az, securityGroup, awsRegion).subnetId()).stream().filter(az -> az != null).distinct().toArray(String[]::new));
        autoScalingClient.createAutoScalingGroup(b -> {
            b.minSize(Integer.valueOf(minReplicas)).maxSize(Integer.valueOf(maxReplicas)).healthCheckGracePeriod(Integer.valueOf(instanceWarmupTimeInSeconds)).autoScalingGroupName(autoScalingGroupName).vpcZoneIdentifier(vpcIdentifier).targetGroupARNs(new String[]{publicTargetGroup.getTargetGroupArn()}).launchTemplate((LaunchTemplateSpecification)LaunchTemplateSpecification.builder().launchTemplateName(launchTemplateName).version("$Default").build());
            tags.ifPresent(t -> {
                ArrayList<software.amazon.awssdk.services.autoscaling.model.Tag> awsTags = new ArrayList<software.amazon.awssdk.services.autoscaling.model.Tag>();
                for (Map.Entry tag : t) {
                    awsTags.add((software.amazon.awssdk.services.autoscaling.model.Tag)software.amazon.awssdk.services.autoscaling.model.Tag.builder().key((String)tag.getKey()).value((String)tag.getValue()).build());
                }
                b.tags(awsTags);
            });
        });
        this.enableAutoScalingGroupMetricCollection(autoScalingGroupName, autoScalingClient);
        this.putScalingPolicy(instanceWarmupTimeInSeconds, autoScalingGroupName, publicTargetGroup, maxRequestsPerTarget, region);
    }

    private void enableAutoScalingGroupMetricCollection(String autoscalinggroupName, AutoScalingClient client) {
        EnableMetricsCollectionRequest request = (EnableMetricsCollectionRequest)EnableMetricsCollectionRequest.builder().autoScalingGroupName(autoscalinggroupName).granularity("1Minute").build();
        client.enableMetricsCollection(request);
    }

    @Override
    public String getAutoScalingGroupName(String replicaSetName) {
        return String.valueOf(replicaSetName) + AUTO_SCALING_GROUP_NAME_SUFFIX;
    }

    @Override
    public Snapshot getSnapshot(AwsRegion region, String snapshotId) {
        DescribeSnapshotsResponse describeSnapshotResponse = this.getEc2Client(this.getRegion(region)).describeSnapshots(b -> {
            DescribeSnapshotsRequest.Builder builder = b.filters(new Filter[]{(Filter)Filter.builder().name("snapshot-id").values(new String[]{snapshotId}).build()});
        });
        return describeSnapshotResponse.hasSnapshots() ? (Snapshot)describeSnapshotResponse.snapshots().iterator().next() : null;
    }

    @Override
    public DNSCache getNewDNSCache() {
        return new DNSCache(this.getRoute53AsyncClient());
    }

    @Override
    public CompletableFuture<Void> removeAutoScalingGroupAndLaunchTemplate(AwsAutoScalingGroup autoScalingGroup) {
        String launchTemplateId = autoScalingGroup.getAutoScalingGroup().launchTemplate() == null ? null : autoScalingGroup.getAutoScalingGroup().launchTemplate().launchTemplateId();
        String launchTemplateName = autoScalingGroup.getAutoScalingGroup().launchTemplate() == null ? null : autoScalingGroup.getAutoScalingGroup().launchTemplate().launchTemplateName();
        Ec2AsyncClient ec2AsyncClient = this.getEc2AsyncClient(this.getRegion(autoScalingGroup.getRegion()));
        return this.removeAutoScalingGroup(autoScalingGroup).thenAccept(response -> {
            if (launchTemplateId != null) {
                logger.info("Removing launch template " + launchTemplateName + " with ID " + launchTemplateId);
                ec2AsyncClient.deleteLaunchTemplate(b -> {
                    DeleteLaunchTemplateRequest.Builder builder = b.launchTemplateId(launchTemplateId);
                });
            }
        });
    }

    @Override
    public CompletableFuture<DeleteAutoScalingGroupResponse> removeAutoScalingGroup(AwsAutoScalingGroup autoScalingGroup) {
        AutoScalingAsyncClient autoScalingAsyncClient = this.getAutoScalingAsyncClient(this.getRegion(autoScalingGroup.getRegion()));
        logger.info("Removing auto-scaling group " + autoScalingGroup.getAutoScalingGroup().autoScalingGroupName());
        return autoScalingAsyncClient.deleteAutoScalingGroup(b -> {
            DeleteAutoScalingGroupRequest.Builder builder = b.forceDelete(Boolean.valueOf(true)).autoScalingGroupName(autoScalingGroup.getAutoScalingGroup().autoScalingGroupName());
        });
    }

    @Override
    public TargetGroup<ShardingKey> createTargetGroupWithoutLoadbalancer(Region region, String targetGroupName, int port, String vpcId) {
        return this.createTargetGroup(region, targetGroupName, port, "/gwt/status", port, null, vpcId);
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> String createAutoScalingGroupFromExisting(AwsAutoScalingGroup autoScalingParent, String shardName, TargetGroup<ShardingKey> targetGroup, int minSize, Optional<Tags> tags) {
        AutoScalingClient autoScalingClient = this.getAutoScalingClient(this.getRegion(autoScalingParent.getRegion()));
        String launchTemplateId = autoScalingParent.getLaunchTemplate().launchTemplateId();
        String autoScalingGroupName = this.getAutoScalingGroupName(shardName);
        List availabilityZones = autoScalingParent.getAutoScalingGroup().availabilityZones();
        int instanceWarmupTimeInSeconds = autoScalingParent.getAutoScalingGroup().defaultInstanceWarmup() != null ? autoScalingParent.getAutoScalingGroup().defaultInstanceWarmup() : 180;
        logger.info("Creating Auto-Scaling Group " + autoScalingGroupName + " for Shard " + shardName + ". Inheriting from Auto-Scaling Group: " + autoScalingParent.getName() + ". Starting with " + minSize + " instances.");
        autoScalingClient.createAutoScalingGroup(b -> {
            b.minSize(Integer.valueOf(minSize)).maxSize(autoScalingParent.getAutoScalingGroup().maxSize()).healthCheckGracePeriod(Integer.valueOf(instanceWarmupTimeInSeconds)).autoScalingGroupName(autoScalingGroupName).availabilityZones((Collection)availabilityZones).targetGroupARNs(new String[]{targetGroup.getTargetGroupArn()}).launchTemplate(ltb -> {
                LaunchTemplateSpecification.Builder builder = ltb.launchTemplateId(launchTemplateId).version("$Default");
            });
            ArrayList<software.amazon.awssdk.services.autoscaling.model.Tag> awsTags = new ArrayList<software.amazon.awssdk.services.autoscaling.model.Tag>();
            List parentTags = autoScalingParent.getAutoScalingGroup().tags();
            for (TagDescription parentTag : parentTags) {
                awsTags.add((software.amazon.awssdk.services.autoscaling.model.Tag)software.amazon.awssdk.services.autoscaling.model.Tag.builder().key(parentTag.key()).value(parentTag.key().equals("Name") ? String.valueOf(parentTag.value()) + " (" + shardName + ")" : parentTag.value()).propagateAtLaunch(parentTag.propagateAtLaunch()).build());
            }
            tags.ifPresent(t -> {
                for (Map.Entry tag : t) {
                    awsTags.add((software.amazon.awssdk.services.autoscaling.model.Tag)software.amazon.awssdk.services.autoscaling.model.Tag.builder().key((String)tag.getKey()).value((String)tag.getValue()).build());
                }
            });
            b.tags(awsTags);
        });
        this.enableAutoScalingGroupMetricCollection(autoScalingGroupName, autoScalingClient);
        autoScalingClient.close();
        return autoScalingGroupName;
    }

    @Override
    public void resetShardMinAutoscalingGroupSize(String autoscalinggroupName, Region region) {
        AutoScalingClient autoScalingClient = this.getAutoScalingClient(this.getRegion(region));
        autoScalingClient.updateAutoScalingGroup(t -> {
            Object object = t.autoScalingGroupName(autoscalinggroupName).minSize(Integer.valueOf(2)).build();
        });
        autoScalingClient.close();
    }

    @Override
    public TargetGroup<ShardingKey> copyTargetGroup(TargetGroup<ShardingKey> parent, String suffix) {
        TargetGroup<ShardingKey> child = this.createTargetGroupWithoutLoadbalancer(parent.getRegion(), String.valueOf(parent.getName()) + suffix, parent.getPort(), parent.getLoadBalancer().getVpcId());
        child.addTargets(parent.getRegisteredTargets().keySet());
        return child;
    }

    @Override
    public Iterable<Rule> modifyRuleActions(Region region, Rule rule) {
        ModifyRuleResponse res = this.getLoadBalancingClient(this.getRegion(region)).modifyRule(t -> {
            Object object = t.actions((Collection)rule.actions()).ruleArn(rule.ruleArn()).build();
        });
        return res.rules();
    }

    @Override
    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> void putScalingPolicy(int instanceWarmupTimeInSeconds, String autoScalingGroupName, TargetGroup<ShardingKey> targetgroup, int maxRequestPerTarget, Region region) {
        AutoScalingClient autoScalingClient = this.getAutoScalingClient(this.getRegion(region));
        autoScalingClient.putScalingPolicy(b -> {
            PutScalingPolicyRequest.Builder builder = b.autoScalingGroupName(autoScalingGroupName).estimatedInstanceWarmup(Integer.valueOf(instanceWarmupTimeInSeconds)).policyType("TargetTrackingScaling").policyName("KeepRequestsPerTargetAt" + maxRequestPerTarget).targetTrackingConfiguration(t -> {
                TargetTrackingConfiguration.Builder builder = t.predefinedMetricSpecification(p -> {
                    PredefinedMetricSpecification.Builder builder = p.resourceLabel("app/" + targetgroup.getLoadBalancer().getName() + "/" + targetgroup.getLoadBalancer().getId() + "/targetgroup/" + targetgroup.getName() + "/" + targetgroup.getId()).predefinedMetricType(MetricType.ALB_REQUEST_COUNT_PER_TARGET);
                }).targetValue(Double.valueOf(15000.0));
            });
        });
    }

    private static class LoadBalancerDescriptor
    extends NamedWithIDImpl {
        private static final long serialVersionUID = 5813730385448660098L;
        private final software.amazon.awssdk.regions.Region region;

        public LoadBalancerDescriptor(String name, String id, software.amazon.awssdk.regions.Region region) {
            super(name, (Serializable)((Object)id));
            this.region = region;
        }

        public software.amazon.awssdk.regions.Region getRegion() {
            return this.region;
        }
    }
}

