/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.BODSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class BODParser
extends SentenceParser
implements BODSentence {
    private static final int BEARING_TRUE = 0;
    private static final int TRUE_INDICATOR = 1;
    private static final int BEARING_MAGN = 2;
    private static final int MAGN_INDICATOR = 3;
    private static final int DESTINATION = 4;
    private static final int ORIGIN = 5;

    public BODParser(String nmea) {
        super(nmea, SentenceId.BOD);
    }

    public BODParser(TalkerId talker) {
        super(talker, SentenceId.BOD, 6);
        this.setCharValue(1, 'T');
        this.setCharValue(3, 'M');
    }

    @Override
    public String getDestinationWaypointId() {
        return this.getStringValue(4);
    }

    @Override
    public double getMagneticBearing() {
        return this.getDoubleValue(2);
    }

    @Override
    public String getOriginWaypointId() {
        return this.getStringValue(5);
    }

    @Override
    public double getTrueBearing() {
        return this.getDoubleValue(0);
    }

    @Override
    public void setDestinationWaypointId(String id) {
        this.setStringValue(4, id);
    }

    @Override
    public void setMagneticBearing(double bearing) {
        this.setDegreesValue(2, bearing);
    }

    @Override
    public void setOriginWaypointId(String id) {
        this.setStringValue(5, id);
    }

    @Override
    public void setTrueBearing(double bearing) {
        this.setDegreesValue(0, bearing);
    }
}

