/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.text.DecimalFormat;
import net.sf.marineapi.ais.message.AISPositionReport;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Angle9;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.ManeuverIndicator;
import net.sf.marineapi.ais.util.NavigationalStatus;
import net.sf.marineapi.ais.util.PositionInfo;
import net.sf.marineapi.ais.util.RateOfTurn;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.TimeStamp;

class AISPositionReportParser
extends AISMessageParser
implements AISPositionReport {
    private static final String SEPARATOR = "\n\t";
    private static final int NAVIGATIONALSTATUS = 0;
    private static final int RATEOFTURN = 1;
    private static final int SPEEDOVERGROUND = 2;
    private static final int POSITIONACCURACY = 3;
    private static final int LONGITUDE = 4;
    private static final int LATITUDE = 5;
    private static final int COURSEOVERGROUND = 6;
    private static final int TRUEHEADING = 7;
    private static final int TIMESTAMP = 8;
    private static final int MANOEUVER = 9;
    private static final int[] FROM = new int[]{38, 42, 50, 60, 61, 89, 116, 128, 137, 143};
    private static final int[] TO = new int[]{42, 50, 60, 61, 89, 116, 128, 137, 143, 145};
    private int fNavigationalStatus;
    private int fRateOfTurn;
    private int fSOG;
    private boolean fPositionAccuracy;
    private double fLongitude;
    private double fLatitude;
    private int fCOG;
    private int fTrueHeading;
    private int fTimeStamp;
    private int fManouverIndicator;

    public AISPositionReportParser(Sixbit content) {
        super(content);
        if (content.length() != 168) {
            throw new IllegalArgumentException("Wrong message length");
        }
        this.fNavigationalStatus = content.getInt(FROM[0], TO[0]);
        if (!NavigationalStatus.isCorrect(this.fNavigationalStatus)) {
            this.fViolations.add(new AISRuleViolation("NavigationalStatus", this.fNavigationalStatus, "[0,8] + [14,15]"));
        }
        this.fRateOfTurn = content.getAs8BitInt(FROM[1], TO[1]);
        this.fSOG = content.getInt(FROM[2], TO[2]);
        this.fPositionAccuracy = content.getBoolean(FROM[3]);
        this.fLongitude = Longitude28.toDegrees(content.getAs28BitInt(FROM[4], TO[4]));
        if (!PositionInfo.isLongitudeCorrect(this.fLongitude)) {
            this.fViolations.add(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-180.0, 180.0] + {181}"));
        }
        this.fLatitude = Latitude27.toDegrees(content.getAs27BitInt(FROM[5], TO[5]));
        if (!PositionInfo.isLatitudeCorrect(this.fLatitude)) {
            this.fViolations.add(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-90.0, 90.0] + {91}"));
        }
        this.fCOG = content.getInt(FROM[6], TO[6]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.fViolations.add(new AISRuleViolation("CourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTrueHeading = content.getInt(FROM[7], TO[7]);
        if (!Angle9.isCorrect(this.fTrueHeading)) {
            this.fViolations.add(new AISRuleViolation("TrueHeading", this.fTrueHeading, "[0,359] + {511}"));
        }
        this.fTimeStamp = content.getInt(FROM[8], TO[8]);
        this.fManouverIndicator = content.getInt(FROM[9], TO[9]);
        if (!ManeuverIndicator.isCorrect(this.fManouverIndicator)) {
            this.fViolations.add(new AISRuleViolation("ManouverIndicator", this.fManouverIndicator, "[1,2] + {0}"));
        }
    }

    @Override
    public int getNavigationalStatus() {
        return this.fNavigationalStatus;
    }

    @Override
    public int getRateOfTurn() {
        return this.fRateOfTurn;
    }

    @Override
    public int getSpeedOverGround() {
        return this.fSOG;
    }

    public String getSOGString() {
        String msg = this.fSOG == 1023 ? "no SOG" : (this.fSOG == 1022 ? ">=102.2" : new DecimalFormat("##0.0").format((double)this.fSOG / 10.0));
        return msg;
    }

    @Override
    public boolean getPositionAccuracy() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return this.fLongitude;
    }

    @Override
    public double getLatitudeInDegrees() {
        return this.fLatitude;
    }

    @Override
    public int getCourseOverGround() {
        return this.fCOG;
    }

    @Override
    public int getTrueHeading() {
        return this.fTrueHeading;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    @Override
    public int getManouverIndicator() {
        return this.fManouverIndicator;
    }

    public String toString() {
        String result = "\tNav st:  " + NavigationalStatus.toString(this.fNavigationalStatus);
        result = String.valueOf(result) + "\n\tROT:     " + RateOfTurn.toString(this.fRateOfTurn);
        result = String.valueOf(result) + "\n\tSOG:     " + this.getSOGString();
        result = String.valueOf(result) + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = String.valueOf(result) + "\n\tLat:     " + PositionInfo.longitudeToString(this.fLongitude);
        result = String.valueOf(result) + "\n\tLon:     " + PositionInfo.latitudeToString(this.fLatitude);
        result = String.valueOf(result) + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = String.valueOf(result) + "\n\tHeading: " + Angle9.getTrueHeadingString(this.fTrueHeading);
        result = String.valueOf(result) + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        result = String.valueOf(result) + "\n\tMan ind: " + ManeuverIndicator.toString(this.fManouverIndicator);
        return result;
    }
}

