/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.xdstorage;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorageEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DelegatingCrossDomainStorageFuture
implements CrossDomainStorage {
    private CrossDomainStorage storageToUse;
    private final List<Consumer<CrossDomainStorage>> queuedWhileWaitingForStorage = new LinkedList<Consumer<CrossDomainStorage>>();
    private Timer timer;
    private final int timeoutInMillis;
    private final Supplier<CrossDomainStorage> defaultSupplier;

    public DelegatingCrossDomainStorageFuture() {
        this(-1, null);
    }

    public DelegatingCrossDomainStorageFuture(int timeoutInMillis, Supplier<CrossDomainStorage> defaultSupplier) {
        if (defaultSupplier == null && timeoutInMillis != -1) {
            throw new IllegalArgumentException("If a timeout of " + timeoutInMillis + "ms is provided, a valid default supplier must be provided, too.");
        }
        this.timeoutInMillis = timeoutInMillis;
        this.defaultSupplier = defaultSupplier;
    }

    public void setStorageToUse(CrossDomainStorage storageToUse) {
        if (storageToUse == null) {
            throw new NullPointerException("Must set a valid, non-null storage");
        }
        CrossDomainStorage oldStorageToUse = this.storageToUse;
        this.storageToUse = storageToUse;
        if (oldStorageToUse != null) {
            GWT.log((String)("Switching storage to use from type " + oldStorageToUse.getClass().getName() + " to " + storageToUse.getClass().getName()));
        }
        if (!this.queuedWhileWaitingForStorage.isEmpty()) {
            GWT.log((String)("now executing " + this.queuedWhileWaitingForStorage.size() + " queued requests for cross-domain storage of type " + storageToUse.getClass().getName()));
            for (Consumer<CrossDomainStorage> queuedRequest : this.queuedWhileWaitingForStorage) {
                queuedRequest.accept(storageToUse);
            }
            this.queuedWhileWaitingForStorage.clear();
        }
    }

    private void runOrEnqueue(Consumer<CrossDomainStorage> request) {
        if (this.storageToUse != null) {
            request.accept(this.storageToUse);
        } else {
            this.queuedWhileWaitingForStorage.add(request);
            if (this.timeoutInMillis != -1) {
                this.ensureTimerIsRunning();
            }
        }
    }

    private void ensureTimerIsRunning() {
        if (this.timer == null) {
            GWT.log((String)("cross-domain storage iframe not ready yet; waiting " + this.timeoutInMillis + "ms for message port"));
            this.timer = new Timer(){

                public void run() {
                    DelegatingCrossDomainStorageFuture.this.timer = null;
                    if (DelegatingCrossDomainStorageFuture.this.storageToUse == null) {
                        GWT.log((String)("cross-domain storage timeout expired, using local storage " + Window.Location.getProtocol() + "//" + Window.Location.getHost() + " instead of cross-domain storage"));
                        DelegatingCrossDomainStorageFuture.this.setStorageToUse((CrossDomainStorage)DelegatingCrossDomainStorageFuture.this.defaultSupplier.get());
                    }
                }
            };
            this.timer.schedule(this.timeoutInMillis);
        }
    }

    @Override
    public HandlerRegistration addStorageEventHandler(CrossDomainStorageEvent.Handler handler) {
        HandlerRegistration[] result = new HandlerRegistration[1];
        this.runOrEnqueue(storage -> {
            HandlerRegistration handlerRegistration = storage.addStorageEventHandler(handler);
        });
        return () -> this.runOrEnqueue(storage -> {
            if (result[0] != null) {
                result[0].removeHandler();
            }
        });
    }

    @Override
    public void setItem(String key, String value, Consumer<Void> callback) {
        this.runOrEnqueue(storage -> storage.setItem(key, value, callback));
    }

    @Override
    public void getItem(String key, Consumer<String> callback) {
        this.runOrEnqueue(storage -> storage.getItem(key, callback));
    }

    @Override
    public void removeItem(String key, Consumer<Void> callback) {
        this.runOrEnqueue(storage -> storage.removeItem(key, callback));
    }

    @Override
    public void clear(Consumer<Void> callback) {
        this.runOrEnqueue(storage -> storage.clear(callback));
    }

    @Override
    public void key(int index, Consumer<String> callback) {
        this.runOrEnqueue(storage -> storage.key(index, callback));
    }

    @Override
    public void getLength(Consumer<Integer> callback) {
        this.runOrEnqueue(storage -> storage.getLength(callback));
    }
}

